package GUIAdmin::3310;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM;
use Util;
use Agent;
use Agent::3310;
use strict;
use Logic::3310;

use GUIAdmin::IP;
use base 'GUIAdmin::IP';

sub login       { "_,telnet"}
sub isDevice    {1}
sub ipRequired  {1}
sub description { 
   my($class, $q) = @_;
   if($q =~ /Dis_Screen/) {
      my $G = Labels->read();
      return $G->{inband_minnow} || "Inband 3120JBOD/3310JBOD/3310/3320/3510/3511";
   }
   return "Sun 3310/3320/3510/3511";
}

sub logic       { "Logic::3310"  }
sub package     { "GUIAdmin::3310"}
sub wwn_label   { "key"}

sub discover {
  my($q) = @_;
  my($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();
  my ($err, $nodes, $info, $all_info);

  Discover->ras_admin($q->{select_host}, "discover_3510p", $renv, $host, "3510_inband");
  sleep 5;
  return "DISCO";

}



sub NUdiscover {
  my( $q, $post, $util) = @_;

  my $SELECT = $q->{select_host};

  my(%T, @a, $loc, $ip);
  my(%F);
  my(@NEW);

  Logic::3310->discover( $SELECT, &description, 1 );

  print "</pre>";
  GUI::Devices::list($q);
}



1;
