# iPort error in switch
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2006, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

package FCRules::Rule4;
use TO;
use Data::Dumper;
use FCRules;
use strict;

# WRITE
sub description { return "CRC went up on a DSP Port" }

sub category    { return "CRC" }

sub run {
  my($class, $To, $hm, $report, $count, $key, $info, $reads, $writes, $fc_type ) = @_;

# key= '0|2f0000015d22c900|0|dsp'


  my($hba, $name, $port0, $type) = split(/\|/, $key);
  return(undef,undef) if ($type ne "dsp"); # dsp

  my($port) = $port0 + 0;

  my($sw) = $To->nodeByKey($name); 
  return(undef,undef) if (!$sw);
  
  my $source_type  = $sw->type();

  if (!$sw) {
    Debug->print2("FCRule: Cannot find $source_type $name in Topology");
    return ();
  }
  
  my($sw_info) = $sw->{info};

  my $port_info  = $sw->{portInfo};
  my $port_type = $port_info->[$port]{sw_PortType};

  my $port_state = $port_info->[$port]{State};
  if($port_state !~ /Online/){
    Debug->print2("FCRule: Port is not online");
    return();
  }



  my $links  = $sw->{port};
  my $link  = $links->[$port];

  my($ltype, $lname, $pno) = split(/:/, $link);


  my($level, $cnt, $desc, $mins) = Thresholds->test("${fc_type}counters","rule1",
                                     $port , $count, $name);
  $mins = 1 if (!$mins);
  if ( $level eq "E") { # error level threshold fired

    my($desc) = "$fc_type-ERROR ($cnt in $mins mins): ".
                "Detector: port $port on '" . $sw->id() ;

    my($CIMKey1, $CIMKey2, $key1, $key2);

    $key1    = $sw->name() . ":$port";
    $key2    = $sw->name() . ":$port";

#   key1 is the probable origin of the problem.

    $hm->linkEvent( $report, $ltype,  $key1, $source_type, $key2, $desc, $reads, $writes, 
                    $hba, $fc_type, $sw->id());
  }
  return ("FC", "");
}

1;


