package Discover::SAMFS;
use Agent::SAMFS;
use System;
use strict;
use DiscoveryObject;
use Logic::SWITCH;
use Discover;

sub REGISTER {
  my($class) = @_;

  return { types  => "samfs",
          sysDesc => 0,
          fromIP  => 1, 
          };
}


sub discoverFromIP {
  my($class, $ipno, $args) = @_;

  if ($args->{type} ne "samfs") {
   return;
  }

  my $rc = Agent::SAMFS->getWWN($ipno);
  my $sn = $rc->{key};
  return [] if (!$sn);

  my $obj;
  if ($rc->{error}) {
    $obj = DiscoveryObject->error($ipno, $rc->{error} );
  } else {
    $obj = DiscoveryObject->newFromString(
            "application.samfs|samfs|$ipno|$sn|$sn|$sn||$rc->{name}|$rc->{userLabel}");
  }

  return [$obj];
}

1;

