package Discover::Inrange;
use System;
use strict;
use DiscoveryObject;
use Logic::SWITCH;
use Discover;

sub REGISTER {
  my($class) = @_;

  return { types  => "inrange",
          sysDesc => 1,
          fromIP  => 0,
          };
}

sub discoverFromSysDesc {
  my($class, $ip, $sysDesc, $args) = @_;

  if ($sysDesc =~ /inrange technologies/i) {
     return $class->discoverFromIP($ip, $args, 1);
  }
  return undef;
}



sub discoverFromIP {
  my($class, $ipno, $args, $confirmed) = @_;

  my $password = $args->{password};
  my($wwn, $type, $label) = Logic::SWITCH->find_wwn($ipno);
  if (!$confirmed) {
     my $oid = Logic::SWITCH->get_oid();
     return [] if ($oid !~ /private.824.1.9/);
  }
  if ($type) {
    my $o = DiscoveryObject->newFromString(
      "switch.inrange|inrange|$ipno|$wwn|$wwn|$wwn|||$label");
    Discover->updateTopoDevice($o);
    return [$o];
  }
  return [];
  
}

1;
