# $Id: COMMON.pm,v 1.3 2004/12/23 19:57:07 jkremer Exp $
# Copyright 2004 Sun Microsystems, Inc., All Rights Reserved.
# Sun Proprietary/Confidential: For Internal Use Only

package Discover::COMMON;
use strict;
use System;
use Catalog::Implementation;
use DiscoveryObject;
use Java::Discovery;
use Discover;

# COMMON requires new to be called with type argument instead of REGISTER.
sub REGISTER {
  my($class) = @_;
  return undef;
}


# create a new discover object for a given device type.
sub new {
  my($class, $type) = @_;

  my $impl = new Catalog::Implementation($type);
  if (!$impl){
	 return undef;
  }
  use Data::Dumper;

  my $disco = $impl->getInterface("Discover");
  if (!$disco){
	 return undef;
  }

  my $config = $disco->{config}->{property};
  my $types  = $config->{deviceType}->{_VAL} || $type;
  my $search = $config->{searchType}->{_VAL} || $type;

  my $this = {
				  type    => $type,
				  types   => $types,
				  merge_devices => 1
				 };
  if (index($search, "ip") >= 0){
	 $this->{fromIP} = 1;
  }
  if (index($search, "snmp") >= 0){
	 $this->{sysDesc} = 1;
  }
  if (index($search, "inband") >= 0){
	 $this->{inBand} = 1;
  }

  $this->{function} = $this;
  bless($this, "Discover::COMMON");


  $this->_setFlag($config, "fromIP");
  $this->_setFlag($config, "sysDesc");
  $this->_setFlag($config, "inBand");

  $this->_setFlag($config, "no_snmp");
  $this->_setFlag($config, "no_ping");

  if ($this->{inBand}){
	 $this->{disco_level} = 2;
  }

  return $this;
}

sub toString {
  my ($this) = @_;
  return "Discover::COMMON::". $this->{type};
}


# merge info from $new into $current device
# optional function, if present, the proxys will be merged.
# return 1 if device was merged.
sub MERGE {
  my($class, $current, $new, $Config, $DevHash) = @_;
  if ($current->{ipno} eq $new->{altipno}) { # skip the alternate
     return 0;
  }
  if ($new->{proxys} &&
      index( $current->{proxys}, $new->{proxys} ) < 0) {
      $current->{proxys} .= "|$new->{proxys}";
  }
  return 1;
}

sub _doDiscover {
  my ($this, $search, $args) = @_;
  my $type  = $this->{type};
  my $impl  = new Catalog::Implementation($type);
  my $disco = $impl->getInterface("Discover");

  my $rcs;

  my $loadType = $disco->{load}->{_ATT}->{type};

  $DB::single=1;

  if ($loadType eq "java"){
	 $rcs = Java::Discovery->deviceSearch($search, $type);
  }
  elsif ($loadType eq "perl"){
	 
  }
  elsif ($loadType eq "cli"){
	 
  }
  return undef if ($#$rcs < 0);
  my (@LIST);

  foreach my $rc (@$rcs) {
	 if ($rc->{error}){
		Debug->print2("ERROR:". Dumper($rc->{error}));
		next;
# Why does framework think an error is a device?
# Must ignore for now.
#		push(@LIST, DiscoveryObject->error($search->{ip}, $rc->{error}));
		
	 }
	 if ($rc->{key}){
		if ($rc->{wwn}){
		  $rc->{wwn} = lc($rc->{wwn});
		}
		else {
		  $rc->{wwn} = $rc->{key};
		}
		my $do     = DiscoveryObject->new($rc);
		my $config = $disco->{config}->{property};
		my $topo   = $config->{topoUpdate}->{_VAL};
		if ($topo eq "true"){
		  Discover->updateTopoDevice($do, $rc);
		}	
		push(@LIST, $do);
	 }	
  }
  return \@LIST;
}

sub discoverFromSysDesc {
  my($this, $ip, $sysDesc, $args) = @_;

  return $this->_doDiscover( {
										search  => "snmp",
										ip      => $ip,
										sysDesc => $sysDesc
									  },
									  $args );
}

sub discoverFromIP {
  my($this, $ip, $args) = @_;
  return $this->_doDiscover( {
										search => "ip",
										ip     => $ip
									  },
									  $args );
}

sub discoverInBand {
  my($this, $q) = @_;
  return $this->_doDiscover( {
										search => "inband",
										ip     => "localhost",
									  },
									  $q );
}

sub _setFlag {
  my($this, $config, $name, $cname) = @_;
  $cname = $name if (!$cname);
  my $value = $config->{$name}->{_VAL};
  if ($value){
	 if ($value eq "true"){
		$this->{$cname} = 1;
	 }
	 else {
		$this->{$cname} = 1;
	 }
  }
}
1;
