package Discover::5310;
use Agent::5310;
use System;
use strict;
use DiscoveryObject;
use Logic::SWITCH;
use Discover;

sub REGISTER {
  my($class) = @_;

  return { types  => "5310,5310C",
          sysDesc => 1,
          fromIP  => 0, 
          };
}



sub discoverFromSysDesc {
  my($class, $ip, $sysDesc, $args) = @_;

  if (($sysDesc =~ /5310/) || ($sysDesc =~ /5310C/)) {
     return $class->discoverFromIP($ip, $args);
  }
  return undef;
}



sub discoverFromIP {
  my($class, $ipno, $args) = @_;

  my $rc = Agent::5310->getWWN($ipno);
  my $sn = $rc->{key};

  Debug->print1("Invalid or NULL Serial Number for $ipno") if (!$sn);
  if(!$sn){
     my $o = DiscoveryObject->error(
       $ipno, "Invalid or NULL Serial Number");
     return [$o];
  }

  my $obj = DiscoveryObject->newFromString(
	    "storage.5310|5310|$ipno|$sn|$sn|$sn||$rc->{name}|$rc->{userLabel}");

  Discover->updateTopoDevice($obj, $sn);
  return [$obj];
  
}

1;


