package DeviceReport::T3;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';



# no $q->{summary}                    # only frus,vols, system, id
# $q->{summary} = "controller.u1ctr." # this controller
# $q->{summary} = "controller."       # all controllers
# Main sections:
# <FRU> <LOGICAL> <SYSTEM> <ID>

sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $fru_list = ",controller,disk,loopcard,midplane,power,";
  my $logical  = ",volume,slice,";
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";
  my $wwn2 = $rep->{'port.u2p1.portWWN'} || $rep->{'port.u3p1.portWWN'} || $rep->{'port.u4p1.portWWN'};
  my $units = $rep->{"unit.count"} || $rep->{"controller.count"};
  my $cu    = $rep->{"controller.count"} . "x$units";
  my $pg    = "PG" if ($units > 1);

  $S{SAN} = $class->san_info($report);

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'}},
      device_type            => {order => 2, value => "$rep->{'id.device_type'} $pg ($cu)"},
      device_key             => {order => 3, value => $rep->{'id.device_key'} },
      device_ip              => {order => 4, value => $rep->{'id.ipno'} },
      port_wwn               => {order => 5, value => "$rep->{'port.u1p1.portWWN'} / $wwn2"},
      communication_status   => {order => 6,
                             value => ($report->{_status} eq "CC") ? "Management-Path Lost!" : "OK"},
      system_revision        => {order => 7, value => $rep->{"system.sysRevision"}},
      multipath_support      => {order => 8, value => $rep->{"system.sysMpSupport"}},

      disk_scrubber          => {order => 9,  value => $rep->{"system.sysDiskScrubber"} || "Off"},
      fc_speed               => {order => 10, value => $rep->{"system.sysFcSpeed"} || "1Gb"},
      online_diagnostic      => {order => 11, value => $rep->{"system.sysOndgMode"}},
      
      };

  # get the 'volume disk' first
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       next if (index($el, "fruDiskPerf") >= 0);
       if (!$summary) {
          if ($L[0] eq "volume_disk" && $L[2] eq "volDiskFruId")  {
              my @s = split(/\-/, $L[1]);
              $VD{$s[0]} .= $rep->{$el} . ",";
          }
       }
  }

  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       next if (index($el, "fruDiskPerf") >= 0);
       if (!$summary) {
          if (index($fru_list, ",$L[0],") >= 0 && $L[2] eq "fruState") {
            if ($L[1] ne "count" && $L[1] ne "header") {
              my $rev = $rep->{"$k.fruCtlrVersion"} || $rep->{"$k.fruLoopVersion"} || 
                        $rep->{"$k.fruRevision"};
              my $key = $rep->{"$k.fruVendor"} . "." . $rep->{"$k.fruModel"} . 
                        "." . $rep->{"$k.fruSerialNo"} ;
              $key = "" if ($key eq "..");
              my $avail = "Not Installed" if ($rep->{"$k.fruStatus"} eq "dummy"                                 ||$rep->{"$k.fruStatus"} eq "notInstalled");

              my $id = $k;
              if ($id =~ /disk\.u(\d)d(\d+)/) {
                  $id = sprintf("disk.u%dd%2.2d", $1, $2);
              }

              $S{FRU}{$k}            = { name    => $L[1], 
                                           id    => $id,
                                         state   => $rep->{"$k.fruState"},
                                    availability => $avail,
                                         status  => $rep->{"$k.fruStatus"},
                                         type    => $rep->{"$k.fruType"},
                                         revision=> $rev,
                                           model => $rep->{"$k.fruModel"},
                                           vendor=> $rep->{"$k.fruVendor"},
                                          serial => $rep->{"$k.fruSerialNo"},
                                         keyLabel=> "serialno",
                                         keyValue=> $key ,
                                       };
            }

          } elsif ($L[0] eq "port" && $L[1] =~ /u\dp\d$/) {
              my $displaySummary = "name,state,status,serial";
              $S{PORT}{$k} = {    name => $L[1],
                                   id => $k,
                               state  =>  $rep->{"$k.portState"},
                               status =>  $rep->{"$k.portStatus"},
                             keyLabel => "wwn",
                             keyValue => $rep->{"$k.portWWN"},
                                 type => $rep->{"$k.portType"},
                             serial   => $rep->{"$k.portWWN"},
                              summary => $displaySummary,
                                       };

          } elsif ($L[0] eq "system") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } elsif ($L[0] eq "volume" && $L[2] eq "volStatus" )  {
              # do we have volume disk associated with this volume?
              my $disks;
              foreach my $v (sort keys %VD) {
                my $volumeName = "volume.".$v;
                if ($volumeName eq $k) {
                  $disks = $VD{$v};
                }
              }
              # Add Volume
	      $S{LOGICAL}{$k} =  { name     => $rep->{"$k.volId"} || $L[1], 
                                     id     => $k,
                                   type     => "volume",
                                  status    => $rep->{"$k.volStatus"},
                                  disks     => $disks,
                                  capacity  => $rep->{"$k.volCapacity"},
                                  raidLevel => $rep->{"$k.volRaidLevel"},
				 sourcePool => $rep->{"$k.volName"},
 			        sourceVdisk => $rep->{"$k.volName"}
                                 };

              # Add VDisk.
	      my $m = "vdisk.$L[1]";
	      my $volumeStatus = $rep->{"$k.volStatus"};
	      if ($volumeStatus ne "deleted") {
                  $S{LOGICAL}{$m} =  {  name    => $rep->{"$k.volName"}, 
                                         id     => $m,
                                       type     => "LUN",
                                      status    => $rep->{"$k.volStatus"},
                                      raidLevel => $rep->{"$k.volRaidLevel"},
                                            wwn => $rep->{"$k.volWWN"},
                                       capacity => $rep->{"$k.volCapacity"},
                                         disks  => $disks,
                                     };	       
	      }
	                                   
          } elsif ($L[0] eq "slice" && $L[2] eq "volId" )  {
              $S{LOGICAL}{$k} =  {  name => $rep->{"$k.volSliceName"},  
                                     id  => $k,
                                   type  => "slice",
                                 status  => $rep->{"$k.volSliceStatus"} ,
                                 };
          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }
  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}




1;
