package DeviceReport::BROCADE;
use System;
use strict;
use DeviceReport;
use base 'DeviceReport';


# xml for GUI Interface

sub xmlSummary {
   my($class, $report, $q) = @_;
  my $summary = $q->{summary};
  my $rep = $report->content();
  my (%S);

  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $namesw = $rep->{"id.device_userLabel"} || $rep->{"id.switch_type"}   ;

  my $key0 = $rep->{"id.device_key"};
  $S{HEADER} =   {
                  device_key   => { order => 1 , value => $rep->{"id.device_key"}       },
                  device_label => { order => 2 , value => $rep->{"id.device_userLabel"} },
                  revision     => { order => 3 , value => $rep->{"swSystem.swFirmwareVersion"} },
                  status       => { order => 4 , value => $rep->{"swSystem.swOperStatus"} },
                  admin_status => { prder => 5 , value => $rep->{"swSystem.swAdmStatus"} },
                  switch_type  => { order => 6 , value => $namesw },
                  boot_date    => { order => 7 , value => $rep->{"swSystem.swBootDate"}  },
                  last_flash_update => { order => 8, value => $rep->{'swSystem.swFlashLastUpdated'}},
                 };
                
  $S{SAN} = $class->san_info($report);
               
  $S{FRU}{"enclosure"} = {  name  => "Enclosure",
                            id  => "Enclosure",
                        status  => "OK",
                          type  => "Enclosure",
                       revision => $rep->{"info.version.Active_Firmware_image"},
                         serial => "",
                          model => "",
                       keyLabel => "WWN",
                       keyValue => $key0,
                           };

  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $x  = "$L[0].$L[1].$L[2]";

       if (!$summary) {
          if ($L[0] eq "sensor" && $L[3] eq "status") {
            my $key = "$key0.$L[1].$L[2]";
            $S{COMPONENT}{$x} = {  name  => $x ,
                               id  => $x ,
                           status  => $rep->{"$x.status"},
                             type  => $L[1],
                          revision => "",
                            serial => "",
                             model => "",
                          keyLabel => "ID",
                          keyValue => $key,
                           };

#    'port.0.state' => 'offline',
#    'port.0.state.AdmStatus' => 'offline(2)',
#    'port.0.state.LinkState' => 'enabled(1)',
#    'port.0.state.OpStatus' => 'offline(2)',
#    'port.0.state.PhyState' => 'noGbic(2)',
#    'port.0.stats.Wwn' => 'Hex: 20 00 00 60 69 51 14 D3 ',
#    'port.0.type' => 'g-port',

          } elsif ($L[0] eq "port" && $L[2] eq "state") {
              $x = "$L[0].$L[1]";
              my $wwn =  $rep->{"$x.stats.Wwn"};
              $wwn =~ s/Hex://;
              $wwn =~ s/ //g;
              my $displaySummary = "name,state,status,type,speed,serial";
              $S{PORT}{$x} = {  name  => $x,
                                 id  => $x,
                              state  => $rep->{"$x.state"} . " " . $rep->{"$x.state.PhyState"},
                             status  => $rep->{"$x.state.LinkState"},
                               type  => $rep->{"$x.type"},
                              speed  => $rep->{"$x.speed"},
                           keyLabel  => "ID",
                           keyValue  => $rep->{"$x.stats.Wwn"},
                           serial    => $wwn,
                             summary => $displaySummary,
                            };

          } elsif ($L[0] eq "system") {
              $x = "$L[0].$L[1]";
              if (index("uptime,sysUpTime,sysObjectID,sysDescr,sysLocation,sysName,sysContact", $L[1]) >= 0) {
                my $val = $rep->{$el};
                $val =~ s/[\<\>]//g;
                $S{SYSTEM}{$x} = { value => $val };
              }

          } elsif ($L[0] eq "id") {
              $x = "$L[0].$L[1]";
              $S{ID}{$x} = { value => $rep->{$el} };

          } else {
              #$S{OTHER}{$x} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }
  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return (\%S, $out);
}




#    'SFC.Front5.Attention' => '0',
#    'SFC.Front5.CardNum' => '5',
#    'SFC.Front5.Class' => 'Switch Fabric Card',
#    'SFC.Front5.DateOfMfg' => '06-13-2003',
#    'SFC.Front5.HWRev' => 'AF',
#    'SFC.Front5.MACAddr' => '00:01:5D:00:3F:FF',
#    'SFC.Front5.MACCnt' => '0',
#    'SFC.Front5.NumCpus' => '1',
#    'SFC.Front5.NumPorts' => '0',
#    'SFC.Front5.PCBRev' => '04',
#    'SFC.Front5.Panel' => 'Front',
#    'SFC.Front5.PartNumber' => '720-00014-04',
#    'SFC.Front5.Power' => '1',
#    'SFC.Front5.Ready' => 'Ready',
#    'SFC.Front5.SerialNumber' => '500077',
#    'SFC.Front5.State' => 'Normal',
#    'SFC.Front5.TempF' => '111',
#    'SFC.Front5.Type' => 'SFC_1',



1;
