package Client::TestMail;
use Client;
use strict;
use System;
use Net::SMTP;
use Net::Util;
use Mail;

sub mail {
  my($to, $from, $subject, $data, $TO, $sendmailServer, $locale) = @_;
  
  return Mail->mail($to, $from, $subject, $data, $TO, 
                    { sendmail_server  => $sendmailServer,
                      locale           => $locale
                    });
}

sub mailData {
  my($to, $data, $TO, $sendmailServer) = @_;

  return Mail->mailData($to, $data, $TO, 
                    { sendmail_server  => $sendmailServer ,
                    });

}

######################################################
#   TEST EMAIL
######################################################

sub test {
  my($q) = @_;
  my($renv, $dev, $host, $notifs) = PDM::ConfigFile->read();

  my $rc = mail($q->{email}, "Storage_ADE", "Test Message", 
		$q->{message}, 30, $q->{sendmailServer}, $q->{locale});

  print Client->http_OK();

  if ($rc) {
    print Client->error("xml", 801, "$q->{sendmailServer}");
  } else {
    print "<TESTEMAIL>\n";
    print "<VALUE ID=\"$q->{sendmailServer}, $q->{email}\">sent</VALUE>\n";
    print "</TESTEMAIL>\n";
  }
}

1;
