package Client::Sscs;

use System;
use Client;
use Debug;
use strict;

#
# CALLED BY SSCS program on system edition.
# $args = "-r 2 -d 2 ";
# $args = Util->encode($args);
# http://ccadieux:7654/rashttp?GO=Client::Sscs::run&command=/opt/SUNWstade/bin/ras_admin&args=-l

use vars qw($CNT);

sub run {
  my($q) = @_;
  my $command = $q->{command};
  my $args    = Util->decode($q->{args});

  Debug->logLine("Sscs::run:$command $args");

  my @allowed = (
     "/opt/SUNWstade/bin/ras_admin",
     "/opt/SUNWstade/sysbin/config_solution",
     "/opt/SUNWstade/sysbin/sys_admin",
     "/opt/SUNWstade/bin/ras_patchlist",
     "/opt/SUNWstade/bin/ras_patchdowngrade",
     "/opt/SUNWstade/bin/ras_upgrade",
     "/opt/SUNWstade/bin/ras_downgrade" );

  my $doCommand = 0;
  foreach my $cmd (@allowed) {
    if ($cmd eq $command){
      $doCommand = 1;
      last;
    }
  }
  if ($doCommand == 0)
  {
      print Client->error("xml", 99, "ERROR: Command $command not allowed.");
      return;
  }

  

  $CNT++;
  my $file = "/tmp/$$." . time . ".$CNT";

  # start process in /tmp/$file
  print Client->http_OK;
  umask 000;

  my $run = "$command $args";
  system("($run > $file.2 2>&1;mv $file.2 $file)");

  if ($q->{nohttp}) {
    return $file;
  }

  my $output;
  my $n;
  if (open(O, "$file")) {
    while ($n = <O>) {
      $output .= $n;
    }
  }

  print $output;

  if ($file) {
    unlink $file;
  }

  #print "FILE=$file\n",
  #print "ERR=Error\n";
}

1;

