# $Id: Message.pm,v 1.3 2004/12/06 20:38:09 jkremer Exp $
# Copyright 2004 Sun Microsystems, Inc., All Rights Reserved.
package Client::Message;

use System;
use Client;
use Policies;
use Labels;
use Debug;
use Data::Dumper;

use strict;

# Log posted lines and run polices.
sub post {
  my($q, $post, $util) = @_;
  print Client->http_OK();
  print "<MESSAGE><DEBUG>\n";

  my $type = $q->{type};
  my $key  = $q->{key};
  my $ipno = $q->{ip};
  my $name = $q->{name};
  my $index;
  my @lines;

  require XML::LibXML;
  my $parser = XML::LibXML->new();
  eval {
	 my $dom  = $parser->parse_string($post);
	 if ($dom){
		my $elem = $dom->getDocumentElement();
		if ($elem){
		  my @msgs = $elem->findnodes("Message");
		  for($index = 0; $index <= $#msgs; $index++) {
			 my $node = $msgs[$index];
			 next if ($node->getType() != &XML::LibXML::ELEMENT_NODE() );
			 my $msg = {};
			 foreach my $el ($node->getChildNodes()){
				next if ($el->getType() != &XML::LibXML::ELEMENT_NODE() );
				$msg->{$el->getName()} = $el->textContent();
			 }
			 my $line = Client::Message::getLine($msg);
			 push (@lines, $line);
		  }
		}
	 }
  };
  if ($@){
	  print "$@</DEBUG><RESULT>FAILURE</RESULT></MESSAGE>\n";
	  return;
  }

  my $renv    = System->get_renv();
  my $LOGName = "messages." . $type;
  my $LOGFile = $renv->{$LOGName} || "/var/adm/$LOGName";
  open(O, ">>$LOGFile");

  for($index = 0; $index <= $#lines; $index++) {
	 my $line = $lines[$index];
	 print O "$line\n";
  }
  close(O);

  my @err;
  my $policies = Policies->new($type . "_policies");
  for ($index = 0; $index <= $#lines; $index++ ) {
	 my($line, $component) = split(/\t/, $lines[$index]);
	 my $compKey   = $key;
	 if ($component){
		$compKey = "$key:$component";
	 }
	 $policies->run(\@err, \@lines, \$index,
						 $component, $name, $compKey, $ipno, $key, 1);
  }
   print "</DEBUG><RESULT>OK</RESULT></MESSAGE>\n";
}


# log a single message.
sub logMessage {
   my($q) = @_;
	print Client->http_OK();
	print "<MESSAGE>\n";

	my $type        = $q->{type};
	my $id          = $q->{id};
	my $severity    = $q->{severity};
	my $component   = $q->{component};
	my $time        = $q->{time};
	my $description = $q->{description};
	my $source      = $q->{source};
	my $ipno        = $q->{ip};

	my $line    =  $q->{line} || Client::Message::getLine($q);
	my $renv    = System->get_renv();
	my $LOGName = "messages." . $type;
	my $LOGFile = $renv->{$LOGName} || "/var/adm/$LOGName";
	open(O, ">>$LOGFile");
	print O "$line\n";
	close(O);

	my @lines;
	push(@lines, $line);

	my @err;
	my $policies = Policies->new($type . "_policies");	
	my $index;
	for ($index = 0; $index <= $#lines; $index++ ) {
	  my($line, $component) = split(/\t/, $lines[$index]);
	  my $compKey   = $source;
	  if ($component){
		 $compKey = "$source:$component";
	  }
	  $policies->run(\@err, \@lines, \$index,
						  $component, $source, $compKey, $ipno, $source, 1);
	  my $warn_lines = \@err;
	  print "<DEBUG_LINES>";
	  print Dumper($warn_lines);
	  print "<\DEBUG_LINES>";
	}
#   print "<RESULT>OK</RESULT></MESSAGE>\n";   
	print "<RESULT>ERROR</RESULT></MESSAGE>\n";
}

# Private utility method
sub getLine {
  my($q) = @_;
  my $type        = $q->{type};
  my $id          = $q->{id};
  my $severity    = $q->{severity};
  my $component   = $q->{component};
  my $time        = $q->{time};
  my $description = $q->{description};
  my $source      = $q->{source};
  my $line = "$time $source";
	if ($component){
	  $line .= " $component";
	}
	$line .= ":[ID " . "$id] $severity $description";
	if ($component){
	  $line .= "\t$component";
	}
  return $line;
}

# Get localized error messages from the Client interface.
sub getErrorMsg {
   my($q) = @_;
	my $errno  = $q->{errno};
	my $locale = $q->{locale};
	my $resource = Labels->read("Client");

	my @args;
	my $argno = 1;
	my $arg;
	while ($arg = $q->{"arg".$argno}){
	  push(@args, $arg);
	  $argno++;
	}
	print Client->errno( $errno, \@args, );
}

1;
