package Client::AppLauncher;

use strict;
use System;
use Launch;
use Client;

use vars qw(@CATS);
@CATS = ('3310','3320','3511','9900','domain','3510','a5k','a3500FC','brocade','d2','inrange','mcdata','switch','switch2','qlogicsw','se','se2','t3','tape','v880');


sub getDeviceTypes {
   
   print Client->http_OK();
   print "<DEVICETYPES> \n";
   foreach my $cat (@CATS) {
      my $abb = Util->abb("$cat.medium") || $cat;
      print "<VALUE ID=\"$cat\">$abb</VALUE> \n";
   }
   print "</DEVICETYPES> \n"

}

sub addApp {

  my($q) = @_; 
  my $name = $q->{name};
  my $location = $q->{location};
  my $deviceType = $q->{deviceType};

  my $urls = Util->deserialize("UrlLaunch2.txt") || {};
  if($urls->{$name}) {
    print Client->error("xml", 901, "$name");
    return;
  } else {
    $urls->{$name}[0] = $location;
    $urls->{$name}[1] = $deviceType;
    Util->serialize("UrlLaunch2.txt", $urls);
    print Client->http_OK();
    print "<ADDAPP>$name</ADDAPP>\n";
    return;
  }

}

sub deleteApp {
  my($q) = @_; 
  my $name = $q->{name};

  my $urls = Util->deserialize("UrlLaunch2.txt") || {};
  if(!$urls->{$name}) {
    print Client->error("xml", 902, "$name");
    return;
  } else {
    delete $urls->{$name};
    Util->serialize("UrlLaunch2.txt", $urls);
    print Client->http_OK();
    print "<DELETEAPP>$name</DELETEAPP>\n";
    return;
  }

}

sub updateApp {
  my($q) = @_; 
  my $name = $q->{name};
  my $location = $q->{location};
  my $deviceType = $q->{deviceType};

  my $urls = Util->deserialize("UrlLaunch2.txt") || {};
  if(!$urls->{$name}) {
    print Client->error("xml", 903, "$name");
    return;
  } else {
    $urls->{$name}[0] = $location;
    $urls->{$name}[1] = $deviceType;
    Util->serialize("UrlLaunch2.txt", $urls);
    print Client->http_OK();
    print "<UPDATEAPP>$name</UPDATEAPP>\n";
    return;
  }
}

sub listApp {
  my($q) = @_; 
  my $dt = $q->{deviceType};
  my $n = $q->{name};

  my $urls = Util->deserialize("UrlLaunch2.txt") || {};
  print Client->http_OK();
  print "<APPS>\n";
  foreach my $name (keys %$urls) {

    my $location = $urls->{$name}[0];
    my $deviceType = $urls->{$name}[1];

    next if($dt && $dt ne $deviceType);
    next if($n && $n ne $name);

    my $l = Util->abb("$deviceType.medium") || $deviceType;

    print " <APP>\n";
    print "   <NAME>$name</NAME>\n";
    print "   <LOCATION>$location</LOCATION>\n";
    print "   <DEVICETYPE ID=\"$deviceType\">$l</DEVICETYPE>\n";
    print " </APP>\n";
  }
  print "</APPS>\n";
}

1;
