package Client::6130Control;
use Client;
use strict;
use Events;
use Debug;
use Util;
use State;
use Java::TreefrogControls;

sub blinkArrayLEDs {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  print Client->http_OK();
  my $ret = Java::TreefrogControls->blinkArrayLEDs($deviceKey);
  if("OK" eq $ret) {
    print "<LED>$deviceKey</LED>";
  } else {
    print Client->error("xml", 1301, Client->xmlEncode($ret));
  }
 
}

sub blinkTrayLEDs {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruId = $q->{fruID};
  my $midplaneKey;

  #construct midplaneKey from any fruID
  if($fruId=~m/^(t[0-9]+)./) {
    $midplaneKey = $1 . "mpn";
  } else {
    $midplaneKey = $fruId;
  }

  print Client->http_OK();
  my $ret = Java::TreefrogControls->blinkTrayLEDs($deviceKey, $midplaneKey);
  if("OK" eq $ret) {
    print "<LED>$deviceKey</LED>";
  } else {
    print Client->error("xml", 1301, Client->xmlEncode($ret));
  }
}

sub blinkDriveLED {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $driveKey = $q->{fruID};
  print Client->http_OK();
  my $ret = Java::TreefrogControls->blinkDriveLED($deviceKey, $driveKey);
  if("OK" eq $ret) {
    print "<LED>$deviceKey</LED>";
  } else {
    print Client->error("xml", 1301, Client->xmlEncode($ret));
  }
}

sub stopLEDBlinking {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  print Client->http_OK();
  my $ret = Java::TreefrogControls->stopLEDBlinking($deviceKey);
  if("OK" eq $ret) {
    print "<LED>$deviceKey</LED>";
  } else {
    print Client->error("xml", 1301, Client->xmlEncode($ret));
  }
}

sub activateController {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruKey = $q->{fruID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->activateController($deviceKey, $fruKey);
  if("OK" eq $ret) {
    print "<CONTROLLER>$deviceKey, $fruKey</CONTROLLER>";
  } else {
    print Client->error("xml", 1302, Client->xmlEncode($ret));
  }
}

sub deactivateController {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruKey = $q->{fruID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->deactivateController($deviceKey, $fruKey);
  if("OK" eq $ret) {
    print "<CONTROLLER>$deviceKey, $fruKey</CONTROLLER>";
  } else {
    print Client->error("xml", 1303, Client->xmlEncode($ret));
  }
}

sub resetBattery {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruKey = $q->{fruID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->resetBattery($deviceKey, $fruKey);
  if("OK" eq $ret) {
    print "<BATTERY>$deviceKey, $fruKey</BATTERY>";
  } else {
    print Client->error("xml", 1304, Client->xmlEncode($ret));
  }
}

sub setDriveChannelOptimal {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $channelID = $q->{channelID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->setDriveChannelOptimal($deviceKey, $channelID);
  if("OK" eq $ret) {
    print "<DRIVECHANNEL>$deviceKey, $channelID</DRIVECHANNEL>";
  } else {
    print Client->error("xml", 1305, Client->xmlEncode($ret));
  }
}

sub getSupportData {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $path = $q->{path};
  my $fileName = $q->{fileName};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->getSupportData($deviceKey, $path, $fileName);
  if("Success" eq $ret) {
    print "<GETSUPPORTDATA>$deviceKey, $path, $fileName</GETSUPPORTDATA>";
  } else {
    print Client->error("xml", 1306, Client->xmlEncode($ret));
  }

}

sub powerDownArray {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->powerDownArray($deviceKey);
  if("OK" eq $ret) {
    print "<POWERDOWN>$deviceKey</POWERDOWN>";
  } else {
    print Client->error("xml", 1305, Client->xmlEncode($ret));
  }
}

sub reviveDrive {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruKey = $q->{fruID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->reviveDrive($deviceKey, $fruKey);
  if("OK" eq $ret) {
    print "<CONTROLLER>$deviceKey, $fruKey</CONTROLLER>";
  } else {
    print Client->error("xml", 1306, Client->xmlEncode($ret));
  }
}

sub controllerToServiceMode {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruKey = $q->{fruID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->controllerToServiceMode($deviceKey, $fruKey);
  if("OK" eq $ret) {
    print "<CONTROLLER>$deviceKey, $fruKey</CONTROLLER>";
  } else {
    print Client->error("xml", 1306, Client->xmlEncode($ret));
  }
}

sub resetController {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};
  my $fruKey = $q->{fruID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->resetController($deviceKey, $fruKey);
  if("OK" eq $ret) {
    print "<CONTROLLER>$deviceKey, $fruKey</CONTROLLER>";
  } else {
    print Client->error("xml", 1306, Client->xmlEncode($ret));
  }
}

sub redistributeVolumes {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->redistributeVolumes($deviceKey);
  if("OK" eq $ret) {
    print "<CONTROLLER>$deviceKey</CONTROLLER>";
  } else {
    print Client->error("xml", 1306, Client->xmlEncode($ret));
  }
}

sub clearArrayConfig {
  my($q) = @_;
  my $deviceKey = $q->{deviceID};

  print Client->http_OK();
  my $ret = Java::TreefrogControls->clearArrayConfig($deviceKey);
  if("OK" eq $ret) {
    print "<CONTROLLER>$deviceKey</CONTROLLER>";
  } else {
    print Client->error("xml", 1307, Client->xmlEncode($ret));
  }

}

sub clearArrayConfigByIP {
  my($q) = @_;
  my $ipAddress = $q->{ipAddress};

  print Client->http_OK();

  # still re-use original api, which means the passing of array 
  # id will not work anymore

  my $ret = Java::TreefrogControls->clearArrayConfig($ipAddress);
  if("OK" eq $ret) {
    print "<CONTROLLER>$ipAddress</CONTROLLER>";
  } else {
    print Client->error("xml", 1308, Client->xmlEncode($ret));
  }

}

1;
