package Catalog::Log;

use Catalog::RF;
use base 'Catalog::RF';
use strict;

#######################################
# LOG FILE PARSING
#
# Log FIle parsing
# Author: Christian Cadieux
# Transform back and forth between storade resource files and XML documents.

# Log Policies: System/Policies/*policies   rf2.test
#               $policy_report = Catalog::Log->parseFile(
#                    "System/Policies/3310_policies",
#                    { root => "policies", section => "policy" } );
#               print $report->toText($policy_report);
# Format:
# [section1]
# name1=value1
# name2=value2
# threshold=10,24h,10h,E
# ..
# <threshold name="driver.SF_OFFLINE">
#   <number>10</number>
#   <period>24h</period>
#   <quiet>1h</quiet>
#   <severity>W</severity>
#   <comment>Comment</comment>
# </threshold>

# $report = XML->parseResourceFile("3310_policies", 
#               {
#               root => "policies", 
#            section => "policy",  # [policy01]
#               };
#######################################

sub info {
  return  { ROOT => "policies",
           hash  => { property => "name" },
           array => { policy => "name" },
           section_name => "policy", 
        };
}

sub toCatalog {
  my($class, $arg) = @_;
  my $D = ($arg->{BASE_DIR} || System->get_home()) . "/System/Policies";
  my(%D2);
  opendir(O, $D);
  my @files = readdir(O); closedir(O);
  my $C = System->get_home() .  Catalog->device_path();

  foreach my $f (@files) {
    if ($f =~ /(\w+)_policies/) {
       my $file = $1;
       my $log = $class->parseFile("System/Policies/$f");
       if ($file eq "array") {
          foreach my $f ('6020','6120','t3') {
             &add($C, $f, $log);
          }
       } else {
          &add($C, $file, $log);
       }
    }
  }
}

sub fromCatalog {
  my($class, $arg) = @_;
  my $D = System->get_home() .  Catalog->device_path();
  chdir $D;
  my @files = `ls */log.xml`;

  my $DATA =  Catalog->system_path() . "/Policies/";
  mkdir $DATA,0777 if (!-d $DATA);

  my(%D2);
  foreach my $f (@files) {
     chomp($f);
     my $rep =  Catalog::XML->parseFile("$D/$f", $class->info());
     if (!$rep) {
         print "Error reading Catalog/device/$f\n";
         last;
     }
     my $ix = index($f, "/");
     my $f2 = substr($f, 0, $ix);
     open(W, ">$DATA/${f2}_policies");
     print W $class->toText($rep);
     close(W);
  }
}




sub add {
  my($C, $file, $log) = @_;

  mkdir "$C/$file",0777 if (!-d "$C/$file");
  open(W, ">$C/$file/log.xml");
  print W $log->toXML();
  close(W);
}



sub parseFile {
  my($class, $file, $arg) = @_;

  my $D = System->get_home();
  if (open(O, "$D/$file")) {
     my @l = <O>; close(O);
     return $class->parse(\@l,  $class->file_name($file));
  } else {
     $class->err("opening $file: $! \n");
     return undef;
  }
}


sub parse_threshold {
  my($class, $name, $val) = @_;
  my($number,$period,$quiet,$severity) = split(/\s*,\s*/, $val);
  return "<threshold>
    <number>$number</number>
    <period>$period</period>
    <quiet>$quiet</quiet>
    <severity>$severity</severity>
  </threshold>";

}

1;
