package Catalog;
use Catalog::Implementation;
use PDM::Parse;
use Modules;

#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
# $catalog = Catalig->read();
# $devices = $catalog->{devices};
# $a5k_catalog = $devices->{a5k}{implementation};
# $agent = $a5k_catalog->{interface}{Agent};


use Util;
use strict;
use System;
use vars qw(%BASE_DIRS $CATALOG);

sub init {
  my($class) = @_;

  # READ ALL IMPLEMENTATIONS FROM THE REGISTRY
  my $catalog = $class->read(); # read all catalog

  # READ ALL XML FILES FRM EACH BASE_DIR (ACME etc..), MOVE to System
  foreach my $base (keys %BASE_DIRS) {
     $class->installXMLCatalogs($base); # /opt/ACME
  }

  my $devs = $catalog->{devices};

  foreach my $d (keys %$devs) {
    my $type = uc($d);
    my $mod = System->get_home();
    if (!-f "$mod/lib/TO/$type.pm") {
       eval <<EOF;
package TO::$type;
use base 'TO::COMMON';
use type { '$d' }
sub leaf { 1 }
EOF
    }

    if (!-f "$mod/lib/Discover/$type.pm") {
       eval <<EOF;
package Discover::$type;
use Discover::COMMON;
use base 'Discover::COMMON';
EOF
    }
  }
  return $catalog;
}


# find all XML resource files and install them in the main directory of
# storade:
# /opt/ACME/System/Catalog/device2/... => /opt/SUNWstade/DATA/System/Catalog/device2/

sub installXMLCatalogs {
  my($class, $base) = @_;
  foreach my $a ('Catalog','Threshold','Log','Health','Diag','Fault','Grid') {
     require "Catalog::$a";
     my $f = "Catalog::$a";
     $f->fromCatalog({BASE_DIR => $base});
  }
}

  

# /etc/storade/acme.conf
# BASE_DIR=/opt/ACME/
# ONLY READS IMPLEMENTATIONS

sub read {
  my($class) = @_;
 
  return $CATALOG if ($CATALOG);
  $CATALOG = {};
  my( @D);
  my $ETC = "/etc/storade";
  push(@D, System->get_home());
  opendir(O, $ETC);
  my @files = readdir(O);
  foreach my $f (@files) {
     if ($f =~ /\.conf/) {
        my $hash = PDM::Parse->file2hash("$ETC/$f");
        my $base = $hash->{BASE_DIR};
        push(@D, $base);
        $BASE_DIRS{$base} = 1;
     }
   }
   foreach my $d (@D) {
     my $c = Catalog::Implementation->readAll($d);
     foreach my $d (keys %$c) {
        $CATALOG->{devices}{$d} = $c->{$d};  
     }
   }
   return $CATALOG;
}


sub device_path {
  return "/System/Catalog/device2/";
}
sub system_path {
  return System->get_home() . "/DATA/System/";
}


sub devices {
  my($class) = @_;
  my $catalog = $class->read();
  if ($catalog) {
    return $catalog->{devices};
  }
  return undef;
}

sub implementation {
  my($class, $type) = @_;
  my $catalogs = $class->read();
  if (exists $catalogs->{devices}{$type}) {
     return  $catalogs->{devices}{$type}{implementation};
  }
  return undef;
}

sub interface {
  my($class, $type, $interface) = @_;
  my $impl = $class->implementation($type);
  if ($impl && exists $impl->{interface}{$interface}) {
     return $impl->{interface}{$interface};
  }
  return undef;
}

sub loadModule {
  my($class, $module, $dev_type) = @_;

  my $impl = $class->implementation($dev_type);
  if ($impl) {
     my $mod = $module . "::COMMON";
     my $rc = Modules->loadOne($mod);
     return $mod;
    
  } else {
     my $mod = $module . "::" . uc($dev_type);
     my $rc = Modules->loadOne($mod);
     return $mod;
  }
}


sub Type { 0 }
sub Name { 1 }
sub WWN1 { 2 }
sub WWN2 { 3 }
sub IP   { 4 }
sub IPno { 5 }
sub Port1{ 6 }     # t3
sub Port2{ 7 }     # t3
sub Key  { 8 }
sub Host { 9 }

sub WWN  {10 }
sub ShortWWN  {11 }



1;
  
