package Agent::SAN;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


#  $Name:  $
#  $Id: SAN.pm,v 1.2 2006/07/19 14:53:25 mckenney Exp $
use strict;
use Agent;
use base 'Agent';
use Agent::SWITCH;
use Agent::T3;
use Agent::SWITCH;
use Agent::VE;
use vars qw( %RAID);
#
#
# LOOK FOR FC_COUNTERS in the Health directory for more fc counter code.
# Health/FC_COUNTERS apply to device that can provide counters OOB.
#
# This section runs only for devices that need to be executed 
# on a device_type by device_type basis because they rely on luxadm
# to extract all counters from all devices inband at the same time.

sub isSelectable {"FC-Counters"}

sub revision {'$Revision: 1.2 $'}


sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::SAN');
  return $self;
}

sub RUN {
  my($agent, $static_list, $pass, $SINFO) = @_;
  my($mod, @mods, $x, @writes, @reads);
  my($a5, $t3, $sw, $sum, @fc, $l, $ib, $ob, $skip);

  my($cache) = 0;
  my $renv = System->get_renv();
  my $report = {};

  $DB::single=1;

  my $inband_off = System->get_home()  . "/DATA/inband_off";
  if (-e $inband_off ) {
       Debug->print1("-> Skipping running SAN commands since inband monitoring/discovery is off.");
       return [] ;
  }
  #
  # RUN SAN when there is a 'host' entry in the static_list
  #
  my($run);
  foreach my $d (@$static_list) {
     if ($d->{key} eq $renv->{hostname}) {
        $run = 1; last;
     }
  }
  return [] if (!$run);
  
  Debug->print2("SAN: extracting counters...");
  my $agents = Modules->load("Agent");

  foreach my $ag0 (@$agents) {
     next if (index("|$renv->{categories}|", "|". lc($ag0) . "|") < 0);
     my $ag = "Agent::$ag0";
     if ($ag->can("FCCounters")) {
        my $rep = $ag->FCCounters( { responsibleOnly => 1} );
        if (!exists $report->{"FC_$ag" }) {
          $report->{"FC_$ag"} = $rep;
        } else {
          &merge( $report->{"FC_$ag" }, $rep);
        }
     }
  }

  my $id  =   {deviceName  => "san",
                     name  => "san",
                  category => Report::CAT_SAN,
                        ip => "",
                 };

  my $new_rep = Report->new($id, $report , undef);

  require Health::SAN;

  my $broke_list = Health::SAN->all_logic($new_rep);

  PDM->saveReport($new_rep);
  return $broke_list;
}

sub merge {
  my($R, $r) = @_;

  my $r_data = $r->{data};

  foreach my $el (keys %$r_data) {
     $R->{data}{$el} = $r_data->{$el};
  }
}



1;



