package Agent::PS;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
use Agent;
use vars qw($AUTOLOAD);
use System;
use base 'Agent';
use strict;
use Util;
use LWP::UserAgent;
use Data::Dumper;

sub new {
  my($self) = Agent->new();
  bless ($self, 'Agent::PS');
  return $self;
}

sub probe {
 my($class, $ip, $host, $TO, $frus) = @_;
  my %H;
  $TO = 300 if (!$TO);
  my $VAR1;

  my $alive = Util->ping($ip, 10);
  if ($alive) { #check if its alive
  $H{ip}=$ip;
  $H{name}=$ip;
      require XML::LibXML;
      my $parser = XML::LibXML->new();
      my $dom;
      my $elem;
      my @err;
      my $xml;
        #  $ua->agent("AgentName/0.1 " . $ua->agent);
        #  $ua->proxy('http' => "http://cache-brm.Central.Sun.COM:8080");
        #  $ua->credentials("http://diag210.central", "NobleGUI", "guest", "");
        my $ua = new LWP::UserAgent;
        my $req = new HTTP::Request(GET =>"http://$ip/xml/get_sw_versions.xml");
        my $res = $ua->request($req);
        if ($res->is_success) {
          $xml =  $res->content;
        } else {
          $H{err}= "http://$ip/xml/get_sw_versions.xml FAILED!";
        }
        if(length($xml) > 5){
            eval {
              $dom = $parser->parse_string($xml);
            };
            if ($@) {
              Debug->print2("Error parsing XML from http://$ip/xml/get_sw_versions.xml.\n$@");
              $H{err}.="Error parsing XML from http://$ip/xml/get_sw_versions.xml.";
            }
          }
         my ($CSXVER, $SWVER);
         my $root = $dom->getDocumentElement;
         my @comps= $root->getChildNodes();
         foreach my $comp (@comps) {
           my $name= $comp->getName();
           if ($name eq 'CXC_RMU_SW'){
             $CSXVER = Util->trim($comp->textContent());
           }elsif($name eq 'Sequencer_SW'){
             $SWVER = Util->trim($comp->textContent());
           }
        }             
        $H{CXC_RMU_SW}=$CSXVER;
        $H{Sequencer_SW}=$SWVER;
        if($CSXVER && $SWVER){
          print "  -> found Power Sequencer at $ip\n";
        }else{
          print "  -> Unable to identify device at at $ip\n";
          $H{err} = "Unable to identify device at at $ip\n";
        }

     }else{$H{err}="Could not ping";}
  return \%H;
}

sub xmlFiles{
  my @FILES =
    (
      "xml/get_relay_status.xml",
      "xml/get_sw_versions.xml",
      "xml/get_line_values.xml",
      "xml/get_hw_status.xml",
      "xml/get_unit_fault_status.xml",
      "xml/get_uptime_counter.xml",
      "xml/get_vendor_info.xml",
      "xml/get_ip_config.xml",
      "xml/get_snmp_config.xml",
      "xml/get_local_seq_delay.xml",
      "xml/get_date_time.xml",
      "xml/get_site_info.xml",
      "xml/get_seq_install_status.xml"
   );
return @FILES;
}

sub getRelayStates{

  my ($class, $sequ) =@_;
  my @sequencers;
  if(!$sequ){
     @sequencers=("psq00", "psq01", "psq10", "psq11", "psq20", "psq21"); 
  }else{
     @sequencers = ("$sequ");
  }
  my $H;
  foreach my $seq (@sequencers){
    my $alive = Util->ping($seq, 1);
    next if (!$alive);  #check if its alive
    require XML::LibXML;
    my $parser = XML::LibXML->new();
    my $dom;
    my $elem;
    my @err;
    my $xml;
      #  $ua->agent("AgentName/0.1 " . $ua->agent);
      #  $ua->proxy('http' => "http://cache-brm.Central.Sun.COM:8080");
      #  $ua->credentials("http://diag210.central", "NobleGUI", "guest", "");
    my $ua = new LWP::UserAgent;
    my $req = new HTTP::Request(GET =>"http://$seq/xml/get_relay_status.xml");
    my $res = $ua->request($req);
    if ($res->is_success) {
        $xml =  $res->content;
     } else {
        $H->{err}= "http://$seq/xml/get_relay_status.xml FAILED!";
     }
     if(length($xml) > 5){
       eval {
         $dom = $parser->parse_string($xml);
       };
       if ($@) {
         Debug->print2("Error parsing XML from http://$seq/xml/get_relay_status.xml.\n$@");
         $H->{err}.="Error parsing XML from http://$seq/xml/get_relay_status.xml.";
       }
     }
     my @States;
     my $root = $dom->getDocumentElement;
     my @comps= $root->getChildNodes();
     foreach my $comp (@comps) {
       my $name= $comp->getName();
       if ($name eq 'Relay'){
         my @states= $comp->getChildNodes();
         foreach my $state (@states) {
           my $sname= $state->getName();
           if ($sname eq 'Live_State'){
             my $s =Util->trim($state->textContent());
             push(@States,$s); 
           }
         }
       }
    }
  $H->{$seq}=\@States;
  }
return $H;
}

#http://10.4.28.57/xml/set_relay.xml?relay=0&state=1
#This is the command to turn on and off sequencer
#relay=0-11 and state=1 for on and 0 for off
sub setRelayStates{
  my ($class, $H, $args) =@_;
  my $failedSeq = "";
  foreach my $seq (keys(%$H)){
    my $states=$H->{$seq};
    my $ua = new LWP::UserAgent;
    for(my $index=0; $index<=$#$states; $index++){
     my $url="http://$seq/xml/set_relay.xml?relay=$index&state=$states->[$index]";
      my $req = new HTTP::Request(GET =>$url);
      my $res = $ua->request($req);
      if ($res->is_success) {
        my $xml =  $res->content;
      } else {
          $H->{err}= "http://$seq/xml/get_sw_versions.xml FAILED!";
	  $failedSeq = $failedSeq . " $seq";
      }
    }
  }
sleep 1;
#return $class->getRelayStates();
  if($failedSeq) {
    return $failedSeq;
  } else {
    return "success";
  }
}

sub getRackRelayStates{
  my ($class, $args) =@_;
  my $H = $class->getRelayStates();
  my $newH;
  foreach my $seq (keys(%$H)){
    if($seq eq 'psq00'){$newH->{rack1a}=$H->{$seq};
    }elsif($seq eq 'psq01'){$newH->{rack1b}=$H->{$seq};
    }elsif($seq eq 'psq10'){$newH->{rack2a}=$H->{$seq};
    }elsif($seq eq 'psq11'){$newH->{rack2b}=$H->{$seq};
    }elsif($seq eq 'psq20'){$newH->{rack3a}=$H->{$seq};
    }elsif($seq eq 'psq21'){$newH->{rack3b}=$H->{$seq};
    }
  }
  return $newH;
}

sub setRackRelayStates{
  my ($class, $H, $args) =@_; 
  my $newH;
  foreach my $seq (keys(%$H)){
    if($seq eq 'rack1a'){$newH->{psq00}=$H->{$seq};
    }elsif($seq eq 'rack1b'){$newH->{psq01}=$H->{$seq};
    }elsif($seq eq 'rack2a'){$newH->{psq10}=$H->{$seq};
    }elsif($seq eq 'rack2b'){$newH->{psq11}=$H->{$seq};
    }elsif($seq eq 'rack3a'){$newH->{psq20}=$H->{$seq};
    }elsif($seq eq 'rack3b'){$newH->{psq21}=$H->{$seq};
    }
  }
  return $class->setRelayStates($newH);
  #return $class->getRackRelayStates();
}


sub setRackRelayState{
  my ($class, $seq, $zone, $state, $timeout) =@_; 

  if(!defined($timeout)){
     $timeout = 10;
  }

  my $psq;
  if(    $seq eq 'rack1a'){$psq="psq00";}
  elsif($seq eq 'rack1b'){$psq="psq01";}
  elsif($seq eq 'rack2a'){$psq="psq10";}
  elsif($seq eq 'rack2b'){$psq="psq11";}
  elsif($seq eq 'rack3a'){$psq="psq20";}
  elsif($seq eq 'rack3b'){$psq="psq21";}
  elsif($seq =~ /psq/){$psq=$seq};

  my $ua = new LWP::UserAgent;
  $ua->timeout(1);
  my $url="http://$psq/xml/set_relay.xml?relay=$zone&state=$state";
  my $req = new HTTP::Request(GET =>$url);
  my $res = $ua->request($req);
  # Must allow time for settings to occur
  sleep($timeout);
  if ($res->is_success) {
    my $xml =  $res->content;
  } else {
      return  "Error\n";
  }
}



sub getpseqstatus{

  my ($class, $seq) =@_;

  Debug->print2("   ping $seq");
  my $alive = Util->ping($seq, 1);
  if (!$alive){
     Debug->print2("   Ping failed for $seq");

     return("ERROR", "PING_FAILED");

  }
  require XML::LibXML;
  my $parser = XML::LibXML->new();
  my $dom;
  my $elem;
  my @err;
  my $xml;
  my $ua = new LWP::UserAgent;
  my $req = new HTTP::Request(GET =>"http://$seq/xml/get_unit_fault_status.xml");
  my $res = $ua->request($req);
  if ($res->is_success) {
      $xml =  $res->content;
   } else {
      return("ERROR", "XML_FAILED");
   }
   if($xml =~ /LED_Status>(\d)<\/LED_Status/){
     my $value = $1;
     if($value eq 0){
       return ("OK", "OK");
     }else{
       return ("ERROR", "FAULTED");
     }
   }

   return("ERROR", "UNKNOWN");


}


sub getHWStates{

  my ($class, $seq) =@_;
  my $H;
  my $alive = Util->ping($seq, 1);
  if (!$alive){
    return $H;
  }

  require XML::LibXML;
  my $parser = XML::LibXML->new();
  my $dom;
  my $elem;
  my @err;
  my $xml;
  my $ua = new LWP::UserAgent;
  my $req = new HTTP::Request(GET =>"http://$seq/xml/get_hw_status.xml");
  my $res = $ua->request($req);
  if ($res->is_success) {
      $xml =  $res->content;
   } else {
      $H->{err}= "http://$seq/xml/get_hw_status.xml FAILED!";
   }
   if(length($xml) > 5){
     eval {
       $dom = $parser->parse_string($xml);
     };
     if ($@) {
       Debug->print2("Error parsing XML from http://$seq/xml/get_hw_status.xml.\n$@");
       $H->{err}.="Error parsing XML from http://$seq/xml/get_hw_status.xml.";
     }
   }
   my @States;
   my $root = $dom->getDocumentElement;
   my @comps= $root->getChildNodes();
   foreach my $comp (@comps) {
     my $name= $comp->getName();
     if ($name eq 'Branch_Breaker'){
       my @states= $comp->getChildNodes();
       foreach my $state (@states) {
         my $sname= $state->getName();
	 if ($sname eq 'State'){
             my $s =Util->trim($state->textContent());
             push(@States,$s);
         }

       }
     }
  }
  $H->{$seq}=\@States;
return $H;
}
1;
