package Agent::NTC;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
use Agent;
use vars qw($AUTOLOAD);
use System;
use base 'Agent';
use strict;
use Util;
use Data::Dumper;

sub new {
  my($self) = Agent->new();
  bless ($self, 'Agent::NTC');
  return $self;
}





sub revision {'$Revision: 1.11 $'}
sub isSelectable {"Power Sequencer"}



sub RUN {
  my($agent, $static_list, $pass) = @_;

  my($timelapse);
  my($report, $device, $id);
  $DB::single=1;
  
  my($pdm) = $agent->get_pdm();
  my($renv) = System->get_renv();
  my $processed_list = [];
  my($today) = Util->today("YMDH");


  foreach $device ( $agent->deviceList($static_list)) {
    next if ($device->{active} eq "N"); 

    Timelapse->startDev( $device);


    Debug->print1("-> NTC Agent: Reading device $device->{name}");


    ($report) = $agent->INSTRUMENTATION($device);

     $id = {  
              deviceName  => $device->{key},
              active      => $device->{active},
              logFile     => "",
              display     => "$device->{name}",
              name        => $device->{name},
              class       => $device->{class},
              category    => Report::CAT_NTC, 
              ip          => "",
           };
     $report = {} if (!$report);
     $agent->copyDev($device, $report);

     $report->{"id.name"} = $device->{name};
     $report->{'id.wwn'} = $device->{wwn};

     my $new_rep = Report->new($id, $report , "");

     require Health::NTC;
     my $problems = PDM->get_last_event();
     Health::NTC->all_logic($new_rep);
     PDM->saveReport($new_rep);

     my ($broke, $abort) = $agent->new_events($problems, $device, 1);
     push(@$processed_list, $device);
     Timelapse->stopDev( $device);

     last if ($broke && $pass == 1 || $abort);

  } 

  return $processed_list;
}


sub INSTRUMENTATION {
  my($agent, $device) = @_;

  return Report->readTest($device) if (System->get_testMode());

  my $report = {};

  $agent->addIdentification($report);

  my $ntc = $device->{name};
  $report->{"info.ip"}   = $ntc;
  $report->{"info.name"} = $ntc;

  my $rc = Agent::NTC->probe($ntc, 1);
  if($rc->{slcSystemFWRev}){
     $report->{"info.ping"} = "OK";
     $report->{"info.firmwareRevision"} = $rc->{slcSystemFWRev};
     $report->{"info.SerialNo"} = $rc->{slcSystemSerialNo};
     $report->{"info.Model"} = $rc->{slcSystemModel};

  }else{
     $report->{"info.ping"} = "CannotPing";
     $report->{"info.firmwareRevision"} = "NA";
     $report->{"info.SerialNo"} = "NA";
     $report->{"info.Model"} = "NA";

     return $report;


  }
  

  # Get POWER supply status
  my $DIR  = System->get_home() . "/snmp/bin";
  my $MIBDIR  = System->get_home() . "/snmp/share/snmp/mibs";
  my $renv  = System->get_renv();
  my $TO  = $renv->{'timeout.snmp'} || 10;
  my $public = "public";

  my $OPT = "-m all -M $MIBDIR -r 0 -t $TO -Osb $ntc $public slc.slcDevices.slcDevPowerSupply";

  my ($err,$output) = Util->run_command("$DIR/snmpwalk $OPT");
  if ($err){
     Debug->errNoRepeat( SNMP_SENSOR => $ntc,8, "Run Command error:".
     "$err: $DIR/snmpwalk $OPT");
  }
  foreach my $line (@$output){
    if($line =~ /lcDevPowerSupply(\w)\.0 = (.*)\(/ ) {
      my $ps = $1;
      my $status = $2;
      $report->{"power.${ps}.status"}  = $status;

    
    }
  }



  # Get MODEM status
  my $OPT = "-m all -M $MIBDIR -r 0 -t $TO -Osb $ntc $public slc.slcDevices.slcDevPCCard";

  my ($err,$output) = Util->run_command("$DIR/snmpwalk $OPT");
  if ($err){
     Debug->errNoRepeat( SNMP_SENSOR => $ntc,8, "Run Command error:".
     "$err: $DIR/snmpwalk $OPT");
  }

  $report->{"pccard_slotmax"} = 0;

  foreach my $line (@$output){
    if($line =~ /slcPCCardCfg(\w*)\.(\d) = (.*)/) {
      my $comp = $1;
      my $slot = $2;
      my $value = $3;
      $value =~ s/\(\d\)//;
      $report->{"pccard.${slot}.$comp"}  = $value;
      if($line =~ /CardType/){
        $report->{"pccard_slotmax"}++;
      }

    
    }
  }



  return $report;

}



sub probe {
 my($class, $ip, $hide) = @_;
  my %H;
  my $VAR1;

  my $alive = Util->ping($ip, 1);
  if ($alive) { #check if its alive
    $H{ip}=$ip;
    $H{name}=$ip;
    my $DIR  = System->get_home() . "/snmp/bin";
    my $MIBDIR  = System->get_home() . "/snmp/share/snmp/mibs";
    my $renv  = System->get_renv();
    my $TO  = $renv->{'timeout.snmp'} || 10;
    my $public = "public";

    my $OPT = "-m all -M $MIBDIR -r 0 -t $TO -Osb $ip $public slc.slcSystem";
    my ($err,$output) = Util->run_command(
                 "$DIR/snmpwalk $OPT");
    if ($err){
       Debug->errNoRepeat( SNMP_SENSOR => $ip,8, "Run Command error:".
       "$err: $DIR/snmpwalk $OPT");
    }
    foreach my $line (@$output){
      my ($key, $value)= split(/\s\=\s/,$line);
      $key =~ s/\.0//;
      $value =~ s/\"//g;
      $H{ $key } = $value;
    }
    if($#$output>5){
      if(!$hide){
          print "  -> found NTC at $ip\n";
      }
    }

  }else{$H{err}="Could not ping";}
  return \%H;
}







###############################################################################
###### export configuration report
###############################################################################
sub REPORT {
  my($class, $host, $r, $arg) = @_;
  
  my $out;
  my($v) = $r->{_value};

  my($renv, $devs, $hosts,$notifs, $Config) = PDM::ConfigFile->read();

  $out .= $class->reportHead($v->{'system.description'}, $r);


  $out .= <<EOF;
 <tr><td bgcolor=$Style::LIGHT align=right>Name:</td><td>$v->{'id.device_name'}</td>
     <td bgcolor=$Style::LIGHT align=right>IP:</td><td>$v->{'id.device_ip'}</td>

 <tr><td bgcolor=$Style::LIGHT align=right>Revision:</td><td>$v->{'id.device_sysRevision'}&nbsp;</td>
     <td bgcolor=$Style::LIGHT align=right>Key:</td><td>$v->{'id.device_key'}d&nbsp;</td>


  </table>
EOF





###################################################
# PCCARD

  $out .= "<table border=1 cellspacing=0 width=$Style::WIDTH bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=5><font color=white><b>PC Card</td>
    <tr bgcolor=$Style::LIGHT>
        <td>Name</td>
        <td><center>State</td>
        <td><center>Status</td>
   ";

  foreach my $el (sort keys %$v) 
  {
     my @L = split(/\./, $el);
     my $x  = "$L[0].$L[1]";

     if(($L[0] eq "pccard") && ($el =~ /CardType/)) {

	my $cbname = "Slot $L[1] $v->{\"$el\"}";

	my $status = $v->{"${x}.ModemState"};

	$out .=<<EOF;
        <tr>
          <td><center>$cbname</td>
          <td><center>$status</td>
          <td><center>$status</td>
EOF
     }
  }

  $out .= "</table>";



###################################################
# Power

  $out .= "<table border=1 cellspacing=0 width=$Style::WIDTH bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=5><font color=white><b>Power Supply</td>
    <tr bgcolor=$Style::LIGHT>
        <td>Name</td>
        <td><center>Status</td>
   ";

  foreach my $el (sort keys %$v) 
  {
     my @L = split(/\./, $el);
     my $x  = "$L[0].$L[1]";

     if ($L[0] eq "power") {
	my $cbname = "Power Supply $L[1]";

	my $status = $v->{"$el"};

	$out .=<<EOF;
        <tr>
          <td><center>$cbname</td>
          <td><center>$status</td>
EOF
     }
  }

  $out .= "</table>";



  $out .= "&nbsp;<p>&nbsp;";
  return $out;
}

1;
