package Agent::INTERNAL;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name: bld61_002 $ 

#  $Id: INTERNAL.pm,v 1.2 2004/09/20 23:15:39 mckenney Exp $


use strict;
use Agent;
use base 'Agent';

sub isSelectable {"Internal FC Disks"}
sub revision {'$Revision: 1.2 $'}

sub category {Report::CAT_INTERNAL}
use vars qw ($ERR);


sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::INTERNAL');
  return $self;
}


sub RUN {
  my($agent, $static_list, $pass) = @_;
  my($HBA, $logfile, $r, @results);
  my($xml, @lux_dif, $dif, $ev, $found);
  my($log_err, $lines, $timelapse);
  my(%DONE, $report, $device, $wwn, $id, $x, $l, $connect_errs);
  $DB::single=1;
  
  my($renv) = System->get_renv();

  my $processed_list = [];
  my($today) = Util->today("YMDH");
  my $dc;
  foreach $device ( $agent->deviceList($static_list)) {
    $dc++;

    Debug->print1("-> " . uc($device->{type}) . ": Reading Internal FC Disks");
    my($key);
    ($key, $connect_errs, $report) = $agent->INSTRUMENTATION($device);

     $id = {  
              deviceName  => "ID" . $renv->{hostname},
              active      => $device->{active},
              logFile     => "",
              display     => "Internal FC Disks",
              name        => "internal",
              class       => $device->{class},
              category    => $agent->category(),
              ip          => "",
           };
     $report = {} if (!$report);
     $agent->copyDev($device, $report);
     $report->{"id.name"} = $device->{name};
     $report->{"id.wwn"}  = $device->{key};
    $report->{"id.mgmtLevel"}   = $device->{mgmtLevel};

     my $new_rep = Report->new($id, $report , undef);
     my $problems = PDM->get_last_event();
     require Health::Internal;
     Health::Internal->all_logic($new_rep);
     PDM->saveReport($new_rep);

     my ($broke, $abort) = $agent->new_events($problems, $device, 1);
     push(@$processed_list, $device);
  } 
  return  $processed_list;
}

############################################################################


  
#luxadm display 200000203717db8d

##DEVICE PROPERTIES for disk: 200000203717db8d
#  Status(Port A):       O.K.
#  Vendor:               SEAGATE 
#  Product ID:           ST118273FSUN18G 
#  WWN(Node):            200000203717db8d
#  WWN(Port A):          210000203717db8d
#  Revision:             9954
#  Serial Num:           LP7381080000
#  Unformatted capacity: 17274.674 MBytes
#  Read Cache:           Enabled
#    Minimum prefetch:   0x0
#    Maximum prefetch:   0xffff
#  Device Type:          Disk device
#  Path(s):
#  /dev/rdsk/c0t0d0s2
#  /devices/sbus@2,0/SUNW,socal@d,10000/sf@0,0/ssd@w210000203717db8d,0:c,raw


sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my(@s, %dev, $in, %info, $key, $state, $num);
  my($v3, $v1, $v2, $x, $wwn, $status, $rev, $ib, $no, $id);

  if (System->get_testMode()) {
     my $testrep = Report->readTest($device);
     return ("internal", "", $testrep);
  }

  Timelapse->startDev( $device);

  my $renv  = System->get_renv();
  my $TO    = $renv->{'timeout.luxadm'};

  my @WWNS = split(/,/, $device->{wwn2});
  my $cnt;
  for ($cnt=0; $cnt <= $#WWNS; $cnt++) {
     my $wwn = $WWNS[$cnt];
     my $lux = "/usr/sbin/luxadm";
     my $w = $device->{wwn};
     my($err,$com) = Util->run_command("$lux display $wwn 2>&1", "luxadm.txt" , $TO);

     if ($err) {
        $info{"disk.$cnt.error"} = $err;
     }
     foreach my $l (@$com) {
         my($name, $val) = split(/\s*:\s*/, $l);
         $name =~ s/ +//g;
         if ($name =~ /Node/) {
             $info{"disk.$cnt.NodeWWN"} = $val;

         } elsif ($name =~ /Status/) {
             $val =~ s/\.//g;
             $info{"disk.$cnt.Status"} = $val;

         } elsif ($name =~ /capacity/) {
             $info{"disk.$cnt.Capacity"} = $val;

         } elsif ($name =~ /Vendor/ || $name =~ /Product/ || 
                  $name =~ /Revision/ || $name =~ /Serial/ ||
                  $name =~ /Read/ || $name =~ /Type/) {
             $info{"disk.$cnt.$name"} = $val;
         }
      }
  }
  $info{"info.count"} = $#WWNS + 1;

  $agent->addIdentification(\%info);
  Timelapse->stopDev( $device);

  return ($device->{key}, "", \%info);
}

sub FRUS {
  my($class, $r, $name) = @_;
  my (@FRUS, $x);
  my $devtype = $r->category();
  my $v = $r->{_value};

  foreach my $el (keys %$v) {
    if ($el =~ /disk\.(\d+)\.ProductID/) {
       my $x = $1;
       push(@FRUS, [$name, $devtype, "disk","disk.$x",
                  $v->{"disk.$x.Vendor"},
                  $v->{"disk.$x.ProductID"},
                  $v->{"disk.$x.SerialNum"},
                  $v->{"disk.$x.Revision"}, 
                  $v->{"disk.$x.Status"}] );
    }
  }
  return \@FRUS;
}


sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($out);
  my($tableCnt) = $arg->{tableCnt};
  my($rev) = $r->{'_value'}{"revision.value"};
  my($host0) = $host || System->hostname();
  $out .= $class->reportHead('A5K', $r);
  $out .= "
   <tr><td bgcolor=#F0F0F0 align=right><b>Name:</td><td width=25%>&nbsp;$r->{_id}{name}</td>
       <td bgcolor=#F0F0F0 align=right><b>Monitored on:</td><td>&nbsp;$host0</td>
  
  </table>
  
  <table border=1 cellspacing=0 cellpadding=1 width=100% bgcolor=white>
   ";

  my($name) = $r->{_id}{name};
  my($v) = $r->{_value};
  my ($max, @R);
  foreach my $k (keys %$v) {
     if ($k =~ /^disk\.(\d+)\.(.*)/) {
        my $ix = $1;
        $max = $ix if ($ix > $max);
        $R[$ix]{$2} = $v->{$k};
         
     }
  }
  my($x);
  for ($x=1; $x <= $max; $x++) {
     $out .= "<tr><td colspan=4 bgcolor=$Style::LIGHT><b>&nbsp; Disk # $x</td>";
     my $v = $R[$x];
     my $cnt = 0;
     foreach my $k (sort keys %$v) {
        $out .= "<tr>" if ($cnt % 2 == 0);
        my $v1 = $v->{$k};
        $v1 =~ s/\//\/ /g;
        $out .= "<td align=right>$k:</td><td>&nbsp;$v1</td>\n";
        $cnt++;
     }
  }
  $out .= "</table><p>&nbsp;<p>\n";

  return $out;

}


1;


