package Agent::5310;

#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  Keyur Desai 
#  $Id: 
use strict;
use Agent;
use Agent::5210;
use base 'Agent::5210';
use Revision;
use Report;
use Matrix;
use System;
use Util;

sub isSelectable {"Sun 5310"}

sub revision {'$Revision: 1.3 $'}

# DO NOT REMOVE THIS COMMENT
# Report::CAT_5310MESSAGE
sub category { Report::CAT_5310 }

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::5310');
  return $self;
}
use vars qw ($ERR);

###############################################
# sub INSTRUMENTATION
###############################################
sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my(@s, %dev, $in, $key, $state, $num);
  my $report = {};

  if (System->get_testMode()) {
     my $testrep = Report->readTest($device);
     return ($device->{key}, "", $testrep);
  }

  my $renv = System->get_renv();
  my $ping_to  = $renv->{'timeout.ping'} || 20;
  my $public = $renv->{'snmp.comunity'} || "public";
  my $TO = $renv->{'timeout.snmp'} || 40;
  my $DIR = System->get_home();
  my $ip = $device->{ip};
  my $MIBDIR = System->get_home() . "/snmp/share/snmp/mibs";

  $TO = 2*$TO;
  my $retry = 2;

  my $OPT = "-v1 -c$public -r$retry -t$TO -Ose";

  my $type = $device->{userLabel};

  my $ext;
  my $mibext;
  my $isClustered = "No";
  if ($type eq "5310C") {
    $ext = "5310C";
    $mibext = "5310c";
    $isClustered ="Yes";
  } else {
    $ext = "5310";
    $mibext = $type;	
  }

  $report->{'info.ethernet_status'} = "ok";

  # CHECK for access problem
  if (!$device->{path} && $device->{ipno} && !Util->ping($device->{ipno},$ping_to)) {
     $report->{'info.ethernet_errs'} = "Ping failed to $device->{ipno} (timeout=$ping_to)";
     $report->{'info.ethernet_status'} = "ping_failed";
     return ($device->{key}, "Ping failed", $report);
  }

  # START TIMELAPSE ON A DEVICE
  Timelapse->startDev( $device); 


  # REPLACE THIS PART
  
  # Put SNMP Walk stuff here.

  my $raidtable =[];
  # 1. Do all the walks by table
  my($err_systemtable,$systemtable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."System",
                       "System Group", 5*$TO +5);

  my($err_interfacestable,$interfacestable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/mcdata/rfc1213.mib $ip interfaces",
                       "MIB2 Interface Group", 3*$TO +5);

  my($err_environmentable,$environmenttable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."Environment",
                       "Environment Group", 2*$TO +5);

  my($err_optionstable,$optionstable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."Options",
                       "Options Group", 2*$TO +5);

#  my($err_raidControllertable,$raidControllertable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidControllerTable",
#                       "RAID Controller", 2*$TO +5);
# Break Controller table in to small tables for performance reasons.

  my($err_raidControllertableN,$raidControllerName) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidControllerName",
                       "RAID Controller Name", 2*$TO +5);
  push (@$raidtable, @$raidControllerName);

  my($err_raidControllertable,$raidControllerVendor) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidControllerVendor",
                       "RAID Controller Vendor", 2*$TO +5);
  push (@$raidtable, @$raidControllerVendor);

  my($err_raidControllertable,$raidControllerModel) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidControllerModel",
                       "RAID Controller Model", 2*$TO +5);
  push (@$raidtable, @$raidControllerModel);

  my($err_raidControllertableF,$raidControllerFirmware) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidCtlrFirmwareVersion",
                       "RAID Controller Firmware", 2*$TO +5);
  push (@$raidtable, @$raidControllerFirmware);

  my($err_raidControllertableE,$raidControllerEnclCount) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidCtlrEnclosureCount",
                       "RAID Controller Encl Count", 2*$TO +5);
  push (@$raidtable, @$raidControllerEnclCount);

  my($err_raidControllertable,$raidControllerStatus) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidControllerStatus",
                       "RAID Controller Status", 2*$TO +5);
  push (@$raidtable, @$raidControllerStatus);


# End of push
#  push (@$raidtable, @$raidControllertable); 

  my($err_raidChanneltable,$raidChanneltable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidChannelTable",
                       "RAID Channel", 2*$TO +5);
  push (@$raidtable, @$raidChanneltable);

  my($err_raidPhysicaltable,$raidPhysicalDrivetable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidPhysicalDriveTable",
                       "RAID Physical Drive", 30*$TO +5);
  push (@$raidtable, @$raidPhysicalDrivetable);

  my($err_raidSystemtable,$raidSystemDrivetable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidSystemDriveTable",
                       "RAID System Drive", 2*$TO +5);
  push (@$raidtable, @$raidSystemDrivetable); 

  my($err_raidBBUtable,$raidBBUtable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidBBUTable",
                       "RAID BBU", 2*$TO +5);
  push (@$raidtable, @$raidBBUtable);

  my $noOfEnclosure = 0;
  foreach my $x (@$raidControllerEnclCount) {
    my(@a) = split(/ +\= */, $x);
    $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
    $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");

    $noOfEnclosure = $noOfEnclosure + $a[1];	
  }

  if (($noOfEnclosure) && ($noOfEnclosure > 1)) {
    my($err_raidEnclosuretable,$raidEnclosuretable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidEnclosureTable",
                       "RAID Enclosure", 2*$TO +5);
    push (@$raidtable, @$raidEnclosuretable);

    my($err_raidPowertable,$raidPowerSupplytable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidPowerSupplyTable",
                       "RAID Power Supply", 2*$TO +5);
    push (@$raidtable, @$raidPowerSupplytable);

    my($err_raidFantable,$raidFantable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidFanTable",
                       "RAID Fan", 2*$TO +5);
    push (@$raidtable, @$raidFantable);

    my($err_raidTStable,$raidTStable) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$ext."RaidThermalSensorTable",
                       "RAID TS", 2*$TO +5);
    push (@$raidtable, @$raidTStable);
  }

  if ($err_systemtable || $err_interfacestable || $err_raidControllertable || $err_environmentable || $err_raidPhysicaltable || $err_raidSystemtable) {
    Debug->err(SNMP => "Cannot run snmp on $ip:$err_systemtable$err_interfacestable$err_raidControllertable$err_environmentable$err_raidPhysicaltable$err_raidSystemtable");
    $report->{'rc.error'} = "$err_systemtable$err_interfacestable$err_raidControllertable$err_environmentable,$err_raidPhysicaltable$err_raidSystemtable";
    return ($device->{key}, "Cannot run SNMP", $report);
  } 

  # 2. Parse the each tables 
  my $totalController = 0;
  my $totalBattery = 0;
  my $totalPort = 0;
  my $totalPowerSupply = 0;
  my $totalFan = 0;
  my $totalSensor = 0; 
  my $totalLogicalDrive = 0;
  my $totalPhysicalDrive = 0;
  my $totalPartition = 0;
  my $totalChannel = 0;
  my $totalEnvPowerSupply = 0;
  my $totalEnvFan = 0;
  my $totalEnvSensor = 0;
  my $totalMirror = 0;

  foreach my $x (@$systemtable) {
     my(@a) = split(/ +\= */, $x);

     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     if ($type eq "5310C") {
	$a[0] =~ s/se5310C//;
     } else {
        $a[0] =~ s/se5310//;	
     }
      
     if (($a[0] =~ /Sys/) || ($a[0] =~ /OsVersion/) ) {
         $report->{'info.'.$a[0]} =  $a[1];
     } elsif ($a[0] =~ /Partition/)  {
	 my $ix = rindex($a[0],".");
	 my $partitionNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);

         if ($a0 =~ /Mode/) {
            $a[1] = $agent->snmpPartitionModeToText($a[1]);
	    $totalPartition++;
         }

	 $report->{'partition.'.$partitionNumber. '.' .$a0} =  $a[1];
         
     } elsif ($a[0] =~ /Processor/)  {
         my $ix = rindex($a[0],".");
	 my $processorNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 $report->{'processor.'.$processorNumber. '.' .$a0} =  $a[1];

     } 
  }

  foreach my $x (@$interfacestable) {
     my(@a) = split(/ +\= */, $x);

     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     $a[0] =~ s/if//;

     my $ix = rindex($a[0],".");
     my $portID = substr($a[0],$ix+1); 
     my $a0 = substr($a[0],0,$ix);
     
     $a[1] =~ s/Gauge\d+\://;
     $a[1] =~ s/Counter\d+\://;
     if ($a0 =~ /Status/) {
         $a[1] = $agent->snmpPortStatusToText($a[1]);
     } elsif ($a0 =~ /Type/) {
	 
         $a[1] = $agent->snmpPortTypeToText($a[1]);
 	 $totalPort++;
	 
     }

     $report->{'port.'.$portID. '.' .$a0} =  $a[1];

  }


  foreach my $x (@$raidtable) {
     my(@a) = split(/ +\= */, $x);

     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     if ($type eq "5310C") {
	$a[0] =~ s/se5310C//;
     } else {
        $a[0] =~ s/se5310//;	
     }
     
     if (($a[0] =~ /RaidController/) || ($a[0] =~ /RaidCtlr/)) {
         my $ix = rindex($a[0],".");
         my $controllerNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 
	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpRaidCntrlStatusToText($a[1]);
	    $totalController++;
         }

         $report->{'controller.'.$controllerNumber. '.' .$a0} =  $a[1];
     } elsif ($a[0] =~ /RaidChannel/)  {
         my $ix = rindex($a[0],".");
         my $channelNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);           
	 $a0 = substr($a0,0,-2);

	 if ($a0 =~ /RaidChannelConnectedDevice/) {
	     $totalChannel++;
	 }

         $report->{'channel.'.$channelNumber. '.' .$a0} =  $a[1];
     } elsif (($a[0] =~ /RaidPhysicalDrive/) || ($a[0] =~ /RaidPhysDrive/))  {
         my $ix = rindex($a[0],".");
         my $diskdriveNumber = substr($a[0],$ix+1); 
	 
	 my $splita0 = substr($a[0],0,$ix);
	 my $channelix = rindex($splita0,".");
	 my $channelID = substr($splita0,$channelix+1);

	 my $splitAa0 = substr($a[0],0,$channelix);
	 my $controllerix = rindex($splitAa0,".");
	 my $controllerID = substr($splitAa0,$controllerix+1);


	 my $a0 = substr($a[0],0,$controllerix); 

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpPhysicalDriveStatusToText($a[1]);
	    $totalPhysicalDrive++;
         }  elsif ($a0 =~ /Type/) {
            $a[1] = $agent->snmpPhysicalDriveTypeToText($a[1]); 
         }

	 next if (($a0 =~ /RaidPhysDriveSectorRead/) || 
	          ($a0 =~ /RaidPhysDriveSectorWrite/));
	 
	 if ($noOfEnclosure <= 2) { # Audi 1.0 for backward compatibility 
	   $report->{'physicaldrive.'.$channelID."-".$diskdriveNumber. "." .$a0} =  $a[1];
	 } else { # Audi 1.1 
	   $report->{'physicaldrive.'.$controllerID."-".$channelID."-".$diskdriveNumber. "." .$a0} =  $a[1];
	 }
     } elsif (($a[0] =~ /RaidSystemDrive/) || ($a[0] =~ /RaidSysDrive/))  {
         my $ix = rindex($a[0],".");
         my $logicaldriveNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix); 

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpSystemDriveStatusToText($a[1]);
	    $totalLogicalDrive++;
         } elsif ($a0 =~ /CachePolicy/) {
            $a[1] = $agent->snmpCachePolicyToText($a[1]);
         } 

	 $report->{'logicaldrive.'.$logicaldriveNumber. '.' .$a0} =  $a[1];
     } elsif ($a[0] =~ /RaidBBU/ || $a[0] =~ /RaidBat/ || $a[0] =~ /RaidCharge/ )  {
         my $ix = rindex($a[0],".");
         my $batteryNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 
         if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpBatteryStatusToText($a[1]);
	    $totalBattery++;
         } elsif ($a0 =~ /Type/) {
            $a[1] = $agent->snmpBatteryTypeToText($a[1]); 
         }
	  
	 $report->{'battery.'.$batteryNumber. '.' .$a0} =  $a[1];
     } elsif ($a[0] =~ /RaidEnclosure/)  {
         my $ix = rindex($a[0],".");
         my $enclNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 $report->{'raid_enclosure.'.$enclNumber. '.' .$a0} =  $a[1];          
     } elsif ($a[0] =~ /RaidPowerSupply/)  {
         my $ix = rindex($a[0],".");
         my $powerSupplyNumber = substr($a[0],$ix+1); 
	 #my $a0 = substr($a[0],0,$ix);

	 my $splitAa0 = substr($a[0],0,$ix);
	 my $enclosureix = rindex($splitAa0,".");
	 my $enclosureID = substr($splitAa0,$enclosureix+1);

	 my $a0 = substr($a[0],0,$enclosureix); 

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpStatusToText($a[1]);
	    if ($a[1] ne "absent") {
	        $totalPowerSupply++;
	    }
         }
	 if ($noOfEnclosure <= 2) { # Audi 1.0 for backward compatibility 
	   $report->{'powersupply.'.$powerSupplyNumber. '.' .$a0} =  $a[1]; 
	 } else  {
	   $report->{'powersupply.'.$enclosureID."-".$powerSupplyNumber.'.' .$a0} =  $a[1];
	 }
     } elsif ($a[0] =~ /RaidFan/)  {
         my $ix = rindex($a[0],".");
         my $fanNumber = substr($a[0],$ix+1); 
	 #my $a0 = substr($a[0],0,$ix);

	 my $splitAa0 = substr($a[0],0,$ix);
         my $enclosureix = rindex($splitAa0,".");
	 my $enclosureID = substr($splitAa0,$enclosureix+1);

	 my $a0 = substr($a[0],0,$enclosureix); 
	 
	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpStatusToText($a[1]);
	    if ($a[1] ne "absent") {
 	    	$totalFan++;
	    }
         } elsif ($a0 =~ /Speed/) {
            $a[1] = $agent->snmpSpeedToText($a[1]);
         }

	 if ($noOfEnclosure <= 2) { # Audi 1.0 for backward compatibility 
  	    $report->{'fan.'.$fanNumber. '.' .$a0} =  $a[1]; 
	 } else  {
	    $report->{'fan.'.$enclosureID."-".$fanNumber. '.' .$a0} =  $a[1];
   	 }
 
     } elsif (($a[0] =~ /RaidThermalSensor/) ||
              ($a[0] =~ /RaidTemperature/))   {
         my $ix = rindex($a[0],".");
         my $thsensorNumber = substr($a[0],$ix+1); 
	 #my $a0 = substr($a[0],0,$ix);

  	 my $splitAa0 = substr($a[0],0,$ix);
         my $enclosureix = rindex($splitAa0,".");
	 my $enclosureID = substr($splitAa0,$enclosureix+1);

	 my $a0 = substr($a[0],0,$enclosureix); 

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpStatusToText($a[1]);
	    $totalSensor++;
         }

	 if ($noOfEnclosure <= 2) { # Audi 1.0 for backward compatibility 
   	    $report->{'thermalsensor.'.$thsensorNumber. '.' .$a0} =  $a[1]; 
	 } else {
	    $report->{'thermalsensor.'.$enclosureID."-".$thsensorNumber. '.' .$a0} =  $a[1]; 
	 }
     }   
  }

  foreach my $x (@$environmenttable) {
     my(@a) = split(/ +\= */, $x);

     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     if ($type eq "5310C") {
	$a[0] =~ s/se5310C//;
     } else {
        $a[0] =~ s/se5310//;	
     }


     if (($a[0] =~ /UpsStatus/) || ($a[0] =~ /UpsEstMinuteRemain/) ||
         ($a[0] =~ /UpsEstChargeRemain/) || ($a[0] =~ /UpsTransferCause/)) {
	 if ($a[1] eq "-1") { # -1 equal to 0
	     $a[1] = "Not applicable";
	 } 
	 
	 if ($a[0] =~ /UpsTransferCause/) {
	     $a[1] = $agent->snmpUpsTransferToText($a[1]);
	 }
	  
     	 $report->{'ups.'.$a[0]} =  $a[1];
     } elsif ($a[0] =~ /EnvPower/)  {
         my $ix = rindex($a[0],".");
         my $powerSupplyNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);

	 if ($a0 =~ /Status/) {
            $a[1] = $agent->snmpEnvPowerStatusToText($a[1]);
	    if (($a[1] eq "normal") || ($a[1] eq "warning")) {
 	      $totalEnvPowerSupply++;
	    }	     
         }

	 $report->{'environment_ps.'.$powerSupplyNumber. '.' .$a0} =  $a[1]; 
     } elsif ($a[0] =~ /EnvFan/)  {
         my $ix = rindex($a[0],".");
         my $fanNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);
	 my $status = "failed";
	 
         if ($a0 =~ /RPM/) {
	    if ($a[1] ne 0) {
	      $status = "normal";
	    }
	    $totalEnvFan++;
         }

	 $report->{'environment_fn.'.$fanNumber. '.' .$a0} = $a[1]; 
	 $report->{'environment_fn.'.$fanNumber.'.EnvFanStatus'} = $status;
     } elsif ($a[0] =~ /EnvTemperature/)  {
         my $ix = rindex($a[0],".");
         my $thsensorNumber = substr($a[0],$ix+1); 
	 my $a0 = substr($a[0],0,$ix);			    

	 if ($a0 =~ /Temperature/) {
	    $totalEnvSensor++;
         }

	 $report->{'environment_ts.'.$thsensorNumber. '.' .$a0} =  $a[1]; 
     }   
  }

				      
  # Options Group
  foreach my $x (@$optionstable) {
     my(@a) = split(/ +\= */, $x);

     $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
     $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
     if ($type eq "5310C") {
	$a[0] =~ s/se5310C//;
     } else {
        $a[0] =~ s/se5310//;	
     }

     my $ix = rindex($a[0],".");
     my $mirrorNumber = substr($a[0],$ix+1); 
     my $a0 = substr($a[0],0,$ix);

     next if ($a[1] =~ /End of MIB/i);

     if ($a[0] =~ /Mirror/) {
     
        if ($a0 =~ /Status/) {
            $totalMirror++;
        }

        $report->{'mirror.'.$mirrorNumber. '.' .$a0} =  $a[1]; 
     }		

  }

  $report->{'info.totalJBODFan'} =  $totalFan;
  $report->{'info.totalJBODThermalSensor'} = $totalSensor;
  $report->{'info.totalJBODPowerSupply'} =  $totalPowerSupply;
  $report->{'info.totalBattery'} = $totalBattery;
  $report->{'info.totalPhysicalDiskDrive'} =  $totalPhysicalDrive;
  $report->{'info.totalLogicalDiskDrive'} =  $totalLogicalDrive;
  $report->{'info.totalPort'} =  $totalPort - 1;
  $report->{'info.totalRaidController'} =  $totalController;
  $report->{'info.totalPartition'} = $totalPartition;
  $report->{'info.totalChannel'} = $totalChannel;
  $report->{'info.totalEnclosureCount'} =  $noOfEnclosure;
  $report->{'info.totalEnvironmentFan'} =  $totalEnvFan;
  $report->{'info.totalEnvironmentPowerSupply'} = $totalEnvPowerSupply;
  $report->{'info.totalEnvironmentTempSensor'} = $totalEnvSensor;
  $report->{'info.totalMirror'} = $totalMirror;
  $report->{'info.isClustered'}= $isClustered;


  # ADD Site Identification data to the report
  $agent->addIdentification($report);

  # ADD 'rc.key' to the report
  $report->{'rc.key'} = $device->{key};
  Timelapse->stopDev( $device); 

  # RETURN a pointer to the HASH
  return ($device->{key}, "", $report);

}

##########################################
# sub getWWN
##########################################
sub getWWN {
  my($agent, $name, $host) = @_;
  my($wwn);
  $ERR = undef;
  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.snmp'} || 40;

  if (!$host) {
     return &get_WWN({name => $name});
  } else {
     my $rc = Util::Http->getCommand($host, "Agent::5310::WWN&name=$name&HTTP=1" , $TO);
     if ($rc !~ /OK /) {
        $ERR = "5310: getWWN: cannot identify $name on $host";
        return undef;
     } else {
        my $VAR1;
        my $ix = index($rc, "OK ");
        eval substr($rc,$ix+3);
        return $VAR1;
     }
  }
}

##########################################
# Identifying a 5310
##########################################
sub get_WWN {
  my($q) = @_;
  my $report = {};
  my $rc = {};
  my $DIR = System->get_home();
  my $renv = System->get_renv();
  my $TO  = $renv->{'timeout.snmp'} || 40;
  my $public = $renv->{'snmp.community'} || "public";
  my $MIBDIR = System->get_home() . "/snmp/share/snmp/mibs";
  my $OPT = "-v1 -c$public -r1 -t$TO -Ose";
  my $ip = $q->{name};

  my $comm;
  

  if (Util->ping($q->{name}, 10) ){
    #my $err = Agent::5310->getConfig({ipno => $q->{name} }, $report);
    #if($err){
    #   $rc->{error} = "Error on getConfig, $err";
    #}else{  
       
       my $isClusteredSystem;
       $comm = "$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5310_1.mib $ip se5310SysSerialNo";
       my($err,$id) = Util->run_command($comm, "getSN", 2*$TO+5);

       my $idref = \@$id;
       if ($idref->[0]) {
       } else {
          # Try the 5310 C system
          $comm = "$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5310c_1.mib $ip se5310CSysSerialNo";
  	  ($err,$id) = Util->run_command($comm, "getSN", 2*$TO+5);
	  $isClusteredSystem = 1;
       }

       #$comm = "$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se5310_1.mib $ip se5310SysSerialNo";
       #my($err,$os) = Util->run_command($comm, "getOs", 2*$TO+5);

       my($sn,$osver);
       								        
       foreach my $x (@$id) {
           my(@a) = split(/ +\= */, $x);

           $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
           $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
	   
	   $sn = $a[1];
       }
       
       $rc->{key}      = $sn;
       $rc->{wwn}      = $sn;
       $rc->{type} = "5310";

       if ($isClusteredSystem) {
       	 $rc->{userLabel}= "5310C";
       } else {
         $rc->{userLabel} = "5310";
       }       

       $rc->{error}    = $err;       
       #$rc->{model}    = $report->{'info.model'};
       #$rc->{disk_map} = $report->{"info.disk_map"};
       #$rc->{top_disk} = $report->{"info.top_disk"};
       #$rc->{units}    = 1;
       #$rc->{wwns}     = "";
       #$rc->{revision} = $osver;
       $rc->{serial}   = $sn;
       $rc->{ip}       = $ip;
       $rc->{ipno}     = Util->name2ip($rc->{ip});
     #}  
  } else {
    $rc->{error} = "Cannot ping $q->{name}";
  }

  if ($q->{HTTP}) {
    $Data::Dumper::Indent = 0;
    print "\nOK " . Data::Dumper::Dumper($rc) . "\n";
  } else {
    return $rc;
  }
}

  ## 
# For Topology, Work on it in future.
##
sub getInfoForTopology {
  
  my($class, $name, $type) = @_;
  my $rc = {};
  my $DIR = System->get_home();
  my $renv = System->get_renv();
  my $TO  = $renv->{'timeout.snmp'} || 40;
  my $public = $renv->{'snmp.community'} || "public";
  my $MIBDIR = System->get_home() . "/snmp/share/snmp/mibs";
  my $OPT = "-v1 -c$public -r1 -t$TO -Ose";
  my $ip = $name;

  my $mibext = $type;
  if ($type eq "5310C") {
     $mibext = "5310c";	
  }

  my $comm;
  
  if (Util->ping($ip, 10) ){
 
       $comm = "$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$type."RaidCtlrEnclosureCount";
       my($err,$enclCount) = Util->run_command($comm, "No. of Enclosure", 2*$TO+5);
       my $enclCnt;
       								        
       foreach my $x (@$enclCount) {
           my(@a) = split(/ +\= */, $x);

           $a[1] = substr($a[1],1,-1) if (substr($a[1],0,1) eq "\"");
           $a[0] = substr($a[0],0,-2) if (substr($a[0], -2) eq ".0");
	  
	   $enclCnt += $a[1];
       }

       my($err_portCount, $portCount) = Util->run_command("$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/mcdata/rfc1213.mib $ip ifIndex",
                       "PortCount", 2*$TO +5);
       my $portCnt = 0;
       foreach my $x (@$portCount) {
         $portCnt++;    
       }

       $comm = "$DIR/snmp/bin/snmpwalk $OPT -m$MIBDIR/se".$mibext."_1.mib $ip se".$type."RaidPhysicalDriveType";
       my($err_diskDrive, $diskCount) = Util->run_command($comm,"No of diskdrive", 2*$TO +5);
       my $diskCnt = 0; # Default is 6
       foreach my $x (@$diskCount) {
         $diskCnt++;    
       }
       if (($diskCnt eq '0') || ($diskCnt eq '7')) {
	 $diskCnt = 6; 
       }
       
       if ($portCnt ne 0) {
         $portCnt = $portCnt - 1; # Filter out lo0     
       }

       $rc->{'portCount'} = $portCnt;
       $rc->{'diskCount'} = $diskCnt;
       $rc->{'enclCount'} = $enclCnt;

  } else {
    $rc->{error} = "Cannot ping $ip";
  }

  return $rc;
}

1;






