/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.wbem.client;

import com.sun.netstorage.fm.util.Options;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class EnumClass {
    CIMClient cc;
    private static boolean debug = true;
    private static boolean useXML = true;
    public static boolean verbose;

    public EnumClass(String host, String nameSpace, String user, String pass) throws CIMException {
        block7: {
            if (nameSpace == null || "".equals(nameSpace)) {
                nameSpace = "\\root\\cimv2";
            }
            try {
                UserPrincipal principal = new UserPrincipal(user);
                PasswordCredential credential = new PasswordCredential(pass);
                CIMNameSpace cns = new CIMNameSpace(host, nameSpace);
                String protocol = useXML ? "cim-xml" : "cim-rmi";
                String altproto = useXML ? "cim-rmi" : "cim-xml";
                try {
                    this.cc = new CIMClient(cns, (Principal)principal, (Object)credential, protocol);
                }
                catch (Exception e) {
                    if (debug) {
                        System.out.println(protocol + " failed.  Trying " + altproto);
                    }
                    this.cc = new CIMClient(cns, (Principal)principal, (Object)credential, altproto);
                }
            }
            catch (Exception e) {
                if (!debug) break block7;
                e.printStackTrace();
            }
        }
        if (debug) {
            System.out.println("CIM_Client open: " + host + ":" + nameSpace + "&" + user + "@" + pass);
        }
    }

    public void enumSubClasses(CIMObjectPath cop) throws CIMException {
        CIMClass topclass = this.cc.getClass(cop, true, true, true, null);
        System.out.println(topclass.toMOF());
        Enumeration e = this.cc.enumerateClasses(cop, true, false, true, true);
        System.out.println("\nSubclasses of " + cop);
        while (e.hasMoreElements()) {
            CIMClass subclass = (CIMClass)e.nextElement();
            System.out.println(subclass.toMOF());
        }
    }

    public void enumInstances(CIMObjectPath cop) throws CIMException {
        Enumeration e = this.cc.enumerateInstances(cop, true, false, verbose, verbose, null);
        System.out.println("Instances of " + cop);
        while (e.hasMoreElements()) {
            CIMInstance ci = (CIMInstance)e.nextElement();
            System.out.println(ci);
        }
    }

    public void enumRefInstances(CIMObjectPath cop) throws CIMException {
        Enumeration e = this.cc.enumerateInstanceNames(cop);
        while (e.hasMoreElements()) {
            CIMObjectPath instPath = (CIMObjectPath)e.nextElement();
            StringBuffer buf = new StringBuffer();
            this.printCop(instPath, buf, 1);
            System.out.println("instance of : " + buf.toString() + "\n");
        }
    }

    public void printInstance(CIMObjectPath cop) throws CIMException {
        CIMInstance ci = this.cc.getInstance(cop, false, verbose, true);
        System.out.println("CIMObjectPath=" + cop);
        System.out.println(ci);
    }

    public void printCop(CIMObjectPath cop, StringBuffer buf, int level) {
        buf.append(cop.getObjectName());
        buf.append(":\n");
        Vector keys = cop.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            CIMProperty cp = (CIMProperty)keys.get(i);
            CIMValue cv = cp.getValue();
            Object value = cv == null ? new String("null") : cv.getValue();
            this.tabLevel(buf, level);
            buf.append(cp.getName());
            buf.append("=");
            if (value instanceof CIMObjectPath) {
                this.printCop((CIMObjectPath)value, buf, level + 1);
            } else {
                buf.append(value.toString());
            }
            if (i == keys.size() - 1) continue;
            buf.append("\n");
        }
    }

    public void tabLevel(StringBuffer buf, int level) {
        if (level < 0) {
            return;
        }
        for (int i = 0; i < level; ++i) {
            buf.append("\t");
        }
    }

    public void cleanup() throws CIMException {
        if (this.cc != null) {
            this.cc.close();
        }
    }

    public static void usage() {
        System.out.println("Usage: EnumClass [options] <CIM_Class> [key=value]...");
        System.out.println("\t-h <host>      CIMOM host name");
        System.out.println("\t-u <user>      CIMOM user name");
        System.out.println("\t-p <passowd>   CIMOM password");
        System.out.println("\t-n <namespace> CIMOM name space");
        System.out.println("\t-I             Enum class instances.");
        System.out.println("\t-C             Print classes.");
        System.out.println("\t-v             Verbose listings.");
    }

    public static void main(String[] args) {
        try {
            Options opts = new Options("u:p:n:h:vRIC");
            args = opts.parseOptions(args);
            String userName = opts.getOption("u", "guest");
            String password = opts.getOption("p", "");
            String nameSpace = opts.getOption("n", "\\root\\cimv2");
            String cimomHost = opts.getOption("h", "localhost");
            boolean enumRefs = opts.getFlagOption("R");
            boolean enumInsts = opts.getFlagOption("I");
            boolean enumClass = opts.getFlagOption("C");
            verbose = opts.getFlagOption("v");
            boolean hasKeys = false;
            if (args.length == 0) {
                EnumClass.usage();
                System.exit(-1);
            }
            EnumClass client = new EnumClass(cimomHost, nameSpace, userName, password);
            String className = args[0];
            CIMObjectPath cop = new CIMObjectPath(className);
            for (int i = 1; i < args.length; ++i) {
                int index = args[i].indexOf("=");
                if (index > 0) {
                    hasKeys = true;
                    cop.addKey(args[i].substring(0, index), new CIMValue((Object)args[i].substring(index + 1)));
                    continue;
                }
                EnumClass.usage();
                System.exit(-1);
            }
            System.out.println("CIMObjectPath=" + cop);
            if (enumClass) {
                client.enumSubClasses(cop);
            } else if (enumInsts) {
                if (hasKeys) {
                    client.printInstance(cop);
                } else {
                    client.enumInstances(cop);
                }
            } else {
                client.enumRefInstances(cop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

