/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.resource.report;

import com.sun.netstorage.fm.storade.resource.report.ErrorReportClass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ReportClass
implements Serializable {
    public static String COMM_TYPE = "commType";
    public static String OO_BAND = "oob";
    public static String IN_BAND = "ib";
    private String className;
    private ReportClass parent;
    private Map children;
    private Properties prop = new Properties();
    private String path;
    private String description;

    public ReportClass(String className, String name) {
        this.className = className;
        this.setProperty("_Name", name);
    }

    public ReportClass(String className) {
        this.className = className;
    }

    public ReportClass newSubInstance(String inClassName) {
        ReportClass rc = new ReportClass(inClassName);
        this.addChild(rc);
        return rc;
    }

    public ReportClass newSubInstance(String inClassName, String name) {
        ReportClass rc = new ReportClass(inClassName, name);
        this.addChild(rc);
        return rc;
    }

    public static ReportClass newInstance(File f) {
        return null;
    }

    private static String[] makePath(String in) {
        StringTokenizer st = new StringTokenizer(in, ".");
        LinkedList<String> list = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            String a = st.nextToken();
            String b = null;
            if (st.hasMoreTokens()) {
                b = st.nextToken();
                try {
                    int index = Integer.parseInt(b);
                }
                catch (Exception e) {
                    b = null;
                }
            }
            if (b != null) {
                list.add(a);
                list.add(b);
                continue;
            }
            if (list.size() != 0) continue;
            list.add(a);
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    private static String join(String[] list) {
        String ins = ".";
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                sb.append(list[i]);
                if (i + 1 >= list.length) continue;
                sb.append(ins);
            }
        }
        return sb.toString();
    }

    private static boolean pathMatch(String[] a, String[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length / 2 != b.length / 2) {
            return false;
        }
        int hlen = a.length;
        for (int i = 0; i < hlen; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public ReportClass findChild(String path) {
        return this.findChild(ReportClass.makePath(path));
    }

    private ReportClass findChild(String[] path) {
        return this.findChild(path, 0);
    }

    private ReportClass findChild(String[] path, int offset) {
        try {
            if (path.length + offset < 2) {
                return null;
            }
            List clist = (List)this.children.get(path[offset]);
            int index = Integer.parseInt(path[1 + offset]);
            ReportClass rc = (ReportClass)clist.get(index);
            if (path.length + offset + 2 < 2) {
                return rc;
            }
            return rc.findChild(path, offset + 2);
        }
        catch (Exception e) {
            return null;
        }
    }

    private synchronized ReportClass addChild(String[] path) {
        return this.addChild(path, 0);
    }

    private synchronized ReportClass addChild(String[] spath, int offset) {
        try {
            String cname;
            LinkedList<ReportClass> clist;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((clist = (LinkedList<ReportClass>)this.children.get(cname = spath[offset])) == null) {
                clist = new LinkedList<ReportClass>();
                this.children.put(cname, clist);
            }
            int index = Integer.parseInt(spath[offset + 1]);
            if (clist.size() < index) {
                int toAdd = index - clist.size();
                for (int i = 0; i < toAdd; ++i) {
                    ReportClass child = new ReportClass(cname);
                    clist.add(child);
                    child.path = this.path != null ? this.path + "." + cname + "." + clist.size() : cname + "." + clist.size();
                    child.setParent(this);
                }
            }
            ReportClass rc = (ReportClass)clist.get(index - 1);
            if (spath.length - 3 > offset) {
                return rc.addChild(spath, offset + 2);
            }
            return rc;
        }
        catch (Exception e) {
            return new ErrorReportClass(e);
        }
    }

    private void setPathProperty(String name, String value) {
        if (this.path != null && name.startsWith(this.path)) {
            this.setProperty(name.substring(this.path.length() + 1), value);
            return;
        }
        this.setProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ReportClass newInstance(File f, String separator) {
        Exception e222;
        ReportClass reportClass;
        BufferedReader in;
        FileReader fin;
        block19: {
            String line;
            fin = null;
            in = null;
            fin = new FileReader(f);
            in = new BufferedReader(fin);
            int slen = separator.length();
            String[] cpath = null;
            ReportClass rc = new ReportClass("system");
            ReportClass crep = null;
            while ((line = in.readLine()) != null) {
                int sindex;
                if (line.startsWith("#") || (sindex = line.indexOf(separator)) < 0) continue;
                String name = line.substring(0, sindex);
                String value = line.substring(sindex + slen);
                if (name.endsWith(".count")) continue;
                String[] items = ReportClass.makePath(name);
                if (items.length == 1) {
                    int dindex = name.indexOf(".");
                    if (dindex <= 0) continue;
                    rc.setProperty(name.substring(dindex + 1), value);
                    continue;
                }
                if (!ReportClass.pathMatch(cpath, items)) {
                    cpath = items;
                    crep = rc.findChild(items);
                    if (crep == null) {
                        crep = rc.addChild(items);
                    }
                }
                if (crep == null) continue;
                crep.setPathProperty(name, value);
            }
            reportClass = rc;
            Object var15_17 = null;
            if (in == null) break block19;
            try {
                in.close();
            }
            catch (Exception e222) {
                // empty catch block
            }
        }
        if (fin != null) {
            try {
                fin.close();
            }
            catch (Exception e222) {
                // empty catch block
            }
        }
        return reportClass;
        catch (Exception e3) {
            Exception e222;
            ErrorReportClass errorReportClass;
            block21: {
                try {
                    errorReportClass = new ErrorReportClass(e3);
                    Object var15_18 = null;
                    if (in == null) break block21;
                }
                catch (Throwable throwable) {
                    block23: {
                        Exception e222;
                        Object var15_19 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e222) {
                                // empty catch block
                            }
                        }
                        if (fin == null) break block23;
                        try {
                            fin.close();
                        }
                        catch (Exception e222) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (Exception e222) {
                    // empty catch block
                }
            }
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception e222) {
                    // empty catch block
                }
            }
            return errorReportClass;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public ReportClass getParent() {
        return this.parent;
    }

    public void setParent(ReportClass parent) {
        this.parent = parent;
    }

    public Collection getChildren() {
        LinkedList all = new LinkedList();
        if (this.children == null) {
            return null;
        }
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            all.addAll((Collection)iter.next());
        }
        return all;
    }

    public Collection getChildren(String className) {
        return (Collection)this.children.get(className);
    }

    public Collection getPeers() {
        if (this.parent != null) {
            return this.parent.getChildren();
        }
        return null;
    }

    public Collection getPeers(String className) {
        if (this.parent != null) {
            return this.parent.getChildren(className);
        }
        return null;
    }

    public int getNumChildren() {
        if (this.children == null) {
            return 0;
        }
        Iterator iter = this.children.values().iterator();
        int size = 0;
        while (iter.hasNext()) {
            size += ((Collection)iter.next()).size();
        }
        return size;
    }

    public ReportClass findChild(String className, String propName, String propValue) {
        List cclass;
        if (className == null || propName == null || propValue == null) {
            return null;
        }
        if (this.children != null && (cclass = (List)this.children.get(className)) != null) {
            Iterator iter = cclass.iterator();
            while (iter.hasNext()) {
                ReportClass rc = (ReportClass)iter.next();
                if (!propValue.equals(rc.getProperty(propName))) continue;
                return rc;
            }
        }
        return null;
    }

    public synchronized void addChild(ReportClass child) {
        if (child != null) {
            String ccname;
            LinkedList<ReportClass> list;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((list = (LinkedList<ReportClass>)this.children.get(ccname = child.getClassName())) == null) {
                list = new LinkedList<ReportClass>();
                this.children.put(ccname, list);
            }
            list.add(child);
            child.path = this.path != null ? this.path + "." + ccname + "." + list.size() : ccname + "." + list.size();
            child.setParent(this);
        }
    }

    public Properties getProperties() {
        return this.prop;
    }

    public void setProperties(Properties prop) {
        this.prop = prop;
    }

    public void setProperty(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.prop.setProperty(name, value);
    }

    public void clearProperty(String name) {
        this.prop.remove(name);
    }

    public void setKey(String key) {
        this.setStringProperty("_Key", key, "null");
    }

    public String getKey() {
        return this.getProperty("_Key");
    }

    public void setStringProperty(String name, String value) {
        this.setStringProperty(name, value, "null");
    }

    public void setStringProperty(String name, String value, String defaultValue) {
        if (value == null || value.length() == 0) {
            value = defaultValue;
        }
        this.setProperty(name, value);
    }

    public void setIntProperty(String name, String value) {
        if (value == null) {
            value = "0";
        } else {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                value = "0";
            }
        }
        this.setProperty(name, value);
    }

    public void setFloatProperty(String name, String value) {
        if (value == null) {
            value = "0.0";
        } else {
            try {
                Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                value = "0.0";
            }
        }
        this.setProperty(name, value);
    }

    public String getProperty(String name) {
        if (this.prop == null) {
            return null;
        }
        return this.prop.getProperty(name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void toTab(OutputStream out) {
        PrintWriter pw = new PrintWriter(out);
        this.toLine(pw, "\t");
        pw.flush();
    }

    public void toProperties(OutputStream out) {
        PrintWriter pw = new PrintWriter(out);
        this.toLine(pw, "=");
        pw.flush();
    }

    public void toLine(PrintWriter out, String sep) {
        String root = this.path;
        if (root == null) {
            root = this.className;
        }
        if (this.prop != null) {
            TreeMap<Object, Object> t = new TreeMap<Object, Object>(this.prop);
            Set<Map.Entry<Object, Object>> s = t.entrySet();
            Iterator<Map.Entry<Object, Object>> iter = s.iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                Object name = entry.getKey();
                Object value = entry.getValue();
                out.write(root);
                out.write(".");
                out.write(name.toString());
                out.write(sep);
                out.println(value.toString());
            }
        }
        if (this.children != null) {
            Iterator iter = this.children.keySet().iterator();
            while (iter.hasNext()) {
                String cname = (String)iter.next();
                List clist = (List)this.children.get(cname);
                if (this.path != null) {
                    out.write(this.path);
                    out.write(".");
                }
                out.write(cname);
                out.write(".count");
                out.println(sep + clist.size());
                Iterator citer = clist.iterator();
                while (citer.hasNext()) {
                    ReportClass cc = (ReportClass)citer.next();
                    cc.toLine(out, sep);
                }
            }
        }
    }

    public void toXML(OutputStream out) {
        this.toXML(out, "");
    }

    public void toXML(OutputStream out, String pre) {
        PrintWriter pw = new PrintWriter(out);
        this.toXML(pw, pre);
    }

    public void toXML(PrintWriter out) {
        this.toXML(out, null);
    }

    public void toXML(PrintWriter out, String pre) {
        if (pre == null) {
            this.toXML(out, null, "");
        } else {
            this.toXML(out, "", pre);
        }
    }

    public void toXML(PrintWriter out, String pre, String orig) {
        Collection cc;
        Iterator<Object> iter;
        String name;
        String nextpre = null;
        if (pre != null) {
            nextpre = pre + orig;
            out.write(pre);
        }
        if ((name = this.path) == null) {
            name = this.getProperty("_Name");
        }
        out.write("<class type='");
        out.write(this.className);
        out.write("' id='");
        out.write(name);
        out.write("'>\n");
        if (this.prop != null) {
            TreeMap<Object, Object> t = new TreeMap<Object, Object>(this.prop);
            Set<Map.Entry<Object, Object>> s = t.entrySet();
            iter = s.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (nextpre != null) {
                    out.write(nextpre);
                }
                out.write("<value name='");
                out.write((String)entry.getKey());
                out.write("'>");
                out.write((String)entry.getValue());
                out.write("</value>\n");
            }
        }
        if ((cc = this.getChildren()) != null && (iter = cc.iterator()) != null && iter.hasNext()) {
            while (iter.hasNext()) {
                ((ReportClass)iter.next()).toXML(out, nextpre, orig);
            }
        }
        if (pre != null) {
            out.write(pre);
        }
        out.write("</class>\n");
        out.flush();
    }

    public String toXML() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.toXML(pw);
        return sw.toString();
    }

    public String toXML(String pre) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.toXML(pw, pre);
        return sw.toString();
    }

    private static String encodeXML(String in) {
        int len = in.length();
        StringBuffer sb = new StringBuffer(len);
        ReportClass.encodeXML(in, sb);
        return sb.toString();
    }

    private static void encodeXML(String in, StringBuffer sb) {
        if (in == null) {
            return;
        }
        int len = in.length();
        block7: for (int i = 0; i < len; ++i) {
            char ch = in.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
    }

    public void toSOAP(StringBuffer buf) {
        String root = this.path;
        if (root == null) {
            root = this.className;
        }
        if (this.prop != null) {
            TreeMap<Object, Object> t = new TreeMap<Object, Object>(this.prop);
            Set<Map.Entry<Object, Object>> s = t.entrySet();
            Iterator<Map.Entry<Object, Object>> iter = s.iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                buf.append("<");
                buf.append(root);
                buf.append(".");
                buf.append((String)entry.getKey());
                buf.append(">");
                ReportClass.encodeXML((String)entry.getValue(), buf);
                buf.append("</");
                buf.append(root);
                buf.append(".");
                buf.append((String)entry.getKey());
                buf.append(">\n");
            }
        }
        if (this.children != null) {
            Iterator iter = this.children.keySet().iterator();
            while (iter.hasNext()) {
                String cname = (String)iter.next();
                List clist = (List)this.children.get(cname);
                buf.append("<");
                String cntName = cname + ".count>";
                if (this.path != null) {
                    cntName = this.path + "." + cntName;
                }
                buf.append(cntName);
                buf.append(Integer.toString(clist.size()));
                buf.append("</" + cntName + "\n");
                Iterator citer = clist.iterator();
                while (citer.hasNext()) {
                    ReportClass cc = (ReportClass)citer.next();
                    cc.toSOAP(buf);
                }
            }
        }
    }
}

