/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.whitney;

import com.sun.netstorage.fm.storade.device.storage.treefrog.ReportUtilities;
import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.TreefrogReport;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import devmgr.versioned.symbol.Battery;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.Fan;
import devmgr.versioned.symbol.IOInterfaceTypeData;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PowerSupply;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Sfp;
import devmgr.versioned.symbol.ThermalSensor;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeGroup;
import java.util.Properties;

public class WhitneyReport
extends TreefrogReport {
    public ReportClass generateReport(Properties p, String content) {
        SYMbolAPIClientV1[] client = new SYMbolAPIClientV1[1];
        ObjectBundle objectBundle = null;
        try {
            this.arrayType = p.getProperty("type");
            try {
                objectBundle = this.getConnection(p, client);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message.equals("Missing data") || message.equals("No contact")) {
                    return this.generateErrorReport(p, message);
                }
                return this.generateErrorReport(p, e);
            }
            ReportClass system = this.buildReport(client[0], objectBundle, p);
            return system;
        }
        catch (Exception e) {
            SYMbolConnection.closeClient(client[0]);
            return this.generateErrorReport(p, e);
        }
    }

    private ReportClass buildReport(SYMbolAPIClientV1 client, ObjectBundle objectBundle, Properties props) throws Exception {
        ComponentBundle components = objectBundle.getComponentBundle();
        ReportClass system = new ReportClass("system");
        this.createSystem(system, objectBundle, props);
        Controller[] controllers = objectBundle.getController();
        for (int x = 0; x < controllers.length; ++x) {
            this.createController(system, controllers[x], objectBundle, client);
            IOInterfaceTypeData[] hostPorts = controllers[x].getHostInterfaces();
            for (int port = 0; port < hostPorts.length; ++port) {
                this.createPort(system, hostPorts[port], objectBundle, controllers[x], port, "Host");
            }
        }
        SYMbolConnection.closeClient(client);
        Battery[] batteries = components.getBattery();
        for (int x = 0; x < batteries.length; ++x) {
            this.createBattery(system, batteries[x], objectBundle);
        }
        Drive[] drives = objectBundle.getDrive();
        for (int x = 0; x < drives.length; ++x) {
            this.createDrive(system, drives[x], objectBundle);
        }
        VolumeGroup[] groups = objectBundle.getVolumeGroup();
        for (int x = 0; x < groups.length; ++x) {
            this.createStoragePool(system, groups[x], objectBundle);
        }
        Volume[] volumes = objectBundle.getVolume();
        for (int x = 0; x < volumes.length; ++x) {
            this.createVolume(system, volumes[x], objectBundle);
        }
        Esm[] esms = components.getEsm();
        for (int x = 0; x < esms.length; ++x) {
            this.createESM(system, esms[x], objectBundle);
        }
        Tray[] trays = objectBundle.getTray();
        for (int x = 0; x < trays.length; ++x) {
            this.createMidplane(system, trays[x], x, objectBundle, esms);
        }
        Sfp[] sfps = components.getSfp();
        for (int x = 0; x < sfps.length; ++x) {
            this.createSFP(system, sfps[x], objectBundle);
        }
        Fan[] fans = components.getFan();
        for (int x = 0; x < fans.length; ++x) {
            this.createFan(system, fans[x], objectBundle);
        }
        PowerSupply[] power = components.getPowerSupply();
        for (int x = 0; x < power.length; ++x) {
            this.createPowerSupply(system, power[x], objectBundle);
        }
        ThermalSensor[] ts = components.getThermalSensor();
        for (int x = 0; x < ts.length; ++x) {
            this.createTempSensor(system, ts[x], objectBundle);
        }
        this.createLicences(system, objectBundle);
        return system;
    }

    protected void createFan(ReportClass system, Fan fan, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("fan");
        try {
            Location location = fan.getPhysicalLocation();
            byte[] refToken = fan.getFanRef().getRefToken();
            String deviceID = ReportUtilities.createDeviceID("fan", bundle, location);
            String name = this.createFanName(bundle, location);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "Fan");
            repClass.setStringProperty("_Description", "Fan");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            String status = Translator.translateFanStatus(fan.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing fan data");
        }
    }

    private String createFanName(ObjectBundle bundle, Location location) {
        int tray = -1;
        int slot = -1;
        int controllers = 1;
        try {
            if (bundle == null) {
                tray = -1;
                slot = -1;
            } else if (location == null) {
                slot = -1;
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                controllers = physicalTray.getNumControllerSlots();
                tray = physicalTray.getTrayId();
                slot = location.getSlot();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = "Tray.X.PowerSupply.Y.Fan";
        if (controllers > 0) {
            name = "Tray." + tray + ".PowerSupply." + Translator.getSlotName(slot) + ".Fan";
        } else {
            String postfix = "unspecified";
            switch (slot) {
                case 1: {
                    postfix = "B.Fan.1";
                    break;
                }
                case 2: {
                    postfix = "B.Fan.2";
                    break;
                }
                case 3: {
                    postfix = "A.Fan.1";
                    break;
                }
                case 4: {
                    postfix = "A.Fan.2";
                }
            }
            name = "Tray." + tray + ".PowerSupply." + postfix;
        }
        return name;
    }
}

