/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.mgmt;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.NOCList;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.diags.DiagUtility;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.netstorage.fm.util.PropertyList;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.Battery;
import devmgr.versioned.symbol.BatteryParamsUpdateDescriptor;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveChannelState;
import devmgr.versioned.symbol.DriveChannelStateDescriptor;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.DriveRefList;
import devmgr.versioned.symbol.HostPortRef;
import devmgr.versioned.symbol.HostPortTypeUpdateDescriptor;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.TrayRef;
import devmgr.versioned.symbol.TrayRefList;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.UserAssignedLabel;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeOwnershipUpdateDescriptor;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Controls {
    private static final int DISABLE = 0;
    private static final int ENABLE = 1;
    private static final int SERVICE = 2;
    private static final int CONTROLLER_COUNT = 2;
    public static final String SUCCESSFUL_STATUS = "OK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blinkDriveLED(Map propMap, String deviceID) throws StoradeException {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String status = null;
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            DriveRef ref = Controls.convertToDriveRef(client, deviceID);
            DriveRef[] driveRefs = new DriveRef[]{ref};
            DriveRefList refList = new DriveRefList();
            refList.setDriveRef(driveRefs);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(33));
            ReturnCode rc = client.startDriveIdentification(refList);
            if (rc.getValue() != 1) {
                status = Translator.translateReturnCode(rc);
            }
        }
        catch (Exception e) {
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        if (status != null) {
            throw new StoradeException("Error blinking LED: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blinkTrayLEDs(Map propMap, String deviceID) throws StoradeException {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String status = null;
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            TrayRef ref = Controls.convertToTrayRef(client, deviceID);
            TrayRef[] trayRefs = new TrayRef[]{ref};
            TrayRefList refList = new TrayRefList();
            refList.setTrayRef(trayRefs);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(115));
            ReturnCode rc = client.startTrayIdentification(refList);
            if (rc.getValue() != 1) {
                status = Translator.translateReturnCode(rc);
            }
        }
        catch (Exception e) {
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        if (status != null) {
            throw new StoradeException("Error blinking LED: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blinkArrayLEDs(Map propMap) throws StoradeException {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String status = null;
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(32));
            ReturnCode rc = client.startSAIdentification();
            if (rc.getValue() != 1) {
                status = Translator.translateReturnCode(rc);
            }
        }
        catch (Exception e) {
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        if (status != null) {
            throw new StoradeException("Error blinking LED: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void turnOffLEDs(Map propMap) throws StoradeException {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String status = null;
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(34));
            ReturnCode rc = client.stopIdentification();
            if (rc.getValue() != 1) {
                status = Translator.translateReturnCode(rc);
            }
        }
        catch (Exception e) {
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        if (status != null) {
            throw new StoradeException("Error blinking LED: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String resetBattery(Map propMap, String deviceID) throws Exception {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String status = null;
        String password = Controls.getPassword(props);
        try {
            String ip = props.getProperty("ipno");
            String altip = props.getProperty("altipno");
            String targetip = ip;
            client = SYMbolConnection.getOpenConnection(targetip);
            if (client == null && (client = SYMbolConnection.getOpenConnection(targetip = altip)) == null) {
                String string = "Could not open a connection to the array";
                SYMbolConnection.closeClient(client);
                return string;
            }
            Battery battery = Controls.findBattery(client, deviceID);
            if (battery == null) {
                throw new StoradeException("Could not find a battery using " + deviceID);
            }
            ComponentRef ref = battery.getBatteryRef();
            for (int x = 0; x < 2; ++x) {
                BatteryParamsUpdateDescriptor descr = new BatteryParamsUpdateDescriptor();
                descr.setComponent(ref);
                descr.setResetBatteryAge(true);
                Utility.setClientPassword(password, client);
                client.setTimeout(new ProcedureTimeout().getProcTimeout(89));
                ReturnCode rc = client.setBatteryParams(descr);
                if (rc.getValue() == 13) {
                    status = Translator.translateReturnCode(rc);
                    SYMbolConnection.closeClient(client);
                    targetip = targetip.equals(ip) ? altip : ip;
                    client = SYMbolConnection.getOpenConnection(targetip);
                    if (client != null) continue;
                    String string = "Could not open a connection to the parent controller: " + targetip;
                    SYMbolConnection.closeClient(client);
                    return string;
                }
                if (rc.getValue() == 1) {
                    status = SUCCESSFUL_STATUS;
                    break;
                }
                status = Translator.translateReturnCode(rc);
                break;
            }
            SYMbolConnection.closeClient(client);
            return status;
        }
        catch (Exception e) {
            status = e.toString();
            return status;
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
    }

    public static String activateController(Map propMap, String deviceID) throws Exception {
        String status = Controls.changeControllerState(propMap, deviceID, 1);
        return status;
    }

    public static String deactivateController(Map propMap, String deviceID) throws Exception {
        String status = Controls.changeControllerState(propMap, deviceID, 0);
        return status;
    }

    public static String putControllerInServiceMode(Map propMap, String deviceID) throws Exception {
        String status = Controls.changeControllerState(propMap, deviceID, 2);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String changeControllerState(Map propMap, String deviceID, int targetState) throws Exception {
        String status;
        SYMbolAPIClientV1 client;
        block14: {
            String targetip;
            String altip;
            String ip;
            String password;
            block13: {
                PropertyList props = new PropertyList(propMap);
                client = null;
                status = null;
                password = Controls.getPassword(props);
                ip = props.getProperty("ipno");
                altip = props.getProperty("altipno");
                targetip = ip;
                client = SYMbolConnection.getOpenConnection(targetip);
                if (client != null || (client = SYMbolConnection.getOpenConnection(targetip = altip)) != null) break block13;
                String string = "Could not open a connection to the array";
                SYMbolConnection.closeClient(client);
                return string;
            }
            try {
                ControllerRef ref = Controls.convertToControllerRef(client, deviceID);
                if (ref != null) {
                    if (DiagUtility.bindToController(client, ref)) {
                        SYMbolConnection.closeClient(client);
                        targetip = targetip.equals(ip) ? altip : ip;
                        client = SYMbolConnection.getOpenConnection(targetip);
                    }
                    if (client != null) {
                        Utility.setClientPassword(password, client);
                        ReturnCode rc = null;
                        if (targetState == 0) {
                            client.setTimeout(new ProcedureTimeout().getProcTimeout(10));
                            rc = client.setControllerToFailed(ref);
                        } else if (targetState == 2) {
                            client.setTimeout(new ProcedureTimeout().getProcTimeout(157));
                            rc = client.setControllerServiceMode(ref);
                        } else {
                            client.setTimeout(new ProcedureTimeout().getProcTimeout(36));
                            rc = client.setControllerToOptimal(ref);
                        }
                        status = rc.getValue() == 1 ? SUCCESSFUL_STATUS : Translator.translateReturnCode(rc);
                    } else {
                        status = "Could not open a connection to the alternate controller";
                    }
                    break block14;
                }
                status = "Error creating a reference using " + deviceID;
            }
            catch (Exception e) {
                try {
                    status = "An error was received from the RPC call: " + e.toString();
                }
                catch (Throwable throwable) {
                    SYMbolConnection.closeClient(client);
                    throw throwable;
                }
                SYMbolConnection.closeClient(client);
            }
        }
        SYMbolConnection.closeClient(client);
        return status;
    }

    public static String resetController(Map propMap, String deviceID) throws Exception {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        DeviceProperties devProps = new DeviceProperties((Properties)props);
        String password = devProps.getPassword();
        if (password == null) {
            password = "";
        }
        String rval = "unknown";
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            if (client != null) {
                ControllerRef ref = Controls.convertToControllerRef(client, deviceID);
                if (ref != null) {
                    Utility.setClientPassword(password, client);
                    client.setTimeout(new ProcedureTimeout().getProcTimeout(92));
                    ReturnCode rc = client.resetController(ref);
                    rval = rc.getValue() == 1 ? SUCCESSFUL_STATUS : Translator.translateReturnCode(rc);
                } else {
                    rval = "Could not reference a controller using " + deviceID;
                }
            }
        }
        catch (Exception e) {
            rval = e.toString();
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String powerDownArray(Map propMap) throws Exception {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String rval = "unknown";
        DeviceProperties devProps = new DeviceProperties((Properties)props);
        String password = devProps.getPassword();
        if (password == null) {
            password = "";
        }
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            Utility.setClientPassword(password, client);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(177));
            ReturnCode rc = client.powerDownArray();
            rval = Translator.translateReturnCode(rc);
            if (rc.getValue() == 14) {
                rval = SUCCESSFUL_STATUS;
            } else if (rc.getValue() == 1) {
                rval = SUCCESSFUL_STATUS;
            }
        }
        catch (Exception e) {
            rval = e.toString();
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        return rval;
    }

    public static String failDrive(String deviceKey, String deviceID) throws Exception {
        throw new UnsupportedOperationException("StorADE does not yet allow execution of this method");
    }

    public static String reviveTrayDrives(Map propMap, String deviceID) throws Exception {
        String rval = SUCCESSFUL_STATUS;
        Pattern pattern = Pattern.compile("t(\\d+)mpn");
        Matcher match = pattern.matcher(deviceID);
        int trayid = -1;
        if (match.matches()) {
            String tray = match.group(1);
            try {
                trayid = Integer.parseInt(tray);
            }
            catch (NumberFormatException nfe) {
                throw new StoradeException("Invalid midplane identifier format, X in tXmpn is not a number: " + deviceID);
            }
        } else {
            throw new StoradeException("Invalid midplane identifier format: " + deviceID + " tXmpn is expected");
        }
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        DeviceProperties devProps = new DeviceProperties((Properties)props);
        String password = devProps.getPassword();
        if (password == null) {
            password = "";
        }
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
        }
        catch (Exception e) {
            throw new StoradeException("Could not obtain a client connection to the target array");
        }
        ObjectBundle bundle = client.getObjectGraph();
        SYMbolConnection.closeClient(client);
        Drive[] drives = bundle.getDrive();
        StringBuffer failures = new StringBuffer();
        int length = drives != null ? drives.length : 0;
        for (int i = 0; i < length; ++i) {
            String tempval;
            int status;
            Drive drive = drives[i];
            Location location = drive.getPhysicalLocation();
            Tray driveTray = NOCList.findTray(bundle, location.getTrayRef().getRefToken());
            if (driveTray == null || driveTray.getTrayId() != trayid || (status = drive.getStatus().getValue()) != 2 || SUCCESSFUL_STATUS.equals(tempval = Controls.reviveDrive(props, drive.getDriveRef()))) continue;
            rval = tempval;
            byte[] reftoken = drive.getDriveRef().getRefToken();
            String driveName = NOCList.findName(bundle, 2, reftoken);
            failures.append(driveName + " ");
        }
        if (!SUCCESSFUL_STATUS.equals(rval)) {
            rval = "Could not revive drive(s) " + failures.toString();
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String reviveDrive(PropertyList props, DriveRef ref) {
        SYMbolAPIClientV1 client = null;
        String password = Controls.getPassword(props);
        String rval = "Starting operation";
        try {
            String ip = props.getProperty("ipno");
            String altip = props.getProperty("altipno");
            String targetip = ip;
            client = SYMbolConnection.getOpenConnection(targetip);
            if (client == null && (client = SYMbolConnection.getOpenConnection(targetip = altip)) == null) {
                String string = "Could not open a connection to the array";
                SYMbolConnection.closeClient(client);
                return string;
            }
            for (int i = 0; i < 2; ++i) {
                Utility.setClientPassword(password, client);
                client.setTimeout(new ProcedureTimeout().getProcTimeout(37));
                ReturnCode rc = client.setDriveToOptimal(ref);
                if (rc.getValue() == 13) {
                    rval = Translator.translateReturnCode(rc);
                    SYMbolConnection.closeClient(client);
                    targetip = targetip.equals(ip) ? altip : ip;
                    client = SYMbolConnection.getOpenConnection(targetip);
                    if (client != null) continue;
                    String string = "Could not open a connection to the required controller: " + targetip;
                    SYMbolConnection.closeClient(client);
                    return string;
                }
                if (rc.getValue() == 1 || rc.getValue() == 14) {
                    rval = SUCCESSFUL_STATUS;
                    break;
                }
                rval = Translator.translateReturnCode(rc);
            }
            SYMbolConnection.closeClient(client);
            return rval;
        }
        catch (Exception e) {
            rval = e.toString();
            return rval;
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
    }

    public static String reviveDrive(Map propMap, String deviceID) throws Exception {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        DeviceProperties devProps = new DeviceProperties((Properties)props);
        String password = devProps.getPassword();
        if (password == null) {
            password = "";
        }
        String rval = "unknown";
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            DriveRef ref = Controls.convertToDriveRef(client, deviceID);
            SYMbolConnection.closeClient(client);
            rval = Controls.reviveDrive(props, ref);
        }
        catch (Exception e) {
            rval = e.toString();
            SYMbolConnection.closeClient(client);
        }
        return rval;
    }

    public static String initializeDrive(String deviceKey, String deviceID) throws Exception {
        throw new UnsupportedOperationException("StorADE does not yet allow execution of this method");
    }

    public static String reconstructDrive(String deviceKey, String deviceID) throws Exception {
        throw new UnsupportedOperationException("StorADE does not yet allow execution of this method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resetMEL(Map propMap) throws Exception {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String rval = "unknown";
        String password = Controls.getPassword(props);
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            Utility.setClientPassword(password, client);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(16));
            ReturnCode rc = client.resetMel();
            rval = rc.getValue() == 1 ? SUCCESSFUL_STATUS : Translator.translateReturnCode(rc);
        }
        catch (Exception e) {
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        return rval;
    }

    public static String redistributeVolumes(Map propMap) throws Exception {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        DeviceProperties devProps = new DeviceProperties((Properties)props);
        String password = devProps.getPassword();
        if (password == null) {
            password = "";
        }
        String rval = SUCCESSFUL_STATUS;
        String ip = props.getProperty("ipno");
        String altip = props.getProperty("altipno");
        String targetip = ip;
        client = SYMbolConnection.getOpenConnection(targetip);
        if (client == null) {
            targetip = targetip.equals(ip) ? altip : ip;
            client = SYMbolConnection.getOpenConnection(targetip);
        }
        if (client == null) {
            return "Unable to open a connection using either " + ip + " or " + altip;
        }
        try {
            client = SYMbolConnection.getOpenConnection(targetip);
            ObjectBundle bundle = client.getObjectGraph();
            Volume[] volumes = bundle.getVolume();
            int size = volumes == null ? 0 : volumes.length;
            block2: for (int i = 0; i < size; ++i) {
                Volume thisVolume = volumes[i];
                ControllerRef prefConRef = thisVolume.getPreferredManager();
                ControllerRef currConRef = thisVolume.getCurrentManager();
                if (Utility.rawCompare(prefConRef.getRefToken(), currConRef.getRefToken())) continue;
                for (int x = 0; x < 2; ++x) {
                    VolumeOwnershipUpdateDescriptor update = new VolumeOwnershipUpdateDescriptor();
                    update.setManager(prefConRef);
                    update.setVolumeRef((AbstractVolRef)thisVolume.getVolumeRef());
                    Utility.setClientPassword(password, client);
                    client.setTimeout(new ProcedureTimeout().getProcTimeout(90));
                    ReturnCode rc = client.assignVolumeOwnership(update);
                    if (rc.getValue() == 13) {
                        rval = Translator.translateReturnCode(rc);
                        SYMbolConnection.closeClient(client);
                        targetip = targetip.equals(ip) ? altip : ip;
                        client = SYMbolConnection.getOpenConnectionWithRetries(targetip, 5, 5);
                        if (client != null) continue;
                        return "Could not open a connection to the parent controller: " + targetip;
                    }
                    if (rc.getValue() == 1) {
                        rval = SUCCESSFUL_STATUS;
                        continue block2;
                    }
                    rval = Translator.translateReturnCode(rc);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            rval = e.toString();
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setDriveChannelOptimal(Map propMap, String chan) throws Exception {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String rval = "unknown";
        String password = Controls.getPassword(props);
        int channel = 0;
        try {
            channel = Integer.parseInt(chan);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (channel != 1 && channel != 2) {
            return "Invalid channel specified: " + channel;
        }
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            Utility.setClientPassword(password, client);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(154));
            ReturnCode rc = client.clearDriveChannelStatistics();
            if (rc.getValue() == 1) {
                DriveChannelState dcs = new DriveChannelState();
                dcs.setValue(0);
                DriveChannelStateDescriptor dcsd = new DriveChannelStateDescriptor();
                dcsd.setChannel(channel);
                dcsd.setState(dcs);
                client.setTimeout(new ProcedureTimeout().getProcTimeout(152));
                rc = client.setDriveChannelState(dcsd);
                rval = rc.getValue() == 1 ? SUCCESSFUL_STATUS : Translator.translateReturnCode(rc);
            } else {
                rval = Translator.translateReturnCode(rc);
            }
        }
        catch (Exception e) {
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clearArrayConfig(String ipaddress) throws Exception {
        SYMbolAPIClientV1 client = null;
        String rval = "Operation not started";
        if (ipaddress == null) {
            return "The IP address passed is null";
        }
        String password = "";
        try {
            client = SYMbolConnection.getOpenConnection(ipaddress);
            if (client != null) {
                Utility.setClientPassword(password, client);
                client.setTimeout(new ProcedureTimeout().getProcTimeout(49));
                ReturnCode rc = client.clearSAConfiguration();
                rval = rc.getValue() == 1 ? SUCCESSFUL_STATUS : (rc.getValue() == 30 ? "RETCODE_AUTH_FAIL_PASSWORD" : Translator.translateReturnCode(rc));
            } else {
                rval = "Could not create a connection to " + ipaddress;
            }
        }
        catch (Exception e) {
            rval = e.toString();
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setArrayName(Map propMap, String name) throws Exception {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String rval = "unknown";
        if (name == null) {
            rval = "Name must be a non null value.";
        }
        String password = Controls.getPassword(props);
        try {
            client = SYMbolConnection.getOpenConnection((Properties)props);
            ObjectBundle bundle = client.getObjectGraph();
            UserAssignedLabel currentLabel = bundle.getSa().getSaData().getStorageArrayLabel();
            try {
                String currentName = UnicodeTranslator.getString((byte[])currentLabel.getValue());
                if (name.equals(currentName)) {
                    SYMbolConnection.closeClient(client);
                    String string = SUCCESSFUL_STATUS;
                    return string;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Utility.setClientPassword(password, client);
            UserAssignedLabel label = new UserAssignedLabel();
            label.setValue(UnicodeTranslator.getBytes((String)name));
            client.setTimeout(new ProcedureTimeout().getProcTimeout(27));
            ReturnCode rc = client.setSAUserLabel(label);
            rval = rc.getValue() == 1 ? SUCCESSFUL_STATUS : Translator.translateReturnCode(rc);
        }
        catch (Exception e) {
            rval = e.toString();
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        return rval;
    }

    public static String setHostPortType(Map propMap, String portType) {
        PropertyList props = new PropertyList(propMap);
        SYMbolAPIClientV1 client = null;
        String rval = "unknown";
        try {
            int index = Integer.parseInt(portType);
            client = SYMbolConnection.getOpenConnection((Properties)props);
            ObjectBundle bundle = client.getObjectGraph();
            int currentType = bundle.getSa().getDefaultHostPortTypeIndex();
            if (currentType == index) {
                SYMbolConnection.closeClient(client);
                return SUCCESSFUL_STATUS;
            }
            String password = Controls.getPassword(props);
            Utility.setClientPassword(password, client);
            HostPortRef hpr = new HostPortRef();
            byte[] defaultHostPortRef = new byte[20];
            for (int i = 0; i < defaultHostPortRef.length; ++i) {
                defaultHostPortRef[i] = 0;
            }
            hpr.setRefToken(defaultHostPortRef);
            HostPortTypeUpdateDescriptor hptud = new HostPortTypeUpdateDescriptor();
            hptud.setHostPortRef(hpr);
            hptud.setHostPortTypeIndex(index);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(80));
            ReturnCode rc = client.setHostPortType(hptud);
            rval = rc.getValue() == 1 ? SUCCESSFUL_STATUS : Translator.translateReturnCode(rc);
        }
        catch (NumberFormatException nfe) {
            rval = "Port type index " + portType + " needs to be a number.";
        }
        catch (Exception e) {
            rval = e.toString();
        }
        return rval;
    }

    private static DriveRef convertToDriveRef(SYMbolAPIClientV1 client, String id) throws StoradeException {
        DriveRef driveRef = null;
        if (id == null) {
            throw new StoradeException("Drive identifier is null");
        }
        int tindex = id.indexOf("t");
        int dindex = id.indexOf("drive");
        String tstr = id.substring(tindex + 1, dindex);
        String dstr = id.substring(dindex + 5);
        int targetTray = -1;
        int targetSlot = -1;
        try {
            targetTray = Integer.parseInt(tstr);
            targetSlot = Integer.parseInt(dstr);
        }
        catch (NumberFormatException nfe) {
            throw new StoradeException(id + " is not a valid drive identifier");
        }
        try {
            ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client);
            Drive[] drives = objectBundle.getDrive();
            Tray[] trays = objectBundle.getTray();
            for (int x = 0; x < drives.length; ++x) {
                Location loc = drives[x].getPhysicalLocation();
                int currSlot = loc.getSlot();
                if (currSlot != targetSlot) continue;
                byte[] driveTray = loc.getTrayRef().getRefToken();
                int trayID = -1;
                for (int i = 0; i < trays.length; ++i) {
                    byte[] currTray = trays[i].getTrayRef().getRefToken();
                    if (!Utility.rawCompare(driveTray, currTray)) continue;
                    trayID = trays[i].getTrayId();
                    break;
                }
                if (trayID != targetTray) continue;
                driveRef = drives[x].getDriveRef();
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (driveRef == null) {
            throw new StoradeException("Could not generate a reference using " + id);
        }
        return driveRef;
    }

    private static TrayRef convertToTrayRef(SYMbolAPIClientV1 client, String id) throws StoradeException {
        TrayRef trayRef = null;
        if (id == null) {
            throw new StoradeException("Tray identifier is null");
        }
        int tindex = id.indexOf("t");
        int mindex = id.indexOf("mpn");
        String tstr = id.substring(tindex + 1, mindex);
        int targetTray = -1;
        try {
            targetTray = Integer.parseInt(tstr);
        }
        catch (NumberFormatException nfe) {
            throw new StoradeException(id + " is not a valid tray identifier");
        }
        try {
            ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client);
            Tray[] trays = objectBundle.getTray();
            for (int i = 0; i < trays.length; ++i) {
                if (targetTray != trays[i].getTrayId()) continue;
                trayRef = trays[i].getTrayRef();
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (trayRef == null) {
            throw new StoradeException("Could not generate a reference using " + id);
        }
        return trayRef;
    }

    private static Battery findBattery(SYMbolAPIClientV1 client, String id) throws StoradeException {
        Battery battery = null;
        if (id == null) {
            throw new StoradeException("Battery identifier is null");
        }
        battery = id.indexOf("ctrl") == -1 ? Controls.findBatterySimple(client, id) : Controls.findBatteryComplex(client, id);
        if (battery == null) {
            throw new StoradeException("Could not generate a reference using " + id);
        }
        return battery;
    }

    private static Battery findBatteryComplex(SYMbolAPIClientV1 client, String id) throws StoradeException {
        Battery battery = null;
        String traystr = null;
        String slotstr = null;
        if (id == null) {
            throw new StoradeException("Battery identifier is null");
        }
        Pattern patt = Pattern.compile("t(\\d+)ctrl(\\d+)bat");
        Matcher match = patt.matcher(id);
        if (!match.matches()) {
            throw new StoradeException("Unknown battery identifier format: " + id);
        }
        traystr = match.group(1);
        slotstr = match.group(2);
        int targetTray = -1;
        int targetSlot = -1;
        try {
            targetTray = Integer.parseInt(traystr);
            targetSlot = Integer.parseInt(slotstr);
        }
        catch (NumberFormatException nfe) {
            throw new StoradeException(id + " is not a valid battery identifier");
        }
        try {
            ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client);
            Controller[] controllers = objectBundle.getController();
            Tray[] trays = objectBundle.getTray();
            ComponentBundle compBundle = objectBundle.getComponentBundle();
            Battery[] batteries = compBundle.getBattery();
            block4: for (int x = 0; x < batteries.length; ++x) {
                ControllerRef parentRef = batteries[x].getBatteryTypeData().getParentController();
                for (int i = 0; i < controllers.length; ++i) {
                    Location cloc;
                    int currSlot;
                    ControllerRef cref = controllers[i].getControllerRef();
                    if (!Utility.rawCompare(parentRef.getRefToken(), cref.getRefToken()) || (currSlot = (cloc = controllers[i].getPhysicalLocation()).getSlot()) != targetSlot) continue;
                    byte[] controllerTray = cloc.getTrayRef().getRefToken();
                    int trayID = -1;
                    for (int y = 0; y < trays.length; ++y) {
                        byte[] currTray = trays[y].getTrayRef().getRefToken();
                        if (!Utility.rawCompare(controllerTray, currTray)) continue;
                        trayID = trays[y].getTrayId();
                        break;
                    }
                    if (trayID != targetTray) continue;
                    battery = batteries[x];
                    continue block4;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (battery == null) {
            throw new StoradeException("Could not generate a reference using " + id);
        }
        return battery;
    }

    private static Battery findBatterySimple(SYMbolAPIClientV1 client, String id) throws StoradeException {
        Battery battery = null;
        String traystr = null;
        String slotstr = null;
        if (id == null) {
            throw new StoradeException("Battery identifier is null");
        }
        Pattern patt = Pattern.compile("t(\\d+)bat(\\d+)");
        Matcher match = patt.matcher(id);
        if (!match.matches()) {
            throw new StoradeException("Unknown battery identifier format: " + id);
        }
        traystr = match.group(1);
        slotstr = match.group(2);
        int targetTray = -1;
        int targetSlot = -1;
        try {
            targetTray = Integer.parseInt(traystr);
            targetSlot = Integer.parseInt(slotstr);
        }
        catch (NumberFormatException nfe) {
            throw new StoradeException(id + " is not a valid battery identifier");
        }
        try {
            ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client);
            ComponentBundle compBundle = objectBundle.getComponentBundle();
            Battery[] batteries = compBundle.getBattery();
            for (int i = 0; i < batteries.length; ++i) {
                Location bloc = batteries[i].getPhysicalLocation();
                int currSlot = bloc.getSlot();
                if (currSlot != targetSlot) continue;
                battery = batteries[i];
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (battery == null) {
            throw new StoradeException("Could not generate a reference using " + id);
        }
        return battery;
    }

    private static ControllerRef convertToControllerRef(SYMbolAPIClientV1 client, String id) throws StoradeException {
        ControllerRef controllerRef = null;
        if (id == null) {
            throw new StoradeException("Controller identifier is null");
        }
        int tindex = id.indexOf("t");
        int cindex = id.indexOf("ctrl");
        String tstr = id.substring(tindex + 1, cindex);
        String cstr = id.substring(cindex + 4);
        int targetTray = -1;
        int targetSlot = -1;
        try {
            targetTray = Integer.parseInt(tstr);
            targetSlot = Integer.parseInt(cstr);
        }
        catch (NumberFormatException nfe) {
            throw new StoradeException(id + " is not a valid controller identifier");
        }
        try {
            ObjectBundle objectBundle = SYMbolConnection.getObjectBundle(client);
            Controller[] controllers = objectBundle.getController();
            Tray[] trays = objectBundle.getTray();
            for (int x = 0; x < controllers.length; ++x) {
                Location loc = controllers[x].getPhysicalLocation();
                int currSlot = loc.getSlot();
                if (currSlot != targetSlot) continue;
                byte[] controllerTray = loc.getTrayRef().getRefToken();
                int trayID = -1;
                for (int i = 0; i < trays.length; ++i) {
                    byte[] currTray = trays[i].getTrayRef().getRefToken();
                    if (!Utility.rawCompare(controllerTray, currTray)) continue;
                    trayID = trays[i].getTrayId();
                    break;
                }
                if (trayID != targetTray) continue;
                controllerRef = controllers[x].getControllerRef();
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return controllerRef;
    }

    private static String getPassword(PropertyList props) {
        DeviceProperties devProps = new DeviceProperties((Properties)props);
        String password = devProps.getPassword();
        if (password == null) {
            password = "";
        }
        return password;
    }
}

