/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.eventlog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.ComponentLocation;
import devmgr.versioned.symbol.EventComponentType;
import java.util.HashMap;

public class DecodeMEL {
    private static final long MB = 0x100000L;
    public static final int ALL_EVENTS = 0;
    public static final int CRITICAL_EVENTS = 1;

    public static String getTypeName(EventComponentType type) {
        String rval = "Unknown";
        if (type != null) {
            rval = DecodeMEL.getTypeName(type.getValue());
        }
        return rval;
    }

    public static String getTypeName(int type) {
        String name = "Unknown";
        switch (type) {
            case 9: {
                name = "Battery";
                break;
            }
            case 6: {
                name = "Channel";
                break;
            }
            case 12: {
                name = "Chip";
                break;
            }
            case 8: {
                name = "Controller";
                break;
            }
            case 1: {
                name = "Drive";
                break;
            }
            case 10: {
                name = "Enclosure";
                break;
            }
            case 7: {
                name = "IOM";
                break;
            }
            case 3: {
                name = "Fan";
                break;
            }
            case 4: {
                name = "Minihub";
                break;
            }
            case 15: {
                name = "PortCRU";
                break;
            }
            case 2: {
                name = "PowerSupply";
                break;
            }
            case 5: {
                name = "TempSensor";
                break;
            }
            case 0: {
                name = "Controller Firmware";
                break;
            }
            case 11: {
                name = "UPS";
                break;
            }
            case 13: {
                name = "Volume";
                break;
            }
            case 14: {
                name = "Vdisk";
            }
        }
        return name;
    }

    public static String getComponentLocation(int type, ComponentLocation loc) {
        String location = "Unknown";
        if (loc == null) {
            return location;
        }
        switch (type) {
            case 9: {
                int tray = loc.getBatteryTray();
                if (tray >= 0) {
                    location = "tray" + loc.getBatteryTray();
                    break;
                }
                location = "controller tray";
                break;
            }
            case 6: {
                int cslot = loc.getChannelLoc().getControllerSlot();
                location = "Controller." + Translator.getSlotName(cslot) + ".channel." + loc.getChannelLoc().getIndex();
                break;
            }
            case 12: {
                location = "t" + loc.getChipLoc().getTray() + "s" + loc.getChipLoc().getSlot();
                break;
            }
            case 8: {
                int slot = loc.getControllerLoc().getSlot();
                location = "Controller in slot " + Translator.getSlotName(++slot);
                break;
            }
            case 1: {
                location = "Tray." + loc.getDriveLoc().getTray() + ".Drive." + loc.getDriveLoc().getSlot();
                break;
            }
            case 10: {
                location = "Tray." + loc.getEnclosureTray();
                break;
            }
            case 7: {
                location = "Tray." + loc.getEsmTray();
                break;
            }
            case 3: {
                location = "Tray." + loc.getFanTray();
                break;
            }
            case 4: {
                location = "Unknown";
                break;
            }
            case 15: {
                location = "Tray." + loc.getPortCruTray();
                break;
            }
            case 2: {
                location = "Tray." + loc.getPowerSupplyTray();
                break;
            }
            case 5: {
                location = "Tray." + loc.getTempSensorTray();
                break;
            }
            case 0: {
                location = "Unknown";
                break;
            }
            case 11: {
                location = "Unknown";
                break;
            }
            case 13: {
                location = Utility.userLabelString(loc.getLabel());
                break;
            }
            case 14: {
                location = "Vdisk index " + loc.getGroupNumber();
            }
        }
        return location;
    }

    public static String decodePriority(int priority) {
        String description = "Unknown";
        switch (priority) {
            case 0: {
                description = "Critical";
                break;
            }
            case 1: {
                description = "Info";
            }
        }
        return description;
    }

    public HashMap getMELMap() {
        HashMap<Integer, EntryData> map = new HashMap<Integer, EntryData>();
        map.put(new Integer(256), new EntryData("Event log cleared", false));
        map.put(new Integer(4097), new EntryData("Channel failed", true));
        map.put(new Integer(4098), new EntryData("Channel revived", false));
        map.put(new Integer(4099), new EntryData("Drive error tally exceeded threshold", false));
        map.put(new Integer(4100), new EntryData("Error on drive open", false));
        map.put(new Integer(4101), new EntryData("Drive read failure - retries exhausted", false));
        map.put(new Integer(4102), new EntryData("Drive write failure - retries exhausted", false));
        map.put(new Integer(4103), new EntryData("Controller out of memory", false));
        map.put(new Integer(4104), new EntryData("Unsupported SCSI chip", false));
        map.put(new Integer(4105), new EntryData("Controller memory parity error", true));
        map.put(new Integer(4106), new EntryData("Drive returned CHECK CONDITION", true));
        map.put(new Integer(4107), new EntryData("Start-of-day error in destination driver", false));
        map.put(new Integer(4108), new EntryData("Hardware error on drive side of controller", false));
        map.put(new Integer(4109), new EntryData("Timeout on drive side of controller", true));
        map.put(new Integer(4110), new EntryData("Unexpected interrupt on controller", true));
        map.put(new Integer(4111), new EntryData("Bus parity error on controller", false));
        map.put(new Integer(4112), new EntryData("Impending drive failure (PFA) detected", true));
        map.put(new Integer(4113), new EntryData("Chip error", false));
        map.put(new Integer(4114), new EntryData("Destination driver event", false));
        map.put(new Integer(4115), new EntryData("Destination driver level 0 diagnostic failed", false));
        map.put(new Integer(4116), new EntryData("Destination driver successfully issued reassign blocks command", true));
        map.put(new Integer(4117), new EntryData("Incorrect mode parameters modified and saved on drive", false));
        map.put(new Integer(4118), new EntryData("Hardware error - Unrecoverable read error on drive", true));
        map.put(new Integer(4119), new EntryData("Fibre channel link down", true));
        map.put(new Integer(4120), new EntryData("Fibre channel link up", true));
        map.put(new Integer(4121), new EntryData("Extended fibre channel link down (greater than one minute)", true));
        map.put(new Integer(4122), new EntryData("Unresponsive drive - extended I/O timeout", false));
        map.put(new Integer(4353), new EntryData("SRC driver detected exception on SCSI chip", false));
        map.put(new Integer(4354), new EntryData("Host bus reset asserted", false));
        map.put(new Integer(4355), new EntryData("Host bus reset received", false));
        map.put(new Integer(4356), new EntryData("Unknown interrupt", false));
        map.put(new Integer(4609), new EntryData("Fibre channel - LIP reset received", false));
        map.put(new Integer(4610), new EntryData("Fibre channel - TGT reset received", false));
        map.put(new Integer(4611), new EntryData("Fibre channel - TPRLO reset received", false));
        map.put(new Integer(4612), new EntryData("Fibre channel - driver detected error after initialization", false));
        map.put(new Integer(4613), new EntryData("Fibre channel - driver detected error during initialization", false));
        map.put(new Integer(4614), new EntryData("Fibre channel link errors continue", false));
        map.put(new Integer(4615), new EntryData("Fibre channel link errors - threshold exceeded", true));
        map.put(new Integer(4616), new EntryData("Data rate negotiation failed", true));
        map.put(new Integer(4617), new EntryData("Drive channel set to degraded", true));
        map.put(new Integer(5376), new EntryData("Channel initialization error", false));
        map.put(new Integer(5377), new EntryData("Selective LIP reset issued to drive", false));
        map.put(new Integer(5378), new EntryData("Selective LIP reset issued to alternate controller", false));
        map.put(new Integer(5379), new EntryData("Selective LIP reset issued to IOM", false));
        map.put(new Integer(5380), new EntryData("Loop port enable (LPE) issued to drive", false));
        map.put(new Integer(5381), new EntryData("Loop port enable (LPE) issued to alternate controller", false));
        map.put(new Integer(5382), new EntryData("Loop port enable (LPE) issued to IOM", false));
        map.put(new Integer(5383), new EntryData("Loop port bypass (LPB) issued to drive", false));
        map.put(new Integer(5384), new EntryData("Loop port bypass (LPB) issued to alternate controller", false));
        map.put(new Integer(5385), new EntryData("Loop port bypass (LPB) issued to IOM", false));
        map.put(new Integer(5386), new EntryData("Unresponsive drive (bad AL_PA error)", false));
        map.put(new Integer(5387), new EntryData("Unresponsive alternate controller (bad AL_PA error)", false));
        map.put(new Integer(5388), new EntryData("Unresponsive IOM (bad AL_PA error)", false));
        map.put(new Integer(5389), new EntryData("Channel reset occurred", false));
        map.put(new Integer(5390), new EntryData("Controller loop-back diagnostics failed", true));
        map.put(new Integer(5391), new EntryData("Channel miswire", true));
        map.put(new Integer(5392), new EntryData("IOM miswire", true));
        map.put(new Integer(5393), new EntryData("Channel miswire resolved", false));
        map.put(new Integer(5394), new EntryData("IOM miswire resolved", false));
        map.put(new Integer(5395), new EntryData("Individual drive - degraded path", true));
        map.put(new Integer(5396), new EntryData("Drive channel changed to optimal", true));
        map.put(new Integer(5401), new EntryData("Unresponsive drive (bad AL_PA error)", true));
        map.put(new Integer(5632), new EntryData("Uncertified drive detected", true));
        map.put(new Integer(5633), new EntryData("Reserved blocks on SATA drives cannot be discovered", true));
        map.put(new Integer(8193), new EntryData("Repair started", true));
        map.put(new Integer(8194), new EntryData("Repair completed", true));
        map.put(new Integer(8195), new EntryData("Interrupted write started", false));
        map.put(new Integer(8196), new EntryData("Interrupted write completed", false));
        map.put(new Integer(8197), new EntryData("Virtual disk failed - interrupted write", true));
        map.put(new Integer(8198), new EntryData("Piece failed", false));
        map.put(new Integer(8199), new EntryData("Fail piece delayed", false));
        map.put(new Integer(8200), new EntryData("Failed volume started reconstruction", false));
        map.put(new Integer(8201), new EntryData("RAID 0 write failures", false));
        map.put(new Integer(8202), new EntryData("Data/parity mismatch on volume", true));
        map.put(new Integer(8203), new EntryData("Unrecovered deferred error on volume", false));
        map.put(new Integer(8204), new EntryData("Recovered error on volume", false));
        map.put(new Integer(8205), new EntryData("I/O aborted on volume", true));
        map.put(new Integer(8206), new EntryData("Virtual disk driver reconfigured", true));
        map.put(new Integer(8207), new EntryData("Cache synchronization started", true));
        map.put(new Integer(8208), new EntryData("Cache synchronization completed", false));
        map.put(new Integer(8209), new EntryData("Cache flush started", false));
        map.put(new Integer(8210), new EntryData("Cache flush completed", false));
        map.put(new Integer(8211), new EntryData("Unwritten data/parity recovered from cache", false));
        map.put(new Integer(8212), new EntryData("VDD logged an error", true));
        map.put(new Integer(8213), new EntryData("Uncompleted writes detected in NVSRAM at start-of-day", false));
        map.put(new Integer(8214), new EntryData("Interrupted writes processed", false));
        map.put(new Integer(8215), new EntryData("Interrupted writes detected from checkpoint logs", false));
        map.put(new Integer(8216), new EntryData("I/O suspended due to no pre-allocated resources", false));
        map.put(new Integer(8217), new EntryData("Performance monitor: I/O's elapsed time exceeded threshold", true));
        map.put(new Integer(8218), new EntryData("VDD restore started", true));
        map.put(new Integer(8219), new EntryData("VDD restore completed", true));
        map.put(new Integer(8220), new EntryData("VDD recover started", true));
        map.put(new Integer(8221), new EntryData("VDD recover completed", true));
        map.put(new Integer(8222), new EntryData("VDD repair started", true));
        map.put(new Integer(8223), new EntryData("VDD repair completed", true));
        map.put(new Integer(8224), new EntryData("Piece failed during interrupted write", false));
        map.put(new Integer(8225), new EntryData("Virtual disk failed during interrupted write", true));
        map.put(new Integer(8226), new EntryData("Media scan (scrub) started", true));
        map.put(new Integer(8227), new EntryData("Media scan (scrub) completed", true));
        map.put(new Integer(8228), new EntryData("Media scan (scrub) resumed", true));
        map.put(new Integer(8229), new EntryData("Reconstruction started", true));
        map.put(new Integer(8230), new EntryData("Reconstruction completed", true));
        map.put(new Integer(8231), new EntryData("Reconstruction resumed", true));
        map.put(new Integer(8232), new EntryData("Modification (reconfigure) started", true));
        map.put(new Integer(8233), new EntryData("Modification (reconfigure) completed", true));
        map.put(new Integer(8234), new EntryData("Modification (reconfigure) resumed", false));
        map.put(new Integer(8235), new EntryData("Redundancy check started", true));
        map.put(new Integer(8236), new EntryData("Redundancy check completed", true));
        map.put(new Integer(8237), new EntryData("Redundancy check resumed", true));
        map.put(new Integer(8238), new EntryData("Read drive error during interrupted write", true));
        map.put(new Integer(8239), new EntryData("Automatic volume transfer completed", true));
        map.put(new Integer(8240), new EntryData("Initialization completed on volume", true));
        map.put(new Integer(8241), new EntryData("Initialization started on volume", true));
        map.put(new Integer(8242), new EntryData("Initialization resumed on volume", false));
        map.put(new Integer(8243), new EntryData("Parity reconstructed on volume", true));
        map.put(new Integer(8244), new EntryData("Data/parity mismatch detected on volume", true));
        map.put(new Integer(8288), new EntryData("Protection information mismatch detected by the channel interface", false));
        map.put(new Integer(8289), new EntryData("Protection information mismatch detected for cached volume data", false));
        map.put(new Integer(8449), new EntryData("Alternate controller checked in late", false));
        map.put(new Integer(8450), new EntryData("Cache mirroring on controllers not synchronized", false));
        map.put(new Integer(8451), new EntryData("UPS battery is fully charged", false));
        map.put(new Integer(8452), new EntryData("Controller cache synchronization/purge event", false));
        map.put(new Integer(8453), new EntryData("Controller cache reconfigure event", false));
        map.put(new Integer(8454), new EntryData("Update requested on controller cache manager's DACSTORE", false));
        map.put(new Integer(8455), new EntryData("Clear requested on controller cache manager's DACSTORE", false));
        map.put(new Integer(8456), new EntryData("Controller cache manager experiencing errors", false));
        map.put(new Integer(8457), new EntryData("Controller cache not enabled - cache sizes do not match", true));
        map.put(new Integer(8458), new EntryData("Controller cache not enabled or was internally disabled", false));
        map.put(new Integer(8459), new EntryData("Cache between controllers not synchronized", false));
        map.put(new Integer(8460), new EntryData("Controller cache battery failed", false));
        map.put(new Integer(8461), new EntryData("Controller deferred error", false));
        map.put(new Integer(8462), new EntryData("Controller cache memory recovery failed after power cycle or reset", true));
        map.put(new Integer(8463), new EntryData("Controller cache memory parity error detected", true));
        map.put(new Integer(8464), new EntryData("Controller cache memory initialization failed", true));
        map.put(new Integer(8465), new EntryData("Controller cache task failed", false));
        map.put(new Integer(8466), new EntryData("Controller cache battery is fully charged", true));
        map.put(new Integer(8467), new EntryData("Controller cache battery nearing expiration", true));
        map.put(new Integer(8468), new EntryData("Alternate controller cache battery is fully charged", false));
        map.put(new Integer(8469), new EntryData("Alternate controller cache battery nearing expiration", false));
        map.put(new Integer(8470), new EntryData("Alternate controller cache battery failed", false));
        map.put(new Integer(8471), new EntryData("Controller cache manager error cleared", false));
        map.put(new Integer(8472), new EntryData("Memory parity ECC error", true));
        map.put(new Integer(8473), new EntryData("Recoverable error in data buffer memory detected/corrected", true));
        map.put(new Integer(8474), new EntryData("Cache corrected by using alternate controller's cache", false));
        map.put(new Integer(8475), new EntryData("Batteries present but NVSRAM file configured for no batteries", true));
        map.put(new Integer(8476), new EntryData("Cache battery is charging", true));
        map.put(new Integer(8477), new EntryData("Persistent SB ECC", false));
        map.put(new Integer(8705), new EntryData("Volume marked optimal", false));
        map.put(new Integer(8706), new EntryData("Volume added", false));
        map.put(new Integer(8707), new EntryData("Virtual disk or volume deleted", false));
        map.put(new Integer(8708), new EntryData("I/O is resumed", false));
        map.put(new Integer(8709), new EntryData("Source drive failed during copy operation", false));
        map.put(new Integer(8710), new EntryData("Reconstruction completed", false));
        map.put(new Integer(8711), new EntryData("Device copy complete", false));
        map.put(new Integer(8712), new EntryData("Modification (reconfigure) started", false));
        map.put(new Integer(8713), new EntryData("Modification (reconfigure) completed", false));
        map.put(new Integer(8714), new EntryData("Copyback started", false));
        map.put(new Integer(8715), new EntryData("Copyback restarted", false));
        map.put(new Integer(8716), new EntryData("Device failed during interrupted write processing", false));
        map.put(new Integer(8717), new EntryData("Media scan (scrub) enabled", false));
        map.put(new Integer(8718), new EntryData("Media scan (scrub) started", false));
        map.put(new Integer(8719), new EntryData("Media scan (scrub) completed", false));
        map.put(new Integer(8720), new EntryData("Restore started", false));
        map.put(new Integer(8721), new EntryData("Restore completed", false));
        map.put(new Integer(8722), new EntryData("Parity repaired", false));
        map.put(new Integer(8723), new EntryData("Volume initialized with zeros", false));
        map.put(new Integer(8724), new EntryData("One or more Sundry regions created", false));
        map.put(new Integer(8725), new EntryData("Drive marked failed", false));
        map.put(new Integer(8726), new EntryData("Piece taken out of service", false));
        map.put(new Integer(8727), new EntryData("Piece failed", false));
        map.put(new Integer(8728), new EntryData("Piece failed during uncompleted write processing", false));
        map.put(new Integer(8729), new EntryData("Piece removed from volume", false));
        map.put(new Integer(8730), new EntryData("Piece replaced", false));
        map.put(new Integer(8731), new EntryData("Piece placed in service", false));
        map.put(new Integer(8732), new EntryData("Virtual disk placed offline", false));
        map.put(new Integer(8733), new EntryData("Virtual disk placed online", false));
        map.put(new Integer(8734), new EntryData("Virtual disk or volume initialized", false));
        map.put(new Integer(8735), new EntryData("Immediate availability initialization (IAF) completed on volume", false));
        map.put(new Integer(8736), new EntryData("Hot spare drive added to hot spare list", true));
        map.put(new Integer(8737), new EntryData("Hot spare drive removed from hot spare list", true));
        map.put(new Integer(8738), new EntryData("Logical unit number for volume reassigned", false));
        map.put(new Integer(8739), new EntryData("Duplicate data structure exists for two devices", false));
        map.put(new Integer(8740), new EntryData("Reconstruction started", true));
        map.put(new Integer(8741), new EntryData("Reconstruction restarted", false));
        map.put(new Integer(8742), new EntryData("Drive spun down", false));
        map.put(new Integer(8743), new EntryData("Drive marked optimal", false));
        map.put(new Integer(8744), new EntryData("Drive deleted", false));
        map.put(new Integer(8745), new EntryData("Drive failed by controller", true));
        map.put(new Integer(8746), new EntryData("Hot spare drive assigned", true));
        map.put(new Integer(8747), new EntryData("Drive replaced when storage array was turned off", true));
        map.put(new Integer(8748), new EntryData("Drive marked unassigned", false));
        map.put(new Integer(8749), new EntryData("Drive manually failed", true));
        map.put(new Integer(8750), new EntryData("Mark drive removed", false));
        map.put(new Integer(8751), new EntryData("Drive marked replaced", false));
        map.put(new Integer(8752), new EntryData("Drive failed by device manager", false));
        map.put(new Integer(8753), new EntryData("Drive marked removed", false));
        map.put(new Integer(8754), new EntryData("Removed drive marked removed", false));
        map.put(new Integer(8755), new EntryData("Unassigned drive marked removed", false));
        map.put(new Integer(8756), new EntryData("Reconstructing drive marked removed", true));
        map.put(new Integer(8757), new EntryData("Optimal/Replaced drive marked removed", false));
        map.put(new Integer(8758), new EntryData("Hot spare drive copy completed", true));
        map.put(new Integer(8759), new EntryData("Replaced drive completed reconstruction", true));
        map.put(new Integer(8760), new EntryData("Drive added in previously unused slot", false));
        map.put(new Integer(8761), new EntryData("Hot spare drive assigned internally", true));
        map.put(new Integer(8762), new EntryData("Drive marked deleted", false));
        map.put(new Integer(8763), new EntryData("Failed/Replaced drive marked replaced", false));
        map.put(new Integer(8764), new EntryData("Drive reinserted", false));
        map.put(new Integer(8765), new EntryData("Unassigned drive replaced", false));
        map.put(new Integer(8766), new EntryData("Drive marked optimal", false));
        map.put(new Integer(8767), new EntryData("Partially reconstructed drive marked optimal", false));
        map.put(new Integer(8768), new EntryData("DACSTORE created for unassigned or hot spare drive", false));
        map.put(new Integer(8769), new EntryData("Unassigned drive with no DACSTORE failed", false));
        map.put(new Integer(8770), new EntryData("Unassigned drive with no DACSTORE deleted", false));
        map.put(new Integer(8771), new EntryData("Unassigned drive with no DACSTORE removed", false));
        map.put(new Integer(8772), new EntryData("Unknown drive marked unassigned", false));
        map.put(new Integer(8773), new EntryData("Media scan (scrub) stopped", true));
        map.put(new Integer(8774), new EntryData("Media scan (scrub) resumed", true));
        map.put(new Integer(8775), new EntryData("Data lost on volume during unrecovered interrupted write", true));
        map.put(new Integer(8776), new EntryData("Drive failed - write failure", true));
        map.put(new Integer(8777), new EntryData("Drive capacity less than minimum", true));
        map.put(new Integer(8778), new EntryData("Drive has wrong block size", true));
        map.put(new Integer(8779), new EntryData("Drive failed - initialization failure", true));
        map.put(new Integer(8780), new EntryData("Wrong drive removed/replaced", false));
        map.put(new Integer(8781), new EntryData("Drive failed - no response at start of day", true));
        map.put(new Integer(8782), new EntryData("Drive failed - initialization/reconstruction failure", true));
        map.put(new Integer(8783), new EntryData("Hot spare capacity not sufficient for all drives", false));
        map.put(new Integer(8784), new EntryData("Volume failure", true));
        map.put(new Integer(8785), new EntryData("Drive failed - reconstruction failure", true));
        map.put(new Integer(8786), new EntryData("Drive marked offline during interrupted write", true));
        map.put(new Integer(8787), new EntryData("Virtual disk or volume modified (created or deleted)", false));
        map.put(new Integer(8788), new EntryData("Redundancy (parity) and data mismatch was detected", false));
        map.put(new Integer(8789), new EntryData("Volume definition incompatible with ALT mode-ALT disabled", true));
        map.put(new Integer(8790), new EntryData("Copyback completed on volume", true));
        map.put(new Integer(8791), new EntryData("Modification (reconfigure) started on volume", true));
        map.put(new Integer(8792), new EntryData("Modification (reconfigure) completed on volume", true));
        map.put(new Integer(8793), new EntryData("Initialization started on volume", false));
        map.put(new Integer(8794), new EntryData("Immediate availability initialization (IAF) started on volume", false));
        map.put(new Integer(8795), new EntryData("Premium feature not supported - snapshot volumes and mirror relationships deleted", false));
        map.put(new Integer(8796), new EntryData("Controller in stopped state", false));
        map.put(new Integer(8797), new EntryData("Automatic configuration started", false));
        map.put(new Integer(8798), new EntryData("Automatic configuration completed successfully", false));
        map.put(new Integer(8799), new EntryData("Automatic configuration failed", false));
        map.put(new Integer(9216), new EntryData("Hot swap monitor detected drive removal", false));
        map.put(new Integer(9217), new EntryData("Hot swap monitor detected drive insertion", false));
        map.put(new Integer(9472), new EntryData("Controller inserted or removed", false));
        map.put(new Integer(9473), new EntryData("Controller mode changed to active", false));
        map.put(new Integer(9474), new EntryData("Controller icon chip error", false));
        map.put(new Integer(9475), new EntryData("Controller mode changed to passive", false));
        map.put(new Integer(9476), new EntryData("Controller mode changed to active", false));
        map.put(new Integer(9477), new EntryData("Controller mode switch occurred", false));
        map.put(new Integer(9728), new EntryData("Automatic controller firmware synchronization started", true));
        map.put(new Integer(9729), new EntryData("Automatic controller firmware synchronization completed", true));
        map.put(new Integer(9730), new EntryData("Automatic controller firmware synchronization failed", true));
        map.put(new Integer(9731), new EntryData("Default volume created", false));
        map.put(new Integer(9732), new EntryData("Persistent controller memory parity error", true));
        map.put(new Integer(9733), new EntryData("Start-of-day routine completed", true));
        map.put(new Integer(9734), new EntryData("Start-of-day routine begun", true));
        map.put(new Integer(9984), new EntryData("Controller RPA memory parity error detected", false));
        map.put(new Integer(9985), new EntryData("PCI controller parity error", false));
        map.put(new Integer(9986), new EntryData("Controller unexpected RPA interrupt detected", false));
        map.put(new Integer(9987), new EntryData("Recoverable error in processor memory detected/corrected", true));
        map.put(new Integer(10240), new EntryData("Power supply state change detected", true));
        map.put(new Integer(10241), new EntryData("Storage array running on UPS battery", true));
        map.put(new Integer(10242), new EntryData("UPS battery is fully charged", false));
        map.put(new Integer(10243), new EntryData("UPS battery - two minutes to failure", true));
        map.put(new Integer(10244), new EntryData("UPS battery failed", false));
        map.put(new Integer(10245), new EntryData("Controller tray component change detected", false));
        map.put(new Integer(10246), new EntryData("Tray component change ", false));
        map.put(new Integer(10247), new EntryData("IOM failed", false));
        map.put(new Integer(10248), new EntryData("Tray ID not unique", true));
        map.put(new Integer(10249), new EntryData("Controller tray component changed to optimal", false));
        map.put(new Integer(10250), new EntryData("Controller tray component removed", false));
        map.put(new Integer(10251), new EntryData("Controller tray component failed", false));
        map.put(new Integer(10252), new EntryData("Drive tray component changed to optimal", false));
        map.put(new Integer(10253), new EntryData("Drive tray component failed or removed", false));
        map.put(new Integer(10254), new EntryData("Standby power source not fully charged", true));
        map.put(new Integer(10255), new EntryData("IOM - loss of communication", true));
        map.put(new Integer(10256), new EntryData("IOM - communication restored", true));
        map.put(new Integer(10258), new EntryData("Mini-hub canister changed to optimal", false));
        map.put(new Integer(10259), new EntryData("Mini-hub canister failed", true));
        map.put(new Integer(10260), new EntryData("GBIC/SFP changed to optimal", false));
        map.put(new Integer(10261), new EntryData("GBIC/SFP failed", true));
        map.put(new Integer(10262), new EntryData("Tray ID conflict - duplicate IDs across drive trays", true));
        map.put(new Integer(10263), new EntryData("Tray ID conflict resolved", false));
        map.put(new Integer(10264), new EntryData("Tray ID mismatch - duplicate IDs in same drive tray", true));
        map.put(new Integer(10265), new EntryData("Tray ID mismatch resolved", false));
        map.put(new Integer(10266), new EntryData("Temperature changed to optimal", true));
        map.put(new Integer(10267), new EntryData("Nominal temperature exceeded", true));
        map.put(new Integer(10268), new EntryData("Maximum temperature exceeded", true));
        map.put(new Integer(10269), new EntryData("Temperature sensor removed", false));
        map.put(new Integer(10270), new EntryData("IOM firmware or hardware mismatch", true));
        map.put(new Integer(10271), new EntryData("IOM firmware or hardware mismatch resolved", false));
        map.put(new Integer(10272), new EntryData("Two controllers present but NVSRAM (offset 0x35, bit 6) set for NOT reporting a missing second controller", false));
        map.put(new Integer(10273), new EntryData("Incompatible mini-hub canister", true));
        map.put(new Integer(10274), new EntryData("Drive by-passed - data rate (speed) mismatch", false));
        map.put(new Integer(10275), new EntryData("Drive by-passed", true));
        map.put(new Integer(10276), new EntryData("Drive by-passed condition resolved", true));
        map.put(new Integer(10277), new EntryData("Tray ID harness removed", false));
        map.put(new Integer(10278), new EntryData("Tray ID harness replaced", false));
        map.put(new Integer(10279), new EntryData("Controller inadvertently replaced with an IOM", true));
        map.put(new Integer(10280), new EntryData("Unsupported drive tray detected", true));
        map.put(new Integer(10281), new EntryData("Controller redundancy lost", true));
        map.put(new Integer(10282), new EntryData("Controller redundancy restored", true));
        map.put(new Integer(10283), new EntryData("Drive tray path redundancy lost", true));
        map.put(new Integer(10284), new EntryData("Drive tray path redundancy restored", false));
        map.put(new Integer(10285), new EntryData("Drive path redundancy lost", true));
        map.put(new Integer(10286), new EntryData("Drive path redundancy restored", false));
        map.put(new Integer(10287), new EntryData("Incompatible version of IOM firmware detected", true));
        map.put(new Integer(10288), new EntryData("Mixed drive types not supported", true));
        map.put(new Integer(10293), new EntryData("Drive trays not cabled correctly", false));
        map.put(new Integer(10294), new EntryData("Discrete lines diagnostic failure", false));
        map.put(new Integer(10295), new EntryData("Discrete lines diagnostic failure cleared", false));
        map.put(new Integer(10296), new EntryData("Interconnect CRU removed", false));
        map.put(new Integer(10297), new EntryData("Interconnect CRU reinserted", false));
        map.put(new Integer(10298), new EntryData("Power supply missing or removed", false));
        map.put(new Integer(10299), new EntryData("Power supply failed", false));
        map.put(new Integer(10300), new EntryData("Power supply needs attention", true));
        map.put(new Integer(10301), new EntryData("Fan missing or removed", false));
        map.put(new Integer(10302), new EntryData("Fan failed", false));
        map.put(new Integer(10303), new EntryData("Fan needs attention", true));
        map.put(new Integer(10304), new EntryData("Controller submodel not set", true));
        map.put(new Integer(10305), new EntryData("Controller submodel mismatch detected", true));
        map.put(new Integer(10306), new EntryData("Controller submodel mismatch resolved", true));
        map.put(new Integer(10307), new EntryData("Controller switch card diagnostic failure", true));
        map.put(new Integer(10308), new EntryData("Controller switch card failure", true));
        map.put(new Integer(10309), new EntryData("Controller switch card warning", true));
        map.put(new Integer(10310), new EntryData("Controller Switch card has recovered", true));
        map.put(new Integer(10313), new EntryData("IOM Type mismatch detected", true));
        map.put(new Integer(10314), new EntryData("IOM type mismatched cleared", true));
        map.put(new Integer(12288), new EntryData("Format unit issued", false));
        map.put(new Integer(12289), new EntryData("Quiescence issued", false));
        map.put(new Integer(12290), new EntryData("Reassign blocks issued from host", false));
        map.put(new Integer(12291), new EntryData("Reserve issued", false));
        map.put(new Integer(12292), new EntryData("Release issued", false));
        map.put(new Integer(12293), new EntryData("Synchronize controller cache issued", false));
        map.put(new Integer(12294), new EntryData("Safe pass-through issued", false));
        map.put(new Integer(12295), new EntryData("Mode select for page 1 received", false));
        map.put(new Integer(12296), new EntryData("Mode select for page 2 received", false));
        map.put(new Integer(12297), new EntryData("Mode for caching page 8 received", false));
        map.put(new Integer(12298), new EntryData("Mode select for control mode page A received", false));
        map.put(new Integer(12299), new EntryData("Mode select for array physical page 2A received", false));
        map.put(new Integer(12300), new EntryData("Mode select for array logical page 2B received", false));
        map.put(new Integer(12301), new EntryData("Mode select for redundant controller page 2C received", false));
        map.put(new Integer(12302), new EntryData("Mode select for vendor-unique cache page 2E received", false));
        map.put(new Integer(12303), new EntryData("Mode select for time page 2F received", false));
        map.put(new Integer(12304), new EntryData("Mode select for hot spare page 3A received", false));
        map.put(new Integer(12305), new EntryData("Defect list received", false));
        map.put(new Integer(12306), new EntryData("Write buffer received", false));
        map.put(new Integer(12307), new EntryData("Download controller firmware issued", true));
        map.put(new Integer(12308), new EntryData("Drive firmware download started", true));
        map.put(new Integer(12309), new EntryData("Drive pass-through issued", false));
        map.put(new Integer(12310), new EntryData("Alternate controller transition issued", false));
        map.put(new Integer(12311), new EntryData("Set pass-through issued", false));
        map.put(new Integer(12312), new EntryData("Set pass command issued", false));
        map.put(new Integer(12313), new EntryData("Volume ownership changed due to failover", true));
        map.put(new Integer(12314), new EntryData("Drive firmware download failed", true));
        map.put(new Integer(12315), new EntryData("Drive firmware download completed", true));
        map.put(new Integer(12316), new EntryData("IOM firmware download started", true));
        map.put(new Integer(12317), new EntryData("IOM firmware download failed", true));
        map.put(new Integer(12318), new EntryData("IOM firmware download completed", true));
        map.put(new Integer(12319), new EntryData("Unable to register a volume due to insufficient resources", false));
        map.put(new Integer(12545), new EntryData("AEN posted for recently logged event", false));
        map.put(new Integer(12546), new EntryData("Deferred error (EEL)", false));
        map.put(new Integer(12800), new EntryData("VKI common error", false));
        map.put(new Integer(12801), new EntryData("VKI panic", false));
        map.put(new Integer(16384), new EntryData("Sys wipe request sent to controller", false));
        map.put(new Integer(16385), new EntryData("NVSRAM clear request sent to alternate controller", false));
        map.put(new Integer(16386), new EntryData("Sys wipe request received by alternate controller", false));
        map.put(new Integer(16387), new EntryData("NVSRAM clear request received by alternate controller", false));
        map.put(new Integer(16388), new EntryData("Alternate controller quiescence message received", false));
        map.put(new Integer(16389), new EntryData("Controller quiescence started", false));
        map.put(new Integer(16390), new EntryData("Alternate controller quiescence started", false));
        map.put(new Integer(16391), new EntryData("Subsystem quiescence started", false));
        map.put(new Integer(16392), new EntryData("Controller quiescence halted", false));
        map.put(new Integer(16393), new EntryData("Controller quiescence released", false));
        map.put(new Integer(16394), new EntryData("Alternate controller quiescence released", false));
        map.put(new Integer(16395), new EntryData("All channel reset detected", false));
        map.put(new Integer(16396), new EntryData("Controller placed offline", false));
        map.put(new Integer(16397), new EntryData("Controller placed online", false));
        map.put(new Integer(16398), new EntryData("Automatic volume transfer started", true));
        map.put(new Integer(16399), new EntryData("Controller reset by its alternate", false));
        map.put(new Integer(16400), new EntryData("Controller reset", true));
        map.put(new Integer(16401), new EntryData("Volume not on preferred path due to AVT/RDAC failover", true));
        map.put(new Integer(20480), new EntryData("Assign virtual disk ownership", false));
        map.put(new Integer(20481), new EntryData("Assign hot spare drive", true));
        map.put(new Integer(20482), new EntryData("Create volume", false));
        map.put(new Integer(20483), new EntryData("De-assign hot spare drive", true));
        map.put(new Integer(20484), new EntryData("Delete volume", false));
        map.put(new Integer(20485), new EntryData("Place controller offline", true));
        map.put(new Integer(20486), new EntryData("Fail drive", false));
        map.put(new Integer(20487), new EntryData("Initialize virtual disk or volume", false));
        map.put(new Integer(20488), new EntryData("Initialize drive", false));
        map.put(new Integer(20489), new EntryData("Controller firmware download started", true));
        map.put(new Integer(20490), new EntryData("Download drive firmware issued", true));
        map.put(new Integer(20491), new EntryData("Controller NVSRAM download started", true));
        map.put(new Integer(20492), new EntryData("Place virtual disk offline", false));
        map.put(new Integer(20493), new EntryData("Place virtual disk online", false));
        map.put(new Integer(20494), new EntryData("Reconstruct drive/volume", true));
        map.put(new Integer(20495), new EntryData("Start virtual disk defragment", false));
        map.put(new Integer(20496), new EntryData("Add free capacity to virtual disk", false));
        map.put(new Integer(20497), new EntryData("Change RAID level of virtual disk", false));
        map.put(new Integer(20498), new EntryData("Change segment size of volume", false));
        map.put(new Integer(20499), new EntryData("Change controller to passive mode", false));
        map.put(new Integer(20500), new EntryData("Change controller to active mode", false));
        map.put(new Integer(20501), new EntryData("Update cache parameters of storage array", false));
        map.put(new Integer(20502), new EntryData("Change name of storage array", false));
        map.put(new Integer(20503), new EntryData("Synchronize controller clock", true));
        map.put(new Integer(20504), new EntryData("Change cache parameters of volume", false));
        map.put(new Integer(20505), new EntryData("Change parameters of volume", false));
        map.put(new Integer(20506), new EntryData("Change name of volume", false));
        map.put(new Integer(20507), new EntryData("Place controller online", true));
        map.put(new Integer(20508), new EntryData("Revive drive", false));
        map.put(new Integer(20509), new EntryData("Revive volume", false));
        map.put(new Integer(20510), new EntryData("Change positions of trays in physical view", false));
        map.put(new Integer(20511), new EntryData("Change media scan (scrub) settings of volume", false));
        map.put(new Integer(20512), new EntryData("Change media scan (scrub) settings of storage array", false));
        map.put(new Integer(20513), new EntryData("Reset configuration of storage array", false));
        map.put(new Integer(20514), new EntryData("Automatic configuration on storage array", false));
        map.put(new Integer(20515), new EntryData("Controller return status/function call for requested operation", false));
        map.put(new Integer(20516), new EntryData("Internal download checkpoint", false));
        map.put(new Integer(20517), new EntryData("Controller firmware download failed", true));
        map.put(new Integer(20518), new EntryData("Controller firmware download completed", true));
        map.put(new Integer(20519), new EntryData("Controller NVSRAM download failed", true));
        map.put(new Integer(20520), new EntryData("Controller NVSRAM download completed", true));
        map.put(new Integer(20521), new EntryData("Reset controller battery age", true));
        map.put(new Integer(20522), new EntryData("Assign volume ownership", true));
        map.put(new Integer(20523), new EntryData("Increase volume capacity", false));
        map.put(new Integer(20524), new EntryData("Change parameters of snapshot repository volume", false));
        map.put(new Integer(20525), new EntryData("Re-create snapshot volume", false));
        map.put(new Integer(20526), new EntryData("Disable snapshot volume", false));
        map.put(new Integer(20527), new EntryData("Delete missing volume", false));
        map.put(new Integer(20528), new EntryData("Activate remote volume mirroring", false));
        map.put(new Integer(20529), new EntryData("Deactivate remote volume mirroring", false));
        map.put(new Integer(20530), new EntryData("Change synchronization priority", false));
        map.put(new Integer(20531), new EntryData("Start mirror synchronization", false));
        map.put(new Integer(20535), new EntryData("Incorrect password attempted", false));
        map.put(new Integer(20536), new EntryData("Storage array 10-minute lockout; maximum incorrect passwords attempted", true));
        map.put(new Integer(20537), new EntryData("Change parameters of volume copy pair", false));
        map.put(new Integer(20538), new EntryData("Start volume copy operation ", false));
        map.put(new Integer(20539), new EntryData("Stop volume copy operation", false));
        map.put(new Integer(20540), new EntryData("Change mirrored pair write mode ", false));
        map.put(new Integer(20541), new EntryData("Suspend mirror relationship", false));
        map.put(new Integer(20542), new EntryData("Resume mirror relationship", false));
        map.put(new Integer(20543), new EntryData("Resynchronization set for automatic ", false));
        map.put(new Integer(20544), new EntryData("Place controller in service mode", true));
        map.put(new Integer(20545), new EntryData("Recover volume", true));
        map.put(new Integer(20546), new EntryData("Mirror relationships for write consistency group suspended", false));
        map.put(new Integer(20547), new EntryData("Mirror relationships for write consistency group resumed", false));
        map.put(new Integer(20548), new EntryData("Change to single controller mode", false));
        map.put(new Integer(20549), new EntryData("Activate controller firmware started", false));
        map.put(new Integer(20550), new EntryData("Activate controller firmware completed", false));
        map.put(new Integer(20551), new EntryData("Activate controller firmware failed", false));
        map.put(new Integer(20552), new EntryData("Clear controller firmware started", false));
        map.put(new Integer(20553), new EntryData("Clear controller firmware completed", false));
        map.put(new Integer(20560), new EntryData("Clear controller firmware failed", false));
        map.put(new Integer(20992), new EntryData("Create host group", false));
        map.put(new Integer(20993), new EntryData("Delete host group", false));
        map.put(new Integer(20994), new EntryData("Rename host group", false));
        map.put(new Integer(20995), new EntryData("Create host", false));
        map.put(new Integer(20996), new EntryData("Delete host", false));
        map.put(new Integer(20997), new EntryData("Rename host", false));
        map.put(new Integer(20998), new EntryData("Move host", false));
        map.put(new Integer(20999), new EntryData("Create host port", false));
        map.put(new Integer(21000), new EntryData("Delete host port", false));
        map.put(new Integer(21001), new EntryData("Rename host port", false));
        map.put(new Integer(21002), new EntryData("Move host port", false));
        map.put(new Integer(21003), new EntryData("Set host port type", false));
        map.put(new Integer(21004), new EntryData("Create storage array port group", false));
        map.put(new Integer(21005), new EntryData("Delete storage array port group", false));
        map.put(new Integer(21006), new EntryData("Move storage array port", false));
        map.put(new Integer(21007), new EntryData("Create volume-to-LUN mapping", false));
        map.put(new Integer(21008), new EntryData("Delete volume-to-LUN mapping", false));
        map.put(new Integer(21009), new EntryData("Change volume-to-LUN mapping", false));
        map.put(new Integer(21010), new EntryData("Error writing configuration", false));
        map.put(new Integer(21011), new EntryData("Premium feature not supported - storage partitions deleted", false));
        map.put(new Integer(21504), new EntryData("Premium feature enabled", false));
        map.put(new Integer(21505), new EntryData("Premium feature disabled", false));
        map.put(new Integer(21506), new EntryData("Premium feature out of compliance", false));
        map.put(new Integer(21507), new EntryData("Premium feature exceeds limit", false));
        map.put(new Integer(21508), new EntryData("Feature Enable Identifier changed", false));
        map.put(new Integer(22016), new EntryData("Controller passed diagnostics", false));
        map.put(new Integer(22017), new EntryData("This controller's alternate passed diagnostics", false));
        map.put(new Integer(22018), new EntryData("This controller's alternate failed - timeout waiting for results", true));
        map.put(new Integer(22019), new EntryData("Diagnostics rejected - already in progress", false));
        map.put(new Integer(22020), new EntryData("Diagnostics rejected - this controller's alternate is absent or failed", false));
        map.put(new Integer(22021), new EntryData("Diagnostics rejected - error occurred when sending the Icon message", false));
        map.put(new Integer(22022), new EntryData("Diagnostics rejected - ctlrDiag task unable to queue DIAG_INIT_MSG message", false));
        map.put(new Integer(22023), new EntryData("Diagnostics returned unknown ReturnCode", false));
        map.put(new Integer(22024), new EntryData("Diagnostics rejected - test ID is incorrect", false));
        map.put(new Integer(22025), new EntryData("Diagnostics unable to select a drive for I/O", false));
        map.put(new Integer(22026), new EntryData("Diagnostics rejected - access volume (UTM) is not enabled", false));
        map.put(new Integer(22027), new EntryData("Diagnostics rejected - ctlrDiag task unable to obtain Mode Select lock", true));
        map.put(new Integer(22028), new EntryData("Diagnostics rejected - ctlrDiag task on this controller's alternate unable to obtain Mode Select lock", true));
        map.put(new Integer(22029), new EntryData("Diagnostics read test failed on controller", true));
        map.put(new Integer(22030), new EntryData("This controller's alternate failed diagnostics read test", true));
        map.put(new Integer(22031), new EntryData("Diagnostics write test failed on controller", true));
        map.put(new Integer(22032), new EntryData("This controller's alternate failed diagnostics write test", true));
        map.put(new Integer(22033), new EntryData("Controller passed diagnostics, but loopback test identified error on loop(s)", false));
        map.put(new Integer(22034), new EntryData("This controller's alternate passed diagnostics, but loopback test identified error on loop(s)", false));
        map.put(new Integer(22035), new EntryData("Diagnostics loopback test identified bad destination channel(s)", false));
        map.put(new Integer(22036), new EntryData("A host-side port (link) has been detected as down", false));
        map.put(new Integer(22037), new EntryData("Not Used", false));
        map.put(new Integer(22038), new EntryData("Diagnostics rejected - configuration error on controller", true));
        map.put(new Integer(22039), new EntryData("Diagnostics rejected - configuration error on this controller's alternate", true));
        map.put(new Integer(22040), new EntryData("Diagnostics rejected - no cache memory on controller", false));
        map.put(new Integer(22041), new EntryData("Diagnostics rejected - no cache memory on this controller's alternate", false));
        map.put(new Integer(22042), new EntryData("Diagnostics rejected - data transfer on controller is not disabled (quiesced)", false));
        map.put(new Integer(22043), new EntryData("Diagnostics rejected - data transfer on this controller's alternate is not disabled (quiesced)", false));
        map.put(new Integer(22044), new EntryData("Diagnostics rejected - both controllers must be in active mode", false));
        map.put(new Integer(22045), new EntryData("Diagnostics initiated from this controller", false));
        map.put(new Integer(22046), new EntryData("Running diagnostics on this controller", false));
        map.put(new Integer(22047), new EntryData("Diagnostics rejected - download is in progress", false));
        map.put(new Integer(24576), new EntryData("Internal configuration database created", false));
        map.put(new Integer(24577), new EntryData("Internal configuration database merged", false));
        map.put(new Integer(24578), new EntryData("Internal configuration database - mismatch of drives", false));
        map.put(new Integer(24579), new EntryData("Internal configuration database - not enough optimal drives available", false));
        map.put(new Integer(24580), new EntryData("Internal configuration database is being resynchronized", false));
        map.put(new Integer(24581), new EntryData("Internal configuration database - read or write operation failed", false));
        map.put(new Integer(24582), new EntryData("Internal configuration database - merge failed", false));
        map.put(new Integer(24832), new EntryData("Internal configuration database cleared", false));
        map.put(new Integer(24833), new EntryData("Internal configuration database full", true));
        map.put(new Integer(24834), new EntryData("Internal configuration database size increased", false));
        map.put(new Integer(24835), new EntryData("This controller's alternate was reset", false));
        map.put(new Integer(24836), new EntryData("This controller's alternate was failed", false));
        map.put(new Integer(24837), new EntryData("Internal configuration database - file system corrupted", false));
        map.put(new Integer(24838), new EntryData("Internal configuration database - incorrect file system version", false));
        map.put(new Integer(24839), new EntryData("This controller's alternate is non-functional and is being held in reset", true));
        map.put(new Integer(25088), new EntryData("Snapshot repository volume capacity - threshold exceeded", true));
        map.put(new Integer(25089), new EntryData("Snapshot repository volume capacity - full", true));
        map.put(new Integer(25090), new EntryData("Snapshot volume failed", true));
        map.put(new Integer(25091), new EntryData("Snapshot volume created", true));
        map.put(new Integer(25092), new EntryData("Snapshot volume deleted", true));
        map.put(new Integer(25344), new EntryData("Mirror repository volume created", false));
        map.put(new Integer(25345), new EntryData("Mirror repository volume deleted", false));
        map.put(new Integer(25600), new EntryData("Dual primary volume conflict", true));
        map.put(new Integer(25601), new EntryData("Dual secondary volume conflict", true));
        map.put(new Integer(25602), new EntryData("Data on mirrored pair unsynchronized", true));
        map.put(new Integer(25603), new EntryData("Data on mirrored pair synchronizing", true));
        map.put(new Integer(25604), new EntryData("Data on mirrored pair synchronized", true));
        map.put(new Integer(25605), new EntryData("Associated volume in mirrored pair not present", true));
        map.put(new Integer(25606), new EntryData("Remote volume mirror created", false));
        map.put(new Integer(25607), new EntryData("Mirror relationship removed", false));
        map.put(new Integer(25608), new EntryData("Mirror volume role change successful", false));
        map.put(new Integer(25609), new EntryData("Mirror relationship suspended", true));
        map.put(new Integer(25610), new EntryData("Mirrored pair unsynchronized - volume failures", true));
        map.put(new Integer(25611), new EntryData("Mirror relationship suspended", true));
        map.put(new Integer(25612), new EntryData("Mirror write mode set to synchronous", true));
        map.put(new Integer(25613), new EntryData("Mirror write mode set to asynchronous", true));
        map.put(new Integer(25614), new EntryData("Mirror write mode set to asynchronous, write-consistent", true));
        map.put(new Integer(25856), new EntryData("Remote volume created", true));
        map.put(new Integer(25857), new EntryData("Remote volume deleted", true));
        map.put(new Integer(25858), new EntryData("Communication to remote volume - up", true));
        map.put(new Integer(25859), new EntryData("Communication to remote volume - down", true));
        map.put(new Integer(25860), new EntryData("Remote storage array's world-wide name changed", false));
        map.put(new Integer(25861), new EntryData("Failed to communicate storage array's world-wide name", true));
        map.put(new Integer(26112), new EntryData("Volume copy operation failed", true));
        map.put(new Integer(26113), new EntryData("Volume copy pair established", true));
        map.put(new Integer(26114), new EntryData("Volume copy pair removed", true));
        map.put(new Integer(26115), new EntryData("Volume copy operation in progress", true));
        map.put(new Integer(26116), new EntryData("Volume copy operation pending", false));
        map.put(new Integer(26117), new EntryData("Volume copy operation stopped", false));
        map.put(new Integer(26118), new EntryData("Volume copy operation completed", true));
        map.put(new Integer(26368), new EntryData("Unreadable sector(s) detected - data loss occurred", true));
        map.put(new Integer(26369), new EntryData("Unreadable sector repaired", true));
        map.put(new Integer(26370), new EntryData("All unreadable sectors on the volume repaired - data not recovered", true));
        map.put(new Integer(26371), new EntryData("Overflow in unreadable sector database", true));
        map.put(new Integer(26372), new EntryData("Unreadable sectors found on volume", true));
        map.put(new Integer(26373), new EntryData("Volume import failed - too many unreadable sectors", false));
        return map;
    }

    public class EntryData {
        private String description;
        private boolean monitor;

        EntryData(String description, boolean monitor) {
            this.description = description;
            this.monitor = monitor;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean getMonitor() {
            return this.monitor;
        }
    }
}

