/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.diags;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.resource.diags.AbstractDiagnosticTest;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticException;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticResult;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticSetting;
import com.sun.netstorage.fm.storade.resource.diags.TestParameter;
import com.sun.netstorage.fm.storade.resource.diags.TestProperties;
import com.sun.netstorage.fm.util.LocalizedString;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.RemoteCommunicationCheckDescriptor;
import devmgr.versioned.symbol.RemoteCommunicationCheckSampleList;
import devmgr.versioned.symbol.RemoteVolRef;
import devmgr.versioned.symbol.RemoteVolume;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.util.ArrayList;
import java.util.Properties;

public class Treefrog_CommunicationCheck
extends AbstractDiagnosticTest {
    private static final int TOTAL_PARAMETERS = 2;
    private Properties devProps;

    public Treefrog_CommunicationCheck() {
        this.devProps = null;
    }

    public Treefrog_CommunicationCheck(Properties devProps) {
        this.devProps = devProps;
    }

    public TestProperties getTestProperties() throws DiagnosticException {
        TestProperties tp = new TestProperties(this.getClass().getName(), "6130", "out_of_band");
        tp.setTitle(new LocalizedString("Remote Peer Communication Check"));
        tp.setDescription(new LocalizedString("Remote Peer Communication Check"));
        tp.setAbortable(false);
        tp.setValidate(true);
        TestParameter[] param = new TestParameter[2];
        String selection = null;
        if (this.devProps != null) {
            selection = this.getTargetVolumes();
        }
        if (selection != null) {
            String firstSelect = "";
            int separator = selection.indexOf("|");
            firstSelect = separator > 0 ? selection.substring(0, selection.indexOf("|")) : selection;
            param[0] = new TestParameter("select", firstSelect, "remote_volume", new LocalizedString("Remote Volume Name"), selection);
        } else {
            param[0] = new TestParameter("input", "", "remote_volume", new LocalizedString("Remote Volume Name"));
        }
        param[1] = new TestParameter("input", "1", "sample_count", new LocalizedString("Samples to send (1 - 256)"));
        tp.setTestParameters(param);
        return tp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(DiagnosticSetting settings, DiagnosticResult diagResult) {
        RemoteCommunicationCheckDescriptor rccd;
        SYMbolAPIClientV1 client;
        block6: {
            client = null;
            rccd = this.getDescriptor(settings, diagResult);
            if (rccd != null) break block6;
            SYMbolConnection.closeClient(client);
            return;
        }
        try {
            String[] ips = Treefrog_CommunicationCheck.getIPList(settings.getDeviceProperties());
            for (int x = 0; x < ips.length; ++x) {
                client = SYMbolConnection.getOpenConnection(ips[x]);
                if (client == null) continue;
                diagResult.setState(1);
                client.setTimeout(new ProcedureTimeout().getProcTimeout(145));
                RemoteCommunicationCheckSampleList rccsl = client.communicationCheck(rccd);
                boolean retry = this.evaluateResults(rccsl, diagResult);
                if (!retry) break;
                SYMbolConnection.closeClient(client);
            }
        }
        catch (Exception e) {
            try {
                diagResult.setState(5);
                LocalizedString ls = new LocalizedString("Exception executing the communication check: " + e.toString());
                diagResult.setSynopsis(ls);
            }
            catch (Throwable throwable) {
                SYMbolConnection.closeClient(client);
                throw throwable;
            }
            SYMbolConnection.closeClient(client);
        }
        SYMbolConnection.closeClient(client);
    }

    boolean evaluateResults(RemoteCommunicationCheckSampleList rccsl, DiagnosticResult diagResult) {
        boolean retry = false;
        try {
            ReturnCode rc = rccsl.getReturnCode();
            if (rc.getValue() == 1) {
                LocalizedString ls;
                ReturnCode status = rccsl.getTestStatus();
                if (status.getValue() == 1) {
                    diagResult.setState(0);
                    ls = new LocalizedString("Communication check successful");
                    diagResult.setSynopsis(ls);
                } else if (status.getValue() == 236 || status.getValue() == 237) {
                    diagResult.setState(0);
                    ls = new LocalizedString(Translator.translateReturnCode(status));
                    diagResult.setSynopsis(ls);
                } else {
                    diagResult.setState(4);
                    ls = new LocalizedString("Unsuccessful communication attempt:\n" + Translator.translateReturnCode(status));
                    diagResult.setSynopsis(ls);
                }
                int[] sampleTimes = rccsl.getRemoteCommunicationCheckSamples();
                if (sampleTimes.length > 0) {
                    int total = 0;
                    int average = 0;
                    int max = sampleTimes[0];
                    int min = sampleTimes[0];
                    for (int x = 0; x < sampleTimes.length; ++x) {
                        total += sampleTimes[x];
                        if (sampleTimes[x] > max) {
                            max = sampleTimes[x];
                        }
                        if (sampleTimes[x] >= min) continue;
                        min = sampleTimes[x];
                    }
                    average = total / sampleTimes.length;
                    StringBuffer resultBuffer = new StringBuffer();
                    resultBuffer.append("The average transfer time for " + sampleTimes.length);
                    resultBuffer.append(" samples was " + average + " microseconds\n");
                    resultBuffer.append("Maximum transfer time for a sample was " + max + " microseconds\n");
                    resultBuffer.append("Minimum transfer time for a sample was " + min + " microseconds");
                    diagResult.setOutput(resultBuffer);
                }
            } else if (rc.getValue() == 13) {
                retry = true;
            } else {
                diagResult.setState(5);
                LocalizedString ls = new LocalizedString("Error from client interface: " + Translator.translateReturnCode(rc));
                diagResult.setSynopsis(ls);
            }
        }
        catch (Exception e) {
            diagResult.setState(5);
            LocalizedString ls = new LocalizedString("Exception executing the communication check: " + e.toString());
            diagResult.setSynopsis(ls);
        }
        return retry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteCommunicationCheckDescriptor getDescriptor(DiagnosticSetting settings, DiagnosticResult diagResult) {
        RemoteCommunicationCheckDescriptor rccd = null;
        String rvolName = settings.getOptions().getProperty("remote_volume");
        if (rvolName == null) {
            diagResult.setState(3);
            diagResult.setSynopsis(new LocalizedString("No remote volume name specified"));
            return null;
        }
        String samplesStr = settings.getOptions().getProperty("sample_count");
        int samples = 0;
        try {
            samples = Integer.parseInt(samplesStr);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (samples <= 0 || samples > 256) {
            diagResult.setState(3);
            diagResult.setSynopsis(new LocalizedString("The number of samples must be a number greater than zero (0) and no greater than 256"));
            return null;
        }
        Properties p = settings.getDeviceProperties();
        SYMbolAPIClientV1 client = SYMbolConnection.getOpenConnection(p);
        try {
            RemoteVolRef rvRef = null;
            RemoteVolume[] rvols = client.getObjectGraph().getHighLevelVolBundle().getRemoteVol();
            for (int i = 0; i < rvols.length; ++i) {
                RemoteVolume rvol = rvols[i];
                String name = Utility.userLabelString(rvol.getRemoteVolUserLabel());
                if (!rvolName.equals(name)) continue;
                rvRef = rvol.getRemoteVolRef();
                break;
            }
            if (rvRef == null) {
                diagResult.setState(3);
                diagResult.setSynopsis(new LocalizedString("Could not find a remote volume labeled " + rvolName));
                RemoteCommunicationCheckDescriptor remoteCommunicationCheckDescriptor = null;
                return remoteCommunicationCheckDescriptor;
            }
            rccd = new RemoteCommunicationCheckDescriptor();
            rccd.setNumSamples(samples);
            rccd.setRemoteVolume(rvRef);
        }
        catch (Exception e) {
            diagResult.setState(3);
            diagResult.setSynopsis(new LocalizedString("Exception setting up the communication check\n" + e.toString()));
            rccd = null;
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        return rccd;
    }

    private static String[] getIPList(Properties props) {
        ArrayList<String> ips = new ArrayList<String>();
        if (props.getProperty("ip") != null) {
            ips.add(props.getProperty("ip"));
        }
        if (props.getProperty("altip") != null) {
            ips.add(props.getProperty("altip"));
        }
        String[] addresses = new String[1];
        try {
            addresses = ips.toArray(addresses);
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTargetVolumes() {
        StringBuffer buffer = new StringBuffer();
        SYMbolAPIClientV1 client = null;
        try {
            ObjectBundle bundle;
            RemoteVolume[] remoteVolumes;
            client = SYMbolConnection.getOpenConnection(this.devProps);
            if (client != null && (remoteVolumes = (bundle = client.getObjectGraph()).getHighLevelVolBundle().getRemoteVol()) != null && remoteVolumes.length > 0) {
                for (int x = 0; x < remoteVolumes.length; ++x) {
                    if (buffer.length() > 0) {
                        buffer.append("|");
                    }
                    buffer.append(Utility.userLabelString(remoteVolumes[x].getRemoteVolUserLabel()));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        return buffer.toString();
    }
}

