/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.diags;

import com.sun.netstorage.fm.storade.client.SAClient;
import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.diags.DiagSetup;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticResult;
import com.sun.netstorage.fm.storade.resource.diags.DiagnosticSetting;
import com.sun.netstorage.fm.storade.service.device.DeviceMaintenanceService;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.netstorage.fm.util.LocalizedString;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.RuntimeDiagDescriptor;
import devmgr.versioned.symbol.RuntimeDiagResults;
import devmgr.versioned.symbol.RuntimeDiagTestID;
import devmgr.versioned.symbol.RuntimeDiagTestResults;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.util.Properties;

public class DiagUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void executeTest(DiagnosticSetting settings, DiagnosticResult diagResult, int testType) {
        block15: {
            SYMbolAPIClientV1 client2;
            SYMbolAPIClientV1 client1;
            block14: {
                DiagSetup setup;
                block13: {
                    block12: {
                        String altip;
                        block11: {
                            Properties p;
                            block10: {
                                client1 = null;
                                client2 = null;
                                p = settings.getDeviceProperties();
                                if (p != null) break block10;
                                diagResult.setState(5);
                                diagResult.setSynopsis(new LocalizedString("Could not get device properties. key = " + settings.getDeviceId()));
                                SYMbolConnection.closeClient(client1);
                                SYMbolConnection.closeClient(client2);
                                return;
                            }
                            String ip = p.getProperty("ipno");
                            altip = p.getProperty("altipno");
                            client1 = SYMbolConnection.getOpenConnection(ip);
                            client2 = SYMbolConnection.getOpenConnection(altip);
                            if (client1 != null) break block11;
                            diagResult.setState(5);
                            diagResult.setSynopsis(new LocalizedString("Unable to open a connection to " + ip + "\n" + "Both controllers must be online to run internal diagnostics"));
                            SYMbolConnection.closeClient(client1);
                            SYMbolConnection.closeClient(client2);
                            return;
                        }
                        if (client2 != null) break block12;
                        diagResult.setState(5);
                        diagResult.setSynopsis(new LocalizedString("Unable to open a connection to " + altip + "\n" + "Both controllers must be online to run internal diagnostics"));
                        SYMbolConnection.closeClient(client1);
                        SYMbolConnection.closeClient(client1);
                        SYMbolConnection.closeClient(client2);
                        return;
                    }
                    setup = new DiagSetup(client1, client2, settings.getOptions());
                    if (setup.isRunnable()) break block13;
                    diagResult.setState(5);
                    diagResult.setSynopsis(new LocalizedString(setup.getStatusReason()));
                    SYMbolConnection.closeClient(client1);
                    SYMbolConnection.closeClient(client2);
                    SYMbolConnection.closeClient(client1);
                    SYMbolConnection.closeClient(client2);
                    return;
                }
                try {
                    String password = settings.getOptions().getProperty("password_choice");
                    if (password == null) {
                        password = "";
                    }
                    if (setup.isRunnable()) {
                        RuntimeDiagDescriptor rdd = DiagUtility.createDiagDescriptor(settings.getOptions(), setup, testType);
                        DiagUtility.runDiag(rdd, diagResult, setup, password);
                        break block14;
                    }
                    diagResult.setState(5);
                    diagResult.setSynopsis(new LocalizedString(setup.getStatusReason()));
                }
                catch (Exception e) {
                    SYMbolConnection.closeClient(client1);
                    SYMbolConnection.closeClient(client2);
                    break block15;
                    catch (Throwable throwable) {
                        SYMbolConnection.closeClient(client1);
                        SYMbolConnection.closeClient(client2);
                        throw throwable;
                    }
                }
            }
            SYMbolConnection.closeClient(client1);
            SYMbolConnection.closeClient(client2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runDiag(RuntimeDiagDescriptor rdd, DiagnosticResult diagResult, DiagSetup setup, String password) {
        SYMbolAPIClientV1 targetClient = setup.getTargetClient();
        SYMbolAPIClientV1 primaryClient = setup.getPrimaryClient();
        try {
            boolean callException;
            RuntimeDiagResults results;
            block13: {
                Utility.setClientPassword(password, targetClient);
                diagResult.setState(1);
                diagResult.setSynopsis(new LocalizedString("Starting diagnostic run against Controller " + setup.getControllerLetter()));
                String qval = DiagUtility.quiesceController(targetClient, setup.getTargetRef());
                results = null;
                callException = false;
                try {
                    Object var11_10;
                    try {
                        Utility.setClientPassword(password, primaryClient);
                        primaryClient.setTimeout(new ProcedureTimeout().getProcTimeout(91));
                        results = primaryClient.issueRuntimeDiagnostics(rdd);
                    }
                    catch (Exception ex) {
                        callException = true;
                        diagResult.setState(5);
                        diagResult.setSynopsis(new LocalizedString("Exception while issuing the test: " + ex.toString()));
                        var11_10 = null;
                        Utility.setClientPassword(password, targetClient);
                        qval = DiagUtility.unquiesceController(targetClient, setup.getTargetRef());
                        break block13;
                    }
                    var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    Utility.setClientPassword(password, targetClient);
                    qval = DiagUtility.unquiesceController(targetClient, setup.getTargetRef());
                    throw throwable;
                }
                Utility.setClientPassword(password, targetClient);
                qval = DiagUtility.unquiesceController(targetClient, setup.getTargetRef());
            }
            if (results == null) {
                if (callException) return;
                diagResult.setState(5);
                diagResult.setSynopsis(new LocalizedString("Issue diag call returned null"));
                return;
            }
            if (results.getReturnCode().getValue() != 1) {
                diagResult.setState(5);
                diagResult.setSynopsis(new LocalizedString("Error running diag, RC = " + Translator.translateReturnCode(results.getReturnCode())));
                return;
            }
            StringBuffer resultBuffer = new StringBuffer();
            int runStatus = 0;
            resultBuffer.append("\nDiagnostic Target:  Controller " + setup.getControllerLetter() + "\n\n");
            RuntimeDiagTestResults[] allResults = results.getTestResults();
            int x = 0;
            while (true) {
                if (x >= allResults.length) {
                    diagResult.setState(runStatus);
                    diagResult.setSynopsis(new LocalizedString("Test Completed"));
                    diagResult.setOutput(resultBuffer);
                    return;
                }
                if (allResults[x].getTestStatus().getValue() != -1) {
                    resultBuffer.append("Test ID: " + Translator.translateTestID(allResults[x].getTestID()));
                    if (allResults[x].getChannel() > 0) {
                        resultBuffer.append(", Channel " + allResults[x].getChannel());
                    }
                    resultBuffer.append("\nTest Level: " + Translator.translateTestLevel(allResults[x].getTestLevel()));
                    resultBuffer.append("\nTest Status: " + Translator.translateTestStatus(allResults[x].getTestStatus()));
                    resultBuffer.append("\n\n");
                    if (allResults[x].getTestStatus().getValue() == 1) {
                        runStatus = 4;
                    }
                }
                ++x;
            }
        }
        catch (Exception e) {
            diagResult.setState(5);
            diagResult.setSynopsis(new LocalizedString("Exception while running the test"));
            diagResult.setOutput(new StringBuffer(e.toString()));
        }
    }

    public static RuntimeDiagDescriptor createDiagDescriptor(Properties props, DiagSetup setup, int testID) {
        RuntimeDiagDescriptor descriptor = new RuntimeDiagDescriptor();
        try {
            switch (testID) {
                case 1: {
                    descriptor.setUsePattern(false);
                    break;
                }
                case 3: {
                    descriptor.setUsePattern(false);
                    break;
                }
                case 2: {
                    descriptor.setUsePattern(true);
                    break;
                }
                case 0: {
                    descriptor.setUsePattern(true);
                    break;
                }
                default: {
                    testID = 1;
                    descriptor.setUsePattern(false);
                }
            }
            if (descriptor.getUsePattern()) {
                String channelStr = props.getProperty("channel_choice");
                int channelID = 1;
                try {
                    channelID = Integer.parseInt(channelStr);
                }
                catch (NumberFormatException nfe) {
                    channelID = 1;
                }
                descriptor.setChannel(channelID);
                String patternStr = props.getProperty("pattern_choice");
                byte[] selection = patternStr.getBytes();
                byte[] pattern = new byte[64];
                int y = 0;
                for (int x = 0; x < pattern.length; ++x) {
                    if (y >= selection.length) {
                        y = 0;
                    }
                    pattern[x] = selection[y];
                    ++y;
                }
                descriptor.setPattern(pattern);
            } else {
                descriptor.setChannel(1);
                descriptor.setPattern(new byte[64]);
            }
            RuntimeDiagTestID rttid = new RuntimeDiagTestID(testID);
            descriptor.setRuntimeDiagTestID(rttid);
            descriptor.setControllerRef(setup.getTargetRef());
        }
        catch (Exception e) {
            // empty catch block
        }
        return descriptor;
    }

    public static Properties getDeviceProperties(String deviceKey) {
        Properties devProps = null;
        try {
            SAClient sa = new SAClient();
            DeviceMaintenanceService dms = sa.getDeviceMaintenanceService();
            DeviceProperties dp = dms.getDeviceProperties(deviceKey);
            devProps = dp.getProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return devProps;
    }

    public static boolean bindToController(SYMbolAPIClientV1 client, ControllerRef ref) {
        boolean bound = false;
        try {
            ObjectBundle bundle = client.getObjectGraph();
            SAIdentifier said = bundle.getSa().getSaData().getSaId();
            ControllerDescriptor descriptor = new ControllerDescriptor();
            descriptor.setControllerRef(ref);
            descriptor.setSaId(said);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(2));
            ReturnCode rc = client.bindToController(descriptor);
            if (rc.getValue() == 1) {
                bound = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bound;
    }

    private static String quiesceController(SYMbolAPIClientV1 client, ControllerRef ref) {
        String rval = "No quiesce status";
        try {
            client.setTimeout(new ProcedureTimeout().getProcTimeout(93));
            ReturnCode rcode = client.quiesceController(ref);
            rval = "Quiesce status: " + Translator.translateReturnCode(rcode);
        }
        catch (Exception e) {
            rval = "Error quiescing controller: " + e.toString();
        }
        return rval;
    }

    private static String unquiesceController(SYMbolAPIClientV1 client, ControllerRef ref) {
        String rval = "No quiesce status";
        try {
            client.setTimeout(new ProcedureTimeout().getProcTimeout(94));
            ReturnCode rcode = client.unquiesceController(ref);
            rval = "Unquiesce status: " + Translator.translateReturnCode(rcode);
        }
        catch (Exception e) {
            rval = "Error unquiescing controller: " + e.toString();
        }
        return rval;
    }
}

