/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.common;

import devmgr.versioned.symbol.BatteryStatus;
import devmgr.versioned.symbol.BatteryType;
import devmgr.versioned.symbol.CacheFlushModifier;
import devmgr.versioned.symbol.Capability;
import devmgr.versioned.symbol.DriveChannelState;
import devmgr.versioned.symbol.DriveType;
import devmgr.versioned.symbol.EventCategory;
import devmgr.versioned.symbol.EventPriority;
import devmgr.versioned.symbol.IOInterfaceType;
import devmgr.versioned.symbol.InterfaceSpeed;
import devmgr.versioned.symbol.LinkStatus;
import devmgr.versioned.symbol.MirrorProxyRole;
import devmgr.versioned.symbol.MirrorProxyStatus;
import devmgr.versioned.symbol.MirrorProxyWriteMode;
import devmgr.versioned.symbol.MirrorSyncPriority;
import devmgr.versioned.symbol.NVSRAMRegionId;
import devmgr.versioned.symbol.PhysicalDriveType;
import devmgr.versioned.symbol.RAIDLevel;
import devmgr.versioned.symbol.RemoteVolumeState;
import devmgr.versioned.symbol.RepositoryFullPolicy;
import devmgr.versioned.symbol.ReservationTypeID;
import devmgr.versioned.symbol.ReservedPortID;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.RuntimeDiagTestID;
import devmgr.versioned.symbol.RuntimeDiagTestLevel;
import devmgr.versioned.symbol.RuntimeDiagTestStatus;
import devmgr.versioned.symbol.SFP_CONNECT_TYPE;
import devmgr.versioned.symbol.SFP_IDENT_TYPE;
import devmgr.versioned.symbol.SFP_LINKL_TYPE;
import devmgr.versioned.symbol.SFP_SPEED;
import devmgr.versioned.symbol.SFP_TRANSMISSION_MEDIA;
import devmgr.versioned.symbol.SFP_TRANSMITTER_TYPE;
import devmgr.versioned.symbol.SnapshotAction;
import devmgr.versioned.symbol.SnapshotStatus;
import devmgr.versioned.symbol.SocLoopState;
import devmgr.versioned.symbol.SocPortMode;
import devmgr.versioned.symbol.SocPortState;
import devmgr.versioned.symbol.UsmRecordType;
import devmgr.versioned.symbol.VolumeAction;
import devmgr.versioned.symbol.VolumeCopyStatus;

public class Translator {
    public static final String SLOT_1_NAME = "A";
    public static final String SLOT_2_NAME = "B";

    public static String getSlotName(int slot) {
        String name = "" + slot;
        if (slot == 1) {
            name = SLOT_1_NAME;
        } else if (slot == 2) {
            name = SLOT_2_NAME;
        }
        return name;
    }

    public static String getInvertedSlotName(int slot) {
        String name = Integer.toString(slot);
        if (slot == 2) {
            name = SLOT_1_NAME;
        } else if (slot == 1) {
            name = SLOT_2_NAME;
        }
        return name;
    }

    public static String translateDriveStatusCause(int cause) {
        String result = "Unknown";
        switch (cause) {
            case 1: {
                result = "None";
                break;
            }
            case 5: {
                result = "Speed Mismatch";
                break;
            }
            case 4: {
                result = "Uncertified";
                break;
            }
            case 2: {
                result = "User Operation";
                break;
            }
            case 3: {
                result = "Write Operation";
                break;
            }
            case 6: {
                result = "Unknown";
            }
        }
        return result;
    }

    public static String translateDriveChannelState(DriveChannelState state) {
        String result = "Unknown";
        switch (state.getValue()) {
            case 1: {
                result = "Degraded";
                break;
            }
            case 2: {
                result = "Hardware Failed";
                break;
            }
            case 0: {
                result = "Optimal";
            }
        }
        return result;
    }

    public static String translateTrayType(int type) {
        String result = "Unknown";
        switch (type) {
            case 5: {
                result = "GENERIC";
                break;
            }
            case 4: {
                result = "PCIRAID";
                break;
            }
            case 1: {
                result = "SYM1000";
                break;
            }
            case 7: {
                result = "SYM1200";
                break;
            }
            case 2: {
                result = "SYM2000";
                break;
            }
            case 6: {
                result = "SYM2200";
                break;
            }
            case 3: {
                result = "SYM2772";
                break;
            }
            case 8: {
                result = "SYM2882";
            }
        }
        return result;
    }

    public static String translateRaidLevel(RAIDLevel level) {
        return Translator.translateRaidLevel(level.getValue());
    }

    public static String translateRaidLevel(int level) {
        String result = "Unknown";
        switch (level) {
            case -1: {
                result = "Raid All";
                break;
            }
            case 0: {
                result = "RAID 0";
                break;
            }
            case 1: {
                result = "RAID 1";
                break;
            }
            case 3: {
                result = "RAID 3";
                break;
            }
            case 5: {
                result = "RAID 5";
            }
        }
        return result;
    }

    public static String translateOrientation(int value) {
        String result = "Unknown";
        switch (value) {
            case 1: {
                result = "horizontal";
                break;
            }
            case 2: {
                result = "vertical";
            }
        }
        return result;
    }

    public static String translateRemoteVolState(RemoteVolumeState state) {
        String result = "Unknown";
        switch (state.getValue()) {
            case 4: {
                result = "Initializing";
                break;
            }
            case 2: {
                result = "Cannot access remote array";
                break;
            }
            case 3: {
                result = "Cannot connect to fabric";
                break;
            }
            case 1: {
                result = "Cannot access LUN on remote array";
                break;
            }
            case 0: {
                result = "Optimal";
                break;
            }
            case 5: {
                result = "WWN change failed";
            }
        }
        return result;
    }

    public static String translateMirrorProxyStatus(MirrorProxyStatus status) {
        String rval = "Unknown";
        switch (status.getValue()) {
            case 5: {
                rval = "Failed";
                break;
            }
            case 6: {
                rval = "Failed/Suspended";
                break;
            }
            case 3: {
                rval = "Not Ready";
                break;
            }
            case 0: {
                rval = "Sychronized";
                break;
            }
            case 4: {
                rval = "Suspended";
                break;
            }
            case 2: {
                rval = "Sychronizing";
                break;
            }
            case 1: {
                rval = "Unsychronized";
            }
        }
        return rval;
    }

    public static String translateMirrorProxyRole(MirrorProxyRole role) {
        String rval = "Unknown";
        switch (role.getValue()) {
            case 2: {
                rval = "Invalid";
                break;
            }
            case 1: {
                rval = "Secondary";
                break;
            }
            case 0: {
                rval = "Primary";
            }
        }
        return rval;
    }

    public static String translateMirrorSyncPriority(MirrorSyncPriority priority) {
        String rval = "Unknown";
        switch (priority.getValue()) {
            case 0: {
                rval = "0";
                break;
            }
            case 1: {
                rval = "1";
                break;
            }
            case 2: {
                rval = "2";
                break;
            }
            case 3: {
                rval = "3";
                break;
            }
            case 4: {
                rval = "4";
            }
        }
        return rval;
    }

    public static String translateLocalWriteMode(MirrorProxyWriteMode mode) {
        String rval = "Unknown";
        switch (mode.getValue()) {
            case 1: {
                rval = "Asynchronous";
                break;
            }
            case 2: {
                rval = "Consistent Asychronous";
                break;
            }
            case 0: {
                rval = "Synchronous";
            }
        }
        return rval;
    }

    public static String translateSnapshotStatus(SnapshotStatus status) {
        String rval = "Unknown";
        switch (status.getValue()) {
            case 1: {
                rval = "Active";
                break;
            }
            case 3: {
                rval = "Disabled";
                break;
            }
            case 2: {
                rval = "Failed";
                break;
            }
            case 4: {
                rval = "Offline";
            }
        }
        return rval;
    }

    public static String translateSnapshotAction(SnapshotAction action) {
        String rval = "Unknown";
        switch (action.getValue()) {
            case 1: {
                rval = "None";
                break;
            }
            case 2: {
                rval = "Rollback";
            }
        }
        return rval;
    }

    public static String translateRepositoryFullPolicy(RepositoryFullPolicy policy) {
        String rval = "Unknown";
        switch (policy.getValue()) {
            case 2: {
                rval = "Fail Snap";
                break;
            }
            case 1: {
                rval = "Fail Writes";
            }
        }
        return rval;
    }

    public static String translateSpeed(InterfaceSpeed speed) {
        return Translator.translateSpeed(speed.getValue());
    }

    public static String translateSpeed(int speed) {
        String result = "Unknown";
        switch (speed) {
            case 5: {
                result = "10 Gb/s";
                break;
            }
            case 2: {
                result = "1 Gb/s";
                break;
            }
            case 6: {
                result = "1.5 Gb/s";
                break;
            }
            case 3: {
                result = "2 Gb/s";
                break;
            }
            case 7: {
                result = "3 Gb/s";
                break;
            }
            case 4: {
                result = "4 Gb/s";
            }
        }
        return result;
    }

    public static String translateESMStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
            }
        }
        return rval;
    }

    public static String translateStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 1: {
                rval = "Failed";
                break;
            }
            case 2: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
            }
        }
        return rval;
    }

    public static String translateFanStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
            }
        }
        return rval;
    }

    public static String translateSfpStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
            }
        }
        return rval;
    }

    public static String translateBatteryStatus(BatteryStatus status) {
        String rval = "Unknown";
        int value = status.getValue();
        switch (value) {
            case 2: {
                rval = "Charging";
                break;
            }
            case 4: {
                rval = "Failed";
                break;
            }
            case 3: {
                rval = "Near Expiration";
                break;
            }
            case 7: {
                rval = "Not in Config";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 5: {
                rval = "Removed";
                break;
            }
            case 6: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateBatteryType(BatteryType type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 2: {
                rval = "Controller";
                break;
            }
            case 1: {
                rval = "Controller Tray";
            }
        }
        return rval;
    }

    public static String translatePowerSupplyStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
                break;
            }
            case 5: {
                rval = "No Input";
            }
        }
        return rval;
    }

    public static String translateControllerStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 3: {
                rval = "Removed";
                break;
            }
            case 4: {
                rval = "RPA Parity Error";
                break;
            }
            case 5: {
                rval = "Service";
            }
        }
        return rval;
    }

    public static String translateDriveStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 4: {
                rval = "Bypassed";
                break;
            }
            case 2: {
                rval = "Failed";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 6: {
                rval = "Removed";
                break;
            }
            case 3: {
                rval = "Replaced";
                break;
            }
            case 5: {
                rval = "Unresponsive";
            }
        }
        return rval;
    }

    public static String translateDriveType(DriveType type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 2: {
                rval = "Fibre";
                break;
            }
            case 1: {
                rval = "SCSI";
                break;
            }
            case 3: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translatePhysicalDriveType(PhysicalDriveType type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 0: {
                rval = "All";
                break;
            }
            case 2: {
                rval = "Fibre Channel";
                break;
            }
            case 4: {
                rval = "PATA";
                break;
            }
            case 3: {
                rval = "SATA";
                break;
            }
            case 1: {
                rval = "SCSI";
            }
        }
        return rval;
    }

    public static String translateTempStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 3: {
                rval = "OverMaxTemp";
                break;
            }
            case 2: {
                rval = "OverTemp";
                break;
            }
            case 1: {
                rval = "Optimal";
                break;
            }
            case 4: {
                rval = "Removed";
                break;
            }
            case 5: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateLinkStatus(LinkStatus status) {
        return Translator.translateLinkStatus(status.getValue());
    }

    public static String translateLinkStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Down";
                break;
            }
            case 1: {
                rval = "Up";
                break;
            }
            case 3: {
                rval = "Failed";
            }
        }
        return rval;
    }

    public static String translateSpeedControl(int status) {
        String rval = "Unknown";
        switch (status) {
            case 4: {
                rval = "Auto";
                break;
            }
            case 2: {
                rval = "Fixed";
                break;
            }
            case 3: {
                rval = "Switched";
                break;
            }
            case 1: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateTopologyType(int status) {
        String rval = "Unknown";
        switch (status) {
            case 3: {
                rval = "Arb Loop";
                break;
            }
            case 4: {
                rval = "FAB Loop";
                break;
            }
            case 2: {
                rval = "Fabric";
                break;
            }
            case 1: {
                rval = "PTP";
            }
        }
        return rval;
    }

    public static String translateRLSDeviceType(int type) {
        String rval = "Unknown";
        switch (type) {
            case 1: {
                rval = "Controller";
                break;
            }
            case 2: {
                rval = "Drive";
                break;
            }
            case 3: {
                rval = "ESM";
            }
        }
        return rval;
    }

    public static String translateVolumeStatus(int status) {
        String rval = "Unknown";
        switch (status) {
            case 2: {
                rval = "Degraded";
                break;
            }
            case 3: {
                rval = "Failed";
                break;
            }
            case 4: {
                rval = "Impaired";
                break;
            }
            case 1: {
                rval = "Optimal";
            }
        }
        return rval;
    }

    public static String translateVolumeAction(VolumeAction action) {
        return Translator.translateVolumeAction(action.getValue());
    }

    public static String translateVolumeAction(int action) {
        String rval = "Unknown";
        switch (action) {
            case 2: {
                rval = "Copyback";
                break;
            }
            case 13: {
                rval = "Formatting";
                break;
            }
            case 3: {
                rval = "Initializing";
                break;
            }
            case 1: {
                rval = "None";
                break;
            }
            case 4: {
                rval = "Reconstructing";
                break;
            }
            case 5: {
                rval = "Remapping DCE";
                break;
            }
            case 7: {
                rval = "Remapping DCEDRM";
                break;
            }
            case 10: {
                rval = "Remapping DCEDVE";
                break;
            }
            case 12: {
                rval = "Remapping Defrag";
                break;
            }
            case 6: {
                rval = "Remapping DRM";
                break;
            }
            case 8: {
                rval = "Remapping DSEG";
                break;
            }
            case 9: {
                rval = "Remapping DVE";
                break;
            }
            case 11: {
                rval = "Remapping Internal";
                break;
            }
            case 14: {
                rval = "Synchronizing";
            }
        }
        return rval;
    }

    public static String translateVolumeCopyStatus(VolumeCopyStatus status) {
        String rval = "Unknown";
        switch (status.getValue()) {
            case 2: {
                rval = "Complete";
                break;
            }
            case 4: {
                rval = "Failed";
                break;
            }
            case 3: {
                rval = "Halted";
                break;
            }
            case 1: {
                rval = "In Progress";
                break;
            }
            case 5: {
                rval = "Pending";
            }
        }
        return rval;
    }

    public static String translateCacheFlushModifier(CacheFlushModifier modifier) {
        String rval = "Unknown";
        switch (modifier.getValue()) {
            case 4: {
                rval = "1";
                break;
            }
            case 8: {
                rval = "10";
                break;
            }
            case 11: {
                rval = "20";
                break;
            }
            case 13: {
                rval = "1200";
                break;
            }
            case 5: {
                rval = "1.5";
                break;
            }
            case 6: {
                rval = "2";
                break;
            }
            case 9: {
                rval = "20";
                break;
            }
            case 1: {
                rval = ".25";
                break;
            }
            case 12: {
                rval = "300";
                break;
            }
            case 14: {
                rval = "3600";
                break;
            }
            case 7: {
                rval = "5";
                break;
            }
            case 2: {
                rval = ".5";
                break;
            }
            case 10: {
                rval = "60";
                break;
            }
            case 3: {
                rval = ".75";
                break;
            }
            case 0: {
                rval = "Immediate";
                break;
            }
            case 15: {
                rval = "Infinite";
            }
        }
        return rval;
    }

    public static String translateSfpIdentType(SFP_IDENT_TYPE type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 1: {
                rval = "GBIC";
                break;
            }
            case 3: {
                rval = "SFP";
                break;
            }
            case 2: {
                rval = "Soldered";
            }
        }
        return rval;
    }

    public static String translateSfpConnectType(SFP_CONNECT_TYPE type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 4: {
                rval = "BNC or TNC";
                break;
            }
            case 13: {
                rval = "Copper Pigtail";
                break;
            }
            case 6: {
                rval = "Fibre Jack";
                break;
            }
            case 5: {
                rval = "Fibre Channel Coaxial Headers";
                break;
            }
            case 2: {
                rval = "FC Style 1 Copper Connector";
                break;
            }
            case 3: {
                rval = "FC Style 2 Copper Connector";
                break;
            }
            case 12: {
                rval = "HSSDC II";
                break;
            }
            case 7: {
                rval = "LC";
                break;
            }
            case 8: {
                rval = "MT-RJ";
                break;
            }
            case 9: {
                rval = "MU";
                break;
            }
            case 11: {
                rval = "Optical Pigtail";
                break;
            }
            case 1: {
                rval = "SC";
                break;
            }
            case 10: {
                rval = "SG";
                break;
            }
            case 0: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateEsmIFType(IOInterfaceType type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 2: {
                rval = "Fibre Channel";
                break;
            }
            case 1: {
                rval = "SCSI";
            }
        }
        return rval;
    }

    public static String translateSfpLinkType(SFP_LINKL_TYPE type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "Intermediate";
                break;
            }
            case 4: {
                rval = "Long";
                break;
            }
            case 2: {
                rval = "Short";
                break;
            }
            case 1: {
                rval = "Very long";
            }
        }
        return rval;
    }

    public static String translateSfpSpeed(SFP_SPEED type) {
        String rval = "Unknown";
        int value = type.getValue();
        if (value == 0) {
            rval = "Unknown";
        } else {
            StringBuffer buf = new StringBuffer();
            if ((value & 1) > 0) {
                buf.append("1 Gb/sec");
            }
            if ((value & 2) > 0) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append("2 Gb/sec");
            }
            if ((value & 4) > 0) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append("4 Gb/sec");
            }
            if (buf.length() == 0) {
                buf.append("Unknown");
            }
            rval = buf.toString();
        }
        return rval;
    }

    public static String translateSfpXmitMedia(SFP_TRANSMISSION_MEDIA media) {
        String rval = "unknown";
        switch (media.getValue()) {
            case 4: {
                rval = "Miniature Coax";
                break;
            }
            case 32: {
                rval = "Multi Mode M5 (50m)";
                break;
            }
            case 16: {
                rval = "Multi Mode M6 (62.5m)";
                break;
            }
            case 2: {
                rval = "Shielded Twisted Pair";
                break;
            }
            case 64: {
                rval = "Single Mode";
                break;
            }
            case 8: {
                rval = "Video Coax";
                break;
            }
            case 1: {
                rval = "Twin Axial Pair";
                break;
            }
            case 0: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateSfpXmitType(SFP_TRANSMITTER_TYPE type) {
        String rval = "Unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "Electrical Intra-Enclosure";
                break;
            }
            case 2: {
                rval = "Electrical Inter-Enclosure";
                break;
            }
            case 1: {
                rval = "Long Wave Laser";
                break;
            }
            case 6: {
                rval = "Long Wave Laser";
                break;
            }
            case 5: {
                rval = "Short Wave Laser with OFC";
                break;
            }
            case 4: {
                rval = "Short Wave Laser without OFC";
                break;
            }
            case 0: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateTestStatus(RuntimeDiagTestStatus status) {
        String rval = "Unknown";
        switch (status.getValue()) {
            case 1: {
                rval = "Fail";
                break;
            }
            case -1: {
                rval = "None";
                break;
            }
            case 0: {
                rval = "Pass";
            }
        }
        return rval;
    }

    public static String translateTestID(RuntimeDiagTestID id) {
        String rval = "Unknown";
        switch (id.getValue()) {
            case 0: {
                rval = "All";
                break;
            }
            case 2: {
                rval = "Loopback";
                break;
            }
            case 1: {
                rval = "Read";
                break;
            }
            case 3: {
                rval = "Write";
            }
        }
        return rval;
    }

    public static String translateTestLevel(RuntimeDiagTestLevel level) {
        String rval = "Unknown";
        switch (level.getValue()) {
            case 1: {
                rval = "External";
                break;
            }
            case 0: {
                rval = "Internal";
            }
        }
        return rval;
    }

    public static String translateRegionID(NVSRAMRegionId id) {
        String rval = "Unknown";
        switch (id.getValue()) {
            case -1: {
                rval = "REGION_ALL_REGIONS";
                break;
            }
            case 240: {
                rval = "REGION_BOOTP_DATA";
                break;
            }
            case 234: {
                rval = "REGION_DRIVE_FAULT_DATA";
                break;
            }
            case 241: {
                rval = "REGION_EXT_USER_CONFIG_DATA";
                break;
            }
            case 237: {
                rval = "REGION_HOST_INTERFACE_DATA";
                break;
            }
            case 236: {
                rval = "REGION_HOST_MANAGED_DATA";
                break;
            }
            case 242: {
                rval = "REGION_HOST_TYPE_DEPENDENT_DATA";
                break;
            }
            case 233: {
                rval = "REGION_SUBSYSTEM_FAULT_DATA";
                break;
            }
            case 232: {
                rval = "REGION_SUBSYSTEM_ID";
                break;
            }
            case 238: {
                rval = "REGION_USER_CONFIG_DATA";
            }
        }
        return rval;
    }

    public static String translateUsmRecordType(UsmRecordType type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "USM_RECORD_TYPE_INJECTED";
                break;
            }
            case 2: {
                rval = "USM_RECORD_TYPE_LOGICAL";
                break;
            }
            case 1: {
                rval = "USM_RECORD_TYPE_PHYSICAL";
            }
        }
        return rval;
    }

    public static String translateEventCategory(EventCategory type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "EVENT_CATEGORY_COMMAND";
                break;
            }
            case 1: {
                rval = "EVENT_CATEGORY_ERROR";
                break;
            }
            case 2: {
                rval = "EVENT_CATEGORY_FAILURE";
                break;
            }
            case 7: {
                rval = "EVENT_CATEGORY_GENERAL";
                break;
            }
            case 6: {
                rval = "EVENT_CATEGORY_HOST_ENTRY";
                break;
            }
            case 4: {
                rval = "EVENT_CATEGORY_NOTIFICATION";
                break;
            }
            case 5: {
                rval = "EVENT_CATEGORY_STATE_CHANGE";
            }
        }
        return rval;
    }

    public static String niceEventCategory(EventCategory type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 3: {
                rval = "Command";
                break;
            }
            case 1: {
                rval = "Error";
                break;
            }
            case 2: {
                rval = "Failure";
                break;
            }
            case 7: {
                rval = "General";
                break;
            }
            case 6: {
                rval = "Host Entry";
                break;
            }
            case 4: {
                rval = "Notification";
                break;
            }
            case 5: {
                rval = "State Change";
            }
        }
        return rval;
    }

    public static String translateEventPriority(EventPriority type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 0: {
                rval = "Critical";
                break;
            }
            case 1: {
                rval = "Informational";
            }
        }
        return rval;
    }

    public static String translateReservationTypeID(ReservationTypeID type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 2: {
                rval = "RES_TYPE_EXCL_ACCESS";
                break;
            }
            case 6: {
                rval = "RES_TYPE_EXCL_ACCESS_ALL_REG";
                break;
            }
            case 4: {
                rval = "RES_TYPE_EXCL_ACCESS_REG_ONLY";
                break;
            }
            case 0: {
                rval = "RES_TYPE_NO_RESERVATION";
                break;
            }
            case 1: {
                rval = "RES_TYPE_WRITE_EXCL";
                break;
            }
            case 5: {
                rval = "RES_TYPE_WRITE_EXCL_ALL_REG";
                break;
            }
            case 3: {
                rval = "RES_TYPE_WRITE_EXCL_REG_ONLY";
            }
        }
        return rval;
    }

    public static String translateReservedPortID(ReservedPortID type) {
        String rval = "unknown";
        switch (type.getValue()) {
            case 0: {
                rval = "RES_PORT_A0";
                break;
            }
            case 1: {
                rval = "RES_PORT_A1";
                break;
            }
            case 2: {
                rval = "RES_PORT_B0";
                break;
            }
            case 3: {
                rval = "RES_PORT_B1";
                break;
            }
            case -1: {
                rval = "RES_PORT_ALL";
                break;
            }
            case -2: {
                rval = "RES_PORT_NONE";
            }
        }
        return rval;
    }

    public static String translateCapability(Capability capability) {
        String rval = "unknown";
        switch (capability.getValue()) {
            case 4: {
                rval = "CAPABILITY_AUTO_CODE_SYNC";
                break;
            }
            case 5: {
                rval = "CAPABILITY_AUTO_LUN_TRANSFER";
                break;
            }
            case 3: {
                rval = "CAPABILITY_MIXED_RAIDLEVEL";
                break;
            }
            case 13: {
                rval = "CAPABILITY_REMOTE_MIRRORING";
                break;
            }
            case 1: {
                rval = "CAPABILITY_SHARED_VOLUME";
                break;
            }
            case 12: {
                rval = "CAPABILITY_SNAPSHOTS";
                break;
            }
            case 15: {
                rval = "CAPABILITY_STAGED_DOWNLOAD";
                break;
            }
            case 11: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_16";
                break;
            }
            case 8: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_2";
                break;
            }
            case 2: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_4";
                break;
            }
            case 10: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_64";
                break;
            }
            case 7: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_8";
                break;
            }
            case 9: {
                rval = "CAPABILITY_STORAGE_POOLS_TO_MAX";
                break;
            }
            case 6: {
                rval = "CAPABILITY_SUB_LUNS_ALLOWED";
                break;
            }
            case 14: {
                rval = "CAPABILITY_VOLUME_COPY";
            }
        }
        return rval;
    }

    public static String translateCapabilityDescription(Capability capability) {
        String rval = "unknown";
        switch (capability.getValue()) {
            case 4: {
                rval = "Auto Code Synchronization";
                break;
            }
            case 5: {
                rval = "Auto LUN Transfer";
                break;
            }
            case 3: {
                rval = "Mixed RAID Levels";
                break;
            }
            case 13: {
                rval = "Remote Mirroring";
                break;
            }
            case 1: {
                rval = "Shared Volume";
                break;
            }
            case 12: {
                rval = "Snapshot";
                break;
            }
            case 15: {
                rval = "Staged Download";
                break;
            }
            case 11: {
                rval = "Up to 16 Storage Pools";
                break;
            }
            case 8: {
                rval = "Up to 2 Storage Pools";
                break;
            }
            case 2: {
                rval = "Up to 4 Storage Pools";
                break;
            }
            case 10: {
                rval = "Up to 64 Storage Pools";
                break;
            }
            case 7: {
                rval = "Up to 8 Storage Pools";
                break;
            }
            case 9: {
                rval = "Storage Pools to Max";
                break;
            }
            case 6: {
                rval = "Sub Luns Allowed";
                break;
            }
            case 14: {
                rval = "Volume Copy";
            }
        }
        return rval;
    }

    public static String translateSocPortMode(SocPortMode mode) {
        String rval = "unknown";
        switch (mode.getValue()) {
            case 0: {
                rval = "Device";
                break;
            }
            case 2: {
                rval = "String";
                break;
            }
            case 1: {
                rval = "Tree";
            }
        }
        return rval;
    }

    public static String translateSocLoopState(SocLoopState state) {
        String rval = "unknown";
        switch (state.getValue()) {
            case 4: {
                rval = "Active";
                break;
            }
            case 0: {
                rval = "Down";
                break;
            }
            case 1: {
                rval = "Init";
                break;
            }
            case 2: {
                rval = "Open Init";
                break;
            }
            case 3: {
                rval = "Up";
            }
        }
        return rval;
    }

    public static String translateSocPortState(SocPortState state) {
        String rval = "unknown";
        switch (state.getValue()) {
            case 17: {
                rval = "BYP_CRC_THRESH";
                break;
            }
            case 9: {
                rval = "BYP_DATA_TIMEOUT";
                break;
            }
            case 18: {
                rval = "BYP_INVALID_OS_THRESH";
                break;
            }
            case 8: {
                rval = "BYP_LIP_F8";
                break;
            }
            case 12: {
                rval = "BYP_LIP_ISOL";
                break;
            }
            case 14: {
                rval = "BYP_MANUAL";
                break;
            }
            case 6: {
                rval = "BYP_NO_FRU";
                break;
            }
            case 13: {
                rval = "BYP_PTBI";
                break;
            }
            case 15: {
                rval = "BYP_REDUNDANT";
                break;
            }
            case 10: {
                rval = "BYP_SNOOP";
                break;
            }
            case 16: {
                rval = "";
                break;
            }
            case 11: {
                rval = "BYP_SYNC_LOSS";
                break;
            }
            case 7: {
                rval = "BYP_TX_FAULT";
                break;
            }
            case 5: {
                rval = "Bypassed";
                break;
            }
            case 4: {
                rval = "DIAG_XMIT";
                break;
            }
            case 1: {
                rval = "Inserted";
                break;
            }
            case 2: {
                rval = "Manually Inserted";
                break;
            }
            case 3: {
                rval = "Loopback";
                break;
            }
            case 0: {
                rval = "Unknown";
            }
        }
        return rval;
    }

    public static String translateReturnCode(ReturnCode rcode) {
        return Translator.translateReturnCode(rcode.getValue());
    }

    public static String translateReturnCode(int status) {
        String rval = "Unknown";
        switch (status) {
            case 0: {
                rval = "Value when an object has not been initialized";
                break;
            }
            case 1: {
                rval = "Operation completed successfully";
                break;
            }
            case 2: {
                rval = "Operation failed";
                break;
            }
            case 3: {
                rval = "Operation failed due to resource contention";
                break;
            }
            case 4: {
                rval = "Operation failed due to invalid parameterization";
                break;
            }
            case 5: {
                rval = "Controller memory is in short supply";
                break;
            }
            case 6: {
                rval = "Drive does not exist";
                break;
            }
            case 7: {
                rval = "Drive is not unassigned";
                break;
            }
            case 8: {
                rval = "No hot spares were assigned";
                break;
            }
            case 9: {
                rval = "Not all of the requested spares were assigned";
                break;
            }
            case 10: {
                rval = "Volume does not exist";
                break;
            }
            case 11: {
                rval = "Volume is reconfiguring";
                break;
            }
            case 12: {
                rval = "Must be dual active to perform operation";
                break;
            }
            case 13: {
                rval = "Operation must be performed by alt controller";
                break;
            }
            case 14: {
                rval = "Operation running in background";
                break;
            }
            case 15: {
                rval = "Procedure is not implemented";
                break;
            }
            case 16: {
                rval = "Volume is reserved";
                break;
            }
            case 17: {
                rval = "Volume is dead";
                break;
            }
            case 18: {
                rval = "Internal target error";
                break;
            }
            case 19: {
                rval = "General configuration request error";
                break;
            }
            case 20: {
                rval = "Inter-controller communications failure";
                break;
            }
            case 21: {
                rval = "Volume not ready, format in progress";
                break;
            }
            case 22: {
                rval = "Request failed because alternate is removed";
                break;
            }
            case 23: {
                rval = "Cache synchronization has failed";
                break;
            }
            case 24: {
                rval = "The download file was invalid";
                break;
            }
            case 25: {
                rval = "Illegal request - legacy constraint";
                break;
            }
            case 26: {
                rval = "Illegal request - resource constraint";
                break;
            }
            case 27: {
                rval = "Unable to read/write NVRAM";
                break;
            }
            case 28: {
                rval = "Failure in flashing the firmware";
                break;
            }
            case 29: {
                rval = "Authentication failed - bad auth parameter";
                break;
            }
            case 30: {
                rval = "Authentication failed - incorrect password";
                break;
            }
            case 31: {
                rval = "Memory parity error on controller";
                break;
            }
            case 32: {
                rval = "Invalid ControllerRef";
                break;
            }
            case 33: {
                rval = "Invalid VolumeGroupRef";
                break;
            }
            case 34: {
                rval = "Invalid VolumeRef";
                break;
            }
            case 35: {
                rval = "Invalid DriveRef";
                break;
            }
            case 36: {
                rval = "Invalid FreeExtentRef";
                break;
            }
            case 37: {
                rval = "Volume is offline";
                break;
            }
            case 38: {
                rval = "Volume is not optimal";
                break;
            }
            case 39: {
                rval = "Internal mode sense failed";
                break;
            }
            case 40: {
                rval = "Segment size was invalid";
                break;
            }
            case 41: {
                rval = "Cache block size was invalid";
                break;
            }
            case 42: {
                rval = "Demand flush threshold was invalid";
                break;
            }
            case 43: {
                rval = "Demand flush amount was invalid";
                break;
            }
            case 44: {
                rval = "Label was invalid";
                break;
            }
            case 45: {
                rval = "Cache flush modifier was invalid";
                break;
            }
            case 46: {
                rval = "Read ahead multiplier was invalid";
                break;
            }
            case 47: {
                rval = "Invalid reconstruction priority";
                break;
            }
            case 48: {
                rval = "Invalid media scan period ";
                break;
            }
            case 49: {
                rval = "Invalid tray position length";
                break;
            }
            case 50: {
                rval = "Invalid region ID";
                break;
            }
            case 51: {
                rval = "Invalid preferred fibre ID";
                break;
            }
            case 52: {
                rval = "Invalid encryption routine";
                break;
            }
            case 53: {
                rval = "Invalid RAID level";
                break;
            }
            case 54: {
                rval = "DriveRefList was too large or too small";
                break;
            }
            case 55: {
                rval = "No hot spares were assigned";
                break;
            }
            case 56: {
                rval = "Not all of the requested spares were assigned";
                break;
            }
            case 57: {
                rval = "Cluster or host label, or host port ID already exists";
                break;
            }
            case 58: {
                rval = "Illegal (empty) label";
                break;
            }
            case 59: {
                rval = "Cluster, host, or host port ref invalid";
                break;
            }
            case 60: {
                rval = "Illegal (empty) host port name";
                break;
            }
            case 61: {
                rval = "Nonexistent volume sent to create mapping";
                break;
            }
            case 62: {
                rval = "Attempt to create mapping on taken LUN";
                break;
            }
            case 63: {
                rval = "Maximum # of mappings per volume already existed";
                break;
            }
            case 64: {
                rval = "Mapping ref invalid";
                break;
            }
            case 65: {
                rval = "Mapping create failed due to no host ports";
                break;
            }
            case 66: {
                rval = "Image was successfully transferred";
                break;
            }
            case 67: {
                rval = "totalSize field was too large";
                break;
            }
            case 68: {
                rval = "offset field was invalid";
                break;
            }
            case 69: {
                rval = "Attempt to overrun buffer";
                break;
            }
            case 70: {
                rval = "chunkSize field was invalid";
                break;
            }
            case 71: {
                rval = "totalSize field was invalid";
                break;
            }
            case 72: {
                rval = "NVRAM says download is not permitted";
                break;
            }
            case 73: {
                rval = "Unable to spawn a task";
                break;
            }
            case 74: {
                rval = "Unable to transfer volumes during firmware download";
                break;
            }
            case 75: {
                rval = "Invalid controller state (i.e. PASSIVE) for download";
                break;
            }
            case 76: {
                rval = "Can't reconfigure cache during firmware download";
                break;
            }
            case 77: {
                rval = "Firmware download is already in progress";
                break;
            }
            case 78: {
                rval = "Drive is not optimal";
                break;
            }
            case 79: {
                rval = "Drive is removed";
                break;
            }
            case 80: {
                rval = "List of drives contains duplicate entries";
                break;
            }
            case 81: {
                rval = "DCE request exceeds limit of additional drives";
                break;
            }
            case 82: {
                rval = "Number of drives specified is not valid for request ";
                break;
            }
            case 83: {
                rval = "The drive specified in the DCE request is too small";
                break;
            }
            case 84: {
                rval = "DRM request requires larger volume capacity";
                break;
            }
            case 85: {
                rval = "Requesting more volumes than the max allowed";
                break;
            }
            case 86: {
                rval = "new Storage Partition mapping request is the UTM lun";
                break;
            }
            case 87: {
                rval = "One or more spares assigned was too small to spare all drives";
                break;
            }
            case 88: {
                rval = "Not all of the requested spares were assigned, but some that were are to small";
                break;
            }
            case 89: {
                rval = "Cannot create a new partition, since storage Partitions are disabled, or there are too many";
                break;
            }
            case 90: {
                rval = "Parity scan is already in progress";
                break;
            }
            case 91: {
                rval = "Invalid SAFE ID";
                break;
            }
            case 92: {
                rval = "Invalid SAFE Key (digest)";
                break;
            }
            case 93: {
                rval = "Unsupported capability code";
                break;
            }
            case 94: {
                rval = "Invalid SAFE version";
                break;
            }
            case 95: {
                rval = "Cannot create an unmapped volume, since storage partitions are disabled";
                break;
            }
            case 96: {
                rval = "A firmware download to a drive failed";
                break;
            }
            case 97: {
                rval = "A firmware download to an IOM card failed";
                break;
            }
            case 98: {
                rval = "Firmware download to tray (IOMs) failed for one IOM, so versions mismatch";
                break;
            }
            case 99: {
                rval = "Existing volume conflicts with attempt to set UTM volume";
                break;
            }
            case 100: {
                rval = "A volume must exist to perform the operation";
                break;
            }
            case 101: {
                rval = "Authentication failed - couldn't read password";
                break;
            }
            case 102: {
                rval = "Unable to create host, port or cluster because a table is full";
                break;
            }
            case 103: {
                rval = "Attempt to modify host type dependent values for regionId 0xF1";
                break;
            }
            case 104: {
                rval = "Host index must be between 0 and (MAX_HOST_TYPES - 1)";
                break;
            }
            case 105: {
                rval = "The volume can be accessed from another mapping already";
                break;
            }
            case 106: {
                rval = "Can't delete the utm lun mapping if the command came on that utm";
                break;
            }
            case 107: {
                rval = "The supplied lun value was out of range";
                break;
            }
            case 108: {
                rval = "The maximum number of utm mappings has been exceeded";
                break;
            }
            case 109: {
                rval = "Runtime Diagnostics read test failed";
                break;
            }
            case 110: {
                rval = "Runtime Diagnostics passed, but source link is down";
                break;
            }
            case 111: {
                rval = "Runtime Diagnostics write test failed";
                break;
            }
            case 112: {
                rval = "Runtime Diagnostics data loopback test failed";
                break;
            }
            case 113: {
                rval = "Runtime Diagnostics request timed out ";
                break;
            }
            case 114: {
                rval = "Runtime Diagnostics already in progress";
                break;
            }
            case 115: {
                rval = "Alternate controller is not available for Runtime Diagnostics";
                break;
            }
            case 116: {
                rval = "Error trying to send Runtime Diagnostics ICON message to alt";
                break;
            }
            case 117: {
                rval = "Error encountered before Runtime Diagnostics issued";
                break;
            }
            case 118: {
                rval = "Mode must be Active/Active to run diagnostics ";
                break;
            }
            case 119: {
                rval = "Invalid test ID for Runtime Diagnostics tests";
                break;
            }
            case 120: {
                rval = "Unable to obtain drive number for Runtime Diagnostics tests";
                break;
            }
            case 121: {
                rval = "Unable to obtain mode select lock";
                break;
            }
            case 122: {
                rval = "Unable to configure diagnostic volume";
                break;
            }
            case 123: {
                rval = "No cache memory is available";
                break;
            }
            case 124: {
                rval = "The controller must be quiesced to run diagnostics";
                break;
            }
            case 125: {
                rval = "UTM must be enabled to run diagnostics";
                break;
            }
            case 126: {
                rval = "Can go Active/Passive Mode with AVT enabled";
                break;
            }
            case 127: {
                rval = "Fibre Channel port name doesn't match that of any host port";
                break;
            }
            case 128: {
                rval = "Duplicate Volume to LUN Mapping to the same partition";
                break;
            }
            case 129: {
                rval = "Exceeded max snapshots per base volume limit";
                break;
            }
            case 130: {
                rval = "Exceeded max snapshots per storage array";
                break;
            }
            case 131: {
                rval = "Cannot create snapshot of this base volume";
                break;
            }
            case 132: {
                rval = "Snapshot is not available (base/repos missing)";
                break;
            }
            case 133: {
                rval = "Snapshot is not disabled (cannot recreate)";
                break;
            }
            case 134: {
                rval = "Snapshot feature is disabled";
                break;
            }
            case 135: {
                rval = "Delete failed because repository offline";
                break;
            }
            case 136: {
                rval = "Delete failed because repository reconfiguring";
                break;
            }
            case 137: {
                rval = "Delete failed because rollback in progress";
                break;
            }
            case 138: {
                rval = "Attempt to exceed max volumes per group";
                break;
            }
            case 139: {
                rval = "interpretVolumeRef returned WWN of Ghost instead of SSID";
                break;
            }
            case 140: {
                rval = "Repository volume has been removed";
                break;
            }
            case 141: {
                rval = "Label specified for repository is invalid";
                break;
            }
            case 142: {
                rval = "Label specified for snapshot is invalid";
                break;
            }
            case 143: {
                rval = "Rollback priority value not between 0 and 4";
                break;
            }
            case 144: {
                rval = "Warning threshold not 0-100";
                break;
            }
            case 145: {
                rval = "Cannot map this volume via SPM";
                break;
            }
            case 146: {
                rval = "Cannot format this volume";
                break;
            }
            case 147: {
                rval = "Destination is not fibre";
                break;
            }
            case 148: {
                rval = "Repository size is less than minimum";
                break;
            }
            case 149: {
                rval = "Repository volume is failed, cannot perform operation";
                break;
            }
            case 150: {
                rval = "Base volume is failed, can't perform operation";
                break;
            }
            case 151: {
                rval = "Base volume offline";
                break;
            }
            case 152: {
                rval = "Base volume is formatting, cannot create snapshot";
                break;
            }
            case 153: {
                rval = "Mirroring MetadataVolume is not present";
                break;
            }
            case 154: {
                rval = "Remote Replication feature is disabled";
                break;
            }
            case 155: {
                rval = "There are Mirrors (Pri. or Sec.) on the array";
                break;
            }
            case 156: {
                rval = "Remote Replication feature is not activated";
                break;
            }
            case 157: {
                rval = "Exceeded max mirrors per storage array";
                break;
            }
            case 158: {
                rval = "Base volume for a potential Mirror was invalid";
                break;
            }
            case 159: {
                rval = "The volume is not a MirrorProxyVolume";
                break;
            }
            case 160: {
                rval = "Specified metadata volume already exists";
                break;
            }
            case 161: {
                rval = "Attempted to delete a metadata volume with missing children";
                break;
            }
            case 162: {
                rval = "Attempted to delete a metadata volume with offline children";
                break;
            }
            case 163: {
                rval = "Attempted to delete a metadata volume with reconfiguring children";
                break;
            }
            case 164: {
                rval = "Local role change failed";
                break;
            }
            case 165: {
                rval = "Remote role change failed";
                break;
            }
            case 166: {
                rval = "Local role change ";
                break;
            }
            case 167: {
                rval = "Only the local Mirror relationship was deleted";
                break;
            }
            case 168: {
                rval = "There are no Mirror Candidates on the array.";
                break;
            }
            case 169: {
                rval = "Max Mirrors exceeded on the remote array";
                break;
            }
            case 170: {
                rval = "Feature is disabled on the remote array";
                break;
            }
            case 171: {
                rval = "Metadata Volume is not present on the remote array";
                break;
            }
            case 172: {
                rval = "Tried to deregister an unregistered metadata client";
                break;
            }
            case 173: {
                rval = "Invalid cfg generation number of the remote array";
                break;
            }
            case 174: {
                rval = "Local Mirror's role changed even though it was not forced";
                break;
            }
            case 175: {
                rval = "Remote Mirror's role changed but the local Mirror's role did not change";
                break;
            }
            case 176: {
                rval = "There was an SPM error";
                break;
            }
            case 177: {
                rval = "Authentication failed on the remote";
                break;
            }
            case 178: {
                rval = "Remote array has different version of remote replication than the local array";
                break;
            }
            case 179: {
                rval = "There was an error on the remote array";
                break;
            }
            case 180: {
                rval = "Transport error between local array and remote array";
                break;
            }
            case 181: {
                rval = "Could not enable/disable host port 2";
                break;
            }
            case 182: {
                rval = "Mirror has to be Primary for start sync cmd";
                break;
            }
            case 183: {
                rval = "Secondary vol is not promote-able";
                break;
            }
            case 184: {
                rval = "Primary vol is not demote-able";
                break;
            }
            case 185: {
                rval = "Cannot delete mirror repository volume directly";
                break;
            }
            case 186: {
                rval = "Remote Volume started the volume deletion process - disallowed";
                break;
            }
            case 187: {
                rval = "The remote replication feature is not allowed on this platform";
                break;
            }
            case 188: {
                rval = "Invalid TrayRef";
                break;
            }
            case 189: {
                rval = "Not all related volumes are deleted";
                break;
            }
            case 190: {
                rval = "Attempted LUN Mapping using the LUN value associated with the default utm mapping";
                break;
            }
            case 191: {
                rval = "Copy priority not between 0 and 4";
                break;
            }
            case 192: {
                rval = "Reference was not to a volume copy";
                break;
            }
            case 193: {
                rval = "Change of copy attributes failed";
                break;
            }
            case 194: {
                rval = "Cannot perform operation on copy because copy is active (in progress, failed or pending)";
                break;
            }
            case 195: {
                rval = "Cannot perform operation on copy because copy is inactive (halted, complete)";
                break;
            }
            case 196: {
                rval = "Source volume not valid";
                break;
            }
            case 197: {
                rval = "Target volume not valid";
                break;
            }
            case 198: {
                rval = "Source volume is missing";
                break;
            }
            case 199: {
                rval = "Target volume is missing";
                break;
            }
            case 200: {
                rval = "Source volume ref was invalid";
                break;
            }
            case 201: {
                rval = "Target volume ref was invalid";
                break;
            }
            case 202: {
                rval = "Source volume was not optimal or degraded";
                break;
            }
            case 203: {
                rval = "Target volume was not optimal";
                break;
            }
            case 204: {
                rval = "Source volume undergoing reconfiguration";
                break;
            }
            case 205: {
                rval = "Target volume undergoing reconfiguration";
                break;
            }
            case 206: {
                rval = "Capacity of target must be greater than or equal to the capacity of source";
                break;
            }
            case 207: {
                rval = "Target volume is already a target in another volume copy";
                break;
            }
            case 208: {
                rval = "Maximum volume copies per array exceeded";
                break;
            }
            case 209: {
                rval = "Source volume has a reservation";
                break;
            }
            case 210: {
                rval = "Target volume has a reservation";
                break;
            }
            case 211: {
                rval = "Source volume formatting";
                break;
            }
            case 212: {
                rval = "Target volume formatting";
                break;
            }
            case 213: {
                rval = "Copy Start Failed";
                break;
            }
            case 214: {
                rval = "Copy Stop Failed";
                break;
            }
            case 215: {
                rval = "Volume Copy feature is disabled";
                break;
            }
            case 216: {
                rval = "Operation not permitted due to volume write lock";
                break;
            }
            case 217: {
                rval = "Cannot reconfigure volume";
                break;
            }
            case 218: {
                rval = "The controller's in lockout mode due to excessive authentication failures";
                break;
            }
            case 219: {
                rval = "Volume has a persistent reservation";
                break;
            }
            case 220: {
                rval = "An attempt to delete persistent reservation registrations failed";
                break;
            }
            case 221: {
                rval = "There is no battery in the configuration";
                break;
            }
            case 222: {
                rval = "Battery is not present";
                break;
            }
            case 223: {
                rval = "The channel has no drives or trays";
                break;
            }
            case 224: {
                rval = "Operation not allowed from Secondary array";
                break;
            }
            case 225: {
                rval = "Attempted DRM to RAID0 on volume group that requires RAID1 or better";
                break;
            }
            case 226: {
                rval = "Source volume's routing device has a capacity of 0";
                break;
            }
            case 227: {
                rval = "Invalid command to define or change LUN mapping due to host-LUN restriction";
                break;
            }
            case 228: {
                rval = "Invalid command to move a LUN mapping due to host-LUN restriction";
                break;
            }
            case 229: {
                rval = "Invalid command to define or change host type due to host-LUN restriction";
                break;
            }
            case 230: {
                rval = "Invalid command to move a host port due to host-LUN restriction";
                break;
            }
            case 231: {
                rval = "Cannot download in-compatible firmware to storage array";
                break;
            }
            case 232: {
                rval = "The mirror has already been suspended";
                break;
            }
            case 233: {
                rval = "The local repository volume needs to be upgraded to the new format";
                break;
            }
            case 234: {
                rval = "The remote repository volume needs to be upgraded to the new format";
                break;
            }
            case 235: {
                rval = "An attempt was made to delete a ghost volume with unreadable sectors";
                break;
            }
            case 236: {
                rval = "Test succeeded with recovered timeouts";
                break;
            }
            case 237: {
                rval = "Test succeeded with delayed responses";
                break;
            }
            case 238: {
                rval = "Test could not start";
                break;
            }
            case 239: {
                rval = "Command to remote volume timed out";
                break;
            }
            case 240: {
                rval = "Channel to remote array/volume is failed";
                break;
            }
            case 241: {
                rval = "The remote replication network could not be accessed";
                break;
            }
            case 242: {
                rval = "Remote volume not found or accessable through the fibre channel link";
                break;
            }
            case 243: {
                rval = "Remote volume not permitting login";
                break;
            }
            case 244: {
                rval = "Remote volume login failed";
                break;
            }
            case 245: {
                rval = "Greater than max allowed sample times requested";
                break;
            }
            case 246: {
                rval = "Quiescence or suspension in progress";
                break;
            }
            case 247: {
                rval = "The volume is not a remote volume";
                break;
            }
            case 248: {
                rval = "Start-of-Day processing is in progress";
                break;
            }
            case 249: {
                rval = "One or more drives in a drive list had an exception";
                break;
            }
            case 250: {
                rval = "A download set identifier was incorrect";
                break;
            }
            case 251: {
                rval = "Number of download sets exceeds max allowed";
                break;
            }
            case 252: {
                rval = "Not all data for all download sets was received";
                break;
            }
            case 253: {
                rval = "Request to Quiesce the system failed";
                break;
            }
            case 254: {
                rval = "File validation failed";
                break;
            }
            case 255: {
                rval = "Drive download halted by user";
                break;
            }
            case 256: {
                rval = "Drive download failed";
                break;
            }
            case 257: {
                rval = "Some drive download failed, some completed";
                break;
            }
            case 258: {
                rval = "Function no longer supported";
                break;
            }
            case 259: {
                rval = "Clearing unreadable sectors failed";
                break;
            }
            case 260: {
                rval = "Invalid command because a controller is in service mode";
                break;
            }
            case 261: {
                rval = "Invalid Drive";
                break;
            }
            case 262: {
                rval = "Dbm database error";
                break;
            }
            case 263: {
                rval = "AutoConfig started as a background task";
                break;
            }
            case 264: {
                rval = "AutoConfig is in progress";
                break;
            }
            case 265: {
                rval = "Unsupported LHA SATA IOM detected";
                break;
            }
            case 266: {
                rval = "Parity scan failed";
                break;
            }
            case 267: {
                rval = "Parity error repair failed";
                break;
            }
            case 268: {
                rval = "Media error repair failed";
            }
        }
        return rval;
    }
}

