/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.common;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.Battery;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ControllerSFP;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.Fan;
import devmgr.versioned.symbol.GhostVolume;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.MetadataVolume;
import devmgr.versioned.symbol.MirrorProxyVolume;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PowerSupply;
import devmgr.versioned.symbol.RemoteVolume;
import devmgr.versioned.symbol.SFPParentTypeData;
import devmgr.versioned.symbol.Sfp;
import devmgr.versioned.symbol.ThermalSensor;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeCopy;
import devmgr.versioned.symbol.VolumeGroup;
import devmgr.versioned.symbol.VolumeGroupRef;
import java.util.LinkedList;

public class NOCList {
    public static final int DEVICE_ID = 1;
    public static final int NAME = 2;
    public static final String DRIVE_NAME = "Drive";
    public static final String DRIVE_TYPE = "drive";
    public static final String SENSOR_NAME = "TempSensor";
    public static final String SENSOR_TYPE = "ts";
    public static final String CONTROLLER_TYPE = "ctrl";
    public static final String ESM_TYPE = "iom";
    public static final String IOM_TYPE = "iom";
    public static final int TRAY = 0;
    public static final int CONTROLLER = 1;
    public static final int DRIVE = 2;
    public static final int BATTERY = 3;
    public static final int FAN = 4;
    public static final int POWER = 5;
    public static final int IOM = 6;
    public static final int SFP = 7;
    public static final int VOLUME = 8;
    public static final int SENSOR = 9;
    public static final int MIRROR_PROXY_VOLUME = 10;
    public static final int GHOST_VOLUME = 11;
    public static final int REMOTE_VOLUME = 12;

    public static String findID(ObjectBundle bundle, int type, byte[] ref) {
        return NOCList.findAlias(bundle, type, ref, 1);
    }

    public static String findName(ObjectBundle bundle, int type, byte[] ref) {
        return NOCList.findAlias(bundle, type, ref, 2);
    }

    public static String findAlias(ObjectBundle bundle, int type, byte[] ref) {
        return NOCList.findAlias(bundle, type, ref, 1);
    }

    public static String findAlias(ObjectBundle bundle, int type, byte[] ref, int version) {
        ComponentBundle components = bundle.getComponentBundle();
        String alias = "<NDF>";
        switch (type) {
            case 3: {
                Battery battery = NOCList.findBattery(bundle, ref);
                if (battery == null) break;
                if (version == 1) {
                    alias = NOCList.createDeviceID("bat", bundle, battery.getPhysicalLocation());
                    break;
                }
                alias = NOCList.createName("Battery", bundle, battery.getPhysicalLocation());
                break;
            }
            case 1: {
                Controller controller = NOCList.findController(bundle, ref);
                if (controller == null) break;
                if (version == 1) {
                    alias = NOCList.createDeviceID(CONTROLLER_TYPE, bundle, controller.getPhysicalLocation());
                    break;
                }
                alias = NOCList.createName("Controller", bundle, controller.getPhysicalLocation());
                break;
            }
            case 2: {
                Drive drive = NOCList.findDrive(bundle, ref);
                if (drive == null) break;
                if (version == 2) {
                    alias = NOCList.createName(DRIVE_NAME, bundle, drive.getPhysicalLocation());
                    break;
                }
                alias = NOCList.createDeviceID(DRIVE_TYPE, bundle, drive.getPhysicalLocation());
                break;
            }
            case 4: {
                Fan fan = NOCList.findFan(bundle, ref);
                if (fan == null) break;
                if (version == 2) {
                    alias = NOCList.createName("Fan", bundle, fan.getPhysicalLocation());
                    break;
                }
                alias = NOCList.createDeviceID("fan", bundle, fan.getPhysicalLocation());
                break;
            }
            case 6: {
                Esm iom = NOCList.findIOM(bundle, ref);
                if (iom == null) break;
                if (version == 2) {
                    alias = NOCList.createName("IOM", bundle, iom.getPhysicalLocation());
                    break;
                }
                alias = NOCList.createDeviceID("iom", bundle, iom.getPhysicalLocation());
                break;
            }
            case 5: {
                PowerSupply powerSupply = NOCList.findPowerSupply(bundle, ref);
                if (powerSupply == null) break;
                if (version == 2) {
                    alias = NOCList.createName("PowerSupply", bundle, powerSupply.getPhysicalLocation());
                    break;
                }
                alias = NOCList.createDeviceID("psm", bundle, powerSupply.getPhysicalLocation());
                break;
            }
            case 9: {
                ThermalSensor ts = NOCList.findTempSensor(bundle, ref);
                if (ts == null) break;
                if (version == 2) {
                    alias = NOCList.createName("TemperatureSensor", bundle, ts.getPhysicalLocation());
                    break;
                }
                alias = NOCList.createDeviceID(SENSOR_TYPE, bundle, ts.getPhysicalLocation());
                break;
            }
            case 0: {
                Tray tray = NOCList.findTray(bundle, ref);
                if (tray == null) break;
                if (version == 2) {
                    alias = "Tray." + tray.getTrayId();
                    break;
                }
                alias = "t" + tray.getTrayId();
                break;
            }
            case 7: {
                Sfp sfp = NOCList.findSfp(bundle, ref);
                if (sfp == null) break;
                SFPParentTypeData parent = sfp.getParentData();
                int ptype = parent.getSfpParentType().getValue();
                String parentID = "unknown";
                String parentName = "unknown";
                String idExtention = "";
                String nameExtention = "";
                if (ptype == 3) {
                    ControllerSFP ctrl = parent.getControllerSFP();
                    int sfpType = ctrl.getControllerSFPType().getValue();
                    parentID = NOCList.findAlias(bundle, 1, ctrl.getParentController().getRefToken(), 1);
                    parentName = NOCList.findAlias(bundle, 1, ctrl.getParentController().getRefToken(), 2);
                    if (sfpType == 2) {
                        int port = sfp.getSfpPort().getValue();
                        nameExtention = ".SFP.Expansion" + port;
                        idExtention = "dssfp" + port;
                    } else if (sfpType == 1) {
                        nameExtention = ".SFP.Host" + ctrl.getChannel();
                        idExtention = "hssfp" + ctrl.getChannel();
                    }
                } else if (ptype == 1) {
                    parentID = NOCList.findAlias(bundle, 6, parent.getParentEsm().getRefToken(), 1);
                    parentName = NOCList.findAlias(bundle, 6, parent.getParentEsm().getRefToken(), 2);
                    nameExtention = ".SFP.Port" + sfp.getSfpPort().getValue();
                    idExtention = "sfp" + sfp.getSfpPort().getValue();
                }
                if (version == 2) {
                    alias = parentName + nameExtention;
                    break;
                }
                alias = parentID + idExtention;
                break;
            }
            case 8: {
                Volume volume = NOCList.findVolume(bundle, ref);
                if (volume == null) break;
                if (version == 2) {
                    alias = Utility.userLabelString(volume.getLabel());
                    break;
                }
                alias = Utility.wwnString(volume.getWorldWideName());
                break;
            }
            case 11: {
                GhostVolume gv = NOCList.findGhostVolume(bundle, ref);
                if (gv == null) break;
                alias = Utility.wwnString(gv.getWorldWideName());
                break;
            }
            case 12: {
                RemoteVolume rv = NOCList.findRemoteVolume(bundle, ref);
                if (rv == null) break;
                alias = Utility.userLabelString(rv.getRemoteVolUserLabel());
            }
        }
        return alias;
    }

    public static Battery findBattery(ObjectBundle bundle, byte[] ref) {
        Battery battery = null;
        Battery[] batteries = bundle.getComponentBundle().getBattery();
        for (int x = 0; x < batteries.length; ++x) {
            if (!Utility.rawCompare(ref, batteries[x].getBatteryRef().getRefToken())) continue;
            battery = batteries[x];
            break;
        }
        return battery;
    }

    public static Controller findController(ObjectBundle bundle, byte[] ref) {
        Controller controller = null;
        Controller[] controllers = bundle.getController();
        for (int x = 0; x < controllers.length; ++x) {
            if (!Utility.rawCompare(ref, controllers[x].getControllerRef().getRefToken())) continue;
            controller = controllers[x];
            break;
        }
        return controller;
    }

    public static Drive findDrive(ObjectBundle bundle, byte[] ref) {
        Drive drive = null;
        Drive[] drives = bundle.getDrive();
        for (int x = 0; x < drives.length; ++x) {
            if (!Utility.rawCompare(ref, drives[x].getDriveRef().getRefToken())) continue;
            drive = drives[x];
            break;
        }
        return drive;
    }

    public static Esm findIOM(ObjectBundle bundle, byte[] ref) {
        Esm iom = null;
        Esm[] ioms = bundle.getComponentBundle().getEsm();
        for (int x = 0; x < ioms.length; ++x) {
            if (!Utility.rawCompare(ref, ioms[x].getEsmRef().getRefToken())) continue;
            iom = ioms[x];
            break;
        }
        return iom;
    }

    public static PowerSupply findPowerSupply(ObjectBundle bundle, byte[] ref) {
        PowerSupply ps = null;
        PowerSupply[] pss = bundle.getComponentBundle().getPowerSupply();
        for (int x = 0; x < pss.length; ++x) {
            if (!Utility.rawCompare(ref, pss[x].getPowerSupplyRef().getRefToken())) continue;
            ps = pss[x];
            break;
        }
        return ps;
    }

    public static Fan findFan(ObjectBundle bundle, byte[] ref) {
        Fan fan = null;
        Fan[] fans = bundle.getComponentBundle().getFan();
        for (int x = 0; x < fans.length; ++x) {
            if (!Utility.rawCompare(ref, fans[x].getFanRef().getRefToken())) continue;
            fan = fans[x];
            break;
        }
        return fan;
    }

    public static Sfp findSfp(ObjectBundle bundle, byte[] ref) {
        Sfp sfp = null;
        Sfp[] sfps = bundle.getComponentBundle().getSfp();
        for (int x = 0; x < sfps.length; ++x) {
            if (!Utility.rawCompare(ref, sfps[x].getSfpRef().getRefToken())) continue;
            sfp = sfps[x];
            break;
        }
        return sfp;
    }

    public static Tray findTray(ObjectBundle bundle, byte[] ref) {
        Tray tray = null;
        Tray[] trays = bundle.getTray();
        for (int x = 0; x < trays.length; ++x) {
            if (!Utility.rawCompare(ref, trays[x].getTrayRef().getRefToken())) continue;
            tray = trays[x];
            break;
        }
        return tray;
    }

    public static ThermalSensor findTempSensor(ObjectBundle bundle, byte[] ref) {
        ThermalSensor sensor = null;
        ThermalSensor[] sensors = bundle.getComponentBundle().getThermalSensor();
        for (int x = 0; x < sensors.length; ++x) {
            if (!Utility.rawCompare(ref, sensors[x].getThermalSensorRef().getRefToken())) continue;
            sensor = sensors[x];
            break;
        }
        return sensor;
    }

    public static Volume findVolume(ObjectBundle bundle, byte[] ref) {
        Volume volume = null;
        Volume[] volumes = bundle.getVolume();
        for (int x = 0; x < volumes.length; ++x) {
            if (!Utility.rawCompare(ref, volumes[x].getVolumeRef().getRefToken())) continue;
            volume = volumes[x];
            break;
        }
        return volume;
    }

    public static VolumeGroup findVolumeGroup(ObjectBundle bundle, byte[] ref) {
        VolumeGroup volumeGroup = null;
        VolumeGroup[] volumeGroups = bundle.getVolumeGroup();
        for (int x = 0; x < volumeGroups.length; ++x) {
            if (!Utility.rawCompare(ref, volumeGroups[x].getVolumeGroupRef().getRefToken())) continue;
            volumeGroup = volumeGroups[x];
            break;
        }
        return volumeGroup;
    }

    public static RemoteVolume findRemoteVolume(ObjectBundle bundle, byte[] ref) {
        RemoteVolume remoteVolume = null;
        RemoteVolume[] rvols = bundle.getHighLevelVolBundle().getRemoteVol();
        for (int x = 0; x < rvols.length; ++x) {
            if (!Utility.rawCompare(ref, rvols[x].getRemoteVolRef().getRefToken())) continue;
            remoteVolume = rvols[x];
            break;
        }
        return remoteVolume;
    }

    public static MetadataVolume findMetadataVolume(ObjectBundle bundle, byte[] ref) {
        MetadataVolume metadataVolume = null;
        MetadataVolume[] mvols = bundle.getHighLevelVolBundle().getMetadataVol();
        for (int x = 0; x < mvols.length; ++x) {
            if (!Utility.rawCompare(ref, mvols[x].getMetadataVolRef().getRefToken())) continue;
            metadataVolume = mvols[x];
            break;
        }
        return metadataVolume;
    }

    public static MirrorProxyVolume findMirrorProxyVolume(ObjectBundle bundle, byte[] ref) {
        MirrorProxyVolume mpVolume = null;
        MirrorProxyVolume[] mpvols = bundle.getHighLevelVolBundle().getMirrorVol();
        for (int x = 0; x < mpvols.length; ++x) {
            if (!Utility.rawCompare(ref, mpvols[x].getMirrorProxyRef().getRefToken())) continue;
            mpVolume = mpvols[x];
            break;
        }
        return mpVolume;
    }

    public static GhostVolume findGhostVolume(ObjectBundle bundle, byte[] ref) {
        GhostVolume ghost = null;
        GhostVolume[] gvols = bundle.getGhostVolBundle().getGhostVol();
        for (int x = 0; x < gvols.length; ++x) {
            if (!Utility.rawCompare(ref, gvols[x].getVolumeRef().getRefToken())) continue;
            ghost = gvols[x];
            break;
        }
        return ghost;
    }

    public static VolumeCopy findVolumeCopy(ObjectBundle bundle, byte[] ref) {
        VolumeCopy copy = null;
        VolumeCopy[] cvols = bundle.getHighLevelVolBundle().getVolumeCopy();
        for (int x = 0; x < cvols.length; ++x) {
            if (!Utility.rawCompare(ref, cvols[x].getVolcopyRef().getRefToken())) continue;
            copy = cvols[x];
            break;
        }
        return copy;
    }

    public static LinkedList findAssociatedVolumes(ObjectBundle bundle, byte[] ref) {
        LinkedList<Volume> assocVolumes = new LinkedList<Volume>();
        Volume[] volumes = bundle.getVolume();
        for (int x = 0; x < volumes.length; ++x) {
            if (!Utility.rawCompare(ref, volumes[x].getVolumeRef().getRefToken())) continue;
            assocVolumes.add(volumes[x]);
        }
        return assocVolumes;
    }

    public static String createDeviceID(String component, ObjectBundle bundle, Location location) {
        String tray = "X";
        String slot = "Y";
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = "X";
                slot = "Y";
            } else if (location == null) {
                slot = "Y";
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = "" + physicalTray.getTrayId();
                slot = "" + location.getSlot();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return "t" + tray + component + slot;
    }

    public static String createName(String component, ObjectBundle bundle, Location location) {
        int tray = -1;
        int slot = -1;
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = -1;
                slot = -1;
            } else if (location == null) {
                slot = -1;
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = physicalTray.getTrayId();
                slot = location.getSlot();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = "Tray." + tray + "." + component + "." + Translator.getSlotName(slot);
        if (DRIVE_NAME.equals(component)) {
            name = "Tray." + tray + "." + component + "." + slot;
        }
        return name;
    }

    public static String findControllerName(ObjectBundle bundle, ControllerRef cref) {
        return NOCList.findControllerIdentifier(bundle, cref, 2);
    }

    public static String findControllerDeviceID(ObjectBundle bundle, ControllerRef cref) {
        return NOCList.findControllerIdentifier(bundle, cref, 1);
    }

    public static String findControllerIdentifier(ObjectBundle bundle, ControllerRef cref, int format) {
        byte[] target = cref.getRefToken();
        String name = "cnf";
        try {
            Controller[] controllers = bundle.getController();
            for (int x = 0; x < controllers.length; ++x) {
                byte[] token = controllers[x].getControllerRef().getRefToken();
                if (!Utility.rawCompare(target, token)) continue;
                name = format == 1 ? NOCList.createDeviceID(CONTROLLER_TYPE, bundle, controllers[x].getPhysicalLocation()) : NOCList.createName("Controller", bundle, controllers[x].getPhysicalLocation());
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    public static String findEsmName(ObjectBundle bundle, ComponentRef cref) {
        return NOCList.findEsmIdentifier(bundle, cref, 2);
    }

    public static String findEsmDeviceID(ObjectBundle bundle, ComponentRef cref) {
        return NOCList.findEsmIdentifier(bundle, cref, 1);
    }

    public static String findEsmIdentifier(ObjectBundle bundle, ComponentRef ref, int format) {
        byte[] target = ref.getRefToken();
        String name = "cnf";
        try {
            Esm[] esms = bundle.getComponentBundle().getEsm();
            for (int x = 0; x < esms.length; ++x) {
                byte[] token = esms[x].getEsmRef().getRefToken();
                if (!Utility.rawCompare(target, token)) continue;
                name = format == 1 ? NOCList.createDeviceID("iom", bundle, esms[x].getPhysicalLocation()) : NOCList.createName("IOM", bundle, esms[x].getPhysicalLocation());
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    public static String findPoolName(ObjectBundle bundle, VolumeGroupRef ref) {
        return NOCList.findPoolIdentifier(bundle, ref, 2);
    }

    public static String findPoolDeviceID(ObjectBundle bundle, VolumeGroupRef ref) {
        return NOCList.findPoolIdentifier(bundle, ref, 1);
    }

    public static String findPoolIdentifier(ObjectBundle bundle, VolumeGroupRef ref, int format) {
        byte[] target = ref.getRefToken();
        String name = "cnf";
        try {
            VolumeGroup[] pools = bundle.getVolumeGroup();
            for (int x = 0; x < pools.length; ++x) {
                byte[] token = pools[x].getVolumeGroupRef().getRefToken();
                if (!Utility.rawCompare(target, token)) continue;
                name = format == 1 ? Utility.wwnString(pools[x].getWorldWideName()) : "vdisk." + pools[x].getSequenceNum();
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    public static String findSfpName(String parentID, ComponentRef ref) {
        return NOCList.findSfpIdentifier(parentID, ref, 2);
    }

    public static String findSfpDeviceID(String parentID, ComponentRef ref) {
        return NOCList.findSfpIdentifier(parentID, ref, 1);
    }

    public static String findSfpIdentifier(String parent, ComponentRef sfpRef, int format) {
        String name = "sfp.unknown";
        try {
            byte[] token = sfpRef.getRefToken();
            name = format == 1 ? parent + ":sfp." + token[10] : parent + ".SFP." + token[10];
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }
}

