/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.common;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.AccessibleController;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DiscoveryResponse;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.net.InetAddress;
import java.util.Vector;

public class ManagementPath {
    private InetAddress m_IPAddress;
    private ControllerDescriptor m_ControllerDescriptor;

    public ManagementPath(InetAddress ipAddr, SAIdentifier arrayID, ControllerRef contRef) {
        this.m_IPAddress = ipAddr;
        this.m_ControllerDescriptor = new ControllerDescriptor();
        this.m_ControllerDescriptor.setSaId(arrayID);
        this.m_ControllerDescriptor.setControllerRef(contRef);
    }

    public InetAddress getIPAddress() {
        return this.m_IPAddress;
    }

    public ControllerDescriptor getControllerDescriptor() {
        return this.m_ControllerDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ManagementPath[] discover(InetAddress[] addresses) {
        SYMbolAPIClientV1 client = null;
        Vector<ManagementPath> paths = new Vector<ManagementPath>();
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress ipAddr = addresses[i];
            client = null;
            client = new SYMbolAPIClientV1(ipAddr, 2463, true);
            DiscoveryResponse response = client.discoverControllers();
            AccessibleController[] allControllers = response.getControllers();
            for (int c = 0; c < allControllers.length; ++c) {
                ControllerRef contRef = allControllers[c].getThisController();
                SAIdentifier arrayId = allControllers[c].getSaId();
                paths.addElement(new ManagementPath(ipAddr, arrayId, contRef));
            }
            Object var12_11 = null;
            if (client == null) continue;
            try {
                client.close();
            }
            catch (Exception closeEx) {}
            continue;
            {
                catch (Exception ex) {
                    System.out.println("Could not open address " + addresses[i].getHostName());
                    var12_11 = null;
                    if (client == null) continue;
                    try {
                        client.close();
                    }
                    catch (Exception closeEx) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var12_11 = null;
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Exception closeEx) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        Object[] result = new ManagementPath[paths.size()];
        paths.copyInto(result);
        return result;
    }

    public static ManagementPath[] filterPaths(ManagementPath[] paths) {
        byte[] wwnToKeep = null;
        Vector<ManagementPath> keepList = new Vector<ManagementPath>();
        for (int i = 0; i < paths.length; ++i) {
            ControllerDescriptor desc = paths[i].getControllerDescriptor();
            if (i == 0) {
                wwnToKeep = desc.getSaId().getWorldWideName();
            }
            if (!Utility.rawCompare(wwnToKeep, desc.getSaId().getWorldWideName())) continue;
            keepList.addElement(paths[i]);
        }
        Object[] result = new ManagementPath[keepList.size()];
        keepList.copyInto(result);
        return result;
    }

    public static ManagementPath[] parseAddresses(String[] addrs, boolean filter) {
        Vector<InetAddress> addrList = new Vector<InetAddress>();
        for (int i = 0; i < addrs.length; ++i) {
            try {
                addrList.addElement(InetAddress.getByName(addrs[i]));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Can't process " + addrs[i] + ": " + ex.toString());
            }
        }
        Object[] addresses = new InetAddress[addrList.size()];
        addrList.copyInto(addresses);
        ManagementPath[] paths = ManagementPath.discover((InetAddress[])addresses);
        if (filter) {
            paths = ManagementPath.filterPaths(paths);
        }
        return paths;
    }
}

