/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.diags.DiagUtility;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.AbstractVolRefList;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumePerformance;
import devmgr.versioned.symbol.VolumePerformanceList;

public class VolumeStatistics {
    static String getData(String ip1, String ip2) {
        StringBuffer data = new StringBuffer();
        SYMbolAPIClientV1 client1 = SYMbolConnection.getOpenConnection(ip1);
        data.append(VolumeStatistics.getVolumeStatistics(client1));
        SYMbolConnection.closeClient(client1);
        SYMbolAPIClientV1 client2 = SYMbolConnection.getOpenConnection(ip2);
        data.append(VolumeStatistics.getVolumeStatistics(client2));
        SYMbolConnection.closeClient(client2);
        return data.toString();
    }

    private static String getVolumeStatistics(SYMbolAPIClientV1 client) {
        StringBuffer data = new StringBuffer();
        try {
            client.setTimeout(new ProcedureTimeout().getProcTimeout(40));
            ObjectBundle bundle = client.getObjectGraph();
            Controller[] controllers = bundle.getController();
            int slot = 0;
            for (int i = 0; i < controllers.length; ++i) {
                if (!DiagUtility.bindToController(client, controllers[i].getControllerRef())) continue;
                slot = controllers[i].getPhysicalLocation().getSlot();
            }
            data.append("Controller in slot " + Translator.getSlotName(slot) + "\n");
            Volume[] volumes = bundle.getVolume();
            AbstractVolRef[] volRefArray = new AbstractVolRef[volumes.length];
            for (int x = 0; x < volumes.length; ++x) {
                volRefArray[x] = volumes[x].getVolumeRef();
            }
            AbstractVolRefList refList = new AbstractVolRefList();
            refList.setAbstractVolRef(volRefArray);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(44));
            VolumePerformanceList perfList = client.getVolumePerformance(refList);
            VolumePerformance[] perfArray = perfList.getVolumePerf();
            String header = "volume, Time, Total Requests Serviced, Total Blocks Requested, Total Read Requests, Total Read Blocks Requested, Total Write Requests, Total Write Blocks Requested, Total Percent Read Requests, Total Average Blocks Requested, Total Large Reads, Total Large Read Blocks Requested, Total Large Writes, Total Large Write Blocks Requested, Total Cache Read Checks, Total Cache Read Check Hits, Total Cache Write Requests\n";
            data.append(header);
            int dataProcessed = 0;
            for (int i = 0; i < perfArray.length; ++i) {
                if (perfArray[i].getTime() <= 0L) continue;
                ++dataProcessed;
                String name = null;
                for (int y = 0; y < volumes.length; ++y) {
                    if (!Utility.rawCompare(perfArray[i].getVolumeRef().getRefToken(), volumes[y].getVolumeRef().getRefToken())) continue;
                    name = Utility.userLabelString(volumes[y].getLabel());
                    break;
                }
                if (name != null) {
                    data.append(name);
                } else {
                    data.append(Utility.bytesArrayString(perfArray[i].getVolumeRef().getRefToken()));
                }
                data.append(", ");
                data.append(Utility.convertDate(perfArray[i].getTime()));
                data.append(", ");
                data.append(perfArray[i].getTotalRequestsServiced());
                data.append(", ");
                data.append(perfArray[i].getTotalBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalReadRequests());
                data.append(", ");
                data.append(perfArray[i].getTotalReadBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalWriteRequests());
                data.append(", ");
                data.append(perfArray[i].getTotalWriteBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getPercentReadRequests());
                data.append(", ");
                data.append(perfArray[i].getAverageBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalLargeReads());
                data.append(", ");
                data.append(perfArray[i].getTotalLargeReadBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalLargeWrites());
                data.append(", ");
                data.append(perfArray[i].getTotalLargeWriteBlocksRequested());
                data.append(", ");
                data.append(perfArray[i].getTotalCacheReadChecks());
                data.append(", ");
                data.append(perfArray[i].getTotalCacheReadCheckHits());
                data.append(", ");
                data.append(perfArray[i].getTotalCacheWriteRequests());
                data.append("\n");
            }
            if (dataProcessed == 0) {
                data.append("No Performance data to gather\n");
            }
        }
        catch (Exception e) {
            data.append(e.toString() + "\n");
        }
        return data.toString();
    }
}

