/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.ArrayProfile;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.DriveLogCollector;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.MELLog;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.NVSRAMCollector;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.ObjectBundleCollector;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.PersistentRegistrations;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.ReadLinkStatus;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.StateCapture;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.UnreadableSectors;
import com.sun.netstorage.fm.storade.device.storage.treefrog.collector.VolumeStatistics;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SupportDataCollector {
    private static final int STORAGE_ARRAY_PROFILE = 0;
    private static final int MAJOR_EVENT_LOG = 1;
    private static final int READ_LINK_STATUS = 2;
    private static final int NVSRAM = 3;
    private static final int PERFORMANCE_STATISTICS = 4;
    private static final int PERSISTENT_REGISTRATIONS = 5;
    private static final int BAD_BLOCKS = 6;
    private static final int STATE_CAPTURE = 7;
    private static final int DRIVE_LOG_DATA = 8;
    private static final int OBJECT_BUNDLE = 9;
    private static final String[] ITEM_FILENAMES = new String[]{"storageArrayProfile.txt", "majorEventLog.txt", "readLinkStatus.csv", "NVSRAMdata.txt", "performanceStatistics.csv", "persistentReservations.txt", "badBlocksData.txt", "stateCaptureData.dmp", "driveDiagnosticData.bin", "objectBundle"};
    private static final int IO_BUFFER_BYTE_SIZE = 1024;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String STATUS_SUCCESS = "Success";
    private static final String STATUS_COMPLETE_WITH_ERRORS = "Completed with errors";
    private static final String STATUS_ZIP_ERROR = "Complete but ZIP operation failed";
    private static final String STATUS_ERROR = "Error";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String collectSupportData(Properties props, String path, String zipfileName) {
        String rval;
        SYMbolAPIClientV1 client2;
        SYMbolAPIClientV1 client;
        block26: {
            String string;
            block25: {
                client = null;
                client2 = null;
                rval = STATUS_SUCCESS;
                boolean errorFlag = false;
                try {
                    String zipStatus;
                    File baseDir;
                    if (zipfileName.indexOf(".zip") < 0) {
                        zipfileName = zipfileName + ".zip";
                    }
                    if (!(baseDir = new File(path)).exists()) {
                        String string2 = "ERROR: The directory " + baseDir.getPath() + " does not exist";
                        return string2;
                    }
                    if (!baseDir.canWrite()) {
                        String string3 = "ERROR: Unable to write to the directory " + baseDir.getPath();
                        return string3;
                    }
                    File zipFile = new File(path, zipfileName);
                    if (zipFile.exists() && !zipFile.canWrite()) {
                        String string4 = "ERROR: The file " + zipFile.getPath() + " already exists, and cannot be overwritten (check permissions)";
                        return string4;
                    }
                    File tempPath = File.createTempFile("TEMP_DATA", ".tmp", zipFile.getParentFile());
                    if (tempPath.exists()) {
                        tempPath.delete();
                    }
                    tempPath.mkdir();
                    String tempPathName = tempPath.getCanonicalPath();
                    String ip1 = props.getProperty("ipno");
                    String ip2 = props.getProperty("altipno");
                    String ipUsed = ip1;
                    String altIP = ip2;
                    client = SYMbolConnection.getOpenConnection(ip1);
                    if (client == null) {
                        ipUsed = ip2;
                        altIP = ip1;
                        client = SYMbolConnection.getOpenConnection(ip2);
                    }
                    if (client == null) {
                        string = rval = "ERROR: Could not connect to " + ip1 + " or " + ip2;
                        SYMbolConnection.closeClient(client);
                        break block25;
                    }
                    String profile = ArrayProfile.getData(client);
                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[0], profile);
                    SYMbolConnection.closeClient(client);
                    String melData = MELLog.getData(ipUsed);
                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[1], melData);
                    String rlsData = ReadLinkStatus.getData(ipUsed);
                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[2], rlsData);
                    String persistentReg = PersistentRegistrations.getData(ipUsed);
                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[5], persistentReg);
                    String badBlocks = UnreadableSectors.getData(ipUsed);
                    SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[6], badBlocks);
                    DriveLogCollector.getData(ipUsed, tempPathName, ITEM_FILENAMES[8]);
                    ObjectBundleCollector.getData(ipUsed, tempPathName, ITEM_FILENAMES[9]);
                    DeviceProperties devProps = new DeviceProperties(props);
                    String password = devProps.getPassword();
                    if (password == null) {
                        password = "";
                    }
                    try {
                        String stateCapture = StateCapture.getData(ipUsed, altIP, password);
                        SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[7], stateCapture);
                    }
                    catch (Exception sce) {
                        SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[7], sce.toString() + " ip1:" + ip1 + " ip2:" + ip2);
                        errorFlag = true;
                    }
                    try {
                        String nvsramData = NVSRAMCollector.getData(ipUsed, altIP);
                        SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[3], nvsramData);
                    }
                    catch (Exception nve) {
                        SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[3], nve.toString() + " ip1:" + ip1 + " ip2:" + ip2);
                        errorFlag = true;
                    }
                    try {
                        String volumePerformance = VolumeStatistics.getData(ipUsed, altIP);
                        SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[4], volumePerformance);
                    }
                    catch (Exception vpe) {
                        SupportDataCollector.writeFile(tempPathName, ITEM_FILENAMES[4], vpe.toString() + " ip1:" + ip1 + " ip2:" + ip2);
                        errorFlag = true;
                    }
                    if (errorFlag) {
                        rval = STATUS_COMPLETE_WITH_ERRORS;
                    }
                    if (!(zipStatus = SupportDataCollector.createZipFile(tempPathName, zipFile)).equals(STATUS_SUCCESS)) {
                        rval = zipStatus;
                    }
                    SupportDataCollector.cleanup(tempPathName, tempPath);
                    SYMbolConnection.closeClient(client);
                    break block26;
                }
                catch (Exception e) {
                    rval = "ERROR:\n" + e.toString();
                    e.printStackTrace();
                    return rval;
                }
            }
            SYMbolConnection.closeClient(client2);
            return string;
        }
        SYMbolConnection.closeClient(client2);
        return rval;
        finally {
            SYMbolConnection.closeClient(client);
            SYMbolConnection.closeClient(client2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generateExtractFiles(Properties props, String path) {
        String rval;
        SYMbolAPIClientV1 client2;
        SYMbolAPIClientV1 client;
        block22: {
            String string;
            block21: {
                client = null;
                client2 = null;
                rval = STATUS_SUCCESS;
                try {
                    File targetDir = new File(path);
                    if (!targetDir.exists() && !targetDir.mkdir()) {
                        String string2 = "ERROR: Could not create the directory " + targetDir.getPath();
                        return string2;
                    }
                    if (!targetDir.canWrite()) {
                        String string3 = "ERROR: Unable to write to the directory " + targetDir.getPath();
                        return string3;
                    }
                    String targetPathName = targetDir.getCanonicalPath();
                    String ip1 = props.getProperty("ipno");
                    String ip2 = props.getProperty("altipno");
                    String ipUsed = ip1;
                    String altIP = ip2;
                    client = SYMbolConnection.getOpenConnection(ip1);
                    if (client == null) {
                        ipUsed = ip2;
                        altIP = ip1;
                        client = SYMbolConnection.getOpenConnection(ip2);
                    }
                    if (client == null) {
                        string = rval = "ERROR: Could not connect to " + ip1 + " or " + ip2;
                        SYMbolConnection.closeClient(client);
                        break block21;
                    }
                    String profile = ArrayProfile.getData(client);
                    SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[0], profile);
                    SYMbolConnection.closeClient(client);
                    String melData = MELLog.getData(ipUsed);
                    SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[1], melData);
                    String rlsData = ReadLinkStatus.getData(ipUsed);
                    SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[2], rlsData);
                    String persistentReg = PersistentRegistrations.getData(ipUsed);
                    SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[5], persistentReg);
                    String badBlocks = UnreadableSectors.getData(ipUsed);
                    SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[6], badBlocks);
                    DriveLogCollector.getData(ipUsed, targetPathName, ITEM_FILENAMES[8]);
                    ObjectBundleCollector.getData(ipUsed, targetPathName, ITEM_FILENAMES[9]);
                    DeviceProperties devProps = new DeviceProperties(props);
                    String password = devProps.getPassword();
                    if (password == null) {
                        password = "";
                    }
                    try {
                        String stateCapture = StateCapture.getData(ipUsed, altIP, password);
                        SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[7], stateCapture);
                    }
                    catch (Exception sce) {
                        SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[7], sce.toString());
                    }
                    try {
                        String nvsramData = NVSRAMCollector.getData(ipUsed, altIP);
                        SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[3], nvsramData);
                    }
                    catch (Exception nve) {
                        SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[3], nve.toString());
                    }
                    try {
                        String volumePerformance = VolumeStatistics.getData(ipUsed, altIP);
                        SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[4], volumePerformance);
                    }
                    catch (Exception vpe) {
                        SupportDataCollector.writeFile(targetPathName, ITEM_FILENAMES[4], vpe.toString());
                    }
                    SYMbolConnection.closeClient(client);
                    break block22;
                }
                catch (Exception e) {
                    StackTraceElement[] ste = e.getStackTrace();
                    StringBuffer sb = new StringBuffer();
                    int z = 0;
                    while (true) {
                        if (z >= ste.length) {
                            rval = sb.toString();
                            return rval;
                        }
                        sb.append(ste[z].toString() + "\n");
                        ++z;
                    }
                }
            }
            SYMbolConnection.closeClient(client2);
            return string;
        }
        SYMbolConnection.closeClient(client2);
        return rval;
        finally {
            SYMbolConnection.closeClient(client);
            SYMbolConnection.closeClient(client2);
        }
    }

    static boolean writeFile(String path, String filename, String data) {
        FileWriter outFileWriter = null;
        PrintWriter printWriter = null;
        File outFile = new File(path, filename);
        if (outFile.exists()) {
            outFile.delete();
        }
        try {
            outFileWriter = new FileWriter(outFile.getAbsolutePath(), true);
            printWriter = new PrintWriter((Writer)new BufferedWriter(outFileWriter), true);
            printWriter.println(data);
        }
        catch (Exception e) {
            return false;
        }
        try {
            outFileWriter.close();
        }
        catch (IOException ioException) {
            return false;
        }
        return true;
    }

    private static String createZipFile(String tempPathName, File zipFile) {
        ZipOutputStream zipOutStream = null;
        byte[] buffer = new byte[1024];
        int length = 0;
        String rval = STATUS_SUCCESS;
        try {
            FileOutputStream outStream = new FileOutputStream(zipFile);
            zipOutStream = new ZipOutputStream(outStream);
        }
        catch (IOException e) {
            rval = "Complete but ZIP operation failed\n" + e.toString();
        }
        for (int i = 0; i < ITEM_FILENAMES.length; ++i) {
            File oneFile = new File(tempPathName, ITEM_FILENAMES[i]);
            if (!oneFile.exists() || !oneFile.isFile() || !oneFile.canRead()) continue;
            try {
                FileInputStream fileInStream = new FileInputStream(oneFile);
                ZipEntry zipEntry = new ZipEntry(ITEM_FILENAMES[i]);
                zipEntry.setSize(oneFile.length());
                zipEntry.setTime(oneFile.lastModified());
                zipOutStream.putNextEntry(zipEntry);
                while ((length = fileInStream.read(buffer)) > -1) {
                    zipOutStream.write(buffer, 0, length);
                }
                zipOutStream.closeEntry();
                fileInStream.close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (zipOutStream != null) {
            try {
                zipOutStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return rval;
    }

    private static void cleanup(String tempPathName, File tempPath) {
        File oneFile = null;
        for (int i = 0; i < ITEM_FILENAMES.length; ++i) {
            oneFile = new File(tempPathName, ITEM_FILENAMES[i]);
            if (!oneFile.exists() || !oneFile.isFile()) continue;
            try {
                oneFile.delete();
                continue;
            }
            catch (Exception e) {
                System.out.println("Deletion of " + ITEM_FILENAMES[i] + " was not allowed");
            }
        }
        if (tempPath != null) {
            try {
                tempPath.delete();
            }
            catch (Exception e) {
                System.out.println("Deletion of the temp directory was not allowed");
            }
        }
        if (new File(".", tempPathName).exists()) {
            new File(".", tempPath.getName()).delete();
        }
    }
}

