/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog.collector;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.device.storage.treefrog.eventlog.DecodeMEL;
import com.sun.netstorage.fm.storade.device.storage.treefrog.eventlog.EventLog;
import devmgr.versioned.symbol.ComponentLocation;
import devmgr.versioned.symbol.MelEntry;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.util.HashMap;

public class MELLog {
    static String getData(String ip) {
        String data = "No MEL data collected";
        SYMbolAPIClientV1 client = SYMbolConnection.getOpenConnection(ip);
        data = client != null ? MELLog.collectData(client) : "Null RPC connection to array";
        SYMbolConnection.closeClient(client);
        return data;
    }

    private static String collectData(SYMbolAPIClientV1 client) {
        StringBuffer data = new StringBuffer();
        try {
            EventLog log = new EventLog();
            MelEntry[] entries = log.getMELEntries(client, 0L);
            if (entries.length == 0) {
                data.append("No MEL Log entries found");
            } else {
                DecodeMEL melDecoder = new DecodeMEL();
                HashMap descriptions = melDecoder.getMELMap();
                for (int x = 0; x < entries.length; ++x) {
                    data.append(MELLog.decodeEntry(entries[x], descriptions));
                }
            }
        }
        catch (Exception e) {
            data.append("\nError accessing Major Event Log\n" + e.toString());
        }
        return data.toString();
    }

    static String decodeEntry(MelEntry entry, HashMap descriptions) {
        StringBuffer data = new StringBuffer();
        try {
            data.append("Date/Time: " + Utility.convertDate(entry.getTimeStamp()) + "\n");
            data.append("Sequence number: " + entry.getSequenceNumber() + "\n");
            data.append("Event type: " + Integer.toHexString(entry.getEventType()).toUpperCase() + "\n");
            data.append("Event category: " + Translator.niceEventCategory(entry.getCategory()) + "\n");
            data.append("Priority: " + Translator.translateEventPriority(entry.getPriority()) + "\n");
            String text = "Description unknown";
            Integer eventCode = new Integer(entry.getEventType());
            if (descriptions.containsKey(eventCode)) {
                DecodeMEL.EntryData eData = (DecodeMEL.EntryData)descriptions.get(eventCode);
                text = eData.getDescription();
            }
            data.append("Description: " + text + "\n");
            String sense = Integer.toHexString(entry.getSenseKey());
            String ASC = Integer.toHexString(entry.getASC());
            String ASCQ = Integer.toHexString(entry.getASCQ());
            String escString = sense + "/" + ASC + "/" + ASCQ;
            data.append("Event specific codes: " + escString + "\n");
            data.append("Component type: " + DecodeMEL.getTypeName(entry.getComponentType()) + " \n");
            int type = entry.getComponentType().getValue();
            String locString = "None";
            if (entry.getLocationValid()) {
                ComponentLocation cloc = entry.getComponentLocation();
                locString = DecodeMEL.getComponentLocation(type, cloc);
            }
            data.append("Component location: " + locString + " \n");
            int controller = entry.getEventSourceController();
            String source = "unspecified";
            if (controller == 1) {
                source = "A";
            } else if (controller == 2) {
                source = "B";
            }
            data.append("Logged by: Controller in slot " + source + "\n\n");
            data.append("Raw data:\n\n");
            data.append(MELLog.dumpRawData(entry.getRawData()));
        }
        catch (Exception e) {
            data.append("\nError parsing MelEntry\n" + e.toString());
        }
        data.append("\n\n");
        return data.toString();
    }

    private static String dumpRawData(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        int begin = 0;
        int length = 0;
        int end = 0;
        do {
            if (begin + (length = 16) > data.length) {
                length = data.length - begin;
            }
            end = begin + length;
            buffer.append(Utility.hexBytes(data, begin, end) + "\n");
        } while ((begin += length) < data.length);
        return buffer.toString();
    }
}

