/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.ReportUtilities;
import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.Treefrog_Array;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.resource.report.ErrorReportClass;
import com.sun.netstorage.fm.storade.resource.report.ReportClass;
import com.sun.netstorage.fm.storade.resource.report.ReportGenerator;
import com.sun.netstorage.fm.util.Options;
import devmgr.versioned.symbol.Battery;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.ControllerSFP;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.ESMInterfaceTypeData;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.EthernetInterface;
import devmgr.versioned.symbol.Fan;
import devmgr.versioned.symbol.FibreInterface;
import devmgr.versioned.symbol.FreeExtent;
import devmgr.versioned.symbol.HLVolumeBundle;
import devmgr.versioned.symbol.IOInterfaceTypeData;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.MirrorProxyVolume;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PhysicalDriveType;
import devmgr.versioned.symbol.PhysicalDriveTypeData;
import devmgr.versioned.symbol.Port;
import devmgr.versioned.symbol.PowerSupply;
import devmgr.versioned.symbol.PremiumFeature;
import devmgr.versioned.symbol.RLSCount;
import devmgr.versioned.symbol.RLSData;
import devmgr.versioned.symbol.RLSResults;
import devmgr.versioned.symbol.RemoteVolume;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SFPParentTypeData;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.SataDriveAttributes;
import devmgr.versioned.symbol.ScsiToAtaTranslatorData;
import devmgr.versioned.symbol.Sfp;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.ThermalSensor;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeGroup;
import devmgr.versioned.symbol.VolumeRef;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.StringTokenizer;

public class TreefrogReport
implements ReportGenerator,
Treefrog_Array {
    protected String arrayType;
    protected static boolean debug = false;

    public ReportClass generateReport(Properties p, String content) {
        SYMbolAPIClientV1[] client = new SYMbolAPIClientV1[1];
        ObjectBundle objectBundle = null;
        try {
            this.arrayType = p.getProperty("type");
            try {
                objectBundle = this.getConnection(p, client);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message.equals("Missing data") || message.equals("No contact")) {
                    return this.generateErrorReport(p, message);
                }
                return this.generateErrorReport(p, e);
            }
            ReportClass system = this.buildReport(client[0], objectBundle, p);
            return system;
        }
        catch (Exception e) {
            SYMbolConnection.closeClient(client[0]);
            return this.generateErrorReport(p, e);
        }
    }

    private ReportClass buildReport(SYMbolAPIClientV1 client, ObjectBundle objectBundle, Properties props) throws Exception {
        int x;
        ComponentBundle components = objectBundle.getComponentBundle();
        ReportClass system = new ReportClass("system");
        this.createSystem(system, objectBundle, props);
        Controller[] controllers = objectBundle.getController();
        for (int x2 = 0; x2 < controllers.length; ++x2) {
            this.createController(system, controllers[x2], objectBundle, client);
            IOInterfaceTypeData[] hostPorts = controllers[x2].getHostInterfaces();
            for (int port = 0; port < hostPorts.length; ++port) {
                this.createPort(system, hostPorts[port], objectBundle, controllers[x2], port, "Host");
            }
        }
        SYMbolConnection.closeClient(client);
        int temp = -1;
        boolean slotsOK = true;
        Battery[] batteries = objectBundle.getComponentBundle().getBattery();
        try {
            for (x = 0; x < batteries.length; ++x) {
                Location location = batteries[x].getPhysicalLocation();
                int slot = location.getSlot();
                if (slot == temp) {
                    slotsOK = false;
                }
                temp = slot;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (slotsOK) {
            for (x = 0; x < batteries.length; ++x) {
                this.createBattery(system, batteries[x], objectBundle);
            }
        } else {
            for (x = 0; x < controllers.length; ++x) {
                this.createControllerBattery(system, controllers[x], objectBundle);
            }
        }
        Drive[] drives = objectBundle.getDrive();
        for (int x3 = 0; x3 < drives.length; ++x3) {
            this.createDrive(system, drives[x3], objectBundle);
        }
        VolumeGroup[] groups = objectBundle.getVolumeGroup();
        for (int x4 = 0; x4 < groups.length; ++x4) {
            this.createStoragePool(system, groups[x4], objectBundle);
        }
        Volume[] volumes = objectBundle.getVolume();
        for (int x5 = 0; x5 < volumes.length; ++x5) {
            this.createVolume(system, volumes[x5], objectBundle);
        }
        Esm[] esms = components.getEsm();
        for (int x6 = 0; x6 < esms.length; ++x6) {
            this.createESM(system, esms[x6], objectBundle);
        }
        Tray[] trays = objectBundle.getTray();
        for (int x7 = 0; x7 < trays.length; ++x7) {
            this.createMidplane(system, trays[x7], x7, objectBundle, esms);
        }
        Sfp[] sfps = components.getSfp();
        for (int x8 = 0; x8 < sfps.length; ++x8) {
            this.createSFP(system, sfps[x8], objectBundle);
        }
        Fan[] fans = components.getFan();
        for (int x9 = 0; x9 < fans.length; ++x9) {
            this.createFan(system, fans[x9], objectBundle);
        }
        PowerSupply[] power = components.getPowerSupply();
        for (int x10 = 0; x10 < power.length; ++x10) {
            this.createPowerSupply(system, power[x10], objectBundle);
        }
        ThermalSensor[] ts = components.getThermalSensor();
        for (int x11 = 0; x11 < ts.length; ++x11) {
            this.createTempSensor(system, ts[x11], objectBundle);
        }
        this.createLicences(system, objectBundle);
        return system;
    }

    protected ReportClass generateErrorReport(Properties p, String errorID) {
        ErrorReportClass rc = new ErrorReportClass("rc");
        rc.setProperty("error", errorID);
        rc.setProperty(ErrorReportClass.COMM_TYPE, ErrorReportClass.OO_BAND);
        if ("Missing data".equals(errorID)) {
            rc.setProperty("_Type", "3");
        } else if ("No contact".equals(errorID)) {
            rc.setProperty("_Type", "1");
        }
        return rc;
    }

    protected ReportClass generateErrorReport(Properties p, Exception e) {
        ErrorReportClass rc = new ErrorReportClass("rc");
        rc.setProperty("error", e.toString());
        rc.setProperty(ErrorReportClass.COMM_TYPE, ErrorReportClass.OO_BAND);
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        try {
            out.write("Unable to create report due to " + e.toString());
        }
        catch (Exception e2) {
            // empty catch block
        }
        rc.setProperty("_Trace", sw.toString());
        rc.setProperty("_Type", "0");
        return rc;
    }

    protected ObjectBundle getConnection(Properties p, SYMbolAPIClientV1[] clientArray) throws Exception {
        SYMbolAPIClientV1 client = clientArray[0];
        String connectionStatus = "Connected";
        ObjectBundle objectBundle = null;
        ComponentBundle components = null;
        for (int i = 0; i <= 2; ++i) {
            client = SYMbolConnection.getOpenConnection(p);
            if (client != null) {
                objectBundle = SYMbolConnection.getObjectBundle(client);
                if (objectBundle == null) {
                    SYMbolConnection.closeClient(client);
                    connectionStatus = "Missing data";
                    continue;
                }
                components = objectBundle.getComponentBundle();
                if (components == null) {
                    SYMbolConnection.closeClient(client);
                    connectionStatus = "Missing data";
                    continue;
                }
                if (this.hasRequiredObjects(objectBundle, components)) break;
                SYMbolConnection.closeClient(client);
                connectionStatus = "Missing data";
                continue;
            }
            connectionStatus = "No contact";
        }
        if (!connectionStatus.equals("Connected")) {
            throw new Exception(connectionStatus);
        }
        clientArray[0] = client;
        return objectBundle;
    }

    protected boolean hasRequiredObjects(ObjectBundle obundle, ComponentBundle cbundle) {
        boolean rval = true;
        Controller[] controllers = obundle.getController();
        Drive[] drives = obundle.getDrive();
        Tray[] trays = obundle.getTray();
        Fan[] fans = cbundle.getFan();
        PowerSupply[] power = cbundle.getPowerSupply();
        try {
            if (controllers.length == 0 || drives.length == 0 || trays.length == 0 || fans.length == 0 || power.length == 0) {
                rval = false;
            }
            for (int x = 0; x < power.length; ++x) {
                int status;
                PowerSupply ps = power[x];
                String serialNumber = ps.getSerialNumber();
                if (serialNumber != null && !serialNumber.equals("") || (status = ps.getStatus().getValue()) == 3) continue;
                rval = false;
                break;
            }
        }
        catch (Exception e) {
            rval = false;
        }
        return rval;
    }

    protected void createSystem(ReportClass system, ObjectBundle bundle, Properties props) {
        try {
            StorageArray stArray = bundle.getSa();
            SAData array = bundle.getSa().getSaData();
            byte[] wwn = array.getSaId().getWorldWideName();
            byte[] firmware = array.getFwVersion();
            String nvsram = array.getNvsramVersion();
            boolean needsAttention = array.getNeedsAttention();
            String arrayName = Utility.userLabelString(array.getStorageArrayLabel());
            system.setKey(this.getKey(bundle));
            system.setStringProperty("_Name", arrayName);
            system.setStringProperty("_Dedicated", "Storage");
            system.setStringProperty("_NameFormat", "Other");
            system.setStringProperty("_PrimaryOwnerName", "");
            system.setStringProperty("_PrimaryOwnerContact", "");
            system.setStringProperty("_Roles", "Unknown");
            system.setStringProperty("_IdentifyingNumber", this.getSerialNumber(bundle));
            system.setStringProperty("_Vendor", "Sun Microsystems");
            system.setStringProperty("_Version", Utility.bytesToDecimalString(firmware));
            system.setStringProperty("_SKUNumber", "");
            system.setStringProperty("_SysBootDelay", "");
            system.setStringProperty("nvsram", nvsram);
            system.setStringProperty("needsAttention", "" + needsAttention);
            Controller[] controllers = bundle.getController();
            NetInterfaceTypeData[] net = controllers[0].getNetInterfaces();
            EthernetInterface enet = net[0].getEthernet();
            int ip = enet.getIp();
            system.setStringProperty("_IPAddress", Utility.convertIpAddr(ip));
            system.setStringProperty("_MacAddress", Utility.bytesToString(enet.getMacAddr()));
            system.setStringProperty("featureEnableId", Utility.bytesArrayString(stArray.getSafeId().getWorldWideName()));
            system.setStringProperty(ReportClass.COMM_TYPE, ReportClass.OO_BAND);
            String storedName = props.getProperty("name");
            if (arrayName != null && !arrayName.equals("")) {
                if (storedName != null) {
                    if (!arrayName.equals(storedName)) {
                        props.setProperty("name", arrayName);
                    }
                } else {
                    props.setProperty("name", arrayName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            system.setStringProperty("system", "Error creating the system");
        }
    }

    protected String getKey(ObjectBundle bundle) {
        String vendor = "SUN";
        String partNum = "";
        String serialNum = "";
        if (bundle != null) {
            int x;
            Tray[] trays = bundle.getTray();
            for (x = 0; x < trays.length && trays[x].getNumControllerSlots() <= 0; ++x) {
            }
            if (x >= trays.length) {
                x = 0;
            }
            partNum = ReportUtilities.stripHeader(trays[x].getPartNumber());
            serialNum = ReportUtilities.stripHeader(trays[x].getSerialNumber());
        }
        String key = vendor + "." + partNum + "." + serialNum;
        return key.trim();
    }

    protected String getSerialNumber(ObjectBundle bundle) {
        String serialNumber = "";
        try {
            if (bundle != null) {
                int x;
                Tray[] trays = bundle.getTray();
                for (x = 0; x < trays.length && trays[x].getNumControllerSlots() <= 0; ++x) {
                }
                if (x >= trays.length) {
                    x = 0;
                }
                serialNumber = ReportUtilities.stripHeader(trays[x].getSerialNumber(), "SN");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serialNumber.trim();
    }

    protected void createController(ReportClass system, Controller controller, ObjectBundle bundle, SYMbolAPIClientV1 client) {
        ReportClass repClass = system.newSubInstance("ctrl");
        try {
            Location location = controller.getPhysicalLocation();
            String name = ReportUtilities.createName("Controller", bundle, location);
            String deviceID = ReportUtilities.createDeviceID("ctrl", bundle, location);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "RaidController");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("_FirmwareVersion", "" + controller.getAppVersion());
            repClass.setStringProperty("active", "" + controller.getActive());
            repClass.setStringProperty("cacheSize", "" + controller.getCacheMemorySize() + " MB");
            repClass.setStringProperty("cpuMemorySize", "" + controller.getProcessorMemorySize() + " MB");
            repClass.setStringProperty("_Description", "RAID Controller");
            String boardID = controller.getBoardID();
            if (boardID != null) {
                if ((boardID = boardID.trim()).equals("2882")) {
                    repClass.setStringProperty("_Description", "FC RAID Controller");
                } else if (boardID.equals("2822")) {
                    repClass.setStringProperty("_Description", "SATA RAID Controller");
                } else if (boardID.equals("3994")) {
                    repClass.setStringProperty("_Description", "2 GB RAID Controller");
                } else if (boardID.equals("3992")) {
                    repClass.setStringProperty("_Description", "1 GB RAID Controller");
                }
            }
            repClass.setStringProperty("boardID", boardID);
            String status = Translator.translateControllerStatus(controller.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            NetInterfaceTypeData[] net = controller.getNetInterfaces();
            for (int x = 0; x < net.length; ++x) {
                EthernetInterface enet = net[x].getEthernet();
                if (enet.getChannel() != 1) continue;
                repClass.setStringProperty("ethernetAlias", enet.getAlias());
                repClass.setStringProperty("ethernetChannel", "" + enet.getChannel());
                int gwip = enet.getGatewayIp();
                repClass.setStringProperty("ethernetGatewayIp", Utility.convertIpAddr(gwip));
                repClass.setStringProperty("ethernetInterfaceName", enet.getInterfaceName());
                int ip = enet.getIp();
                String ipNum = Utility.convertIpAddr(ip);
                repClass.setStringProperty("ethernetIP", ipNum);
                repClass.setStringProperty("ethernetRloginEnabled", "" + enet.getRloginEnabled());
                int speed = enet.getSpeed();
                if (speed >= 0) {
                    repClass.setStringProperty("ethernetSpeed", "" + speed + " Mbit/sec");
                } else {
                    repClass.setStringProperty("ethernetSpeed", "N/A");
                }
                repClass.setStringProperty("ethernetSubnetMask", Utility.convertIpAddr(enet.getSubnetMask()));
                repClass.setStringProperty("ethernetBootpUsed", "" + enet.getBootpUsed());
                repClass.setStringProperty("ethernetMACAddress", Utility.bytesToString(enet.getMacAddr()));
                String enetStatus = "Down";
                if (SYMbolConnection.matchController(client, controller.getControllerRef())) {
                    enetStatus = "Up";
                } else if (SYMbolConnection.serverIsResponding(ipNum)) {
                    enetStatus = "Up";
                }
                repClass.setStringProperty("ethernetStatus", enetStatus);
            }
            if (controller.getStatus().getValue() != 3) {
                String key = ReportUtilities.createKey(controller.getManufacturer(), controller.getBoardID(), controller.getSerialNumber().trim());
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "Controller");
                fru.setStringProperty("_Model", controller.getProductRevLevel());
                fru.setStringProperty("_Firmware", controller.getBootVersion());
                fru.setStringProperty("_Vendor", controller.getManufacturer());
                fru.setStringProperty("_SerialNumber", controller.getSerialNumber().trim());
                fru.setStringProperty("_FruNumber", controller.getSerialNumber().trim());
                fru.setStringProperty("IdentifyingNumber", controller.getSerialNumber().trim());
                fru.setStringProperty("ManufactureDate", Utility.convertDate(controller.getManufacturerDate()));
                fru.setStringProperty("productID", controller.getProductID().trim());
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing controller data");
            e.printStackTrace();
        }
    }

    protected void createControllerDriveSidePorts(ReportClass parent, String parentID, String parentName, IOInterfaceTypeData[] driveSidePorts) {
        try {
            for (int i = 0; i < driveSidePorts.length; ++i) {
                FibreInterface fibre = driveSidePorts[i].getFibre();
                ReportClass repClass = parent.newSubInstance("fcport");
                int channel = fibre.getChannel();
                String portID = parentID + "lp" + channel;
                String portName = parentName + ".LoopPort." + channel;
                repClass.setKey(portID);
                repClass.setStringProperty("_DeviceID", portID);
                repClass.setStringProperty("_Caption", "FibrePort");
                repClass.setStringProperty("_Description", "Driveside (Internal Loop) Fibre Port");
                repClass.setStringProperty("_ElementName", portName);
                repClass.setStringProperty("_Name", portName);
                repClass.setStringProperty("channel", "" + channel);
                repClass.setStringProperty("wwn", Utility.wwnString(fibre.getPortName()));
                String status = Translator.translateLinkStatus(fibre.getLinkStatus().getValue());
                repClass.setStringProperty("_RawStatus", status);
                repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
                repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
                repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void createInternalPort(ReportClass parent, String parentID, String parentName, byte[] ref, RLSResults rlsResults, int type) {
        RLSData[] rlsData = null;
        switch (type) {
            case 1: {
                rlsData = rlsResults.getControllers();
                break;
            }
            case 2: {
                rlsData = rlsResults.getDrives();
                break;
            }
            case 3: {
                rlsData = rlsResults.getEsms();
                break;
            }
            default: {
                return;
            }
        }
        int index = 1;
        for (int x = 0; x < rlsData.length; ++x) {
            byte[] refToken = null;
            if (type == 1) {
                refToken = rlsData[x].getDevice().getController().getRefToken();
            } else if (type == 3) {
                refToken = rlsData[x].getDevice().getEsm().getRefToken();
            } else if (type == 2) {
                refToken = rlsData[x].getDevice().getDrive().getRefToken();
            }
            if (!Utility.rawCompare(ref, refToken)) continue;
            try {
                ReportClass repClass = parent.newSubInstance("fcport");
                String portID = parentID + "lp" + index;
                String portName = parentName + ".LoopPort." + index;
                repClass.setKey(portID);
                repClass.setStringProperty("_DeviceID", portID);
                repClass.setStringProperty("_Caption", "FibrePort");
                repClass.setStringProperty("_Description", "Internal Loop Fibre Port");
                repClass.setStringProperty("_ElementName", portName);
                repClass.setStringProperty("_Name", portName);
                int channel = rlsData[x].getChannel();
                repClass.setStringProperty("channel", "" + channel);
                RLSCount count = rlsData[x].getRlsCount();
                repClass.setStringProperty("_CRCErrors", "" + count.getInvalidCRCCount());
                repClass.setStringProperty("_InvalidTransmissionWords", "" + count.getInvalidXmitWord());
                repClass.setStringProperty("_LinkFailures", "" + count.getLinkFailureCount());
                repClass.setStringProperty("_LossOfSignalCounter", "" + count.getLossOfSignalCount());
                repClass.setStringProperty("_LossOfSyncCounter", "" + count.getLossOfSyncCount());
                repClass.setStringProperty("_PrimitiveSequenceProtocolErrCount", "" + count.getPrimSeqProtocolErr());
                ++index;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void createDrive(ReportClass system, Drive drive, ObjectBundle bundle) {
        try {
            Location location = drive.getPhysicalLocation();
            Tray tray = Utility.findTray(bundle, location.getTrayRef());
            if (tray == null) {
                return;
            }
            ReportClass repClass = system.newSubInstance("disk");
            String name = ReportUtilities.createName("Drive", bundle, location);
            String deviceID = ReportUtilities.createDeviceID("drive", bundle, location);
            String driveType = Translator.translatePhysicalDriveType(drive.getPhyDriveType());
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "DiskDrive");
            repClass.setStringProperty("_Description", driveType + " Disk Drive");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            String status = Translator.translateDriveStatus(drive.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            repClass.setStringProperty("blockSize", "" + drive.getBlkSize() + " bytes");
            repClass.setStringProperty("driveType", driveType);
            repClass.setStringProperty("statusCause", Translator.translateDriveStatusCause(drive.getCause().getValue()));
            repClass.setStringProperty("available", "" + drive.getAvailable());
            repClass.setStringProperty("offline", "" + drive.getOffline());
            repClass.setStringProperty("pfa", "" + drive.getPfa());
            repClass.setStringProperty("speed", Translator.translateSpeed(drive.getCurrentSpeed()));
            repClass.setStringProperty("maxSpeed", Translator.translateSpeed(drive.getMaxSpeed()));
            int spindleSpeed = drive.getSpindleSpeed();
            if (spindleSpeed > 0) {
                repClass.setStringProperty("spindleSpeed", Integer.toString(spindleSpeed) + " rpm");
            } else {
                repClass.setStringProperty("spindleSpeed", "unknown");
            }
            long rawCapacity = drive.getRawCapacity();
            repClass.setStringProperty("rawCapacity", this.normalizeCapacity(rawCapacity));
            long usableCapacity = drive.getUsableCapacity();
            repClass.setStringProperty("_Capacity", this.normalizeCapacity(usableCapacity));
            repClass.setStringProperty("hasDegradedChannel", "" + drive.getHasDegradedChannel());
            StringBuffer clist = new StringBuffer();
            int[] channels = drive.getDegradedChannels();
            for (int x = 0; x < channels.length; ++x) {
                if (clist.length() > 0) {
                    clist.append(", ");
                }
                clist.append("\"" + channels[x] + "\"");
            }
            if (clist.length() == 0) {
                clist.append("N/A");
            }
            repClass.setStringProperty("degradedChannels", clist.toString());
            repClass.setStringProperty("hotSpare", "" + drive.getHotSpare());
            repClass.setStringProperty("invalidDriveData", "" + drive.getInvalidDriveData());
            repClass.setStringProperty("uncertified", "" + drive.getUncertified());
            repClass.setStringProperty("wwn", Utility.wwnString(drive.getWorldWideName()));
            int vdiskIdx = drive.getVolumeGroupIndex();
            if (vdiskIdx > -1) {
                repClass.setStringProperty("vdiskAssignment", ReportUtilities.findPoolName(bundle, drive.getCurrentVolumeGroupRef()));
            } else {
                repClass.setStringProperty("vdiskAssignment", "Unassigned");
            }
            String driveFirmware = drive.getSoftwareVersion();
            boolean isSata = false;
            String ipid = "";
            String irev = "";
            String ivnd = "";
            PhysicalDriveTypeData pdtd = drive.getPhyDriveTypeData();
            PhysicalDriveType pdt = pdtd.getPhyDriveType();
            if (pdt.getValue() == 3) {
                isSata = true;
                SataDriveAttributes sataAttributes = pdtd.getSataDriveAttributes();
                if (sataAttributes != null) {
                    driveFirmware = sataAttributes.getAtaDiskFwRevision();
                    ScsiToAtaTranslatorData interposer = sataAttributes.getTranslatorData();
                    if (interposer != null) {
                        ipid = interposer.getProductId();
                    }
                    if (ipid != null) {
                        ipid = ipid.trim();
                    }
                    if ((ivnd = interposer.getVendorId()) != null) {
                        ivnd = ivnd.trim();
                    }
                    irev = (irev = interposer.getProductRevLevel()) != null ? irev.trim() : "<NDF>";
                    driveFirmware = irev + "-" + driveFirmware;
                }
            }
            repClass.setStringProperty("firmware", driveFirmware);
            if (drive.getStatus().getValue() != 6 && drive.getStatus().getValue() != 4) {
                StringTokenizer tokens;
                String manufacturer = ReportUtilities.stripHeader(drive.getManufacturer(), "VN");
                String model = ReportUtilities.stripHeader(drive.getProductID(), "PN");
                String serialNumber = ReportUtilities.stripHeader(drive.getSerialNumber(), "SN");
                if (drive.getPhyDriveType().getValue() == 3 && model != null && (tokens = new StringTokenizer(model)).countTokens() == 3) {
                    manufacturer = tokens.nextToken();
                    model = tokens.nextToken();
                }
                String key = ReportUtilities.createKey(manufacturer, model, serialNumber);
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "Disk");
                fru.setStringProperty("_Model", model);
                fru.setStringProperty("_Firmware", driveFirmware);
                fru.setStringProperty("_Vendor", manufacturer);
                fru.setStringProperty("_SerialNumber", serialNumber);
                fru.setStringProperty("_FruNumber", serialNumber);
                fru.setStringProperty("IdentifyingNumber", serialNumber);
                fru.setStringProperty("ManufactureDate", Utility.convertDate(drive.getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
                if (isSata) {
                    fru.setStringProperty("interposerPID", ipid);
                    fru.setStringProperty("interposerREV", irev);
                    fru.setStringProperty("interposerVND", ivnd);
                }
            }
            if (drive.getStatus().getValue() == 6) {
                repClass.setStringProperty("firmware", "N/A");
                repClass.setStringProperty("wwn", "N/A");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void createMidplane(ReportClass system, Tray tray, int index, ObjectBundle bundle, Esm[] esms) {
        ReportClass repClass = system.newSubInstance("midplane");
        try {
            String name = "Tray." + tray.getTrayId() + ".Midplane";
            String deviceID = "t" + tray.getTrayId() + "mpn";
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "Midplane");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            boolean speedMismatch = tray.getDrvMHSpeedMismatch();
            boolean esmMiswire = tray.getEsmMiswire();
            boolean esmMismatch = tray.getEsmVersionMismatch();
            boolean idConflict = tray.getTrayIDConflict();
            boolean idMismatch = tray.getTrayIDMismatch();
            boolean unsupported = tray.getUnsupportedTray();
            String status = "Optimal";
            if (speedMismatch || esmMiswire || esmMismatch || idConflict || idMismatch || unsupported) {
                status = "Error";
            }
            String partNumber = ReportUtilities.stripHeader(tray.getPartNumber(), "PN");
            String serialNumber = ReportUtilities.stripHeader(tray.getSerialNumber(), "SN");
            if (partNumber.equals("") && serialNumber.equals("")) {
                status = "Removed";
            }
            if (tray.getNumControllerSlots() > 0) {
                repClass.setStringProperty("_Description", "Common RAID Module midplane");
            } else {
                repClass.setStringProperty("_Description", "Common Expansion Module midplane");
                if (!ReportUtilities.usableTrayIOM(bundle, tray.getTrayId(), esms)) {
                    status = "No Contact";
                }
            }
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            repClass.setStringProperty("driveSpeedMismatch", Utility.convertBoolean(speedMismatch));
            repClass.setStringProperty("iomMiswire", Utility.convertBoolean(esmMiswire));
            repClass.setStringProperty("iomVersionMismatch", Utility.convertBoolean(esmMismatch));
            repClass.setStringProperty("trayIDConflict", Utility.convertBoolean(idConflict));
            repClass.setStringProperty("trayIDMismatch", Utility.convertBoolean(idMismatch));
            repClass.setStringProperty("unsupportedTray", Utility.convertBoolean(unsupported));
            repClass.setStringProperty("maxSpeed", Translator.translateSpeed(tray.getMaxSpeed().getValue()));
            repClass.setStringProperty("numControllerSlots", "" + tray.getNumControllerSlots());
            repClass.setStringProperty("numDriveSlots", "" + tray.getNumDriveSlots());
            boolean redundantAccess = !tray.getNonRedundantAccess();
            repClass.setStringProperty("redundantAccess", "" + redundantAccess);
            if (redundantAccess) {
                repClass.setStringProperty("workingChannel", "N/A (Channels are redundant)");
            } else {
                repClass.setStringProperty("workingChannel", "" + tray.getWorkingChannel());
            }
            String vendor = ReportUtilities.stripHeader(tray.getVendorName(), "VN");
            String key = ReportUtilities.createKey(vendor, partNumber, serialNumber) + ".mpn";
            if (!status.equals("Removed")) {
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "Midplane");
                fru.setStringProperty("_Model", partNumber);
                fru.setStringProperty("_Firmware", "N/A");
                fru.setStringProperty("_Vendor", vendor);
                fru.setStringProperty("_SerialNumber", serialNumber);
                fru.setStringProperty("_FruNumber", serialNumber);
                fru.setStringProperty("IdentifyingNumber", serialNumber);
                fru.setStringProperty("PartNumber", partNumber);
                fru.setStringProperty("ManufactureDate", Utility.convertDate(tray.getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "false");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing midplane data");
            e.printStackTrace();
        }
    }

    protected void createESM(ReportClass system, Esm esm, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("iom");
        try {
            Location location = esm.getPhysicalLocation();
            String name = ReportUtilities.createName("IOM", bundle, location);
            String deviceID = ReportUtilities.createDeviceID("iom", bundle, location);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "IOM");
            repClass.setStringProperty("_Description", "I/O Module");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            int currSpeed = esm.getCurrentSpeed().getValue();
            int maxSpeed = esm.getMaxSpeed().getValue();
            String rawType = esm.getFruType();
            String type = "Unspecified";
            if (rawType != null) {
                if (rawType.indexOf("SATA") > -1) {
                    type = "SATA";
                } else if (rawType.indexOf("SBOD") > -1) {
                    type = "SBOD";
                }
            }
            repClass.setStringProperty("type", type);
            repClass.setStringProperty("currentSpeed", Translator.translateSpeed(currSpeed));
            repClass.setStringProperty("maxSpeed", Translator.translateSpeed(maxSpeed));
            boolean redundantAccess = !esm.getNonRedundantAccess();
            repClass.setStringProperty("redundantAccess", "" + redundantAccess);
            if (redundantAccess) {
                repClass.setStringProperty("workingChannel", "N/A (Channels are redundant)");
            } else {
                repClass.setStringProperty("workingChannel", "" + esm.getWorkingChannel());
            }
            repClass.setStringProperty("softwareVersion", esm.getSoftwareVersion());
            String status = Translator.translateESMStatus(esm.getStatus().getValue());
            String partNumber = ReportUtilities.stripHeader(esm.getPartNumber(), "PN");
            String serialNumber = ReportUtilities.stripHeader(esm.getSerialNumber(), "SN");
            if (partNumber.equals("") && serialNumber.equals("")) {
                status = "Removed";
            }
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            ESMInterfaceTypeData ifData = esm.getEsmInterfaceData();
            repClass.setStringProperty("interfaceType", Translator.translateEsmIFType(ifData.getIoInterfaceType()));
            Port[] ports = esm.getEsmInterfaceData().getPortList().getPorts();
            for (int i = 0; i < ports.length; ++i) {
                int bypassStatus = ports[i].getPortStatus().getValue();
                int portType = ports[i].getPortType().getValue();
                repClass.setStringProperty("port" + i + ".status", "" + bypassStatus);
                repClass.setStringProperty("port" + i + ".type", "" + portType);
            }
            if (!status.equals("Removed")) {
                String key = ReportUtilities.createKey("SUN", partNumber, serialNumber);
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "IOM");
                fru.setStringProperty("_Model", ReportUtilities.stripHeader(esm.getPartNumber(), "PN"));
                fru.setStringProperty("_Firmware", esm.getSoftwareVersion());
                fru.setStringProperty("_Vendor", esm.getManufacturer().trim());
                fru.setStringProperty("_SerialNumber", serialNumber);
                fru.setStringProperty("_FruNumber", serialNumber);
                fru.setStringProperty("IdentifyingNumber", serialNumber);
                fru.setStringProperty("ProductID", ReportUtilities.stripHeader(esm.getProductID()));
                fru.setStringProperty("ManufactureDate", Utility.convertDate(esm.getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing esm data");
        }
    }

    protected void createSFP(ReportClass system, Sfp sfp, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("sfp");
        try {
            Location location = sfp.getPhysicalLocation();
            repClass.setStringProperty("_Caption", "SFP");
            repClass.setStringProperty("_Description", "Small Form Pluggable");
            String parentID = "unknown";
            String parentName = "unknown";
            String nameExtention = null;
            String idExtention = null;
            SFPParentTypeData parent = sfp.getParentData();
            int ptype = parent.getSfpParentType().getValue();
            if (ptype == 3) {
                repClass.setStringProperty("parentType", "Controller");
                ControllerSFP controller = parent.getControllerSFP();
                parentID = ReportUtilities.findControllerDeviceID(bundle, controller.getParentController());
                parentName = ReportUtilities.findControllerName(bundle, controller.getParentController());
                repClass.setStringProperty("parent", parentID);
                repClass.setStringProperty("channel", "" + controller.getChannel());
                int type = controller.getControllerSFPType().getValue();
                if (type == 2) {
                    repClass.setStringProperty("type", "DriveSide");
                    int port = sfp.getSfpPort().getValue();
                    nameExtention = ".SFP.Expansion" + port;
                    idExtention = "dssfp" + port;
                } else if (type == 1) {
                    repClass.setStringProperty("type", "HostSide");
                    nameExtention = ".SFP.Host" + controller.getChannel();
                    idExtention = "hssfp" + controller.getChannel();
                }
            } else if (ptype == 1) {
                parentID = ReportUtilities.findEsmDeviceID(bundle, parent.getParentEsm());
                parentName = ReportUtilities.findEsmName(bundle, parent.getParentEsm());
                repClass.setStringProperty("parentType", "IOM");
                repClass.setStringProperty("parent", parentID);
                int port = sfp.getSfpPort().getValue();
                String portStr = Integer.toString(port);
                if ("6140".equals(this.arrayType)) {
                    portStr = ReportUtilities.mapWhitneyIOMPorts(port);
                }
                nameExtention = ".SFP.Port" + portStr;
                idExtention = "sfp" + port;
            } else if (ptype == 2) {
                parentName = parentID = "minihub:" + Utility.bytesArrayString(parent.getParentMinihub().getRefToken());
                repClass.setStringProperty("parentType", "Minihub");
                repClass.setStringProperty("minihubRef", Utility.bytesArrayString(parent.getParentMinihub().getRefToken()));
            }
            String name = null;
            String deviceID = null;
            if (nameExtention == null) {
                name = ReportUtilities.findSfpName(parentName, sfp.getSfpRef());
                deviceID = ReportUtilities.findSfpDeviceID(parentID, sfp.getSfpRef());
            } else {
                name = parentName + nameExtention;
                deviceID = parentID + idExtention;
            }
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("port", "" + sfp.getSfpPort().getValue());
            repClass.setStringProperty("connectType", Translator.translateSfpConnectType(sfp.getSfpType().getSfpConnectType()));
            repClass.setStringProperty("identType", Translator.translateSfpIdentType(sfp.getSfpType().getSfpIdentType()));
            repClass.setStringProperty("linkType", Translator.translateSfpLinkType(sfp.getSfpType().getSfpLinkLType()));
            repClass.setStringProperty("speed", Translator.translateSfpSpeed(sfp.getSfpType().getSfpSpeed()));
            repClass.setStringProperty("transmissionMedia", Translator.translateSfpXmitMedia(sfp.getSfpType().getSfpTransmissionMedia()));
            repClass.setStringProperty("transmitterType", Translator.translateSfpXmitType(sfp.getSfpType().getSfpTransmitterType()));
            repClass.setStringProperty("OUI", Utility.bytesArrayString(sfp.getSfpType().getVendorOUI()));
            String status = Translator.translateSfpStatus(sfp.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            if (sfp.getStatus().getValue() != 3 && sfp.getStatus().getValue() != 4) {
                String key = ReportUtilities.createKey(sfp.getSfpType().getVendorName(), sfp.getSfpType().getVendorPN(), sfp.getSfpType().getVendorSN());
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "SFP");
                fru.setStringProperty("_Model", sfp.getSfpType().getVendorPN().trim());
                fru.setStringProperty("_Firmware", "N/A");
                fru.setStringProperty("_Vendor", sfp.getSfpType().getVendorName().trim());
                fru.setStringProperty("_SerialNumber", sfp.getSfpType().getVendorSN().trim(), "");
                fru.setStringProperty("_FruNumber", sfp.getSfpType().getVendorSN().trim());
                fru.setStringProperty("IdentifyingNumber", sfp.getSfpType().getVendorSN().trim());
                fru.setStringProperty("PartNumber", sfp.getSfpType().getVendorPN().trim());
                fru.setStringProperty("ManufactureDate", Utility.convertDate(sfp.getSfpType().getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing sfp data");
        }
    }

    protected void createFan(ReportClass system, Fan fan, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("fan");
        try {
            Location location = fan.getPhysicalLocation();
            byte[] refToken = fan.getFanRef().getRefToken();
            String name = ReportUtilities.createName("Fan", bundle, location);
            String deviceID = ReportUtilities.createDeviceID("fan", bundle, location);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "Fan");
            repClass.setStringProperty("_Description", "Fan");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            String status = Translator.translateFanStatus(fan.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing fan data");
        }
    }

    protected void createPowerSupply(ReportClass system, PowerSupply powerSupply, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("pcu");
        try {
            Location location = powerSupply.getPhysicalLocation();
            byte[] refToken = powerSupply.getPowerSupplyRef().getRefToken();
            String deviceID = ReportUtilities.createDeviceID("psm", bundle, location);
            String name = ReportUtilities.createName("PowerSupply", bundle, location);
            if (("6140".equals(this.arrayType) || "csm200".equals(this.arrayType)) && !ReportUtilities.inControllerTray(bundle, location)) {
                name = ReportUtilities.createName("PowerSupply", bundle, location, true);
            }
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "PowerSupply");
            repClass.setStringProperty("_Description", "Power Supply Module");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("fruType", powerSupply.getFruType());
            String status = Translator.translatePowerSupplyStatus(powerSupply.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            String partNumber = ReportUtilities.stripHeader(powerSupply.getPartNumber(), "PN");
            String serialNumber = ReportUtilities.stripHeader(powerSupply.getSerialNumber(), "SN");
            boolean assetDataExists = true;
            if (partNumber.equals("") && serialNumber.equals("")) {
                assetDataExists = false;
            }
            if (powerSupply.getStatus().getValue() != 3 && assetDataExists) {
                String key = ReportUtilities.createKey(powerSupply.getVendorName(), partNumber, serialNumber);
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "Power Supply");
                fru.setStringProperty("_Vendor", powerSupply.getVendorName());
                fru.setStringProperty("_Model", partNumber);
                fru.setStringProperty("_Firmware", "N/A");
                fru.setStringProperty("_SerialNumber", serialNumber);
                fru.setStringProperty("_FruNumber", serialNumber);
                fru.setStringProperty("IdentifyingNumber", serialNumber);
                fru.setStringProperty("PartNumber", partNumber);
                fru.setStringProperty("ManufactureDate", Utility.convertDate(powerSupply.getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing power supply data");
        }
    }

    protected void createTempSensor(ReportClass system, ThermalSensor sensor, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("tempsensor");
        try {
            Location location = sensor.getPhysicalLocation();
            byte[] ref = sensor.getThermalSensorRef().getRefToken();
            String name = ReportUtilities.createName("TempSensor", bundle, location, ref);
            String deviceID = ReportUtilities.createDeviceID("ts", bundle, location, ref);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "TemperatureSensor");
            repClass.setStringProperty("_Description", "Temperature Sensor (Non Numeric)");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            String status = Translator.translateTempStatus(sensor.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing temp sensor data");
        }
    }

    protected void createBattery(ReportClass system, Battery battery, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("battery");
        try {
            Location location = battery.getPhysicalLocation();
            byte[] ref = battery.getBatteryRef().getRefToken();
            String name = ReportUtilities.createName("Battery", bundle, location);
            String deviceID = ReportUtilities.createDeviceID("bat", bundle, location);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "CacheBattery");
            repClass.setStringProperty("_Description", "Cache Battery");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("type", Translator.translateBatteryType(battery.getBatteryTypeData().getBatteryType()));
            String age = "" + battery.getBatteryAge() + " Days";
            String remaining = "" + battery.getBatteryLifeRemaining() + " Days";
            int statusValue = battery.getStatus().getValue();
            if (statusValue == 5 || statusValue == 6) {
                age = "N/A";
                remaining = "N/A";
            }
            repClass.setStringProperty("batteryAge", age);
            repClass.setStringProperty("lifeRemaining", remaining);
            String status = Translator.translateBatteryStatus(battery.getStatus());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            if (statusValue != 5 && statusValue != 6) {
                String key = ReportUtilities.createKey(battery.getVendorName(), battery.getVendorPN(), battery.getVendorSN());
                repClass.setStringProperty("_Realized", key);
                ReportClass fru = system.newSubInstance("fru");
                fru.setKey(key);
                fru.setStringProperty("_Name", key);
                fru.setStringProperty("_Type", "Battery");
                fru.setStringProperty("_Model", battery.getVendorPN().trim());
                fru.setStringProperty("_Firmware", "N/A");
                String serialNumber = ReportUtilities.stripHeader(battery.getVendorSN(), "SN");
                String vendor = ReportUtilities.stripHeader(battery.getVendorName(), "VN");
                String partNum = ReportUtilities.stripHeader(battery.getVendorPN(), "PN");
                fru.setStringProperty("_Vendor", vendor);
                fru.setStringProperty("_SerialNumber", serialNumber, "");
                fru.setStringProperty("_FruNumber", serialNumber);
                fru.setStringProperty("IdentifyingNumber", serialNumber);
                fru.setStringProperty("PartNumber", partNum);
                fru.setStringProperty("ManufactureDate", Utility.convertDate(battery.getManufacturerDate()));
                fru.setStringProperty("CanBeFRUed", "true");
                fru.setStringProperty("CustomerReplaceable", "true");
            }
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing battery data");
        }
    }

    protected void createControllerBattery(ReportClass system, Controller controller, ObjectBundle bundle) {
        try {
            Location location = controller.getPhysicalLocation();
            String controllerName = ReportUtilities.createName("Controller", bundle, location);
            String controllerID = ReportUtilities.createDeviceID("ctrl", bundle, location);
            ComponentBundle components = bundle.getComponentBundle();
            ControllerRef cref = controller.getControllerRef();
            Battery[] batteries = components.getBattery();
            boolean batteryFound = false;
            for (int x = 0; x < batteries.length; ++x) {
                ControllerRef pref = batteries[x].getBatteryTypeData().getParentController();
                if (!Utility.rawCompare(cref.getRefToken(), pref.getRefToken())) continue;
                batteryFound = true;
                this.defineControllerBattery(system, batteries[x], bundle);
                break;
            }
            if (!batteryFound) {
                this.createDefaultBattery(system, controllerID, controllerName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void defineControllerBattery(ReportClass system, Battery battery, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("battery");
        try {
            Location location = battery.getPhysicalLocation();
            byte[] ref = battery.getBatteryRef().getRefToken();
            ControllerRef cref = battery.getBatteryTypeData().getParentController();
            String parentID = ReportUtilities.findControllerDeviceID(bundle, cref);
            String parentName = ReportUtilities.findControllerName(bundle, cref);
            String name = parentName + ".Battery";
            String deviceID = parentID + "bat";
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "CacheBattery");
            repClass.setStringProperty("_Description", "Cache Battery");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("batteryAge", "" + battery.getBatteryAge() + " Days");
            repClass.setStringProperty("lifeRemaining", "" + battery.getBatteryLifeRemaining() + " Days");
            repClass.setStringProperty("type", Translator.translateBatteryType(battery.getBatteryTypeData().getBatteryType()));
            repClass.setStringProperty("parentController", parentName);
            String status = Translator.translateBatteryStatus(battery.getStatus());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing battery data");
        }
    }

    protected void createDefaultBattery(ReportClass system, String parentID, String parentName) {
        ReportClass repClass = system.newSubInstance("battery");
        try {
            String name = parentName + ".Battery";
            String deviceID = parentID + "bat";
            repClass.setKey(deviceID);
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setStringProperty("_Caption", "CacheBattery");
            repClass.setStringProperty("_Description", "Cache Battery");
            repClass.setStringProperty("_ElementName", name);
            repClass.setStringProperty("_Name", name);
            repClass.setStringProperty("batteryAge", "Data Unavailable");
            repClass.setStringProperty("lifeRemaining", "Data Unavailable");
            repClass.setStringProperty("type", "Data Unavailable");
            repClass.setStringProperty("parentController", parentName);
            String status = "Unknown";
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing battery data");
        }
    }

    protected void createStoragePool(ReportClass system, VolumeGroup volumeGroup, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("vdisk");
        try {
            boolean online;
            String deviceID = Utility.wwnString(volumeGroup.getWorldWideName());
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_Caption", "Vdisk");
            repClass.setStringProperty("_Description", "Logical concatenation of disk drives");
            repClass.setStringProperty("_ElementName", "vdisk." + volumeGroup.getSequenceNum());
            repClass.setStringProperty("_Name", "vdisk." + volumeGroup.getSequenceNum());
            repClass.setStringProperty("offline", "" + volumeGroup.getOffline());
            repClass.setStringProperty("WWN", Utility.wwnString(volumeGroup.getWorldWideName()));
            repClass.setStringProperty("_RaidLevel", Translator.translateRaidLevel(volumeGroup.getRaidLevel().getValue()));
            repClass.setStringProperty("_Operation", "none");
            repClass.setStringProperty("sequenceNum", "" + volumeGroup.getSequenceNum());
            StringBuffer diskSet = new StringBuffer();
            StringBuffer basis = new StringBuffer();
            byte[] vgRef = volumeGroup.getVolumeGroupRef().getRefToken();
            Drive[] drives = bundle.getDrive();
            double poolCapacity = 0.0;
            for (int x = 0; x < drives.length; ++x) {
                byte[] driveVGRef = drives[x].getCurrentVolumeGroupRef().getRefToken();
                if (!Utility.rawCompare(vgRef, driveVGRef)) continue;
                Location location = drives[x].getPhysicalLocation();
                Tray tray = Utility.findTray(bundle, location.getTrayRef());
                String diskKey = "t" + tray.getTrayId() + "drive" + location.getSlot();
                if (diskSet.length() > 0) {
                    diskSet.append(", ");
                    basis.append(", ");
                }
                diskSet.append("\"" + diskKey + "\"");
                basis.append("\"disk:" + diskKey + "\"");
                poolCapacity += (double)drives[x].getUsableCapacity();
            }
            int poolStatus = 1;
            repClass.setStringProperty("_BasedOn", basis.toString());
            repClass.setStringProperty("diskSet", diskSet.toString());
            double usablePoolCapacity = 0.0;
            Volume[] volumes = bundle.getVolume();
            for (int i = 0; i < volumes.length; ++i) {
                byte[] volVgRef = volumes[i].getVolumeGroupRef().getRefToken();
                if (!Utility.rawCompare(vgRef, volVgRef)) continue;
                usablePoolCapacity += (double)volumes[i].getCapacity();
                int volumeStatus = volumes[i].getStatus().getValue();
                if (volumeStatus <= poolStatus) continue;
                poolStatus = volumeStatus;
            }
            boolean bl = online = !volumeGroup.getOffline();
            if (online) {
                repClass.setStringProperty("_MountState", "mounted");
                String status = Translator.translateVolumeStatus(poolStatus);
                repClass.setStringProperty("_RawStatus", status);
                repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
                repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
                repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            } else {
                repClass.setStringProperty("_MountState", "unmounted");
                repClass.setStringProperty("_Status", "Other");
                repClass.setStringProperty("_RawStatus", "Off Line");
                repClass.setStringProperty("_EnabledState", "3");
                repClass.setStringProperty("_Availability", "Off Line");
                repClass.setStringProperty("_OtherEnabledState", "Disabled");
            }
            FreeExtent[] freeExtent = bundle.getFreeExtent();
            for (int i = 0; i < freeExtent.length; ++i) {
                byte[] feVgRef = freeExtent[i].getVolumeGroupRef().getRefToken();
                if (!Utility.rawCompare(vgRef, feVgRef)) continue;
                usablePoolCapacity += (double)freeExtent[i].getRawCapacity();
            }
            String units = "Bytes";
            if (usablePoolCapacity >= Treefrog_Array.TB) {
                usablePoolCapacity /= Treefrog_Array.TB;
                units = "TB";
            } else if (usablePoolCapacity >= 1.073741824E9) {
                usablePoolCapacity /= 1.073741824E9;
                units = "GB";
            } else if (usablePoolCapacity >= 1048576.0) {
                usablePoolCapacity /= 1048576.0;
                units = "MB";
            }
            NumberFormat formatter = NumberFormat.getInstance();
            formatter.setMaximumFractionDigits(2);
            String output = formatter.format(usablePoolCapacity);
            repClass.setStringProperty("_Capacity", formatter.format(usablePoolCapacity) + " " + units);
            if (poolCapacity >= Treefrog_Array.TB) {
                poolCapacity /= Treefrog_Array.TB;
                units = "TB";
            } else if (poolCapacity >= 1.073741824E9) {
                poolCapacity /= 1.073741824E9;
                units = "GB";
            } else if (poolCapacity >= 1048576.0) {
                poolCapacity /= 1048576.0;
                units = "MB";
            } else {
                units = "Bytes";
            }
            repClass.setStringProperty("rawCapacity", formatter.format(poolCapacity) + " " + units);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing storage vdisk data");
        }
    }

    protected String normalizeCapacity(long capacity) {
        String units = "Bytes";
        if (capacity <= 0L) {
            return "0 " + units;
        }
        if (capacity >= 0x40000000L) {
            capacity /= 0x40000000L;
            units = "GB";
        } else if (capacity >= 0x100000L) {
            capacity /= 0x100000L;
            units = "MB";
        } else {
            units = "Bytes";
        }
        return capacity + " " + units;
    }

    protected void createVolume(ReportClass system, Volume volume, ObjectBundle bundle) {
        ReportClass repClass = system.newSubInstance("volume");
        try {
            String deviceID = Utility.wwnString(volume.getWorldWideName());
            repClass.setStringProperty("_DeviceID", deviceID);
            repClass.setKey(deviceID);
            repClass.setStringProperty("_Caption", "Volume");
            repClass.setStringProperty("_Description", "Subset of a Vdisk");
            repClass.setStringProperty("_ElementName", Utility.userLabelString(volume.getLabel()));
            repClass.setStringProperty("_Name", Utility.userLabelString(volume.getLabel()));
            VolumeRef volRef = volume.getVolumeRef();
            repClass.setStringProperty("WWN", Utility.wwnString(volume.getWorldWideName()));
            repClass.setStringProperty("handle", "" + volume.getVolumeHandle());
            repClass.setStringProperty("_BlockSize", "" + volume.getBlkSize() + " bytes");
            repClass.setStringProperty("_NumberOfBlocks", "" + volume.getCapacity() / (long)volume.getBlkSize());
            long capacity = volume.getCapacity();
            repClass.setStringProperty("_Capacity", this.normalizeCapacity(capacity));
            repClass.setStringProperty("_action", Translator.translateVolumeAction(volume.getAction().getValue()));
            String currentManager = ReportUtilities.findControllerName(bundle, volume.getCurrentManager());
            String preferredManager = ReportUtilities.findControllerName(bundle, volume.getPreferredManager());
            repClass.setStringProperty("currentManager", currentManager);
            repClass.setStringProperty("preferredManager", preferredManager);
            String preferred = "false";
            if (currentManager != null && preferredManager != null && currentManager.equals(preferredManager)) {
                preferred = "true";
            }
            repClass.setStringProperty("onPreferredManager", preferred);
            repClass.setStringProperty("extremeProtection", "" + volume.getExtremeProtection());
            repClass.setStringProperty("offline", "" + volume.getOffline());
            repClass.setStringProperty("raidLevel", Translator.translateRaidLevel(volume.getRaidLevel().getValue()));
            repClass.setStringProperty("reconPriority", ReportUtilities.interpretPriority(volume.getReconPriority()));
            repClass.setStringProperty("readable", "" + volume.getPerms().getReadable());
            repClass.setStringProperty("writable", "" + volume.getPerms().getWritable());
            repClass.setStringProperty("copySource", "" + volume.getPerms().getCopySource());
            repClass.setStringProperty("copyTarget", "" + volume.getPerms().getCopyTarget());
            repClass.setStringProperty("format", "" + volume.getPerms().getFormat());
            repClass.setStringProperty("mapToLUN", "" + volume.getPerms().getMapToLUN());
            repClass.setStringProperty("reconfigure", "" + volume.getPerms().getReconfigure());
            repClass.setStringProperty("snapshot", "" + volume.getPerms().getSnapShot());
            String status = Translator.translateVolumeStatus(volume.getStatus().getValue());
            repClass.setStringProperty("_RawStatus", status);
            repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
            repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
            repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
            repClass.setStringProperty("_OtherEnabledState", status);
            String parentPool = ReportUtilities.findPoolName(bundle, volume.getVolumeGroupRef());
            repClass.setStringProperty("_SourceVdisk", parentPool);
            repClass.setStringProperty("_VolumeStatus", status);
            repClass.setStringProperty("mediaScan", ReportUtilities.booleanEnabledString(volume.getMediaScan().getEnable()));
            repClass.setStringProperty("parityValidation", ReportUtilities.booleanEnabledString(volume.getMediaScan().getParityValidationEnable()));
            this.mirrorCheck(repClass, volume, bundle);
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing data");
        }
    }

    protected void mirrorCheck(ReportClass volClass, Volume volume, ObjectBundle bundle) {
        try {
            HLVolumeBundle volBundle = bundle.getHighLevelVolBundle();
            MirrorProxyVolume[] mirrors = volBundle.getMirrorVol();
            RemoteVolume[] rVols = volBundle.getRemoteVol();
            byte[] vrefToken = volume.getVolumeRef().getRefToken();
            for (int i = 0; i < mirrors.length; ++i) {
                boolean mode;
                MirrorProxyVolume mirror = mirrors[i];
                byte[] baseVolToken = mirror.getBaseVolume().getRefToken();
                if (!Utility.rawCompare(vrefToken, baseVolToken)) continue;
                RemoteVolume remoteVolume = null;
                byte[] remoteRefToken = mirror.getRemoteVolRef().getRefToken();
                for (int x = 0; x < rVols.length; ++x) {
                    byte[] rvolRefToken = rVols[x].getRemoteVolRef().getRefToken();
                    if (!Utility.rawCompare(remoteRefToken, rvolRefToken)) continue;
                    remoteVolume = rVols[x];
                    break;
                }
                String setting = (mode = mirror.getAutoResync()) ? "Automatic" : "Manual";
                volClass.setStringProperty("resyncSetting", setting);
                volClass.setStringProperty("writeMode", Translator.translateLocalWriteMode(mirror.getLocalWriteMode()));
                volClass.setStringProperty("localVolRole", Translator.translateMirrorProxyRole(mirror.getLocalRole()));
                volClass.setStringProperty("localMirrorStatus", Translator.translateMirrorProxyStatus(mirror.getLocalMirrorStatus()));
                volClass.setStringProperty("localPriority", Translator.translateMirrorSyncPriority(mirror.getLocalPriority()));
                volClass.setStringProperty("remoteVolRole", Translator.translateMirrorProxyRole(mirror.getRemoteRole()));
                volClass.setStringProperty("remoteMirrorStatus", Translator.translateMirrorProxyStatus(mirror.getRemoteMirrorStatus()));
                volClass.setStringProperty("remotePriority", Translator.translateMirrorSyncPriority(mirror.getPeerPriority()));
                if (remoteVolume != null) {
                    volClass.setStringProperty("remoteVolName", Utility.userLabelString(remoteVolume.getRemoteVolUserLabel()));
                    volClass.setStringProperty("remoteVolState", Translator.translateRemoteVolState(remoteVolume.getRemoteVolState()));
                    volClass.setStringProperty("remoteVolWWN", Utility.wwnString(remoteVolume.getRemoteVolWWN()));
                    volClass.setStringProperty("remoteArrayNodeWWN", Utility.wwnString(remoteVolume.getRemoteNodeWWN()));
                } else {
                    volClass.setStringProperty("remoteVolName", "Unavailable");
                    volClass.setStringProperty("remoteVolState", "Unavailable");
                    volClass.setStringProperty("remoteVolWWN", "Unavailable");
                    volClass.setStringProperty("remoteArrayNodeWWN", "Unavailable");
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createPort(ReportClass system, IOInterfaceTypeData port, ObjectBundle bundle, Controller controller, int index, String side) {
        ReportClass repClass = system.newSubInstance("fcport");
        try {
            Location location = controller.getPhysicalLocation();
            String ctlrName = ReportUtilities.createName("Controller", bundle, location);
            int type = port.getInterfaceType().getValue();
            if (type == 2) {
                StringTokenizer tokens;
                FibreInterface fc = port.getFibre();
                String deviceID = Utility.wwnString(fc.getPortName()).toLowerCase();
                repClass.setKey(deviceID);
                repClass.setStringProperty("_DeviceID", deviceID);
                repClass.setStringProperty("_Caption", "FibrePort");
                repClass.setStringProperty("_Description", "Fibre Port");
                repClass.setStringProperty("_ElementName", ctlrName + ".FCPort." + side + fc.getChannel());
                repClass.setStringProperty("_Name", ctlrName + ".FCPort." + side + fc.getChannel());
                repClass.setStringProperty("channelMiswire", "" + fc.getChanMiswire());
                repClass.setStringProperty("channel", "" + fc.getChannel());
                repClass.setStringProperty("esmMiswire", "" + fc.getEsmMiswire());
                repClass.setStringProperty("hardAddress", "" + fc.getHardAddress());
                repClass.setStringProperty("degraded", "" + fc.getIsDegraded());
                repClass.setStringProperty("loopID", "" + fc.getLoopID());
                String maxSpeed = Translator.translateSpeed(fc.getMaximumInterfaceSpeed());
                repClass.setStringProperty("maxSpeed", "" + maxSpeed);
                String currentSpeed = Translator.translateSpeed(fc.getCurrentInterfaceSpeed());
                repClass.setStringProperty("speed", "" + currentSpeed);
                String part = fc.getPart();
                if (part != null && (tokens = new StringTokenizer(part)).hasMoreTokens()) {
                    part = tokens.nextToken();
                }
                repClass.setStringProperty("part", part);
                int sc = fc.getSpeedControl().getValue();
                repClass.setStringProperty("speedControl", Translator.translateSpeedControl(sc));
                repClass.setStringProperty("speedNegError", "" + fc.getSpeedNegError());
                repClass.setStringProperty("Topology", Translator.translateTopologyType(fc.getTopology().getValue()));
                repClass.setStringProperty("revision", "" + fc.getRevision());
                repClass.setStringProperty("portID", Utility.bytesArrayString(fc.getPortId()));
                repClass.setStringProperty("_WWN", Utility.wwnString(fc.getPortName()).toLowerCase());
                repClass.setStringProperty("NodeWWN", Utility.wwnString(fc.getNodeName()).toLowerCase());
                int temp = fc.getLinkStatus().getValue();
                String status = Translator.translateLinkStatus(temp);
                repClass.setStringProperty("_linkStatus", status);
                repClass.setStringProperty("_RawStatus", status);
                repClass.setStringProperty("_Status", ReportUtilities.determineStatus(status));
                repClass.setStringProperty("_EnabledState", ReportUtilities.determineState(status));
                repClass.setStringProperty("_Availability", ReportUtilities.determineAvailability(status));
                repClass.setStringProperty("_OtherEnabledState", status);
                return;
            }
            if (type != 1) return;
        }
        catch (Exception e) {
            repClass.setStringProperty("error", "Error accessing port data");
        }
    }

    protected void createLicences(ReportClass system, ObjectBundle bundle) {
        PremiumFeature[] features = bundle.getSa().getPremiumFeatures();
        for (int i = 0; i < features.length; ++i) {
            PremiumFeature feature = features[i];
            if (!feature.getIsEnabled()) continue;
            ReportClass license = system.newSubInstance("license");
            String capability = Translator.translateCapability(feature.getCapability());
            license.setKey(capability);
            license.setStringProperty("_Caption", "License Feature");
            String capabilityName = Translator.translateCapabilityDescription(feature.getCapability());
            license.setStringProperty("_Name", capabilityName);
            license.setStringProperty("_FeatureName", capabilityName);
            license.setStringProperty("_InCompliance", "" + feature.getIsCompliant());
            license.setStringProperty("cabability", capability);
            license.setStringProperty("enabled", "" + feature.getIsEnabled());
            license.setStringProperty("withinLimits", "" + feature.getIsWithinLimits());
            license.setStringProperty("Vendor", "Sun");
            license.setStringProperty("Version", "Unspecified");
            license.setStringProperty("AmountInUse", "0");
            license.setStringProperty("AmountLicensed", "0");
        }
    }

    public static void usage() {
        System.out.println("Usage: TreefrogReport [options]");
        System.out.println("\t-t <type>   Array Type [6130|flx380]");
        System.out.println("\t-i <ip>     Controller IP");
        System.out.println("\t-a <altip>  Other Controller IP");
    }

    public static void main(String[] args) {
        try {
            Options opts = new Options("t:i:a:SRD");
            args = opts.parseOptions(args);
            String arrayType = opts.getOption("t", "6130");
            String ip = opts.getOption("p", "");
            String altip = opts.getOption("a", "");
            debug = opts.getFlagOption("D");
            if (ip == null || "".equals(ip)) {
                TreefrogReport.usage();
                System.exit(-1);
            }
            Properties p = new Properties();
            p.setProperty("type", arrayType);
            p.setProperty("ip", ip);
            p.setProperty("altip", altip);
            TreefrogReport report = new TreefrogReport();
            ReportClass rc = report.generateReport(p, null);
            System.out.println(rc.toXML());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

