/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.SYMbolConnection;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import com.sun.netstorage.fm.storade.resource.discovery.AbstractProbe;
import com.sun.netstorage.fm.storade.resource.discovery.ProbeResult;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import devmgr.versioned.symbol.AccessibleController;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DiscoveryResponse;
import devmgr.versioned.symbol.EthernetInterface;
import devmgr.versioned.symbol.FibreInterface;
import devmgr.versioned.symbol.IOInterfaceTypeData;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.UserAssignedLabel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;

public class TreefrogProbe
extends AbstractProbe {
    public static final String ARRAY_TYPE_6130 = "6130";
    public static final String ARRAY_TYPE_6140 = "6140";
    public static final String ARRAY_TYPE_FLX380 = "flx380";
    public static final String ARRAY_TYPE_CSM200 = "csm200";
    public static final String PRODUCT_ID_6130 = "CSM100";
    public static final String PRODUCT_ID_6140 = "CSM200";
    public static final String PRODUCT_ID_FLX380 = "FLEXLINE 380";
    public static final String BOARD_ID_6130 = "2882";
    public static final String BOARD_ID_6140 = "3994";
    public static final String BOARD_ID_6140_LITE = "3992";
    public static final String BOARD_ID_FLX380 = "6091";
    boolean rack = false;

    public TreefrogProbe(Properties load) {
        String rackFlag = load.getProperty("rack");
        if (rackFlag != null) {
            this.rack = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ProbeResult probe(Properties inputProperties) {
        ProbeResult result;
        block18: {
            result = new ProbeResult();
            ArrayList<String> discoveredArrays = new ArrayList<String>();
            SYMbolAPIClientV1 symbolClient = null;
            String ip = inputProperties.getProperty("ip");
            if (ip == null) {
                ip = "localhost";
            }
            if (SYMbolConnection.serverIsResponding(ip)) {
                InetAddress inet = InetAddress.getByName(ip);
                symbolClient = new SYMbolAPIClientV1(inet, 2463, true);
                DiscoveryResponse response = symbolClient.discoverControllers();
                boolean viaProxy = response.getResponseFromAgent();
                AccessibleController[] controllers = response.getControllers();
                int numControllers = controllers == null ? 0 : controllers.length;
                for (int x = 0; x < numControllers; ++x) {
                    String wwn;
                    ObjectBundle bundle;
                    ControllerRef cref = controllers[x].getThisController();
                    SAIdentifier said = controllers[x].getSaId();
                    ControllerDescriptor descriptor = new ControllerDescriptor();
                    descriptor.setControllerRef(cref);
                    descriptor.setSaId(said);
                    ReturnCode rc = symbolClient.bindToController(descriptor);
                    if (rc.getValue() != 1 || (bundle = symbolClient.getObjectGraph()) == null || discoveredArrays.contains(wwn = this.getWWN(bundle))) continue;
                    discoveredArrays.add(wwn);
                    String controllerIP = this.getControllerIP(bundle);
                    DeviceProperties p = new DeviceProperties();
                    if (viaProxy) {
                        p.setProperty("proxys", ip);
                    }
                    String arrayType = this.determineType(bundle);
                    String arrayClass = this.determineClass(arrayType);
                    p.setProperty("type", arrayType);
                    p.setProperty("class", arrayClass);
                    p.setProperty("key", this.getKey(bundle));
                    p.setProperty("name", this.getName(bundle));
                    p.setProperty("wwn", wwn.toLowerCase());
                    p.setProperty("ipno", this.getIPNum(controllerIP));
                    p.setProperty("ip", this.getIPName(controllerIP));
                    String altIP = this.getAlternateIP(controllerIP, bundle);
                    p.setProperty("altipno", altIP);
                    p.setProperty("altip", this.getIPName(altIP));
                    p.setProperty("said", this.getSaid(bundle));
                    String ipList = this.getIPList(bundle);
                    p.setProperty("iplist", ipList);
                    p.setProperty("wwns", this.getWWNList(bundle));
                    p.setProperty("units", this.getTrayCount(bundle));
                    p.setProperty("boardID", this.getBoardID(bundle));
                    try {
                        p.setIPsFromList(ipList);
                    }
                    catch (UnknownHostException uhe) {
                        // empty catch block
                    }
                    result.addDevice(p);
                }
                Object var26_26 = null;
                try {
                    if (symbolClient != null) {
                        symbolClient.close();
                    }
                    break block18;
                }
                catch (IOException ioe) {}
                break block18;
                {
                    catch (Exception e) {
                        Object var26_27 = null;
                        try {
                            if (symbolClient != null) {
                                symbolClient.close();
                            }
                            break block18;
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var26_28 = null;
                    try {
                        if (symbolClient != null) {
                            symbolClient.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (result.sizeOfDiscoveredDevices() == 0) {
            return new ProbeResult("#ARG_ERROR", "No CSM found at " + inputProperties.getProperty("ip"));
        }
        return result;
    }

    private String getIPName(String ip) {
        String ipName;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            ipName = addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            ipName = ip;
        }
        return ipName;
    }

    private String getIPNum(String ip) {
        String ipNum;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            ipNum = addr.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            ipNum = ip;
        }
        return ipNum;
    }

    private String getAlternateIP(String ip, ObjectBundle bundle) {
        String altIP = "";
        boolean found = false;
        try {
            InetAddress addr = InetAddress.getByName(ip);
            try {
                Controller[] controllers = bundle.getController();
                for (int x = 0; x < controllers.length; ++x) {
                    NetInterfaceTypeData[] net = controllers[x].getNetInterfaces();
                    for (int y = 0; y < net.length; ++y) {
                        EthernetInterface enet = net[y].getEthernet();
                        if (enet.getChannel() != 1) continue;
                        int ipValue = enet.getIp();
                        String tempIP = Utility.convertIpAddr(ipValue);
                        try {
                            InetAddress tempAddr = InetAddress.getByName(tempIP);
                            if (!addr.equals(tempAddr)) {
                                altIP = tempIP;
                                found = true;
                            }
                        }
                        catch (Exception e) {
                            System.out.println(tempIP + "is not a recognizable ip address");
                        }
                        if (found) break;
                    }
                    if (!found) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("Probe error getting alternate IP");
            }
        }
        catch (UnknownHostException uhe) {
            System.out.println("Probe error getting alternate IP");
        }
        return altIP;
    }

    private String getControllerIP(ObjectBundle bundle) {
        String ip = "";
        try {
            Controller[] controllers = bundle.getController();
            NetInterfaceTypeData[] net = controllers[0].getNetInterfaces();
            EthernetInterface enet = net[0].getEthernet();
            int targetip = enet.getIp();
            ip = Utility.convertIpAddr(targetip);
        }
        catch (Exception e) {
            System.out.println("Probe error getting controller ip");
        }
        return ip;
    }

    private String getIPList(ObjectBundle bundle) {
        StringBuffer ipList = new StringBuffer();
        ArrayList<Object> enetList = new ArrayList<Object>();
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Controller[] controllers = bundle.getController();
            for (int x = 0; x < controllers.length; ++x) {
                NetInterfaceTypeData[] net = controllers[x].getNetInterfaces();
                for (int y = 0; y < net.length; ++y) {
                    EthernetInterface enet = net[y].getEthernet();
                    enetList.add(enet);
                }
            }
            for (int z = 0; z < enetList.size() - 1; ++z) {
                boolean swap = false;
                for (int i = 0; i < enetList.size() - 1; ++i) {
                    EthernetInterface enet1 = (EthernetInterface)enetList.get(i);
                    EthernetInterface enet2 = (EthernetInterface)enetList.get(i + 1);
                    if (enet1.getChannel() <= enet2.getChannel()) continue;
                    EthernetInterface temp = (EthernetInterface)enetList.get(i);
                    enetList.set(i, enetList.get(i + 1));
                    enetList.set(i + 1, temp);
                    swap = true;
                }
                if (!swap) break;
            }
            for (int i = 0; i < enetList.size(); ++i) {
                EthernetInterface inetif = (EthernetInterface)enetList.get(i);
                int ipValue = inetif.getIp();
                String ip = Utility.convertIpAddr(ipValue);
                ips.add(ip);
            }
            try {
                if (ips.size() == 4) {
                    String ip0 = (String)ips.get(0);
                    String ip2 = (String)ips.get(2);
                    if (!SYMbolConnection.serverIsResponding(ip0) && SYMbolConnection.serverIsResponding(ip2)) {
                        ips.set(0, ip2);
                        ips.set(2, ip0);
                    }
                    String ip1 = (String)ips.get(1);
                    String ip3 = (String)ips.get(3);
                    if (!SYMbolConnection.serverIsResponding(ip1) && SYMbolConnection.serverIsResponding(ip3)) {
                        ips.set(1, ip3);
                        ips.set(3, ip1);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i < ips.size(); ++i) {
                if (i > 0) {
                    ipList.append(",");
                }
                String ip = (String)ips.get(i);
                ipList.append(ip);
            }
        }
        catch (Exception e) {
            System.out.println("Probe error getting controller ip");
        }
        return ipList.toString();
    }

    private String getWWN(ObjectBundle bundle) {
        String wwn = "";
        try {
            byte[] wwnValue = bundle.getSa().getRemoteAccessID();
            wwn = Utility.wwnString(wwnValue);
        }
        catch (Exception e) {
            System.out.println("Probe error getting wwn");
        }
        return wwn;
    }

    private String getWWNList(ObjectBundle bundle) {
        StringBuffer wwnList = new StringBuffer();
        try {
            Controller[] controllers = bundle.getController();
            for (int x = 0; x < controllers.length; ++x) {
                IOInterfaceTypeData[] ports = controllers[x].getHostInterfaces();
                for (int p = 0; p < ports.length; ++p) {
                    int type = ports[p].getInterfaceType().getValue();
                    if (type != 2) continue;
                    if (wwnList.length() > 0) {
                        wwnList.append(",");
                    }
                    FibreInterface fc = ports[p].getFibre();
                    String wwn = Utility.wwnString(fc.getPortName()).toLowerCase();
                    wwnList.append(wwn);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Probe error getting wwn");
        }
        return wwnList.toString();
    }

    private String getSaid(ObjectBundle bundle) {
        String said = "";
        try {
            SAData array = bundle.getSa().getSaData();
            byte[] wwnValue = array.getSaId().getWorldWideName();
            said = Utility.wwnString(wwnValue);
        }
        catch (Exception e) {
            System.out.println("Probe error getting wwn");
        }
        return said;
    }

    private String getTrayCount(ObjectBundle bundle) {
        String trayCount = "1";
        try {
            Tray[] trays = bundle.getTray();
            int count = trays == null ? 1 : trays.length;
            trayCount = Integer.toString(count);
        }
        catch (Exception e) {
            System.out.println("Probe error getting the tray count");
        }
        return trayCount;
    }

    private String getKey(ObjectBundle bundle) {
        String vendor = "SUN";
        String partNum = "";
        String serialNum = "";
        if (bundle != null) {
            int x;
            Tray[] trays = bundle.getTray();
            for (x = 0; x < trays.length && trays[x].getNumControllerSlots() <= 0; ++x) {
            }
            if (x >= trays.length) {
                x = 0;
            }
            partNum = this.stripHeader(trays[x].getPartNumber());
            serialNum = this.stripHeader(trays[x].getSerialNumber());
        }
        String key = vendor + "." + partNum + "." + serialNum;
        return key.trim();
    }

    private String stripHeader(String data) {
        String value = "";
        if (data != null) {
            int index = data.indexOf(" ");
            value = index > 0 ? data.substring(index + 1) : data;
        }
        return value.trim();
    }

    private String getName(String ip) {
        return this.getIPName(ip);
    }

    private String getName(ObjectBundle bundle) {
        String name = "unnamed";
        try {
            UserAssignedLabel label = bundle.getSa().getSaData().getStorageArrayLabel();
            name = Utility.userLabelString(label);
            if ("".equals(name) || "unlabeled".equals(name)) {
                name = "unnamed";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    private String determineType(ObjectBundle bundle) {
        String type = null;
        Controller[] controllers = bundle.getController();
        for (int i = 0; i < controllers.length; ++i) {
            Controller controller = controllers[i];
            String productID = controller.getProductID();
            String boardID = controller.getBoardID();
            if (productID != null) {
                if (productID.startsWith(PRODUCT_ID_6140)) {
                    type = ARRAY_TYPE_6140;
                    if (!this.rack) break;
                    type = ARRAY_TYPE_CSM200;
                    break;
                }
                if (productID.startsWith(PRODUCT_ID_FLX380)) {
                    type = ARRAY_TYPE_FLX380;
                    break;
                }
            }
            if (type != null || boardID == null) continue;
            if (boardID.startsWith(BOARD_ID_6140)) {
                type = ARRAY_TYPE_6140;
                if (!this.rack) break;
                type = ARRAY_TYPE_CSM200;
                break;
            }
            if (boardID.startsWith(BOARD_ID_6140_LITE)) {
                type = ARRAY_TYPE_6140;
                break;
            }
            if (!boardID.startsWith(BOARD_ID_FLX380)) continue;
            type = ARRAY_TYPE_FLX380;
            break;
        }
        if (type == null) {
            type = ARRAY_TYPE_6130;
        }
        return type;
    }

    private String determineClass(String type) {
        String arrayClass = "storage.6130";
        if (ARRAY_TYPE_6140.equals(type)) {
            arrayClass = "storage.6140";
        } else if (ARRAY_TYPE_CSM200.equals(type)) {
            arrayClass = "storage.csm200";
        } else if (ARRAY_TYPE_FLX380.equals(type)) {
            arrayClass = "storage.flx380";
        }
        return arrayClass;
    }

    private String getBoardID(ObjectBundle bundle) {
        String boardID = "";
        Controller[] controllers = bundle.getController();
        int length = controllers != null ? controllers.length : 0;
        for (int i = 0; i < length; ++i) {
            Controller controller = controllers[i];
            String id = controller.getBoardID();
            if (id == null) continue;
            boardID = id;
            break;
        }
        return boardID;
    }
}

