/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.AccessibleController;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DiscoveryResponse;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ProcedureTimeout;
import devmgr.versioned.symbol.RLSCommand;
import devmgr.versioned.symbol.RLSCommandDescriptor;
import devmgr.versioned.symbol.RLSResults;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class SYMbolConnection {
    public static final int SYMBOL_PORT = 2463;
    public static final int SOCKET_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectBundle getObjectBundle(Properties props) {
        SYMbolAPIClientV1 client = null;
        ObjectBundle bundle = null;
        try {
            client = SYMbolConnection.getClient(props);
            if (client != null) {
                bundle = client.getObjectGraph();
            }
        }
        catch (Exception exception) {
        }
        finally {
            SYMbolConnection.closeClient(client);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectBundle getObjectBundle(String ip) {
        ObjectBundle bundle = null;
        SYMbolAPIClientV1 symbolClient = null;
        try {
            InetAddress inet = InetAddress.getByName(ip);
            symbolClient = new SYMbolAPIClientV1(inet, 2463, true);
            if (symbolClient != null) {
                symbolClient.setTimeout(new ProcedureTimeout().getProcTimeout(40));
                bundle = symbolClient.getObjectGraph();
            }
            SYMbolConnection.closeClient(symbolClient);
        }
        catch (Exception e) {
            System.out.println("Error opening/using the client connection.");
        }
        finally {
            SYMbolConnection.closeClient(symbolClient);
        }
        return bundle;
    }

    public static ObjectBundle getObjectBundle(SYMbolAPIClientV1 client) {
        ObjectBundle bundle = null;
        try {
            client.setTimeout(new ProcedureTimeout().getProcTimeout(40));
            bundle = client.getObjectGraph();
        }
        catch (Exception e) {
            System.out.println("Error using the client connection.");
        }
        return bundle;
    }

    public static RLSResults getRLSData(SYMbolAPIClientV1 client) {
        RLSResults rlsResults = null;
        try {
            RLSCommand command = new RLSCommand(1);
            RLSCommandDescriptor rlsCommand = new RLSCommandDescriptor();
            rlsCommand.setCommand(command);
            client.setTimeout(new ProcedureTimeout().getProcTimeout(102));
            rlsResults = client.getReadLinkStatus(rlsCommand);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rlsResults;
    }

    public static SYMbolAPIClientV1 getOpenConnection(Properties props) {
        SYMbolAPIClientV1 client = SYMbolConnection.getClient(props);
        return client;
    }

    public static SYMbolAPIClientV1 getOpenConnection(String ip) {
        SYMbolAPIClientV1 client = null;
        if (SYMbolConnection.serverIsResponding(ip)) {
            try {
                InetAddress inet = InetAddress.getByName(ip);
                client = new SYMbolAPIClientV1(inet, 2463, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return client;
    }

    public static SYMbolAPIClientV1 getOpenConnectionWithRetries(String ip) {
        return SYMbolConnection.getOpenConnectionWithRetries(ip, 3, 3);
    }

    public static SYMbolAPIClientV1 getOpenConnectionWithRetries(String ip, int retries, int delay) {
        SYMbolAPIClientV1 client = null;
        for (int i = 0; i < retries && (client = SYMbolConnection.getOpenConnection(ip)) == null; ++i) {
            try {
                Thread.sleep(delay * 1000);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        return client;
    }

    public static void closeClient(SYMbolAPIClientV1 client) {
        if (client != null) {
            try {
                client.close();
                client = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static SYMbolAPIClientV1 getClient(Properties props) {
        SYMbolAPIClientV1 client = null;
        String said = props.getProperty("said");
        boolean found = false;
        boolean saidMatch = false;
        ArrayList addresses = SYMbolConnection.getIPList(props);
        for (int x = 0; x < addresses.size(); ++x) {
            try {
                String ip = (String)addresses.get(x);
                if (SYMbolConnection.serverIsResponding(ip)) {
                    InetAddress inet = InetAddress.getByName(ip);
                    client = new SYMbolAPIClientV1(inet, 2463, true);
                    DiscoveryResponse response = client.discoverControllers();
                    AccessibleController[] allControllers = response.getControllers();
                    for (int c = 0; c < allControllers.length; ++c) {
                        SAIdentifier arrayId = allControllers[c].getSaId();
                        String thisSaid = Utility.wwnString(arrayId.getWorldWideName());
                        if (!thisSaid.equals(said)) continue;
                        saidMatch = true;
                        ControllerDescriptor descriptor = new ControllerDescriptor();
                        descriptor.setSaId(arrayId);
                        descriptor.setControllerRef(allControllers[c].getThisController());
                        ReturnCode rc = client.bindToController(descriptor);
                        if (rc.getValue() != 1) continue;
                        found = true;
                        break;
                    }
                }
                if (found) break;
                if (client == null) continue;
                try {
                    client.close();
                    client = null;
                }
                catch (Exception e) {}
                continue;
            }
            catch (Exception ex) {
                if (client == null) continue;
                try {
                    client.close();
                    client = null;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean serverIsResponding(String ip) {
        Socket socket = null;
        boolean response = false;
        socket = new Socket();
        InetSocketAddress socketAddress = new InetSocketAddress(ip, 2463);
        socket.connect(socketAddress, 5000);
        response = true;
        Object var5_6 = null;
        if (socket == null) return response;
        try {
            socket.close();
            return response;
        }
        catch (Exception e) {}
        return response;
        {
            catch (UnknownHostException uhe) {
                Object var5_7 = null;
                if (socket == null) return response;
                try {
                    socket.close();
                    return response;
                }
                catch (Exception e) {}
                return response;
            }
            catch (IOException iOException) {
                Object var5_8 = null;
                if (socket == null) return response;
                try {
                    socket.close();
                    return response;
                }
                catch (Exception e) {}
                return response;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (socket == null) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static boolean matchController(SYMbolAPIClientV1 client, ControllerRef ref) {
        boolean bound = false;
        try {
            ObjectBundle bundle = client.getObjectGraph();
            SAIdentifier said = bundle.getSa().getSaData().getSaId();
            ControllerDescriptor descriptor = new ControllerDescriptor();
            descriptor.setControllerRef(ref);
            descriptor.setSaId(said);
            ReturnCode rc = client.bindToController(descriptor);
            if (rc.getValue() == 1) {
                bound = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bound;
    }

    private static ArrayList getProxies(Properties p) {
        ArrayList<String> proxyList = new ArrayList<String>();
        String proxies = p.getProperty("proxys");
        if (proxies != null) {
            StringTokenizer tokens = new StringTokenizer(proxies, " |");
            while (tokens.hasMoreTokens()) {
                proxyList.add(tokens.nextToken());
            }
        }
        return proxyList;
    }

    private static ArrayList getIPList(Properties props) {
        ArrayList addresses = SYMbolConnection.getProxies(props);
        if (props.getProperty("altip") != null) {
            addresses.add(0, props.getProperty("altip"));
        }
        if (props.getProperty("ip") != null) {
            addresses.add(0, props.getProperty("ip"));
        }
        return addresses;
    }
}

