/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.device.storage.treefrog;

import com.sun.netstorage.fm.storade.device.storage.treefrog.Treefrog_Array;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.NOCList;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Translator;
import com.sun.netstorage.fm.storade.device.storage.treefrog.common.Utility;
import devmgr.versioned.symbol.ComponentRef;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.Location;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.VolumeGroup;
import devmgr.versioned.symbol.VolumeGroupRef;

public class ReportUtilities
implements Treefrog_Array {
    public static String booleanEnabledString(boolean value) {
        return value ? "Enabled" : "Disabled";
    }

    public static boolean inControllerTray(ObjectBundle bundle, Location location) {
        boolean flag = false;
        try {
            int count;
            Tray tray = Utility.findTray(bundle, location.getTrayRef());
            if (tray != null && (count = tray.getNumControllerSlots()) > 0) {
                flag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public static String createKey(String vendor, String part, String serialNum) {
        String key = ReportUtilities.stripHeader(vendor, "VN") + "." + ReportUtilities.stripHeader(part, "PN") + "." + ReportUtilities.stripHeader(serialNum, "SN");
        return key.trim();
    }

    public static String stripHeader(String data) {
        data = data.trim();
        String value = "";
        int index = data.indexOf(" ");
        value = index >= 0 ? data.substring(index + 1) : data;
        return value.trim();
    }

    public static String stripHeader(String data, String type) {
        data = data.trim();
        String value = "";
        int index = data.indexOf(type + " ");
        value = index >= 0 ? data.substring(index + type.length()) : data;
        return value.trim();
    }

    public static String determineStatus(String data) {
        String value = "Unknown";
        if (data.equals("Optimal")) {
            value = "OK";
        } else if (data.equals("Failed")) {
            value = "Error";
        } else if (data.equals("Removed")) {
            value = "Other";
        } else if (data.equals("Charging")) {
            value = "Other";
        } else if (data.equals("Near Expiration")) {
            value = "OK";
        } else if (data.equals("Not in Config")) {
            value = "Other";
        } else if (data.equals("Unknown")) {
            value = "Unknown";
        } else if (data.equals("RPA Parity Error")) {
            value = "Error";
        } else if (data.equals("Bypassed")) {
            value = "Bypassed";
        } else if (data.equals("Replaced")) {
            value = "OK";
        } else if (data.equals("Unresponsive")) {
            value = "No Contact";
        } else if (data.equals("OverMaxTemp")) {
            value = "Error";
        } else if (data.equals("OverTemp")) {
            value = "Stressed";
        } else if (data.equals("Degraded")) {
            value = "Degraded";
        } else if (data.equals("Impaired")) {
            value = "Error";
        } else if (data.equals("Up")) {
            value = "OK";
        } else if (data.equals("Down")) {
            value = "Other";
        } else if (data.equals("Service")) {
            value = "Other";
        } else if (data.equals("No Input")) {
            value = "Error";
        }
        return value;
    }

    public static String determineState(String data) {
        String value = "0";
        if (data.equals("Optimal")) {
            value = "2";
        } else if (data.equals("Failed")) {
            value = "6";
        } else if (data.equals("Removed")) {
            value = "1";
        } else if (data.equals("Charging")) {
            value = "2";
        } else if (data.equals("Near Expiration")) {
            value = "2";
        } else if (data.equals("Not in Config")) {
            value = "1";
        } else if (data.equals("Unknown")) {
            value = "0";
        } else if (data.equals("RPA Parity Error")) {
            value = "6";
        } else if (data.equals("Bypassed")) {
            value = "3";
        } else if (data.equals("Replaced")) {
            value = "2";
        } else if (data.equals("Unresponsive")) {
            value = "1";
        } else if (data.equals("OverMaxTemp")) {
            value = "2";
        } else if (data.equals("OverTemp")) {
            value = "2";
        } else if (data.equals("Degraded")) {
            value = "2";
        } else if (data.equals("Impaired")) {
            value = "2";
        } else if (data.equals("Up")) {
            value = "2";
        } else if (data.equals("Down")) {
            value = "3";
        } else if (data.equals("Service")) {
            value = "3";
        } else if (data.equals("No Input")) {
            value = "6";
        }
        return value;
    }

    public static String determineAvailability(String data) {
        String value = "Unknown";
        if (data.equals("Optimal")) {
            value = "Running/Full Power";
        } else if (data.equals("Failed")) {
            value = "Warning";
        } else if (data.equals("Removed")) {
            value = "Not Installed";
        } else if (data.equals("Charging")) {
            value = "Degraded";
        } else if (data.equals("Near Expiration")) {
            value = "Running/Full Power";
        } else if (data.equals("Not in Config")) {
            value = "Other";
        } else if (data.equals("Unknown")) {
            value = "Not Installed";
        } else if (data.equals("RPA Parity Error")) {
            value = "Warning";
        } else if (data.equals("Bypassed")) {
            value = "Quiesced";
        } else if (data.equals("Replaced")) {
            value = "Running/Full Power";
        } else if (data.equals("Unresponsive")) {
            value = "Unknown";
        } else if (data.equals("OverMaxTemp")) {
            value = "Warning";
        } else if (data.equals("OverTemp")) {
            value = "Warning";
        } else if (data.equals("Degraded")) {
            value = "Warning";
        } else if (data.equals("Impaired")) {
            value = "Warning";
        } else if (data.equals("Up")) {
            value = "Running/Full Power";
        } else if (data.equals("Down")) {
            value = "Off Line";
        } else if (data.equals("Service")) {
            value = "Off Line";
        } else if (data.equals("No Input")) {
            value = "Off Line";
        }
        return value;
    }

    public static String interpretPriority(int priority) {
        String description;
        switch (priority) {
            case 0: {
                description = "Very high (0 on a scale of 0-4)";
                break;
            }
            case 1: {
                description = "High (1 on a scale of 0-4)";
                break;
            }
            case 2: {
                description = "Medium (2 on a scale of 0-4)";
                break;
            }
            case 3: {
                description = "Low (3 on a scale of 0-4)";
                break;
            }
            case 4: {
                description = "Very low (4 on a scale of 0-4)";
                break;
            }
            default: {
                description = "Not specified";
            }
        }
        return description;
    }

    public static String createDeviceID(String component, ObjectBundle bundle, Location location) {
        String tray = "X";
        String slot = "Y";
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = "X";
                slot = "Y";
            } else if (location == null) {
                slot = "Y";
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = "" + physicalTray.getTrayId();
                slot = "" + location.getSlot();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return "t" + tray + component + slot;
    }

    public static String createDeviceID(String component, ObjectBundle bundle, Location location, byte[] ref) {
        return ReportUtilities.createDeviceID(component, bundle, location, ref, 10);
    }

    public static String createDeviceID(String component, ObjectBundle bundle, Location location, byte[] ref, int idx) {
        String tray = "X";
        String slot = "Y";
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = "X";
                slot = "Y";
            } else if (location == null) {
                slot = "Y";
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = "" + physicalTray.getTrayId();
                slot = "" + location.getSlot() + ":" + ref[idx];
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String id = "t" + tray + component + slot;
        if ("ts".equals(component)) {
            id = "t" + tray + component + ref[idx];
        }
        return id;
    }

    public static String createName(String component, ObjectBundle bundle, Location location) {
        return ReportUtilities.createName(component, bundle, location, false);
    }

    public static String createName(String component, ObjectBundle bundle, Location location, boolean invertSlot) {
        int tray = -1;
        int slot = -1;
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = -1;
                slot = -1;
            } else if (location == null) {
                slot = -1;
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = physicalTray.getTrayId();
                slot = location.getSlot();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = "Tray." + tray + "." + component + "." + Translator.getSlotName(slot);
        if (invertSlot) {
            name = "Tray." + tray + "." + component + "." + Translator.getInvertedSlotName(slot);
        }
        if ("Drive".equals(component)) {
            name = "Tray." + tray + "." + component + "." + slot;
        }
        return name;
    }

    public static String createName(String component, ObjectBundle bundle, Location location, byte[] ref) {
        return ReportUtilities.createName(component, bundle, location, ref, 10);
    }

    public static String createName(String component, ObjectBundle bundle, Location location, byte[] ref, int idx) {
        int tray = -1;
        int slot = -1;
        try {
            if (component == null) {
                component = "unknown";
            }
            if (bundle == null) {
                tray = -1;
                slot = -1;
            } else if (location == null) {
                slot = -1;
            } else {
                Tray physicalTray = Utility.findTray(bundle, location.getTrayRef());
                tray = physicalTray.getTrayId();
                slot = location.getSlot();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String name = "Tray." + tray + "." + component + "." + Translator.getSlotName(slot) + ":" + ref[idx];
        if ("Drive".equals(component)) {
            name = "Tray." + tray + "." + component + "." + slot + ":" + ref[idx];
        } else if ("TempSensor".equals(component)) {
            name = "Tray." + tray + "." + component + "." + ref[idx];
        }
        return name;
    }

    public static String findControllerName(ObjectBundle bundle, ControllerRef cref) {
        return ReportUtilities.findControllerIdentifier(bundle, cref, 2);
    }

    public static String findControllerDeviceID(ObjectBundle bundle, ControllerRef cref) {
        return ReportUtilities.findControllerIdentifier(bundle, cref, 1);
    }

    public static String findControllerIdentifier(ObjectBundle bundle, ControllerRef cref, int format) {
        byte[] target = cref.getRefToken();
        String name = "cnf";
        try {
            Controller[] controllers = bundle.getController();
            for (int x = 0; x < controllers.length; ++x) {
                byte[] token = controllers[x].getControllerRef().getRefToken();
                if (!Utility.rawCompare(target, token)) continue;
                name = format == 1 ? ReportUtilities.createDeviceID("ctrl", bundle, controllers[x].getPhysicalLocation()) : ReportUtilities.createName("Controller", bundle, controllers[x].getPhysicalLocation());
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    public static String findEsmName(ObjectBundle bundle, ComponentRef cref) {
        return ReportUtilities.findEsmIdentifier(bundle, cref, 2);
    }

    public static String findEsmDeviceID(ObjectBundle bundle, ComponentRef cref) {
        return ReportUtilities.findEsmIdentifier(bundle, cref, 1);
    }

    public static String findEsmIdentifier(ObjectBundle bundle, ComponentRef ref, int format) {
        byte[] target = ref.getRefToken();
        String name = "cnf";
        try {
            Esm[] esms = bundle.getComponentBundle().getEsm();
            for (int x = 0; x < esms.length; ++x) {
                byte[] token = esms[x].getEsmRef().getRefToken();
                if (!Utility.rawCompare(target, token)) continue;
                name = format == 1 ? ReportUtilities.createDeviceID("iom", bundle, esms[x].getPhysicalLocation()) : ReportUtilities.createName("IOM", bundle, esms[x].getPhysicalLocation());
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    public static String findPoolName(ObjectBundle bundle, VolumeGroupRef ref) {
        return ReportUtilities.findPoolIdentifier(bundle, ref, 2);
    }

    public static String findPoolDeviceID(ObjectBundle bundle, VolumeGroupRef ref) {
        return ReportUtilities.findPoolIdentifier(bundle, ref, 1);
    }

    public static String findPoolIdentifier(ObjectBundle bundle, VolumeGroupRef ref, int format) {
        byte[] target = ref.getRefToken();
        String name = "cnf";
        try {
            VolumeGroup[] pools = bundle.getVolumeGroup();
            for (int x = 0; x < pools.length; ++x) {
                byte[] token = pools[x].getVolumeGroupRef().getRefToken();
                if (!Utility.rawCompare(target, token)) continue;
                name = format == 1 ? Utility.wwnString(pools[x].getWorldWideName()) : "vdisk." + pools[x].getSequenceNum();
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    public static String findSfpName(String parentID, ComponentRef ref) {
        return ReportUtilities.findSfpIdentifier(parentID, ref, 2);
    }

    public static String findSfpDeviceID(String parentID, ComponentRef ref) {
        return ReportUtilities.findSfpIdentifier(parentID, ref, 1);
    }

    public static String findSfpIdentifier(String parent, ComponentRef sfpRef, int format) {
        String name = "sfp.unknown";
        try {
            byte[] token = sfpRef.getRefToken();
            name = format == 1 ? parent + ":sfp." + token[10] : parent + ".SFP." + token[10];
        }
        catch (Exception e) {
            // empty catch block
        }
        return name;
    }

    public static String mapWhitneyIOMPorts(int port) {
        String portStr = Integer.toString(port);
        switch (port) {
            case 1: {
                portStr = "1A";
                break;
            }
            case 2: {
                portStr = "1B";
                break;
            }
            case 3: {
                portStr = "2A";
                break;
            }
            case 4: {
                portStr = "2B";
            }
        }
        return portStr;
    }

    public static boolean usableTrayIOM(ObjectBundle bundle, int trayID, Esm[] esms) {
        boolean rval = false;
        try {
            int length = esms != null ? esms.length : 0;
            for (int i = 0; i <= length; ++i) {
                int status;
                Esm esm = esms[i];
                Location location = esm.getPhysicalLocation();
                Tray esmTray = NOCList.findTray(bundle, location.getTrayRef().getRefToken());
                if (esmTray == null || esmTray.getTrayId() != trayID || (status = esm.getStatus().getValue()) != 1) continue;
                rval = true;
                break;
            }
        }
        catch (Exception e) {
            rval = false;
        }
        return rval;
    }
}

