/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.command.xml;

import com.sun.netstorage.fm.storade.agent.command.CommandHandler;
import com.sun.netstorage.fm.storade.agent.command.xml.JrexRunner;
import com.sun.netstorage.fm.storade.agent.command.xml.SOAPCommandRunner;
import com.sun.netstorage.fm.storade.agent.command.xml.SOAPMessage;
import com.sun.netstorage.fm.storade.agent.jmx.JMXCommandRunner;
import com.sun.netstorage.fm.storade.util.Roles;
import com.sun.netstorage.fm.util.Property;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import sun.misc.BASE64Encoder;

public class XMLCommandHandler
implements CommandHandler {
    private static final String NEWLINE = "\r\n";
    private MBeanServer server;
    private Reader in;
    private StringWriter sout;
    private PrintWriter out;
    private String command;
    private String location;
    private String version;
    private Vector properties;
    private HashMap runners;
    private String credential;
    static Logger logger = Logger.getLogger("com.sun.netstorage.fm.storade.agent.jmx");
    public static final String _SOURCE_REVISION = "$Revision: 1.9 $";

    public XMLCommandHandler(MBeanServer server, String user, String pass) {
        this.server = server;
        this.initAuthorization(user, pass);
        this.registerRunners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void handleRequest(Socket s) {
        this.sout = new StringWriter();
        this.out = new PrintWriter(this.sout);
        InputStreamReader rin = new InputStreamReader((InputStream)new BufferedInputStream(s.getInputStream()), "UTF-8");
        this.in = rin;
        this.parseHTTP(this.getLine());
        Vector header = this.getProperties();
        if (!this.checkAuthorization(this.getProperty("Authorization"))) {
            this.out.print(new SOAPMessage(new IllegalAccessException()).toString());
        } else {
            try {
                if ("POST".equals(this.command)) {
                    StringBuffer doc = new StringBuffer();
                    Property p = this.getProperty("Content-Length");
                    if (p != null) {
                        int c;
                        int byteNum = p.getIntValue(0);
                        for (int i = 0; i < byteNum && (c = this.in.read()) != -1; ++i) {
                            doc.append((char)c);
                        }
                    }
                    SOAPMessage cm = SOAPMessage.parseXML(doc.toString());
                    SOAPCommandRunner cr = (SOAPCommandRunner)this.runners.get(this.location);
                    if (cr != null) {
                        SOAPMessage reply = cr.exec(cm);
                        this.out.print(reply.toString());
                    }
                }
                if ("GET".equals(this.command)) {
                    if ("/jvm/die".equals(this.location)) {
                        System.exit(0);
                    }
                    if ("/jvm/ping".equals(this.location)) {
                        this.out.print("<Alive/>");
                    }
                }
            }
            catch (Throwable t) {
                this.out.print(new SOAPMessage(t).toString());
            }
        }
        this.replyMessage(s);
        Object var10_14 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (IOException ioe2) {}
        return;
        {
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Error serving request.", ioe);
                Object var10_15 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String getLine() {
        StringBuffer line = new StringBuffer();
        try {
            while (true) {
                int c;
                if ((c = this.in.read()) == 13) {
                    continue;
                }
                if (c != 10 && c != -1) {
                    line.append((char)c);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return line.toString();
    }

    private void parseHTTP(String line) {
        this.properties = new Vector();
        int i = line.indexOf(32);
        if (i > 0) {
            this.command = line.substring(0, i);
            int j = line.indexOf(32, i + 1);
            if (j > 0) {
                this.location = line.substring(i + 1, j);
                this.version = line.substring(j + 1);
            }
        } else {
            this.command = line;
        }
    }

    private Vector getProperties() {
        String line;
        while ((line = this.getLine()).length() != 0) {
            int sepos = line.indexOf(58);
            Property prop = sepos > 0 ? new Property(line.substring(0, sepos), line.substring(sepos + 2)) : new Property(line, "");
            this.properties.add(prop);
        }
        return this.properties;
    }

    public Property getProperty(String name) {
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                Property p = (Property)this.properties.get(i);
                if (!p.getName().equals(name)) continue;
                return p;
            }
        }
        return null;
    }

    private void replyMessage(Socket s) throws IOException {
        OutputStreamWriter rout = new OutputStreamWriter((OutputStream)new BufferedOutputStream(s.getOutputStream()), "UTF-8");
        StringBuffer buf = new StringBuffer();
        Date now = new Date();
        int len = this.sout.getBuffer().length();
        buf.append("HTTP/1.0 200 OK\r\n");
        buf.append("Date: " + now + NEWLINE);
        buf.append("Server: StorADE Command XML $Revision: 1.9 $\r\n");
        buf.append("Content-length: " + len + NEWLINE);
        buf.append("Content-Type: application/soap+xml; charset=utf-8\r\n");
        buf.append(NEWLINE);
        rout.write(buf.toString());
        rout.write(this.sout.toString());
        ((Writer)rout).flush();
        ((Writer)rout).close();
    }

    private void registerRunners() {
        this.runners = new HashMap();
        this.runners.put("/jrex", new JrexRunner());
        this.runners.put("/jmx", new JMXCommandRunner(this.server));
    }

    private boolean checkAuthorization(Property auth) {
        if (this.credential == null) {
            return true;
        }
        if (auth == null) {
            return false;
        }
        return this.credential.equals(auth.getValue());
    }

    private void initAuthorization(String user, String pass) {
        if (user == null) {
            this.credential = "Basic " + Roles.getIPCAuthentication();
            return;
        }
        String userPasswd = user + ":" + pass;
        String cipher = new BASE64Encoder().encode(userPasswd.getBytes());
        this.credential = "Basic " + cipher;
    }
}

