/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.agent.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Catalog {
    public static final String CAT_DIR = "/opt/SUNWstade/System/Catalog/";
    public static final String DEV_DIR = "/opt/SUNWstade/System/Catalog/device";
    public static final String STORADE_DIR = "/etc/storade";
    public static final String _SOURCE_REVISION = "$Revision: 1.2 $";

    public static String[] deviceTypes() {
        Set types = Catalog.typeDirs().keySet();
        return types.toArray(new String[types.size()]);
    }

    public static Map typeDirs() {
        File sa;
        HashMap<String, String> types = new HashMap<String, String>();
        File device = new File(DEV_DIR);
        if (device.exists()) {
            File[] devs = device.listFiles();
            for (int i = 0; i < devs.length; ++i) {
                types.put(devs[i].getName(), devs[i].getAbsolutePath());
            }
        }
        if ((sa = new File(STORADE_DIR)).exists()) {
            System.out.println("Searching " + sa);
            File[] devs = sa.listFiles();
            System.out.println("Found " + devs.length);
            for (int i = 0; i < devs.length; ++i) {
                String fname = devs[i].getName();
                System.out.println("Looking in " + fname);
                if (!devs[i].exists() || !fname.endsWith(".conf")) continue;
                try {
                    String type = devs[i].getName();
                    type = type.substring(0, type.length() - 5);
                    Properties p = new Properties();
                    p.load(new FileInputStream(devs[i]));
                    types.put(type, p.getProperty("BASE_DIR"));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return types;
    }

    public static String getCatalogDir(String type) {
        try {
            File dev = new File("/opt/SUNWstade/System/Catalog/device/" + type);
            if (dev.exists()) {
                return dev.getAbsolutePath();
            }
            dev = new File(STORADE_DIR, type + ".conf");
            if (dev.exists()) {
                Properties p = new Properties();
                p.load(new FileInputStream(dev));
                return p.getProperty("BASE_DIR");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getCommonDir(String type) {
        return "/opt/SUNWstade/System/Catalog/common/";
    }

    public static interface Docs {
        public static final String IMPLEMENTATION = "implementation.xml";
        public static final String MODEL = "model.xml";
    }
}

