/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0912api01.symbol;

import devmgr.v0912api01.jrpc.RPCError;
import devmgr.v0912api01.jrpc.XDRInputStream;
import devmgr.v0912api01.jrpc.XDROutputStream;
import devmgr.v0912api01.jrpc.XDRType;
import devmgr.v0912api01.symbol.SYMbolAPIConstants;

public class SACache
implements XDRType,
SYMbolAPIConstants {
    private int cacheBlkSize;
    private int demandFlushAmount;
    private int demandFlushThreshold;
    private byte[] reserved1;
    private byte[] reserved2;

    public SACache() {
    }

    public SACache(SACache sACache) {
        this.cacheBlkSize = sACache.cacheBlkSize;
        this.demandFlushAmount = sACache.demandFlushAmount;
        this.demandFlushThreshold = sACache.demandFlushThreshold;
        this.reserved1 = sACache.reserved1;
        this.reserved2 = sACache.reserved2;
    }

    public int getCacheBlkSize() {
        return this.cacheBlkSize;
    }

    public int getDemandFlushAmount() {
        return this.demandFlushAmount;
    }

    public int getDemandFlushThreshold() {
        return this.demandFlushThreshold;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public void setCacheBlkSize(int n) {
        this.cacheBlkSize = n;
    }

    public void setDemandFlushAmount(int n) {
        this.demandFlushAmount = n;
    }

    public void setDemandFlushThreshold(int n) {
        this.demandFlushThreshold = n;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.cacheBlkSize = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.demandFlushAmount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.demandFlushThreshold = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(12);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.cacheBlkSize);
        xDROutputStream.putInt(this.demandFlushAmount);
        xDROutputStream.putInt(this.demandFlushThreshold);
        xDROutputStream.putFixedOpaque(this.reserved1, 12);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

