/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0912api01.symbol;

import devmgr.v0912api01.jrpc.RPCError;
import devmgr.v0912api01.jrpc.XDRInputStream;
import devmgr.v0912api01.jrpc.XDROutputStream;
import devmgr.v0912api01.jrpc.XDRType;
import devmgr.v0912api01.symbol.ComponentRef;
import devmgr.v0912api01.symbol.Location;
import devmgr.v0912api01.symbol.PowerSupplyStatus;
import devmgr.v0912api01.symbol.SYMbolAPIConstants;

public class PowerSupply
implements XDRType,
SYMbolAPIConstants {
    private ComponentRef powerSupplyRef = new ComponentRef();
    private PowerSupplyStatus status = new PowerSupplyStatus();
    private Location physicalLocation = new Location();
    private String partNumber;
    private String serialNumber;
    private String vendorName;
    private long manufacturerDate;
    private String fruType;
    private byte[] reserved1;
    private byte[] reserved2;

    public PowerSupply() {
    }

    public PowerSupply(PowerSupply powerSupply) {
        this.powerSupplyRef = powerSupply.powerSupplyRef;
        this.status = powerSupply.status;
        this.physicalLocation = powerSupply.physicalLocation;
        this.partNumber = powerSupply.partNumber;
        this.serialNumber = powerSupply.serialNumber;
        this.vendorName = powerSupply.vendorName;
        this.manufacturerDate = powerSupply.manufacturerDate;
        this.fruType = powerSupply.fruType;
        this.reserved1 = powerSupply.reserved1;
        this.reserved2 = powerSupply.reserved2;
    }

    public String getFruType() {
        return this.fruType;
    }

    public long getManufacturerDate() {
        return this.manufacturerDate;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public ComponentRef getPowerSupplyRef() {
        return this.powerSupplyRef;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public PowerSupplyStatus getStatus() {
        return this.status;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setFruType(String string) {
        this.fruType = string;
    }

    public void setManufacturerDate(long l) {
        this.manufacturerDate = l;
    }

    public void setPartNumber(String string) {
        this.partNumber = string;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public void setPowerSupplyRef(ComponentRef componentRef) {
        this.powerSupplyRef = componentRef;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public void setStatus(PowerSupplyStatus powerSupplyStatus) {
        this.status = powerSupplyStatus;
    }

    public void setVendorName(String string) {
        this.vendorName = string;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.powerSupplyRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.partNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.serialNumber = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.vendorName = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.manufacturerDate = xDRInputStream.getLong();
        }
        if (xDRInputStream.getPosition() < n) {
            this.fruType = xDRInputStream.getString();
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(8);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.powerSupplyRef.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        xDROutputStream.putString(this.partNumber);
        xDROutputStream.putString(this.serialNumber);
        xDROutputStream.putString(this.vendorName);
        xDROutputStream.putLong(this.manufacturerDate);
        xDROutputStream.putString(this.fruType);
        xDROutputStream.putFixedOpaque(this.reserved1, 8);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

