/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0912api01.symbol;

import devmgr.v0912api01.jrpc.RPCError;
import devmgr.v0912api01.jrpc.XDRInputStream;
import devmgr.v0912api01.jrpc.XDROutputStream;
import devmgr.v0912api01.jrpc.XDRType;
import devmgr.v0912api01.symbol.SYMbolAPIConstants;
import devmgr.v0912api01.symbol.VolumeGroupSummary;

public class AutoConfigSummary
implements XDRType,
SYMbolAPIConstants {
    private int totalVolumeGroups;
    private int hotSpareCount;
    private int unassignedCount;
    private VolumeGroupSummary[] volumeGroupSummary;

    public AutoConfigSummary() {
    }

    public AutoConfigSummary(AutoConfigSummary autoConfigSummary) {
        this.totalVolumeGroups = autoConfigSummary.totalVolumeGroups;
        this.hotSpareCount = autoConfigSummary.hotSpareCount;
        this.unassignedCount = autoConfigSummary.unassignedCount;
        this.volumeGroupSummary = autoConfigSummary.volumeGroupSummary;
    }

    public int getHotSpareCount() {
        return this.hotSpareCount;
    }

    public int getTotalVolumeGroups() {
        return this.totalVolumeGroups;
    }

    public int getUnassignedCount() {
        return this.unassignedCount;
    }

    public VolumeGroupSummary[] getVolumeGroupSummary() {
        return this.volumeGroupSummary;
    }

    public void setHotSpareCount(int n) {
        this.hotSpareCount = n;
    }

    public void setTotalVolumeGroups(int n) {
        this.totalVolumeGroups = n;
    }

    public void setUnassignedCount(int n) {
        this.unassignedCount = n;
    }

    public void setVolumeGroupSummary(VolumeGroupSummary[] volumeGroupSummaryArray) {
        this.volumeGroupSummary = volumeGroupSummaryArray;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.totalVolumeGroups = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.hotSpareCount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.unassignedCount = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            int n2 = xDRInputStream.getInt();
            this.volumeGroupSummary = new VolumeGroupSummary[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.volumeGroupSummary[n3] = new VolumeGroupSummary();
                this.volumeGroupSummary[n3].xdrDecode(xDRInputStream);
                ++n3;
            }
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        xDROutputStream.putInt(this.totalVolumeGroups);
        xDROutputStream.putInt(this.hotSpareCount);
        xDROutputStream.putInt(this.unassignedCount);
        int n2 = this.volumeGroupSummary == null ? 0 : this.volumeGroupSummary.length;
        xDROutputStream.putInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            this.volumeGroupSummary[n3].xdrEncode(xDROutputStream);
            ++n3;
        }
        xDROutputStream.setLength(n);
    }
}

