/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0912api01.jrpc;

import devmgr.v0912api01.jrpc.RPCClientGeneric;
import devmgr.v0912api01.jrpc.RPCError;
import devmgr.v0912api01.jrpc.UDPChannel;
import devmgr.v0912api01.jrpc.UDPMessageBundle;
import devmgr.v0912api01.jrpc.XDRMessageIOV;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;

class RPCClientUDP
extends RPCClientGeneric {
    private static final int DEFAULT_TIMEOUT = 25;
    private long m_Timeout = 25000L;
    private InetAddress m_ServerAddress;
    private int m_ServerPort;
    private UDPChannel m_Channel = null;

    RPCClientUDP(InetAddress inetAddress, int n, int n2, int n3) throws RPCError, IOException {
        super(n, n2);
        this.m_ServerAddress = inetAddress;
        this.m_ServerPort = n3;
        this.m_Channel = new UDPChannel(new DatagramSocket());
    }

    public void close() throws IOException {
        this.m_Channel.close();
        this.m_Channel = null;
    }

    private int fetchXid(XDRMessageIOV xDRMessageIOV) {
        byte[] byArray = xDRMessageIOV.getBuffer(0);
        int n = byArray.length < 4 ? -1 : (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return n;
    }

    protected void finalize() throws Throwable {
        if (this.m_Channel != null) {
            this.m_Channel.close();
        }
    }

    public InetAddress getDestinationIP() {
        return this.m_ServerAddress;
    }

    public InetAddress getLocalAddress() {
        return this.m_Channel.getLocalAddress();
    }

    public void setTimeout(int n) throws IOException {
        this.m_Timeout = n * 1000;
        if (n == 0) {
            this.m_Channel.setTimeout(0);
        }
    }

    public XDRMessageIOV transact(XDRMessageIOV xDRMessageIOV, int n) throws RPCError, IOException {
        boolean bl = false;
        UDPMessageBundle uDPMessageBundle = null;
        UDPMessageBundle uDPMessageBundle2 = null;
        XDRMessageIOV xDRMessageIOV2 = null;
        uDPMessageBundle = new UDPMessageBundle(xDRMessageIOV, this.m_ServerAddress, this.m_ServerPort);
        this.m_Channel.sendMsg(uDPMessageBundle);
        Date date = new Date();
        while (!bl) {
            if (this.m_Timeout > 0L) {
                Date date2 = new Date();
                long l = date2.getTime() - date.getTime();
                if (l > this.m_Timeout) {
                    throw new RPCError("TIMEOUT");
                }
                this.m_Channel.setTimeout((int)(this.m_Timeout - l) + 1);
            }
            if (this.fetchXid(xDRMessageIOV2 = (uDPMessageBundle2 = this.m_Channel.receiveMsg()).getMsg()) != n) {
                xDRMessageIOV2 = null;
                continue;
            }
            bl = true;
        }
        return xDRMessageIOV2;
    }
}

