/*
 * Decompiled with CFR 0.152.
 */
package devmgr.trace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class TraceMessageBox
extends JDialog {
    GridBagLayout m_TextPanelLayout = new GridBagLayout();
    Insets m_TextAreaInsets = new Insets(15, 15, 0, 15);
    JPanel m_TextPanel;
    JTextArea m_Text;
    JPanel m_ButtonPanel;
    JButton m_OkButton;
    boolean m_ComponentsAdjusted = false;

    public TraceMessageBox(Window window, String string, String string2) {
        this.setupMessageBox(string, string2);
        this.setLocationRelativeTo(window);
        super.setModal(true);
        this.addWindowListener(new SymWindow());
        this.getRootPane().registerKeyboardAction(new EscapeListener(), KeyStroke.getKeyStroke(27, 0, false), 2);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.m_ComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + dimension.width, this.getInsets().top + this.getInsets().bottom + dimension.height);
        Component[] componentArray = this.getContentPane().getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(this.getInsets().left, this.getInsets().top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.m_ComponentsAdjusted = true;
    }

    public void dispose() {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        }
        super.dispose();
    }

    private void setupMessageBox(String string, String string2) {
        BorderLayout borderLayout = new BorderLayout(0, 0);
        Dimension dimension = this.getSize();
        int n = 0;
        this.getContentPane().setLayout(borderLayout);
        this.setResizable(false);
        ((Component)this).setVisible(false);
        ((Component)this).setSize(200, 150);
        this.m_TextPanel = new JPanel();
        this.m_TextPanel.setLayout(this.m_TextPanelLayout);
        this.m_TextPanel.setBounds(0, 0, 200, 100);
        this.getContentPane().add("Center", this.m_TextPanel);
        this.m_Text = new JTextArea();
        this.m_Text.setText("");
        this.m_Text.setMargin(new Insets(0, 0, 0, 0));
        this.m_Text.setLineWrap(true);
        this.m_Text.setWrapStyleWord(true);
        this.m_Text.setSelectionColor(new Color(0));
        this.m_Text.setDisabledTextColor(new Color(0));
        this.m_Text.setFont(new Font("SansSerif", 0, 12));
        this.m_Text.setEditable(false);
        this.m_Text.setEnabled(false);
        this.m_Text.setBorder(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = this.m_TextAreaInsets;
        this.m_TextPanelLayout.setConstraints(this.m_Text, gridBagConstraints);
        this.m_TextPanel.add(this.m_Text);
        this.m_ButtonPanel = new JPanel();
        this.m_ButtonPanel.setLayout(new FlowLayout(1, 20, 12));
        this.getContentPane().add("South", this.m_ButtonPanel);
        this.m_OkButton = new JButton();
        this.m_OkButton.setText("OK");
        this.m_ButtonPanel.add(this.m_OkButton);
        this.m_OkButton.addActionListener(new ButtonListener());
        n = this.m_ButtonPanel.getPreferredSize().height + this.m_TextAreaInsets.top + this.m_TextAreaInsets.bottom;
        Rectangle rectangle = this.m_Text.getBounds();
        rectangle.height = dimension.height - n;
        rectangle.width = dimension.width - this.m_TextAreaInsets.left - this.m_TextAreaInsets.right;
        this.m_Text.setBounds(rectangle);
        this.m_Text.setText(string2);
        this.setTitle(string);
        this.addWindowListener(new DialogWindowListener());
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ((Component)TraceMessageBox.this).setVisible(false);
            TraceMessageBox.this.dispose();
        }
    }

    private class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TraceMessageBox.this.dispatchEvent(new WindowEvent(TraceMessageBox.this, 201));
        }
    }

    class EscapeListener
    implements ActionListener {
        EscapeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TraceMessageBox.this.dispatchEvent(new WindowEvent(TraceMessageBox.this, 201));
        }
    }

    class DialogWindowListener
    extends WindowAdapter {
        DialogWindowListener() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            ((Component)TraceMessageBox.this).setBackground(TraceMessageBox.this.m_TextPanel.getBackground());
            TraceMessageBox.this.m_Text.setBackground(TraceMessageBox.this.m_TextPanel.getBackground());
            TraceMessageBox.this.m_OkButton.requestFocus();
        }
    }
}

