/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class VCanvas
extends Canvas
implements FocusListener,
ActionListener,
KeyListener,
MouseListener,
MouseMotionListener,
ComponentListener {
    static int deltaX = 0;
    static int deltaY = 0;
    public Graph graph;
    private int mode;
    protected static final int EDIT = 1;
    public static int last_x;
    public static int last_y;
    public static int last_x2;
    public static int last_y2;
    public Image img;
    public VertexApplet applet;
    public static Node saveNode;
    private Dimension imageSize;
    Point labelOffset;

    public VCanvas(VertexApplet vertexApplet) {
        this.graph = new Graph(vertexApplet);
        this.mode = 1;
        this.applet = vertexApplet;
        this.img = null;
        this.imageSize = new Dimension(0, 0);
        this.labelOffset = null;
        try {
            this.initListen();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void adjustFont(int n) {
    }

    public void adjustFonts(int n) {
    }

    public boolean alt(int n) {
        return (n & 2) != 0;
    }

    public boolean buttonLeft(int n) {
        return (n & 0x10) != 0;
    }

    public boolean buttonRight(int n) {
        return (n & 4) != 0;
    }

    public void clearAllSelected() {
        int n = 0;
        while (n < this.graph.vertices.size()) {
            Node node = (Node)this.graph.vertices.elementAt(n);
            node.selected = false;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.graph.edges.size()) {
            Edge edge = (Edge)this.graph.edges.elementAt(n2);
            edge.selected = false;
            ++n2;
        }
        this.repaint(0L);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.img = null;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void deleteAll() {
        this.graph.vertices.removeAllElements();
        this.graph.edges.removeAllElements();
        this.repaint(0L);
    }

    public void deleteChar() {
    }

    public void deleteObject() {
    }

    String describe(String string) {
        String string2 = string.substring(0, 1);
        String string3 = string2.equals("p") ? "Port " + string.substring(1) : (string2.equals("d") ? "Disk " + string.substring(1) : (string2.equals("h") ? "Hba " + string.substring(1) : (string2.equals("s") ? "Ses " + string.substring(1) : string)));
        return string3;
    }

    public boolean doubleClick(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return mouseEvent.getClickCount() == 2 && n != 4 && n != 4;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public final Edge hitEdgeLabel(int n, int n2) {
        int n3 = this.graph.edges.size();
        int n4 = 0;
        while (n4 < n3) {
            Edge edge = (Edge)this.graph.edges.elementAt(n4);
            if (edge.hitLabel(n, n2)) {
                return edge;
            }
            ++n4;
        }
        return null;
    }

    public final Edge hitErrorEdge(int n, int n2) {
        int n3 = this.graph.edges.size();
        int n4 = 0;
        while (n4 < n3) {
            Edge edge = (Edge)this.graph.edges.elementAt(n4);
            Object var6_6 = null;
            if (edge.inside(n, n2) != null) {
                return edge;
            }
            ++n4;
        }
        return null;
    }

    public final Node hitNode(int n, int n2) {
        int n3 = this.graph.vertices.size();
        int n4 = 0;
        while (n4 < n3) {
            Node node = (Node)this.graph.vertices.elementAt(n4);
            String string = null;
            string = node.inside(n, n2);
            if (string != null) {
                node.clickedComponent = string;
                return node;
            }
            ++n4;
        }
        return null;
    }

    private final void initListen() {
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 127: {
                if (keyEvent.getModifiers() == 0) {
                    this.deleteChar();
                    break;
                }
                this.deleteObject();
                break;
            }
            case 38: {
                if (keyEvent.getModifiers() == 0) {
                    this.adjustFont(1);
                    break;
                }
                this.adjustFonts(1);
                break;
            }
            case 40: {
                if (keyEvent.getModifiers() == 0) {
                    this.adjustFont(-1);
                    break;
                }
                this.adjustFonts(-1);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (this.mouseDraggedNode(n2, n = mouseEvent.getY(), mouseEvent)) {
            return;
        }
        if (this.graph.lasso.x != 0) {
            this.graph.lasso.width = n2 - this.graph.lasso.x;
            this.graph.lasso.height = n - this.graph.lasso.y;
            this.repaint(0L);
        }
    }

    public final boolean mouseDraggedEdge(int n, int n2, MouseEvent mouseEvent) {
        return false;
    }

    public final boolean mouseDraggedNode(int n, int n2, MouseEvent mouseEvent) {
        if (saveNode == null) {
            return false;
        }
        Graphics graphics = this.img.getGraphics();
        int n3 = n - deltaX - (int)(this.applet.scale * (float)VCanvas.saveNode.position.x);
        int n4 = n2 - deltaY - (int)(this.applet.scale * (float)VCanvas.saveNode.position.y);
        Object var7_7 = null;
        int n5 = 0;
        while (n5 < this.graph.vertices.size()) {
            Node node = (Node)this.graph.vertices.elementAt(n5);
            if (node.selected) {
                if (node == saveNode) {
                    node.paintXOR(graphics, n - deltaX, n2 - deltaY);
                } else {
                    node.paintXOR(graphics, (int)((float)node.position.x * this.applet.scale) + n3, (int)((float)node.position.y * this.applet.scale) + n4);
                }
            }
            ++n5;
        }
        this.repaint(0L);
        return true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.labelOffset = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Edge edge;
        Node node;
        int n = 2;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 1) == 0) {
            this.clearAllSelected();
        }
        if (this.pressedOnNode(node = this.hitNode(n2, n3), mouseEvent)) {
            deltaX = (int)((float)n2 - (float)node.position.x * this.applet.scale);
            deltaY = (int)((float)n3 - (float)node.position.y * this.applet.scale);
            saveNode = node;
            this.applet.saveInfo(node.info());
            return;
        }
        if (mouseEvent.getModifiers() != 4) {
            this.clearAllSelected();
            saveNode = null;
            deltaY = 0;
            deltaX = 0;
            this.graph.lasso.x = n2;
            this.graph.lasso.y = n3;
        }
        if (this.pressedOnErrorEdge(edge = this.hitErrorEdge(n2, n3), mouseEvent)) {
            String string = edge.info();
            this.applet.saveInfo(string);
            return;
        }
        if (this.pressedOnEdgeLabel(this.hitEdgeLabel(n2, n3), mouseEvent)) {
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Node node = null;
        boolean bl = false;
        this.applet.selectedNode = null;
        this.applet.selectedEdge = null;
        this.applet.selectedAlign = null;
        this.applet.selectedZoom = 0;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = 2;
        int n4 = mouseEvent.getModifiers();
        if (this.buttonLeft(n4)) {
            if (this.graph.lasso.x != 0) {
                Rectangle rectangle = new Rectangle((int)((float)this.graph.lasso.x / this.applet.scale), (int)((float)this.graph.lasso.y / this.applet.scale), (int)((float)this.graph.lasso.width / this.applet.scale), (int)((float)this.graph.lasso.height / this.applet.scale));
                int n5 = 0;
                while (n5 < this.graph.vertices.size()) {
                    Node node2 = (Node)this.graph.vertices.elementAt(n5);
                    if (node2.position.x > rectangle.x && node2.position.y > rectangle.y && node2.position.x < rectangle.x + rectangle.width && node2.position.y < rectangle.y + rectangle.height) {
                        node2.selected = true;
                        bl = true;
                    }
                    ++n5;
                }
                this.graph.clearLasso();
                this.repaint(5L);
            }
            if (saveNode != null) {
                saveNode = null;
                this.repaint(5L);
            }
            return;
        }
        if (this.shift(n4) && this.buttonRight(n4) && saveNode != null) {
            this.applet.selectedAlign = saveNode;
            this.applet.alignPopup.show(mouseEvent.getComponent(), n, n2);
            return;
        }
        if (!this.shift(n4) && this.buttonRight(n4)) {
            node = this.hitNode(n, n2);
            if (node != null) {
                this.applet.popup.setLabel(node.label);
                int n6 = node.label.indexOf(":");
                if (n6 < 0) {
                    return;
                }
                char c = node.NodeType;
                String string = node.label.substring(0, n6);
                String string2 = node.name;
                String string3 = node.clickedComponent.equals("e") ? " (" + string + ":" + node.clickedComponent + ")" : (node.clickedComponent.substring(0, 1).equals("h") ? " (" + string + ":" + node.clickedComponent + ")" : " (" + string + ":" + node.clickedComponent.substring(1) + ")");
                this.applet.selectedNode = node;
                int n7 = 0;
                if (VertexApplet.dropMenusCnt <= 2) {
                    String string4 = String.valueOf(this.applet.dropMenus[1][0]) + " " + string3 + " ";
                    this.applet.launch(node, string4, null);
                } else {
                    int n8 = 1;
                    while (n8 <= VertexApplet.dropMenusCnt) {
                        if (this.applet.dropMenus[n8][2].length() <= 0 || this.applet.dropMenus[n8][2].indexOf(c) < 0) {
                            this.applet.popup.getItem(n7).setEnabled(true);
                            this.applet.popup.getItem(n7).setLabel(String.valueOf(this.applet.dropMenus[n8][0]) + " " + string3 + "   ");
                            ++n7;
                        }
                        ++n8;
                    }
                    while (n7 < VertexApplet.dropMenusCnt) {
                        this.applet.popup.getItem(n7).setEnabled(false);
                        this.applet.popup.getItem(n7).setLabel("   ");
                        ++n7;
                    }
                    this.applet.popup.show(mouseEvent.getComponent(), n, n2);
                }
            } else {
                Edge edge = this.hitErrorEdge(n, n2);
                if (edge != null) {
                    this.applet.linkPopup.setLabel("Link Info");
                    String string = edge.label2;
                    int n9 = 1;
                    while (n9 <= VertexApplet.linkMenusCnt) {
                        this.applet.linkPopup.getItem(n9 - 1).setLabel(this.applet.linkMenus[n9][0]);
                        ++n9;
                    }
                    this.applet.selectedEdge = edge;
                    this.applet.linkPopup.show(mouseEvent.getComponent(), n, n2);
                } else {
                    this.applet.zoomPopup.setLabel(String.valueOf(this.applet.zoomLabel) + "=" + this.applet.zoom);
                    this.applet.selectedZoom = 1;
                    this.applet.zoomPosition.x = n;
                    this.applet.zoomPosition.y = n2;
                    this.applet.zoomPopup.show(mouseEvent.getComponent(), n, n2);
                }
            }
        }
    }

    public final void paint(Graphics graphics) {
        if (this.img == null) {
            this.imageSize = this.getSize();
            this.img = this.createImage(this.imageSize.width, this.imageSize.height);
        }
        Graphics graphics2 = this.img.getGraphics();
        if (saveNode == null) {
            if (this.graph.lasso.x > 0) {
                this.graph.paintLasso(graphics2);
            } else {
                this.paintParts(graphics2);
            }
        }
        graphics.drawImage(this.img, 0, 0, null);
    }

    private final void paintParts(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.imageSize.width, this.imageSize.height);
        this.graph.paint(graphics);
    }

    public boolean pressedOnEdge(Edge edge, MouseEvent mouseEvent) {
        if (edge == null) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.select(edge);
        return true;
    }

    public boolean pressedOnEdgeLabel(Edge edge, MouseEvent mouseEvent) {
        if (edge == null) {
            return false;
        }
        this.labelOffset = new Point(mouseEvent.getX() - edge.labelBase.x, mouseEvent.getY() - edge.labelBase.y);
        this.select(edge);
        return true;
    }

    public final boolean pressedOnErrorEdge(Edge edge, MouseEvent mouseEvent) {
        if (edge == null) {
            return false;
        }
        this.select(edge);
        return true;
    }

    public final boolean pressedOnNode(Node node, MouseEvent mouseEvent) {
        if (node == null) {
            return false;
        }
        if ((mouseEvent.getModifiers() & 1) != 0) {
            node.selected = true;
        } else {
            this.clearAllSelected();
            node.selected = true;
        }
        return true;
    }

    public boolean pressedOnNodeLabel(Node node, MouseEvent mouseEvent) {
        return false;
    }

    public void repaintGraph() {
        this.resetVertices();
        this.repaint(0L);
    }

    public final void resetVertices() {
        saveNode = null;
        deltaY = 0;
        deltaX = 0;
        int n = 0;
        while (n < this.graph.vertices.size()) {
            Node node = (Node)this.graph.vertices.elementAt(n);
            node.reset();
            ++n;
        }
    }

    private final void select(Selectable selectable) {
        Selectable.select(selectable);
    }

    public void setEditMode() {
        this.mode = 1;
    }

    public void setViewMode() {
        this.mode = 0;
    }

    public boolean shift(int n) {
        return (n & 1) != 0;
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }
}

