/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.util;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class StoradeDate
implements Serializable {
    private Date date;
    private String dateString;
    public static final String cvs_id = "$Id: StoradeDate.java,v 1.7 2004/10/13 18:10:10 jkremer Exp $";

    public StoradeDate(String dateString) {
        this.dateString = dateString == null ? null : dateString.trim();
    }

    public StoradeDate(Date date) {
        this.date = date;
    }

    public StoradeDate() {
        this.date = new Date();
    }

    public String toString() {
        return this.getDateString();
    }

    public String getDateString() {
        if (this.dateString != null) {
            return this.dateString;
        }
        if (this.date == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(2);
        buf.append(cal.get(1));
        buf.append("-");
        buf.append(nf.format(cal.get(2) + 1));
        buf.append("-");
        buf.append(nf.format(cal.get(5)));
        buf.append(" ");
        buf.append(nf.format(cal.get(11)));
        buf.append(":");
        buf.append(nf.format(cal.get(12)));
        buf.append(":");
        buf.append(nf.format(cal.get(13)));
        return buf.toString();
    }

    public Date getDate() {
        if (this.date != null) {
            return this.date;
        }
        if (this.dateString == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.parse(this.dateString, new ParsePosition(0));
        }
        catch (Exception e) {
            return null;
        }
    }
}

