/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.util;

import com.sun.netstorage.fm.storade.util.ResourceLock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.LinkedList;

public class LockManager {
    public static final String FRU_SEPARATOR = "~";
    public static final String LOCK_DIR = "/tmp/MgmtLocks";
    public static final String MASTERLOCK = "MASTERLOCK";
    public static final String LOCK_EXT = ".lock";
    private String[] resourceNames;
    private FileLock masterLock;
    private FileOutputStream masterStream;
    private FileChannel masterChannel;
    private long lockTime;
    private String application = "Java";
    private String description = "";
    private String ip_address = "localhost";
    private String userName = "nobody";
    private static String pid = LockManager.setDefaultPID();
    private static boolean TRACE;
    public static final String sccs_id = "$Revision";

    public LockManager(String resourceName) {
        this.resourceNames = new String[]{resourceName};
    }

    public LockManager(String[] resourceNames) {
        this.resourceNames = resourceNames;
    }

    public void setInfo(String application, String description, String ip_address, String userName) {
        this.application = application;
        this.description = description;
        this.ip_address = ip_address;
        this.userName = userName;
    }

    public synchronized boolean lock(int length, int wait) {
        long waitTime = System.currentTimeMillis() + (long)(wait * 1000);
        do {
            boolean locked;
            if (locked = this.lock(length)) {
                return true;
            }
            try {
                this.wait(5000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < waitTime);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean lock(int length) {
        try {
            if (this.lockMaster()) {
                long curTime = System.currentTimeMillis() / 1000L;
                long expTime = curTime + (long)length;
                ResourceLock[] locks = new ResourceLock[this.resourceNames.length];
                for (int i = 0; i < this.resourceNames.length; ++i) {
                    locks[i] = new ResourceLock(this.resourceNames[i]);
                    locks[i].readLock();
                    if (locks[i].isLocked()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (locks[i].isFRULocked()) {
                        boolean bl = false;
                        return bl;
                    }
                    locks[i].setInfo(this.application, this.description, this.ip_address, this.userName);
                }
                boolean bl = this.dolocks(locks, expTime);
                return bl;
            }
            boolean curTime = false;
            return curTime;
        }
        catch (Exception e) {
            if (TRACE) {
                e.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlockMaster();
        }
    }

    public synchronized void unlock() throws IOException {
        for (int i = 0; i < this.resourceNames.length; ++i) {
            ResourceLock lock = new ResourceLock(this.resourceNames[i]);
            lock.readLock();
            lock.unlock();
        }
    }

    public boolean isLocked() {
        return this.lockTime > System.currentTimeMillis();
    }

    public boolean checkLocked() throws IOException {
        for (int i = 0; i < this.resourceNames.length; ++i) {
            ResourceLock lock = new ResourceLock(this.resourceNames[i]);
            lock.readLock();
            if (lock.isLocked()) {
                return true;
            }
            if (!lock.isFRULocked()) continue;
            return true;
        }
        return false;
    }

    public static String getPid() {
        return pid;
    }

    private boolean dolocks(ResourceLock[] locks, long expTime) throws IOException {
        int i;
        boolean locked;
        block5: {
            locked = false;
            try {
                for (i = 0; i < locks.length; ++i) {
                    locks[i].lock(expTime, null);
                }
                this.lockTime = expTime;
                locked = true;
            }
            catch (Exception e) {
                if (!TRACE) break block5;
                e.printStackTrace();
            }
        }
        if (!locked) {
            for (i = 0; i < locks.length; ++i) {
                locks[i].unlock();
            }
        }
        return locked;
    }

    private synchronized boolean lockMaster() {
        return this.lockMaster(false);
    }

    private synchronized boolean lockMaster(boolean doBlock) {
        if (this.masterLock != null) {
            return true;
        }
        try {
            File lockDir = new File(LOCK_DIR);
            lockDir.mkdirs();
            File masterFile = new File(LOCK_DIR, MASTERLOCK);
            masterFile.createNewFile();
            this.masterStream = new FileOutputStream(masterFile);
            this.masterChannel = this.masterStream.getChannel();
            this.masterLock = doBlock ? this.masterChannel.lock() : this.masterChannel.tryLock();
            if (this.masterLock.isValid()) {
                PrintWriter out = new PrintWriter(this.masterStream);
                out.println(LockManager.getMasterExpire());
                out.println(LockManager.getPid());
                out.println(this.toString());
                out.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (TRACE) {
                e.printStackTrace();
            }
            this.unlockMaster();
            return false;
        }
    }

    private void clearMaster() {
        block2: {
            try {
                File masterFile = new File(LOCK_DIR, MASTERLOCK);
                FileWriter out = new FileWriter(masterFile);
                out.write(48);
                out.write(10);
                out.close();
            }
            catch (IOException ioe1) {
                if (!TRACE) break block2;
                ioe1.printStackTrace();
            }
        }
    }

    private void unlockMaster() {
        block11: {
            block10: {
                block9: {
                    try {
                        if (this.masterLock != null && this.masterLock.isValid()) {
                            this.clearMaster();
                            this.masterLock.release();
                        }
                    }
                    catch (IOException ioe1) {
                        if (!TRACE) break block9;
                        ioe1.printStackTrace();
                    }
                }
                try {
                    if (this.masterChannel != null) {
                        this.masterChannel.close();
                    }
                }
                catch (IOException ioe2) {
                    if (!TRACE) break block10;
                    ioe2.printStackTrace();
                }
            }
            try {
                if (this.masterStream != null) {
                    this.masterStream.close();
                }
            }
            catch (IOException ioe3) {
                if (!TRACE) break block11;
                ioe3.printStackTrace();
            }
        }
        this.masterLock = null;
        this.masterChannel = null;
        this.masterStream = null;
    }

    private void finishedOp() {
        this.notify();
    }

    private synchronized boolean lockMaster(long limit) {
        MasterLocker ml = new MasterLocker();
        Thread t = new Thread(ml);
        t.start();
        long startTime = System.currentTimeMillis();
        try {
            this.wait(limit);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this.masterLock != null) {
            return true;
        }
        if (startTime + limit >= System.currentTimeMillis()) {
            ml.setTimedOut();
            return false;
        }
        return false;
    }

    private static String setDefaultPID() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    private static String getMasterExpire() {
        return Long.toString(System.currentTimeMillis() / 1000L + 30L);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage ResourceLock <command> [args]");
            System.err.println("Commands: lock   <seconds> [resources]");
            System.err.println("          unlock <seconds> [resources]");
            System.err.println("          check  [resources]");
            System.exit(-1);
        }
        TRACE = true;
        try {
            if ("lock".equals(args[0])) {
                int duration = Integer.parseInt(args[1]);
                String[] res = new String[args.length - 2];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = args[i + 2];
                }
                LockManager lm = new LockManager(res);
                if (lm.lock(duration)) {
                    System.out.println("locked!");
                } else {
                    System.out.println("lock failure");
                }
            } else if ("unlock".equals(args[0])) {
                int duration = Integer.parseInt(args[1]);
                String[] res = new String[args.length - 2];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = args[i + 2];
                }
                LockManager lm = new LockManager(res);
                if (lm.checkLocked()) {
                    lm.unlock();
                    System.out.println("unlocked.");
                } else {
                    System.out.println("Resources already unlocked.");
                }
            } else if ("check".equals(args[0])) {
                String[] res = new String[args.length - 1];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = args[i + 1];
                }
                LockManager lm = new LockManager(res);
                System.out.println("Locked=" + lm.checkLocked());
                for (int i = 0; i < res.length; ++i) {
                    ResourceLock rl = new ResourceLock(res[i]);
                    rl.readLock();
                    System.out.println("Resource=" + rl.getResourceName());
                    System.out.println("Application=" + rl.getApplication());
                    System.out.println("Description=" + rl.getDescription());
                    System.out.println("StartDate=" + rl.getStartDate());
                    System.out.println("Duration=" + rl.getDuration());
                    System.out.println("IP=" + rl.getIpAddress());
                    System.out.println("User=" + rl.getUser());
                }
            } else {
                System.err.println("Unknown command " + args[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ResourceLock[] listLocks() throws IOException {
        LinkedList<ResourceLock> lockList = new LinkedList<ResourceLock>();
        File lockDir = new File(LOCK_DIR);
        String[] files = lockDir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String resource = files[i];
                if (!resource.endsWith(LOCK_EXT)) continue;
                int end = resource.length() - LOCK_EXT.length();
                ResourceLock lock = new ResourceLock(resource.substring(0, end));
                lock.readLock();
                lockList.add(lock);
            }
        }
        ResourceLock[] locks = new ResourceLock[lockList.size()];
        lockList.toArray(locks);
        return locks;
    }

    private class MasterLocker
    implements Runnable {
        private boolean timedOut;
        private long limit;

        private MasterLocker() {
        }

        public void run() {
            boolean locked = LockManager.this.lockMaster(true);
            LockManager.this.finishedOp();
            if (this.timedOut) {
                LockManager.this.unlockMaster();
            }
        }

        public void setTimedOut() {
            this.timedOut = true;
        }
    }
}

