/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.service.device;

import com.sun.netstorage.fm.storade.service.alarm.AlarmCounts;
import com.sun.netstorage.fm.storade.service.alarm.AlarmSeverity;
import com.sun.netstorage.fm.storade.util.StoradeDate;
import java.net.InetAddress;
import java.util.Date;
import java.util.Properties;

public class DeviceSummary {
    private String key;
    private String name;
    private String displayName;
    private String wwn;
    private String ipno;
    private boolean monitored;
    private String monitoringAgent;
    private Date lastScanTime;
    private String category;
    private String vendor;
    private String model;
    private String description;
    private String caption;
    private AlarmCounts alarms;
    public static final String _SOURCE_REVISION = "$Revision: 1.3 $";

    public DeviceSummary(Properties p) {
        int cindex;
        this.key = p.getProperty("key");
        this.displayName = p.getProperty("displayName");
        this.name = p.getProperty("displayName");
        this.wwn = p.getProperty("wwn");
        this.monitored = "Y".equals(p.getProperty("monitored"));
        this.monitoringAgent = p.getProperty("monitoringAgent");
        this.lastScanTime = new StoradeDate(p.getProperty("lastScanTime")).getDate();
        String devClass = p.getProperty("class");
        if (devClass != null && (cindex = devClass.indexOf(".")) > 0) {
            devClass = devClass.substring(0, cindex);
        }
        this.category = devClass;
        this.vendor = p.getProperty("vendor");
        this.model = p.getProperty("model");
        this.description = p.getProperty("description");
        this.caption = p.getProperty("caption");
        String ip = p.getProperty("ip");
        if (ip != null) {
            try {
                int portIndex = ip.indexOf(":");
                if (portIndex > 0) {
                    ip = ip.substring(0, portIndex);
                }
                InetAddress ipaddr = InetAddress.getByName(ip);
                this.ipno = ipaddr.getHostAddress();
                this.name = ipaddr.getHostName();
            }
            catch (Exception e) {
                this.ipno = p.getProperty("ipno");
            }
        }
        String sev = p.getProperty("alarmSeverity");
        int level = 0;
        if (sev != null) {
            level = AlarmSeverity.mapStoradeSeverity(Integer.parseInt(sev));
        }
        int down = 0;
        int crit = 0;
        int majr = 0;
        int minr = 0;
        if (level == 4) {
            ++down;
        } else if (level == 3) {
            ++crit;
        } else if (level == 2) {
            ++majr;
        } else if (level == 1) {
            ++minr;
        }
        this.alarms = new AlarmCounts(down, crit, majr, minr);
    }

    public String toString() {
        return this.category + "|" + this.displayName + "|" + this.wwn + "|" + this.ipno + "|" + this.vendor + "|" + this.model + "|" + this.description;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getWwn() {
        return this.wwn;
    }

    public void setWwn(String wwn) {
        this.wwn = wwn;
    }

    public String getIpNumber() {
        return this.ipno;
    }

    public void setIpNumber(String ip) {
        this.ipno = this.ipno;
    }

    public boolean getMonitored() {
        return this.monitored;
    }

    public void setMonitored(boolean monitored) {
        this.monitored = monitored;
    }

    public String getMonitoringAgent() {
        return this.monitoringAgent;
    }

    public void setMonitoringAgent(String monitoringAgent) {
        this.monitoringAgent = monitoringAgent;
    }

    public Date getLastScanTime() {
        return this.lastScanTime;
    }

    public void setLastScanTime(Date lastScanTime) {
        this.lastScanTime = lastScanTime;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public AlarmCounts getAlarms() {
        return this.alarms;
    }

    public void setAlarms(AlarmCounts alarms) {
        this.alarms = alarms;
    }
}

