/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.service.device;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class DeviceProperties
implements Serializable {
    public static final String ACTIVE = "active";
    public static final String KEY = "key";
    public static final String HOST = "host";
    public static final String TYPE = "type";
    public static final String CLASS = "class";
    public static final String NAME = "name";
    public static final String LABEL = "userLabel";
    public static final String TIME_ADDED = "time_added";
    public static final String WWN = "wwn";
    public static final String ALT_WWN = "wwn2";
    public static final String WWN_LIST = "wwns";
    public static final String IP = "ip";
    public static final String IPNO = "ipno";
    public static final String ALT_IP = "altip";
    public static final String ALT_IPNO = "altipno";
    public static final String IP_LIST = "iplist";
    public static final String PROXYS = "proxys";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    private Properties dp;
    private static final long serialVersionUID = 40L;
    private static final String CVS_ID = "$Id: DeviceProperties.java,v 1.8 2006/02/02 20:32:03 sbrooks Exp $";

    public DeviceProperties() {
        this.dp = new Properties();
    }

    public DeviceProperties(Properties deviceProperties) {
        this.dp = deviceProperties;
    }

    public String getKey() {
        return this.dp.getProperty(KEY);
    }

    public void setKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.dp.setProperty(KEY, key);
    }

    public String getType() {
        return this.dp.getProperty(TYPE);
    }

    public String getTypeKey() {
        return this.dp.getProperty(TYPE) + ":" + this.dp.getProperty(KEY);
    }

    public void setType(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.dp.setProperty(TYPE, type);
    }

    public String getDevClass() {
        return this.dp.getProperty(CLASS);
    }

    public void setClass(String devClass) {
        if (devClass == null) {
            throw new IllegalArgumentException();
        }
        this.dp.setProperty(CLASS, devClass);
    }

    public boolean getActive() {
        String active = this.dp.getProperty(ACTIVE);
        return "Y".equals(active);
    }

    public void setActive(boolean active) {
        this.dp.setProperty(ACTIVE, active ? "Y" : "N");
    }

    public String getHost() {
        String host = this.dp.getProperty(HOST);
        if (host == null) {
            return "localhost";
        }
        return host;
    }

    public void setHost(String host) {
        if (host == null) {
            this.dp.remove(HOST);
        } else {
            this.dp.setProperty(HOST, host);
        }
    }

    public String getName() {
        return this.dp.getProperty(NAME);
    }

    public void setName(String name) {
        if (name == null) {
            this.dp.remove(NAME);
        } else {
            this.dp.setProperty(NAME, name);
        }
    }

    public String getWWN() {
        return this.dp.getProperty(WWN);
    }

    public void setWWN(String wwn) {
        if (wwn == null) {
            this.dp.remove(WWN);
        } else {
            this.dp.setProperty(WWN, wwn);
        }
    }

    public String[] getWWNs() {
        return this.makeArray(this.dp.getProperty(WWN_LIST));
    }

    public void setWWNs(String[] wwns) {
        this.setValueList(WWN_LIST, wwns);
    }

    public void addWWN(String wwn) {
        this.addValueToList(WWN_LIST, wwn);
    }

    public void removeWWN(String wwn) {
        this.removeValueFromList(WWN_LIST, wwn);
    }

    public String getIP() {
        return this.dp.getProperty(IP);
    }

    public void setIP(String ip) {
        if (ip == null) {
            this.dp.remove(IP);
        } else {
            this.dp.setProperty(IP, ip);
        }
    }

    public void setIPAddress(String ip) throws UnknownHostException {
        if (ip == null) {
            this.dp.remove(IP);
            this.dp.remove(IPNO);
        }
        InetAddress addr = InetAddress.getByName(ip);
        this.dp.setProperty(IP, addr.getHostName());
        this.dp.setProperty(IPNO, addr.getHostAddress());
    }

    public String getIPNumber() {
        return this.dp.getProperty(IPNO);
    }

    public void setIPNumber(String ipno) {
        if (ipno == null) {
            this.dp.remove(IPNO);
        } else {
            this.dp.setProperty(IPNO, ipno);
        }
    }

    public String getAlternateIP() {
        return this.dp.getProperty(ALT_IP);
    }

    public void setAlternateIP(String ip) {
        if (ip == null) {
            this.dp.remove(ALT_IP);
        } else {
            this.dp.setProperty(ALT_IP, ip);
        }
    }

    public String getAlternateIPNumber() {
        return this.dp.getProperty(ALT_IPNO);
    }

    public void setAlternateIPAddress(String ip) throws UnknownHostException {
        if (ip == null) {
            this.dp.remove(ALT_IP);
            this.dp.remove(ALT_IPNO);
        }
        InetAddress addr = InetAddress.getByName(ip);
        this.dp.setProperty(ALT_IP, addr.getHostName());
        this.dp.setProperty(ALT_IPNO, addr.getHostAddress());
    }

    public void setAlternateIPNumber(String ip) {
        if (ip == null) {
            this.dp.remove(ALT_IPNO);
        } else {
            this.dp.setProperty(ALT_IPNO, ip);
        }
    }

    public String[] getManagementAddresses() {
        return this.makeArray(this.dp.getProperty(PROXYS));
    }

    public void setManagementAddresses(String[] adders) {
        this.setValueList(PROXYS, adders);
    }

    public void addManagementAddress(String address) {
        this.addValueToList(PROXYS, address);
    }

    public void removeManagementAddress(String address) {
        this.removeValueFromList(PROXYS, address);
    }

    public void setIPAddresses(String[] adders) throws UnknownHostException {
        this.setValueList(IP_LIST, adders);
        this.syncIPAddresses();
    }

    public void addIPAddress(String address) throws UnknownHostException {
        this.addValueToList(IP_LIST, address);
        this.syncIPAddresses();
    }

    public void removeIPAddress(String address) throws UnknownHostException {
        this.removeValueFromList(IP_LIST, address);
        this.syncIPAddresses();
    }

    public void setIPsFromList(String list) throws UnknownHostException {
        this.dp.setProperty(IP_LIST, list);
        this.syncIPAddresses();
    }

    public String[] getIPAddresses() {
        return this.makeArray(this.dp.getProperty(IP_LIST));
    }

    private void syncIPAddresses() {
        String[] ips = this.getIPAddresses();
        if (ips != null) {
            InetAddress addr;
            if (ips.length > 0) {
                try {
                    addr = InetAddress.getByName(ips[0]);
                    this.setIPAddress(addr.getCanonicalHostName());
                    this.setIPNumber(addr.getHostAddress());
                }
                catch (UnknownHostException uhe) {
                    this.dp.setProperty(IP, ips[0]);
                }
            } else {
                this.dp.remove(IP);
                this.dp.remove(IPNO);
            }
            if (ips.length > 1) {
                try {
                    addr = InetAddress.getByName(ips[1]);
                    this.setAlternateIPAddress(addr.getCanonicalHostName());
                    this.setAlternateIPNumber(addr.getHostAddress());
                }
                catch (UnknownHostException uhe) {
                    this.dp.setProperty(ALT_IP, ips[1]);
                }
            } else {
                this.dp.remove(ALT_IP);
                this.dp.remove(ALT_IPNO);
            }
        }
    }

    public String getPassword() {
        int i;
        String pass = this.dp.getProperty(PASSWORD);
        if (pass == null) {
            return null;
        }
        if ("".equals(pass)) {
            return "";
        }
        int tsize = 0;
        for (i = 0; i < pass.length(); ++i) {
            if ('%' != pass.charAt(i)) continue;
            ++tsize;
        }
        if (tsize == 0) {
            return pass;
        }
        char[] pb = new char[tsize];
        StringTokenizer st = new StringTokenizer(pass, "%");
        i = 0;
        while (st.hasMoreTokens()) {
            int c = Integer.parseInt(st.nextToken(), 16);
            c ^= 0xFFFFFFFF;
            pb[i] = (char)(c -= 13);
            ++i;
        }
        return new String(pb);
    }

    public void setPassword(String password) {
        if (password == null) {
            this.dp.remove(PASSWORD);
        } else {
            StringBuffer encode = new StringBuffer();
            char[] pb = password.toCharArray();
            for (int i = 0; i < pb.length; ++i) {
                int c = pb[i] + 13;
                encode.append(Integer.toHexString(~c & 0xFFFF));
                encode.append("%");
            }
            this.dp.setProperty(PASSWORD, encode.toString());
        }
    }

    public String getUserName() {
        return this.dp.getProperty(USER);
    }

    public void setUserName(String user) {
        if (user == null) {
            this.dp.remove(USER);
        } else {
            this.dp.setProperty(USER, user);
        }
    }

    public String getLabel() {
        return this.dp.getProperty(LABEL);
    }

    public void setLabel(String label) {
        if (label == null) {
            this.dp.remove(LABEL);
        } else {
            this.dp.setProperty(LABEL, label);
        }
    }

    public String getProperty(String name) {
        return this.dp.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.dp.setProperty(name, value);
    }

    public void removeProperty(String name) {
        this.dp.remove(name);
    }

    public void removeProperty(String name, String value) {
        if (value == null || "".equals(value)) {
            this.removeProperty(name);
        } else if (WWN_LIST.equals(name)) {
            this.removeWWN(value);
        } else if (PROXYS.equals(name)) {
            this.removeManagementAddress(value);
        } else {
            this.removeProperty(name);
        }
    }

    public Properties getProperties() {
        return this.dp;
    }

    private String[] makeArray(String values) {
        if (values == null || values.length() == 0) {
            return new String[0];
        }
        Pattern p = Pattern.compile("[,|\\|]");
        return p.split(values);
    }

    private void setValueList(String name, String[] vlist) {
        if (vlist == null || vlist.length == 0) {
            this.dp.remove(name);
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vlist.length; ++i) {
            buf.append(vlist[i]);
            if (i >= vlist.length - 1) continue;
            buf.append(",");
        }
        this.dp.setProperty(name, buf.toString());
    }

    private void addValueToList(String name, String val) {
        if (val == null || val.length() == 0) {
            return;
        }
        String olist = this.dp.getProperty(name);
        if (olist == null || olist.length() == 0) {
            this.dp.setProperty(name, val);
            return;
        }
        Pattern p = Pattern.compile("[,|\\|]");
        String[] nvals = p.split(val);
        String[] ovals = p.split(olist);
        for (int n = 0; n < nvals.length; ++n) {
            for (int i = 0; i < ovals.length; ++i) {
                if (ovals[i] == null || !ovals[i].equals(nvals[n])) continue;
                nvals[n] = null;
            }
        }
        StringBuffer nlist = new StringBuffer();
        nlist.append(olist);
        for (int n = 0; n < nvals.length; ++n) {
            if (nvals[n] == null || "".equals(nvals[n])) continue;
            nlist.append("|");
            nlist.append(nvals[n]);
        }
        this.dp.setProperty(name, nlist.toString());
    }

    private void removeValueFromList(String name, String val) {
        String list = this.dp.getProperty(name);
        if (list == null || "".equals(list)) {
            return;
        }
        if (list.equals(val)) {
            this.dp.remove(name);
            return;
        }
        Pattern p = Pattern.compile("[,|\\|]");
        String[] nvals = p.split(val);
        String[] ovals = p.split(list);
        boolean removed = false;
        for (int i = 0; i < ovals.length; ++i) {
            for (int n = 0; n < nvals.length; ++n) {
                if (!nvals[n].equals(ovals[i])) continue;
                ovals[i] = null;
                removed = true;
            }
        }
        if (removed) {
            StringBuffer sb = new StringBuffer();
            boolean firstEntry = true;
            for (int i = 0; i < ovals.length; ++i) {
                if (ovals[i] == null || "".equals(ovals[i])) continue;
                if (!firstEntry) {
                    sb.append("|");
                } else {
                    firstEntry = false;
                }
                sb.append(ovals[i]);
            }
            this.dp.setProperty(name, sb.toString());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        TreeMap<Object, Object> t = new TreeMap<Object, Object>(this.dp);
        Set<Map.Entry<Object, Object>> s = t.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = s.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            buf.append((String)entry.getKey());
            buf.append("=");
            buf.append((String)entry.getValue());
            buf.append(" ");
        }
        return buf.toString();
    }

    public static final class JunitTest
    extends TestCase {
        public void test_password() throws Exception {
            DeviceProperties dp = new DeviceProperties();
            StringBuffer pwb = new StringBuffer();
            for (int i = 0; i < 1024; ++i) {
                pwb.append((char)i);
            }
            String pw = pwb.toString();
            dp.setPassword(pw);
            JunitTest.assertEquals((String)pw, (String)dp.getPassword());
        }

        public void testList() throws Exception {
            DeviceProperties dp = new DeviceProperties();
            dp.setIPAddresses(new String[]{"localhost", "b"});
            JunitTest.assertEquals((String)"localhost|b", (String)dp.getProperty(DeviceProperties.IP_LIST));
            dp.addIPAddress("c");
            String[] ips = dp.getIPAddresses();
            JunitTest.assertEquals((String)ips[0], (String)"localhost");
            JunitTest.assertEquals((String)ips[1], (String)"b");
            JunitTest.assertEquals((String)ips[2], (String)"c");
            JunitTest.assertEquals((String)dp.getIP(), (String)"localhost");
        }
    }
}

