/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.client.http;

import com.sun.netstorage.fm.storade.client.http.AgentCommand;
import com.sun.netstorage.fm.storade.client.http.AgentError;
import com.sun.netstorage.fm.storade.client.http.ComponentSummaryImpl;
import com.sun.netstorage.fm.storade.client.http.DeviceMaintenanceImpl;
import com.sun.netstorage.fm.storade.client.http.HTTPConnection;
import com.sun.netstorage.fm.storade.client.http.HTTPResponse;
import com.sun.netstorage.fm.storade.client.http.XMLUtil;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.netstorage.fm.storade.service.device.DeviceReportService;
import com.sun.netstorage.fm.storade.service.device.DeviceSummary;
import java.net.URL;
import java.util.LinkedList;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceReportImpl
implements DeviceReportService {
    private URL agent;
    private String user;
    private String credential;
    public static final String cvs_id = "$Id: DeviceReportImpl.java,v 1.8 2005/09/27 16:08:25 jkremer Exp $";

    public DeviceReportImpl(URL agent, String user, String credential) {
        this.agent = agent;
        this.user = user;
        this.credential = credential;
    }

    public DeviceSummary[] getDeviceList() throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Device::getSummary");
        cmd.fastcgi();
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "DEVICE_SUMMARY");
        if (error.isError()) {
            throw error.toException();
        }
        return DeviceReportImpl.parseDeviceSummaryNode(XMLUtil.getNode(resp.getData()));
    }

    public DeviceSummary getDeviceSummary(String key) throws StoradeException {
        if (key == null) {
            throw new IllegalArgumentException("key==null");
        }
        AgentCommand cmd = new AgentCommand("Client::Device::getSummary");
        cmd.fastcgi();
        cmd.setProperty("key", key);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp, "DEVICE_SUMMARY");
        if (error.isError()) {
            throw error.toException();
        }
        DeviceSummary[] ds = DeviceReportImpl.parseDeviceSummaryNode(XMLUtil.getNode(resp.getData()));
        if (ds != null && ds.length > 0) {
            return ds[0];
        }
        throw new StoradeException();
    }

    public Properties getClassProperties(String type) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::Device::classProperties");
        cmd.setProperty("type", type);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isOK()) {
            Properties hp = new Properties();
            Properties dp = new Properties();
            DeviceReportImpl.parseReportDoc(resp.getData(), hp, dp, false);
            return hp;
        }
        throw error.toException();
    }

    public Properties getProperties(String devKey, boolean stdOnly) throws StoradeException {
        DeviceMaintenanceImpl dmi = new DeviceMaintenanceImpl(this.agent, this.user, this.credential);
        DeviceProperties devp = dmi.getDeviceProperties(devKey);
        if (devp == null) {
            throw new StoradeException("id.does.not.exist", new String[]{devKey});
        }
        String key = devp.getType() + ":" + devKey;
        AgentCommand cmd = new AgentCommand("Client::InstrReport::report");
        cmd.setProperty("key", key);
        cmd.setProperty("format", "xml");
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isOK()) {
            Properties hp = new Properties();
            Properties dp = new Properties();
            DeviceReportImpl.parseReportDoc(resp.getData(), hp, dp, stdOnly);
            return dp;
        }
        throw error.toException();
    }

    public Properties getProperties(String devKey, String component, boolean stdOnly) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::InstrReport::component");
        cmd.setProperty("key", devKey);
        if (stdOnly) {
            cmd.setProperty("std", "1");
        }
        cmd.setProperty("comp", component);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isOK()) {
            Properties hp = new Properties();
            Properties dp = new Properties();
            DeviceReportImpl.parseReportDoc(resp.getData(), hp, dp, false);
            return dp;
        }
        throw error.toException();
    }

    public Properties getSystemProperties(String devKey, boolean stdOnly) throws StoradeException {
        HTTPResponse resp;
        AgentError error;
        AgentCommand cmd = new AgentCommand("Client::InstrReport::systemProperties");
        cmd.setProperty("key", devKey);
        if (stdOnly) {
            cmd.setProperty("std", "1");
        }
        if ((error = new AgentError(resp = this.getConnection().getResponse(cmd))).isOK()) {
            Properties hp = new Properties();
            Properties dp = new Properties();
            DeviceReportImpl.parseReportDoc(resp.getData(), hp, dp, false);
            return dp;
        }
        throw error.toException();
    }

    public String[] getComponentNames(String devKey) throws StoradeException {
        AgentCommand cmd = new AgentCommand("Client::InstrReport::clist");
        cmd.setProperty("key", devKey);
        HTTPResponse resp = this.getConnection().getResponse(cmd);
        AgentError error = new AgentError(resp);
        if (error.isOK()) {
            LinkedList<String> list = new LinkedList<String>();
            Node root = XMLUtil.getNode(resp.getData());
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node cnode = children.item(i);
                if (cnode.getNodeType() != 1 || !"COMPONENT".equals(cnode.getNodeName())) continue;
                String comp = XMLUtil.getCdata(cnode);
                list.add(comp);
            }
            String[] names = new String[list.size()];
            list.toArray(names);
            return names;
        }
        throw error.toException();
    }

    private static void parseReportDoc(String doc, Properties hp, Properties cp, boolean std) {
        DeviceReportImpl.parseReportNode(XMLUtil.getNode(doc), hp, cp, std);
    }

    private static void parseReportNode(Node node, Properties hp, Properties cp, boolean std) {
        if (node.getNodeType() == 1) {
            if ("REPORT".equals(node.getNodeName())) {
                NodeList children = node.getChildNodes();
                if (children != null) {
                    Properties p = new Properties();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node cnode = children.item(j);
                        DeviceReportImpl.parseReportNode(cnode, hp, cp, std);
                    }
                }
            } else if ("HEADER".equals(node.getNodeName())) {
                DeviceReportImpl.parseValues(node, hp, std);
            } else if ("CONTENT".equals(node.getNodeName())) {
                DeviceReportImpl.parseValues(node, cp, std);
            }
        }
    }

    private static void parseValues(Node node, Properties p, boolean std) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int j = 0; j < children.getLength(); ++j) {
                Node cnode = children.item(j);
                DeviceReportImpl.parseValue(cnode, p, std);
            }
        }
    }

    static void parseValue(Node node, Properties p, boolean std) {
        if (node.getNodeType() == 1 && "VALUE".equals(node.getNodeName())) {
            NamedNodeMap map = node.getAttributes();
            String name = XMLUtil.getAttribute(map, "ID");
            String value = XMLUtil.getCdata(node);
            if (name != null && value != null) {
                if (std && name.indexOf("._") < 0 && name.indexOf(".count") < 0) {
                    return;
                }
                p.setProperty(name, value);
            }
        }
    }

    private static DeviceSummary[] parseDeviceSummaryNode(Node node) {
        if (!XMLUtil.isElement(node, "DEVICE_SUMMARY")) {
            return new DeviceSummary[0];
        }
        LinkedList<Properties> list = new LinkedList<Properties>();
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int j = 0; j < children.getLength(); ++j) {
                Node cnode = children.item(j);
                Properties p = DeviceReportImpl.parseDeviceSummaryProperties(cnode);
                if (p == null) continue;
                list.add(p);
            }
        }
        Properties[] props = new Properties[list.size()];
        list.toArray(props);
        DeviceSummary[] ds = new DeviceSummary[list.size()];
        for (int i = 0; i < ds.length; ++i) {
            ds[i] = new DeviceSummary(props[i]);
        }
        return ds;
    }

    private static Properties parseDeviceSummaryProperties(Node node) {
        if (!XMLUtil.isElement(node, "DEVICE")) {
            return null;
        }
        Properties p = new Properties();
        XMLUtil.parseValues(node, p);
        return p;
    }

    private static void parseSummaryNode(Node node, LinkedList list) {
        if (node.getNodeType() == 1) {
            if ("REPORT".equals(node.getNodeName()) || "CONTENT".equals(node.getNodeName()) || "LOGICAL".equals(node.getNodeName()) || "FRU".equals(node.getNodeName())) {
                NodeList children = node.getChildNodes();
                if (children != null) {
                    Properties p = new Properties();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node cnode = children.item(j);
                        DeviceReportImpl.parseSummaryNode(cnode, list);
                    }
                }
            } else if ("COMPONENT".equals(node.getNodeName())) {
                Properties p = new Properties();
                XMLUtil.parseValues(node, p);
                list.add(new ComponentSummaryImpl(p));
            }
        }
    }

    private HTTPConnection getConnection() {
        if (this.user == null) {
            return new HTTPConnection(this.agent);
        }
        return new HTTPConnection(this.agent, this.user, this.credential);
    }
}

